<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Plan_Template_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You cannot delete a phase when it is referenced by a task resource in the task resource template. | If the Use Date Offset is true, specify the Date Offset Reference. | Specify an active worker for the owner field. | Contains the
 * detailed information about a project plan template.
 * @subpackage Structs
 */
class Project_Plan_Template_DataType extends AbstractStructBase
{
    /**
     * The Project_Plan_Template_ID
     * Meta information extracted from the WSDL
     * - documentation: Contains a unique identifier for an instance of project plan template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Plan_Template_ID;
    /**
     * The Template_Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the project plan template.
     * - maxOccurs: 1
     * @var string
     */
    public $Template_Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: The description details related to the project plan template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: The owner for the project plan template.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Date_Offset
     * Meta information extracted from the WSDL
     * - documentation: If true, the date offset is used for the project plan template.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Date_Offset;
    /**
     * The Date_Offset_Reference
     * Meta information extracted from the WSDL
     * - documentation: The date offset type used by the project plan template: either Days or Months.
     * - minOccurs: 0
     * @var \StructType\Project_Template_Date_Offset_TypeObjectType
     */
    public $Date_Offset_Reference;
    /**
     * The Phase_Template_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Plan_Phase_Template_DataType[]
     */
    public $Phase_Template_Data;
    /**
     * Constructor method for Project_Plan_Template_DataType
     * @uses Project_Plan_Template_DataType::setProject_Plan_Template_ID()
     * @uses Project_Plan_Template_DataType::setTemplate_Name()
     * @uses Project_Plan_Template_DataType::setDescription()
     * @uses Project_Plan_Template_DataType::setWorker_Reference()
     * @uses Project_Plan_Template_DataType::setDate_Offset()
     * @uses Project_Plan_Template_DataType::setDate_Offset_Reference()
     * @uses Project_Plan_Template_DataType::setPhase_Template_Data()
     * @param string $project_Plan_Template_ID
     * @param string $template_Name
     * @param string $description
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param bool $date_Offset
     * @param \StructType\Project_Template_Date_Offset_TypeObjectType $date_Offset_Reference
     * @param \StructType\Project_Plan_Phase_Template_DataType[] $phase_Template_Data
     */
    public function __construct($project_Plan_Template_ID = null, $template_Name = null, $description = null, \StructType\WorkerObjectType $worker_Reference = null, $date_Offset = null, \StructType\Project_Template_Date_Offset_TypeObjectType $date_Offset_Reference = null, array $phase_Template_Data = array())
    {
        $this
            ->setProject_Plan_Template_ID($project_Plan_Template_ID)
            ->setTemplate_Name($template_Name)
            ->setDescription($description)
            ->setWorker_Reference($worker_Reference)
            ->setDate_Offset($date_Offset)
            ->setDate_Offset_Reference($date_Offset_Reference)
            ->setPhase_Template_Data($phase_Template_Data);
    }
    /**
     * Get Project_Plan_Template_ID value
     * @return string|null
     */
    public function getProject_Plan_Template_ID()
    {
        return $this->Project_Plan_Template_ID;
    }
    /**
     * Set Project_Plan_Template_ID value
     * @param string $project_Plan_Template_ID
     * @return \StructType\Project_Plan_Template_DataType
     */
    public function setProject_Plan_Template_ID($project_Plan_Template_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Plan_Template_ID) && !is_string($project_Plan_Template_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Plan_Template_ID, true), gettype($project_Plan_Template_ID)), __LINE__);
        }
        $this->Project_Plan_Template_ID = $project_Plan_Template_ID;
        return $this;
    }
    /**
     * Get Template_Name value
     * @return string|null
     */
    public function getTemplate_Name()
    {
        return $this->Template_Name;
    }
    /**
     * Set Template_Name value
     * @param string $template_Name
     * @return \StructType\Project_Plan_Template_DataType
     */
    public function setTemplate_Name($template_Name = null)
    {
        // validation for constraint: string
        if (!is_null($template_Name) && !is_string($template_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($template_Name, true), gettype($template_Name)), __LINE__);
        }
        $this->Template_Name = $template_Name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Project_Plan_Template_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Project_Plan_Template_DataType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Date_Offset value
     * @return bool|null
     */
    public function getDate_Offset()
    {
        return $this->Date_Offset;
    }
    /**
     * Set Date_Offset value
     * @param bool $date_Offset
     * @return \StructType\Project_Plan_Template_DataType
     */
    public function setDate_Offset($date_Offset = null)
    {
        // validation for constraint: boolean
        if (!is_null($date_Offset) && !is_bool($date_Offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($date_Offset, true), gettype($date_Offset)), __LINE__);
        }
        $this->Date_Offset = $date_Offset;
        return $this;
    }
    /**
     * Get Date_Offset_Reference value
     * @return \StructType\Project_Template_Date_Offset_TypeObjectType|null
     */
    public function getDate_Offset_Reference()
    {
        return $this->Date_Offset_Reference;
    }
    /**
     * Set Date_Offset_Reference value
     * @param \StructType\Project_Template_Date_Offset_TypeObjectType $date_Offset_Reference
     * @return \StructType\Project_Plan_Template_DataType
     */
    public function setDate_Offset_Reference(\StructType\Project_Template_Date_Offset_TypeObjectType $date_Offset_Reference = null)
    {
        $this->Date_Offset_Reference = $date_Offset_Reference;
        return $this;
    }
    /**
     * Get Phase_Template_Data value
     * @return \StructType\Project_Plan_Phase_Template_DataType[]|null
     */
    public function getPhase_Template_Data()
    {
        return $this->Phase_Template_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPhase_Template_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhase_Template_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhase_Template_DataForArrayConstraintsFromSetPhase_Template_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Plan_Template_DataTypePhase_Template_DataItem) {
            // validation for constraint: itemType
            if (!$project_Plan_Template_DataTypePhase_Template_DataItem instanceof \StructType\Project_Plan_Phase_Template_DataType) {
                $invalidValues[] = is_object($project_Plan_Template_DataTypePhase_Template_DataItem) ? get_class($project_Plan_Template_DataTypePhase_Template_DataItem) : sprintf('%s(%s)', gettype($project_Plan_Template_DataTypePhase_Template_DataItem), var_export($project_Plan_Template_DataTypePhase_Template_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Phase_Template_Data property can only contain items of type \StructType\Project_Plan_Phase_Template_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Phase_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Phase_Template_DataType[] $phase_Template_Data
     * @return \StructType\Project_Plan_Template_DataType
     */
    public function setPhase_Template_Data(array $phase_Template_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($phase_Template_DataArrayErrorMessage = self::validatePhase_Template_DataForArrayConstraintsFromSetPhase_Template_Data($phase_Template_Data))) {
            throw new \InvalidArgumentException($phase_Template_DataArrayErrorMessage, __LINE__);
        }
        $this->Phase_Template_Data = $phase_Template_Data;
        return $this;
    }
    /**
     * Add item to Phase_Template_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_Phase_Template_DataType $item
     * @return \StructType\Project_Plan_Template_DataType
     */
    public function addToPhase_Template_Data(\StructType\Project_Plan_Phase_Template_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Plan_Phase_Template_DataType) {
            throw new \InvalidArgumentException(sprintf('The Phase_Template_Data property can only contain items of type \StructType\Project_Plan_Phase_Template_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Phase_Template_Data[] = $item;
        return $this;
    }
}
