<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Prepaid_Spend_Amortization_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Prepaid Spend Amortization data
 * @subpackage Structs
 */
class Prepaid_Spend_Amortization_DataType extends AbstractStructBase
{
    /**
     * The Accounting_Date
     * Meta information extracted from the WSDL
     * - documentation: Accounting Date of the Prepaid Spend Amotization
     * - maxOccurs: 1
     * @var string
     */
    public $Accounting_Date;
    /**
     * The Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice for the Prepaid Spend Amortization
     * @var \StructType\Supplier_InvoiceObjectType
     */
    public $Supplier_Invoice_Reference;
    /**
     * Constructor method for Prepaid_Spend_Amortization_DataType
     * @uses Prepaid_Spend_Amortization_DataType::setAccounting_Date()
     * @uses Prepaid_Spend_Amortization_DataType::setSupplier_Invoice_Reference()
     * @param string $accounting_Date
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     */
    public function __construct($accounting_Date = null, \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null)
    {
        $this
            ->setAccounting_Date($accounting_Date)
            ->setSupplier_Invoice_Reference($supplier_Invoice_Reference);
    }
    /**
     * Get Accounting_Date value
     * @return string|null
     */
    public function getAccounting_Date()
    {
        return $this->Accounting_Date;
    }
    /**
     * Set Accounting_Date value
     * @param string $accounting_Date
     * @return \StructType\Prepaid_Spend_Amortization_DataType
     */
    public function setAccounting_Date($accounting_Date = null)
    {
        // validation for constraint: string
        if (!is_null($accounting_Date) && !is_string($accounting_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounting_Date, true), gettype($accounting_Date)), __LINE__);
        }
        $this->Accounting_Date = $accounting_Date;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Reference value
     * @return \StructType\Supplier_InvoiceObjectType|null
     */
    public function getSupplier_Invoice_Reference()
    {
        return $this->Supplier_Invoice_Reference;
    }
    /**
     * Set Supplier_Invoice_Reference value
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @return \StructType\Prepaid_Spend_Amortization_DataType
     */
    public function setSupplier_Invoice_Reference(\StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null)
    {
        $this->Supplier_Invoice_Reference = $supplier_Invoice_Reference;
        return $this;
    }
}
