<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Netting_Transaction_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Netting Transaction Data
 * @subpackage Structs
 */
class Netting_Transaction_DataType extends AbstractStructBase
{
    /**
     * The Netting_Transaction_ID
     * Meta information extracted from the WSDL
     * - documentation: Netting Transaction ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Netting_Transaction_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the transaction is to be submitted or saved in draft mode. If this flag is set, the transaction will be submitted, otherwise the transaction is saved in draft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Document_Number
     * Meta information extracted from the WSDL
     * - documentation: Document Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Number;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the company that tranasction is for. This is the reference id value of the company.
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id of currency of the transaction If no currency is specified, Workday will first look to see if the payer/payee has a preferred currency and if not, currency will be populated with the company base currency. If
     * the company base currency is not allowed currency for payer/payee then transaction will not be able to be submitted for approval.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Netting_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference an existing Netting Rule for the Netting Transaction.
     * @var \StructType\Netting_RuleObjectType
     */
    public $Netting_Rule_Reference;
    /**
     * The Netting_Transaction_Date
     * Meta information extracted from the WSDL
     * - documentation: Format is MM/DD/YYYY.If this is left blank, Workday will populate transaction date with the current date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Netting_Transaction_Date;
    /**
     * The Supplier_Invoice_Date_On_or_After_Date
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Document Date on or after Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Date_On_or_After_Date;
    /**
     * The Supplier_Invoice_Date_On_or_Before_Date
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Document Date on or before Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Date_On_or_Before_Date;
    /**
     * The Customer_Invoice_Date_On_or_After_Date
     * Meta information extracted from the WSDL
     * - documentation: Customer Invoice Document Date on or after Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Customer_Invoice_Date_On_or_After_Date;
    /**
     * The Customer_Invoice_Date_On_or_Before_Date
     * Meta information extracted from the WSDL
     * - documentation: Customer Invoice Document Date on or before Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Customer_Invoice_Date_On_or_Before_Date;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Attachment Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Supplier_Invoice_for_Netting_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice for Netting Data. A Netting Transaction should have at least one Supplier Invoice for Netting.
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_Invoice_For_Netting_DataType[]
     */
    public $Supplier_Invoice_for_Netting_Data;
    /**
     * The Customer_Invoice_for_Netting_Data
     * Meta information extracted from the WSDL
     * - documentation: Customer Invoice for Netting Data. A Netting Transaction should have at least one Customer Invoice for Netting.
     * - maxOccurs: unbounded
     * @var \StructType\Customer_Invoice_for_Netting_DataType[]
     */
    public $Customer_Invoice_for_Netting_Data;
    /**
     * Constructor method for Netting_Transaction_DataType
     * @uses Netting_Transaction_DataType::setNetting_Transaction_ID()
     * @uses Netting_Transaction_DataType::setSubmit()
     * @uses Netting_Transaction_DataType::setDocument_Number()
     * @uses Netting_Transaction_DataType::setCompany_Reference()
     * @uses Netting_Transaction_DataType::setCurrency_Reference()
     * @uses Netting_Transaction_DataType::setNetting_Rule_Reference()
     * @uses Netting_Transaction_DataType::setNetting_Transaction_Date()
     * @uses Netting_Transaction_DataType::setSupplier_Invoice_Date_On_or_After_Date()
     * @uses Netting_Transaction_DataType::setSupplier_Invoice_Date_On_or_Before_Date()
     * @uses Netting_Transaction_DataType::setCustomer_Invoice_Date_On_or_After_Date()
     * @uses Netting_Transaction_DataType::setCustomer_Invoice_Date_On_or_Before_Date()
     * @uses Netting_Transaction_DataType::setAttachment_Data()
     * @uses Netting_Transaction_DataType::setSupplier_Invoice_for_Netting_Data()
     * @uses Netting_Transaction_DataType::setCustomer_Invoice_for_Netting_Data()
     * @param string $netting_Transaction_ID
     * @param bool $submit
     * @param string $document_Number
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Netting_RuleObjectType $netting_Rule_Reference
     * @param string $netting_Transaction_Date
     * @param string $supplier_Invoice_Date_On_or_After_Date
     * @param string $supplier_Invoice_Date_On_or_Before_Date
     * @param string $customer_Invoice_Date_On_or_After_Date
     * @param string $customer_Invoice_Date_On_or_Before_Date
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @param \StructType\Supplier_Invoice_For_Netting_DataType[] $supplier_Invoice_for_Netting_Data
     * @param \StructType\Customer_Invoice_for_Netting_DataType[] $customer_Invoice_for_Netting_Data
     */
    public function __construct($netting_Transaction_ID = null, $submit = null, $document_Number = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Netting_RuleObjectType $netting_Rule_Reference = null, $netting_Transaction_Date = null, $supplier_Invoice_Date_On_or_After_Date = null, $supplier_Invoice_Date_On_or_Before_Date = null, $customer_Invoice_Date_On_or_After_Date = null, $customer_Invoice_Date_On_or_Before_Date = null, array $attachment_Data = array(), array $supplier_Invoice_for_Netting_Data = array(), array $customer_Invoice_for_Netting_Data = array())
    {
        $this
            ->setNetting_Transaction_ID($netting_Transaction_ID)
            ->setSubmit($submit)
            ->setDocument_Number($document_Number)
            ->setCompany_Reference($company_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setNetting_Rule_Reference($netting_Rule_Reference)
            ->setNetting_Transaction_Date($netting_Transaction_Date)
            ->setSupplier_Invoice_Date_On_or_After_Date($supplier_Invoice_Date_On_or_After_Date)
            ->setSupplier_Invoice_Date_On_or_Before_Date($supplier_Invoice_Date_On_or_Before_Date)
            ->setCustomer_Invoice_Date_On_or_After_Date($customer_Invoice_Date_On_or_After_Date)
            ->setCustomer_Invoice_Date_On_or_Before_Date($customer_Invoice_Date_On_or_Before_Date)
            ->setAttachment_Data($attachment_Data)
            ->setSupplier_Invoice_for_Netting_Data($supplier_Invoice_for_Netting_Data)
            ->setCustomer_Invoice_for_Netting_Data($customer_Invoice_for_Netting_Data);
    }
    /**
     * Get Netting_Transaction_ID value
     * @return string|null
     */
    public function getNetting_Transaction_ID()
    {
        return $this->Netting_Transaction_ID;
    }
    /**
     * Set Netting_Transaction_ID value
     * @param string $netting_Transaction_ID
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setNetting_Transaction_ID($netting_Transaction_ID = null)
    {
        // validation for constraint: string
        if (!is_null($netting_Transaction_ID) && !is_string($netting_Transaction_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netting_Transaction_ID, true), gettype($netting_Transaction_ID)), __LINE__);
        }
        $this->Netting_Transaction_ID = $netting_Transaction_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Document_Number value
     * @return string|null
     */
    public function getDocument_Number()
    {
        return $this->Document_Number;
    }
    /**
     * Set Document_Number value
     * @param string $document_Number
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setDocument_Number($document_Number = null)
    {
        // validation for constraint: string
        if (!is_null($document_Number) && !is_string($document_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Number, true), gettype($document_Number)), __LINE__);
        }
        $this->Document_Number = $document_Number;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Netting_Rule_Reference value
     * @return \StructType\Netting_RuleObjectType|null
     */
    public function getNetting_Rule_Reference()
    {
        return $this->Netting_Rule_Reference;
    }
    /**
     * Set Netting_Rule_Reference value
     * @param \StructType\Netting_RuleObjectType $netting_Rule_Reference
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setNetting_Rule_Reference(\StructType\Netting_RuleObjectType $netting_Rule_Reference = null)
    {
        $this->Netting_Rule_Reference = $netting_Rule_Reference;
        return $this;
    }
    /**
     * Get Netting_Transaction_Date value
     * @return string|null
     */
    public function getNetting_Transaction_Date()
    {
        return $this->Netting_Transaction_Date;
    }
    /**
     * Set Netting_Transaction_Date value
     * @param string $netting_Transaction_Date
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setNetting_Transaction_Date($netting_Transaction_Date = null)
    {
        // validation for constraint: string
        if (!is_null($netting_Transaction_Date) && !is_string($netting_Transaction_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netting_Transaction_Date, true), gettype($netting_Transaction_Date)), __LINE__);
        }
        $this->Netting_Transaction_Date = $netting_Transaction_Date;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Date_On_or_After_Date value
     * @return string|null
     */
    public function getSupplier_Invoice_Date_On_or_After_Date()
    {
        return $this->Supplier_Invoice_Date_On_or_After_Date;
    }
    /**
     * Set Supplier_Invoice_Date_On_or_After_Date value
     * @param string $supplier_Invoice_Date_On_or_After_Date
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setSupplier_Invoice_Date_On_or_After_Date($supplier_Invoice_Date_On_or_After_Date = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Date_On_or_After_Date) && !is_string($supplier_Invoice_Date_On_or_After_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Date_On_or_After_Date, true), gettype($supplier_Invoice_Date_On_or_After_Date)), __LINE__);
        }
        $this->Supplier_Invoice_Date_On_or_After_Date = $supplier_Invoice_Date_On_or_After_Date;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Date_On_or_Before_Date value
     * @return string|null
     */
    public function getSupplier_Invoice_Date_On_or_Before_Date()
    {
        return $this->Supplier_Invoice_Date_On_or_Before_Date;
    }
    /**
     * Set Supplier_Invoice_Date_On_or_Before_Date value
     * @param string $supplier_Invoice_Date_On_or_Before_Date
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setSupplier_Invoice_Date_On_or_Before_Date($supplier_Invoice_Date_On_or_Before_Date = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Date_On_or_Before_Date) && !is_string($supplier_Invoice_Date_On_or_Before_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Date_On_or_Before_Date, true), gettype($supplier_Invoice_Date_On_or_Before_Date)), __LINE__);
        }
        $this->Supplier_Invoice_Date_On_or_Before_Date = $supplier_Invoice_Date_On_or_Before_Date;
        return $this;
    }
    /**
     * Get Customer_Invoice_Date_On_or_After_Date value
     * @return string|null
     */
    public function getCustomer_Invoice_Date_On_or_After_Date()
    {
        return $this->Customer_Invoice_Date_On_or_After_Date;
    }
    /**
     * Set Customer_Invoice_Date_On_or_After_Date value
     * @param string $customer_Invoice_Date_On_or_After_Date
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setCustomer_Invoice_Date_On_or_After_Date($customer_Invoice_Date_On_or_After_Date = null)
    {
        // validation for constraint: string
        if (!is_null($customer_Invoice_Date_On_or_After_Date) && !is_string($customer_Invoice_Date_On_or_After_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_Invoice_Date_On_or_After_Date, true), gettype($customer_Invoice_Date_On_or_After_Date)), __LINE__);
        }
        $this->Customer_Invoice_Date_On_or_After_Date = $customer_Invoice_Date_On_or_After_Date;
        return $this;
    }
    /**
     * Get Customer_Invoice_Date_On_or_Before_Date value
     * @return string|null
     */
    public function getCustomer_Invoice_Date_On_or_Before_Date()
    {
        return $this->Customer_Invoice_Date_On_or_Before_Date;
    }
    /**
     * Set Customer_Invoice_Date_On_or_Before_Date value
     * @param string $customer_Invoice_Date_On_or_Before_Date
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setCustomer_Invoice_Date_On_or_Before_Date($customer_Invoice_Date_On_or_Before_Date = null)
    {
        // validation for constraint: string
        if (!is_null($customer_Invoice_Date_On_or_Before_Date) && !is_string($customer_Invoice_Date_On_or_Before_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_Invoice_Date_On_or_Before_Date, true), gettype($customer_Invoice_Date_On_or_Before_Date)), __LINE__);
        }
        $this->Customer_Invoice_Date_On_or_Before_Date = $customer_Invoice_Date_On_or_Before_Date;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $netting_Transaction_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$netting_Transaction_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($netting_Transaction_DataTypeAttachment_DataItem) ? get_class($netting_Transaction_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($netting_Transaction_DataTypeAttachment_DataItem), var_export($netting_Transaction_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Netting_Transaction_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Invoice_for_Netting_Data value
     * @return \StructType\Supplier_Invoice_For_Netting_DataType[]|null
     */
    public function getSupplier_Invoice_for_Netting_Data()
    {
        return $this->Supplier_Invoice_for_Netting_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_for_Netting_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_for_Netting_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_for_Netting_DataForArrayConstraintsFromSetSupplier_Invoice_for_Netting_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $netting_Transaction_DataTypeSupplier_Invoice_for_Netting_DataItem) {
            // validation for constraint: itemType
            if (!$netting_Transaction_DataTypeSupplier_Invoice_for_Netting_DataItem instanceof \StructType\Supplier_Invoice_For_Netting_DataType) {
                $invalidValues[] = is_object($netting_Transaction_DataTypeSupplier_Invoice_for_Netting_DataItem) ? get_class($netting_Transaction_DataTypeSupplier_Invoice_for_Netting_DataItem) : sprintf('%s(%s)', gettype($netting_Transaction_DataTypeSupplier_Invoice_for_Netting_DataItem), var_export($netting_Transaction_DataTypeSupplier_Invoice_for_Netting_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_for_Netting_Data property can only contain items of type \StructType\Supplier_Invoice_For_Netting_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_for_Netting_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_For_Netting_DataType[] $supplier_Invoice_for_Netting_Data
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setSupplier_Invoice_for_Netting_Data(array $supplier_Invoice_for_Netting_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_for_Netting_DataArrayErrorMessage = self::validateSupplier_Invoice_for_Netting_DataForArrayConstraintsFromSetSupplier_Invoice_for_Netting_Data($supplier_Invoice_for_Netting_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_for_Netting_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_for_Netting_Data = $supplier_Invoice_for_Netting_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_for_Netting_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_For_Netting_DataType $item
     * @return \StructType\Netting_Transaction_DataType
     */
    public function addToSupplier_Invoice_for_Netting_Data(\StructType\Supplier_Invoice_For_Netting_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_For_Netting_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_for_Netting_Data property can only contain items of type \StructType\Supplier_Invoice_For_Netting_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_for_Netting_Data[] = $item;
        return $this;
    }
    /**
     * Get Customer_Invoice_for_Netting_Data value
     * @return \StructType\Customer_Invoice_for_Netting_DataType[]|null
     */
    public function getCustomer_Invoice_for_Netting_Data()
    {
        return $this->Customer_Invoice_for_Netting_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomer_Invoice_for_Netting_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer_Invoice_for_Netting_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomer_Invoice_for_Netting_DataForArrayConstraintsFromSetCustomer_Invoice_for_Netting_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $netting_Transaction_DataTypeCustomer_Invoice_for_Netting_DataItem) {
            // validation for constraint: itemType
            if (!$netting_Transaction_DataTypeCustomer_Invoice_for_Netting_DataItem instanceof \StructType\Customer_Invoice_for_Netting_DataType) {
                $invalidValues[] = is_object($netting_Transaction_DataTypeCustomer_Invoice_for_Netting_DataItem) ? get_class($netting_Transaction_DataTypeCustomer_Invoice_for_Netting_DataItem) : sprintf('%s(%s)', gettype($netting_Transaction_DataTypeCustomer_Invoice_for_Netting_DataItem), var_export($netting_Transaction_DataTypeCustomer_Invoice_for_Netting_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Customer_Invoice_for_Netting_Data property can only contain items of type \StructType\Customer_Invoice_for_Netting_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Customer_Invoice_for_Netting_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Customer_Invoice_for_Netting_DataType[] $customer_Invoice_for_Netting_Data
     * @return \StructType\Netting_Transaction_DataType
     */
    public function setCustomer_Invoice_for_Netting_Data(array $customer_Invoice_for_Netting_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($customer_Invoice_for_Netting_DataArrayErrorMessage = self::validateCustomer_Invoice_for_Netting_DataForArrayConstraintsFromSetCustomer_Invoice_for_Netting_Data($customer_Invoice_for_Netting_Data))) {
            throw new \InvalidArgumentException($customer_Invoice_for_Netting_DataArrayErrorMessage, __LINE__);
        }
        $this->Customer_Invoice_for_Netting_Data = $customer_Invoice_for_Netting_Data;
        return $this;
    }
    /**
     * Add item to Customer_Invoice_for_Netting_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Customer_Invoice_for_Netting_DataType $item
     * @return \StructType\Netting_Transaction_DataType
     */
    public function addToCustomer_Invoice_for_Netting_Data(\StructType\Customer_Invoice_for_Netting_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Customer_Invoice_for_Netting_DataType) {
            throw new \InvalidArgumentException(sprintf('The Customer_Invoice_for_Netting_Data property can only contain items of type \StructType\Customer_Invoice_for_Netting_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Customer_Invoice_for_Netting_Data[] = $item;
        return $this;
    }
}
