<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Mass_Reopen_Procurement_Documents_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Mass Reopen Procurement Documents Data
 * @subpackage Structs
 */
class Mass_Reopen_Procurement_Documents_DataType extends AbstractStructBase
{
    /**
     * The Mass_Reopen_Procurement_Documents_ID
     * Meta information extracted from the WSDL
     * - documentation: Mass Reopen Procurement Documents ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mass_Reopen_Procurement_Documents_ID;
    /**
     * The Mass_Reopen_Procurement_Documents_Request_Name
     * Meta information extracted from the WSDL
     * - documentation: Mass Reopen Procurement Documents Request Name
     * - maxOccurs: 1
     * @var string
     */
    public $Mass_Reopen_Procurement_Documents_Request_Name;
    /**
     * The Company_or_Company_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company or Company Hierarchy Reference
     * @var \StructType\OrganizationObjectType
     */
    public $Company_or_Company_Hierarchy_Reference;
    /**
     * The Procurement_Document_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Procurement Document Type Reference
     * @var \StructType\Procurement_Document_TypeObjectType
     */
    public $Procurement_Document_Type_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Procurement_Mass_Reopen_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Mass Reopen Procurement Documents Line Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Mass_Reopen_Procurement_Documents_Line_DataType[]
     */
    public $Procurement_Mass_Reopen_Line_Data;
    /**
     * Constructor method for Mass_Reopen_Procurement_Documents_DataType
     * @uses Mass_Reopen_Procurement_Documents_DataType::setMass_Reopen_Procurement_Documents_ID()
     * @uses Mass_Reopen_Procurement_Documents_DataType::setMass_Reopen_Procurement_Documents_Request_Name()
     * @uses Mass_Reopen_Procurement_Documents_DataType::setCompany_or_Company_Hierarchy_Reference()
     * @uses Mass_Reopen_Procurement_Documents_DataType::setProcurement_Document_Type_Reference()
     * @uses Mass_Reopen_Procurement_Documents_DataType::setMemo()
     * @uses Mass_Reopen_Procurement_Documents_DataType::setProcurement_Mass_Reopen_Line_Data()
     * @param string $mass_Reopen_Procurement_Documents_ID
     * @param string $mass_Reopen_Procurement_Documents_Request_Name
     * @param \StructType\OrganizationObjectType $company_or_Company_Hierarchy_Reference
     * @param \StructType\Procurement_Document_TypeObjectType $procurement_Document_Type_Reference
     * @param string $memo
     * @param \StructType\Mass_Reopen_Procurement_Documents_Line_DataType[] $procurement_Mass_Reopen_Line_Data
     */
    public function __construct($mass_Reopen_Procurement_Documents_ID = null, $mass_Reopen_Procurement_Documents_Request_Name = null, \StructType\OrganizationObjectType $company_or_Company_Hierarchy_Reference = null, \StructType\Procurement_Document_TypeObjectType $procurement_Document_Type_Reference = null, $memo = null, array $procurement_Mass_Reopen_Line_Data = array())
    {
        $this
            ->setMass_Reopen_Procurement_Documents_ID($mass_Reopen_Procurement_Documents_ID)
            ->setMass_Reopen_Procurement_Documents_Request_Name($mass_Reopen_Procurement_Documents_Request_Name)
            ->setCompany_or_Company_Hierarchy_Reference($company_or_Company_Hierarchy_Reference)
            ->setProcurement_Document_Type_Reference($procurement_Document_Type_Reference)
            ->setMemo($memo)
            ->setProcurement_Mass_Reopen_Line_Data($procurement_Mass_Reopen_Line_Data);
    }
    /**
     * Get Mass_Reopen_Procurement_Documents_ID value
     * @return string|null
     */
    public function getMass_Reopen_Procurement_Documents_ID()
    {
        return $this->Mass_Reopen_Procurement_Documents_ID;
    }
    /**
     * Set Mass_Reopen_Procurement_Documents_ID value
     * @param string $mass_Reopen_Procurement_Documents_ID
     * @return \StructType\Mass_Reopen_Procurement_Documents_DataType
     */
    public function setMass_Reopen_Procurement_Documents_ID($mass_Reopen_Procurement_Documents_ID = null)
    {
        // validation for constraint: string
        if (!is_null($mass_Reopen_Procurement_Documents_ID) && !is_string($mass_Reopen_Procurement_Documents_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mass_Reopen_Procurement_Documents_ID, true), gettype($mass_Reopen_Procurement_Documents_ID)), __LINE__);
        }
        $this->Mass_Reopen_Procurement_Documents_ID = $mass_Reopen_Procurement_Documents_ID;
        return $this;
    }
    /**
     * Get Mass_Reopen_Procurement_Documents_Request_Name value
     * @return string|null
     */
    public function getMass_Reopen_Procurement_Documents_Request_Name()
    {
        return $this->Mass_Reopen_Procurement_Documents_Request_Name;
    }
    /**
     * Set Mass_Reopen_Procurement_Documents_Request_Name value
     * @param string $mass_Reopen_Procurement_Documents_Request_Name
     * @return \StructType\Mass_Reopen_Procurement_Documents_DataType
     */
    public function setMass_Reopen_Procurement_Documents_Request_Name($mass_Reopen_Procurement_Documents_Request_Name = null)
    {
        // validation for constraint: string
        if (!is_null($mass_Reopen_Procurement_Documents_Request_Name) && !is_string($mass_Reopen_Procurement_Documents_Request_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mass_Reopen_Procurement_Documents_Request_Name, true), gettype($mass_Reopen_Procurement_Documents_Request_Name)), __LINE__);
        }
        $this->Mass_Reopen_Procurement_Documents_Request_Name = $mass_Reopen_Procurement_Documents_Request_Name;
        return $this;
    }
    /**
     * Get Company_or_Company_Hierarchy_Reference value
     * @return \StructType\OrganizationObjectType|null
     */
    public function getCompany_or_Company_Hierarchy_Reference()
    {
        return $this->Company_or_Company_Hierarchy_Reference;
    }
    /**
     * Set Company_or_Company_Hierarchy_Reference value
     * @param \StructType\OrganizationObjectType $company_or_Company_Hierarchy_Reference
     * @return \StructType\Mass_Reopen_Procurement_Documents_DataType
     */
    public function setCompany_or_Company_Hierarchy_Reference(\StructType\OrganizationObjectType $company_or_Company_Hierarchy_Reference = null)
    {
        $this->Company_or_Company_Hierarchy_Reference = $company_or_Company_Hierarchy_Reference;
        return $this;
    }
    /**
     * Get Procurement_Document_Type_Reference value
     * @return \StructType\Procurement_Document_TypeObjectType|null
     */
    public function getProcurement_Document_Type_Reference()
    {
        return $this->Procurement_Document_Type_Reference;
    }
    /**
     * Set Procurement_Document_Type_Reference value
     * @param \StructType\Procurement_Document_TypeObjectType $procurement_Document_Type_Reference
     * @return \StructType\Mass_Reopen_Procurement_Documents_DataType
     */
    public function setProcurement_Document_Type_Reference(\StructType\Procurement_Document_TypeObjectType $procurement_Document_Type_Reference = null)
    {
        $this->Procurement_Document_Type_Reference = $procurement_Document_Type_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Mass_Reopen_Procurement_Documents_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Procurement_Mass_Reopen_Line_Data value
     * @return \StructType\Mass_Reopen_Procurement_Documents_Line_DataType[]|null
     */
    public function getProcurement_Mass_Reopen_Line_Data()
    {
        return $this->Procurement_Mass_Reopen_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProcurement_Mass_Reopen_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcurement_Mass_Reopen_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcurement_Mass_Reopen_Line_DataForArrayConstraintsFromSetProcurement_Mass_Reopen_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $mass_Reopen_Procurement_Documents_DataTypeProcurement_Mass_Reopen_Line_DataItem) {
            // validation for constraint: itemType
            if (!$mass_Reopen_Procurement_Documents_DataTypeProcurement_Mass_Reopen_Line_DataItem instanceof \StructType\Mass_Reopen_Procurement_Documents_Line_DataType) {
                $invalidValues[] = is_object($mass_Reopen_Procurement_Documents_DataTypeProcurement_Mass_Reopen_Line_DataItem) ? get_class($mass_Reopen_Procurement_Documents_DataTypeProcurement_Mass_Reopen_Line_DataItem) : sprintf('%s(%s)', gettype($mass_Reopen_Procurement_Documents_DataTypeProcurement_Mass_Reopen_Line_DataItem), var_export($mass_Reopen_Procurement_Documents_DataTypeProcurement_Mass_Reopen_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Procurement_Mass_Reopen_Line_Data property can only contain items of type \StructType\Mass_Reopen_Procurement_Documents_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Procurement_Mass_Reopen_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Mass_Reopen_Procurement_Documents_Line_DataType[] $procurement_Mass_Reopen_Line_Data
     * @return \StructType\Mass_Reopen_Procurement_Documents_DataType
     */
    public function setProcurement_Mass_Reopen_Line_Data(array $procurement_Mass_Reopen_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($procurement_Mass_Reopen_Line_DataArrayErrorMessage = self::validateProcurement_Mass_Reopen_Line_DataForArrayConstraintsFromSetProcurement_Mass_Reopen_Line_Data($procurement_Mass_Reopen_Line_Data))) {
            throw new \InvalidArgumentException($procurement_Mass_Reopen_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Procurement_Mass_Reopen_Line_Data = $procurement_Mass_Reopen_Line_Data;
        return $this;
    }
    /**
     * Add item to Procurement_Mass_Reopen_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Mass_Reopen_Procurement_Documents_Line_DataType $item
     * @return \StructType\Mass_Reopen_Procurement_Documents_DataType
     */
    public function addToProcurement_Mass_Reopen_Line_Data(\StructType\Mass_Reopen_Procurement_Documents_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Mass_Reopen_Procurement_Documents_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Procurement_Mass_Reopen_Line_Data property can only contain items of type \StructType\Mass_Reopen_Procurement_Documents_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Procurement_Mass_Reopen_Line_Data[] = $item;
        return $this;
    }
}
