<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice_Type_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element around a list of elements representing the amount of data that should be included in the Invoice Type response. If this element is not included, then ALL of the Response Groups are included in the response.
 * @subpackage Structs
 */
class Invoice_Type_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Invoice Type Reference data is to be included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Invoice_Type_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Invoice Type data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Invoice_Type_Data;
    /**
     * Constructor method for Invoice_Type_Response_GroupType
     * @uses Invoice_Type_Response_GroupType::setInclude_Reference()
     * @uses Invoice_Type_Response_GroupType::setInclude_Invoice_Type_Data()
     * @param bool $include_Reference
     * @param bool $include_Invoice_Type_Data
     */
    public function __construct($include_Reference = null, $include_Invoice_Type_Data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Invoice_Type_Data($include_Invoice_Type_Data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Invoice_Type_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Invoice_Type_Data value
     * @return bool|null
     */
    public function getInclude_Invoice_Type_Data()
    {
        return $this->Include_Invoice_Type_Data;
    }
    /**
     * Set Include_Invoice_Type_Data value
     * @param bool $include_Invoice_Type_Data
     * @return \StructType\Invoice_Type_Response_GroupType
     */
    public function setInclude_Invoice_Type_Data($include_Invoice_Type_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Invoice_Type_Data) && !is_bool($include_Invoice_Type_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Invoice_Type_Data, true), gettype($include_Invoice_Type_Data)), __LINE__);
        }
        $this->Include_Invoice_Type_Data = $include_Invoice_Type_Data;
        return $this;
    }
}
