<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Catalog_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: There is already an Internal Catalog with that Name and Internal Provider. Please change the Name or the Internal Provider before proceeding. | Element containing Internal Catalog data.
 * @subpackage Structs
 */
class Internal_Catalog_DataType extends AbstractStructBase
{
    /**
     * The Internal_Catalog_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Internal Catalog Reference ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Internal_Catalog_Reference_ID;
    /**
     * The Catalog_Name
     * Meta information extracted from the WSDL
     * - documentation: Name of the Internal Catalog.
     * - maxOccurs: 1
     * @var string
     */
    public $Catalog_Name;
    /**
     * The Internal_Service_Provider_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Internal Service Provider.
     * @var \StructType\Internal_Service_ProviderObjectType
     */
    public $Internal_Service_Provider_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * Constructor method for Internal_Catalog_DataType
     * @uses Internal_Catalog_DataType::setInternal_Catalog_Reference_ID()
     * @uses Internal_Catalog_DataType::setCatalog_Name()
     * @uses Internal_Catalog_DataType::setInternal_Service_Provider_Reference()
     * @uses Internal_Catalog_DataType::setCurrency_Reference()
     * @param string $internal_Catalog_Reference_ID
     * @param string $catalog_Name
     * @param \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     */
    public function __construct($internal_Catalog_Reference_ID = null, $catalog_Name = null, \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this
            ->setInternal_Catalog_Reference_ID($internal_Catalog_Reference_ID)
            ->setCatalog_Name($catalog_Name)
            ->setInternal_Service_Provider_Reference($internal_Service_Provider_Reference)
            ->setCurrency_Reference($currency_Reference);
    }
    /**
     * Get Internal_Catalog_Reference_ID value
     * @return string|null
     */
    public function getInternal_Catalog_Reference_ID()
    {
        return $this->Internal_Catalog_Reference_ID;
    }
    /**
     * Set Internal_Catalog_Reference_ID value
     * @param string $internal_Catalog_Reference_ID
     * @return \StructType\Internal_Catalog_DataType
     */
    public function setInternal_Catalog_Reference_ID($internal_Catalog_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Catalog_Reference_ID) && !is_string($internal_Catalog_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Catalog_Reference_ID, true), gettype($internal_Catalog_Reference_ID)), __LINE__);
        }
        $this->Internal_Catalog_Reference_ID = $internal_Catalog_Reference_ID;
        return $this;
    }
    /**
     * Get Catalog_Name value
     * @return string|null
     */
    public function getCatalog_Name()
    {
        return $this->Catalog_Name;
    }
    /**
     * Set Catalog_Name value
     * @param string $catalog_Name
     * @return \StructType\Internal_Catalog_DataType
     */
    public function setCatalog_Name($catalog_Name = null)
    {
        // validation for constraint: string
        if (!is_null($catalog_Name) && !is_string($catalog_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($catalog_Name, true), gettype($catalog_Name)), __LINE__);
        }
        $this->Catalog_Name = $catalog_Name;
        return $this;
    }
    /**
     * Get Internal_Service_Provider_Reference value
     * @return \StructType\Internal_Service_ProviderObjectType|null
     */
    public function getInternal_Service_Provider_Reference()
    {
        return $this->Internal_Service_Provider_Reference;
    }
    /**
     * Set Internal_Service_Provider_Reference value
     * @param \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference
     * @return \StructType\Internal_Catalog_DataType
     */
    public function setInternal_Service_Provider_Reference(\StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference = null)
    {
        $this->Internal_Service_Provider_Reference = $internal_Service_Provider_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Internal_Catalog_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
}
