<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssetType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulates a single Asset object, including a reference to the Asset, and all related data and transactions.
 * @subpackage Structs
 */
class AssetType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the asset.
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The Asset_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulates all the data for a single Asset.
     * - minOccurs: 0
     * @var \StructType\Asset_DataType
     */
    public $Asset_Data;
    /**
     * Constructor method for AssetType
     * @uses AssetType::setAsset_Reference()
     * @uses AssetType::setAsset_Data()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param \StructType\Asset_DataType $asset_Data
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, \StructType\Asset_DataType $asset_Data = null)
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setAsset_Data($asset_Data);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\AssetType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get Asset_Data value
     * @return \StructType\Asset_DataType|null
     */
    public function getAsset_Data()
    {
        return $this->Asset_Data;
    }
    /**
     * Set Asset_Data value
     * @param \StructType\Asset_DataType $asset_Data
     * @return \StructType\AssetType
     */
    public function setAsset_Data(\StructType\Asset_DataType $asset_Data = null)
    {
        $this->Asset_Data = $asset_Data;
        return $this;
    }
}
