<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Revenue_Center_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Revenue Center
 * @subpackage Structs
 */
class Revenue_Center_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Revenue_Center_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Revenue Center
     * - maxOccurs: unbounded
     * @var \StructType\Revenue_CenterObjectType[]
     */
    public $Revenue_Center_Reference;
    /**
     * Constructor method for Revenue_Center_Request_ReferencesType
     * @uses Revenue_Center_Request_ReferencesType::setRevenue_Center_Reference()
     * @param \StructType\Revenue_CenterObjectType[] $revenue_Center_Reference
     */
    public function __construct(array $revenue_Center_Reference = array())
    {
        $this
            ->setRevenue_Center_Reference($revenue_Center_Reference);
    }
    /**
     * Get Revenue_Center_Reference value
     * @return \StructType\Revenue_CenterObjectType[]|null
     */
    public function getRevenue_Center_Reference()
    {
        return $this->Revenue_Center_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRevenue_Center_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRevenue_Center_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRevenue_Center_ReferenceForArrayConstraintsFromSetRevenue_Center_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $revenue_Center_Request_ReferencesTypeRevenue_Center_ReferenceItem) {
            // validation for constraint: itemType
            if (!$revenue_Center_Request_ReferencesTypeRevenue_Center_ReferenceItem instanceof \StructType\Revenue_CenterObjectType) {
                $invalidValues[] = is_object($revenue_Center_Request_ReferencesTypeRevenue_Center_ReferenceItem) ? get_class($revenue_Center_Request_ReferencesTypeRevenue_Center_ReferenceItem) : sprintf('%s(%s)', gettype($revenue_Center_Request_ReferencesTypeRevenue_Center_ReferenceItem), var_export($revenue_Center_Request_ReferencesTypeRevenue_Center_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Revenue_Center_Reference property can only contain items of type \StructType\Revenue_CenterObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Revenue_Center_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Revenue_CenterObjectType[] $revenue_Center_Reference
     * @return \StructType\Revenue_Center_Request_ReferencesType
     */
    public function setRevenue_Center_Reference(array $revenue_Center_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($revenue_Center_ReferenceArrayErrorMessage = self::validateRevenue_Center_ReferenceForArrayConstraintsFromSetRevenue_Center_Reference($revenue_Center_Reference))) {
            throw new \InvalidArgumentException($revenue_Center_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Revenue_Center_Reference = $revenue_Center_Reference;
        return $this;
    }
    /**
     * Add item to Revenue_Center_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Revenue_CenterObjectType $item
     * @return \StructType\Revenue_Center_Request_ReferencesType
     */
    public function addToRevenue_Center_Reference(\StructType\Revenue_CenterObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Revenue_CenterObjectType) {
            throw new \InvalidArgumentException(sprintf('The Revenue_Center_Reference property can only contain items of type \StructType\Revenue_CenterObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Revenue_Center_Reference[] = $item;
        return $this;
    }
}
