<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Supplier_Category_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Put Supplier Category Response Data
 * @subpackage Structs
 */
class Put_Supplier_Category_ResponseType extends AbstractStructBase
{
    /**
     * The Supplier_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Category
     * - minOccurs: 0
     * @var \StructType\Supplier_CategoryObjectType
     */
    public $Supplier_Category_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Supplier_Category_ResponseType
     * @uses Put_Supplier_Category_ResponseType::setSupplier_Category_Reference()
     * @uses Put_Supplier_Category_ResponseType::setVersion()
     * @param \StructType\Supplier_CategoryObjectType $supplier_Category_Reference
     * @param string $version
     */
    public function __construct(\StructType\Supplier_CategoryObjectType $supplier_Category_Reference = null, $version = null)
    {
        $this
            ->setSupplier_Category_Reference($supplier_Category_Reference)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Category_Reference value
     * @return \StructType\Supplier_CategoryObjectType|null
     */
    public function getSupplier_Category_Reference()
    {
        return $this->Supplier_Category_Reference;
    }
    /**
     * Set Supplier_Category_Reference value
     * @param \StructType\Supplier_CategoryObjectType $supplier_Category_Reference
     * @return \StructType\Put_Supplier_Category_ResponseType
     */
    public function setSupplier_Category_Reference(\StructType\Supplier_CategoryObjectType $supplier_Category_Reference = null)
    {
        $this->Supplier_Category_Reference = $supplier_Category_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Supplier_Category_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
