<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Year_End_Request_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Procurement Year End Request Line Data
 * @subpackage Structs
 */
class Procurement_Year_End_Request_Line_DataType extends AbstractStructBase
{
    /**
     * The Business_Document_Reference
     * Meta information extracted from the WSDL
     * - documentation: Business Document Reference
     * @var \StructType\Business_DocumentObjectType
     */
    public $Business_Document_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Line Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Exclude_from_Process
     * Meta information extracted from the WSDL
     * - documentation: Exclude from Process option
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Exclude_from_Process;
    /**
     * Constructor method for Procurement_Year_End_Request_Line_DataType
     * @uses Procurement_Year_End_Request_Line_DataType::setBusiness_Document_Reference()
     * @uses Procurement_Year_End_Request_Line_DataType::setMemo()
     * @uses Procurement_Year_End_Request_Line_DataType::setExclude_from_Process()
     * @param \StructType\Business_DocumentObjectType $business_Document_Reference
     * @param string $memo
     * @param bool $exclude_from_Process
     */
    public function __construct(\StructType\Business_DocumentObjectType $business_Document_Reference = null, $memo = null, $exclude_from_Process = null)
    {
        $this
            ->setBusiness_Document_Reference($business_Document_Reference)
            ->setMemo($memo)
            ->setExclude_from_Process($exclude_from_Process);
    }
    /**
     * Get Business_Document_Reference value
     * @return \StructType\Business_DocumentObjectType|null
     */
    public function getBusiness_Document_Reference()
    {
        return $this->Business_Document_Reference;
    }
    /**
     * Set Business_Document_Reference value
     * @param \StructType\Business_DocumentObjectType $business_Document_Reference
     * @return \StructType\Procurement_Year_End_Request_Line_DataType
     */
    public function setBusiness_Document_Reference(\StructType\Business_DocumentObjectType $business_Document_Reference = null)
    {
        $this->Business_Document_Reference = $business_Document_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Procurement_Year_End_Request_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Exclude_from_Process value
     * @return bool|null
     */
    public function getExclude_from_Process()
    {
        return $this->Exclude_from_Process;
    }
    /**
     * Set Exclude_from_Process value
     * @param bool $exclude_from_Process
     * @return \StructType\Procurement_Year_End_Request_Line_DataType
     */
    public function setExclude_from_Process($exclude_from_Process = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_from_Process) && !is_bool($exclude_from_Process)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclude_from_Process, true), gettype($exclude_from_Process)), __LINE__);
        }
        $this->Exclude_from_Process = $exclude_from_Process;
        return $this;
    }
}
