<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Business_Entity_Logo_Image_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Business Entity Logo Image Data is an element containing the logo data.
 * @subpackage Structs
 */
class Business_Entity_Logo_Image_DataType extends AbstractStructBase
{
    /**
     * The Filename
     * Meta information extracted from the WSDL
     * - documentation: Filename of Image | Text attribute identifying Filename of the Attachment.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * @var string
     */
    public $Filename;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - documentation: File content in binary format.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Image;
    /**
     * Constructor method for Business_Entity_Logo_Image_DataType
     * @uses Business_Entity_Logo_Image_DataType::setFilename()
     * @uses Business_Entity_Logo_Image_DataType::setImage()
     * @param string $filename
     * @param string $image
     */
    public function __construct($filename = null, $image = null)
    {
        $this
            ->setFilename($filename)
            ->setImage($image);
    }
    /**
     * Get Filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->Filename;
    }
    /**
     * Set Filename value
     * @param string $filename
     * @return \StructType\Business_Entity_Logo_Image_DataType
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($filename) && mb_strlen($filename) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($filename)), __LINE__);
        }
        $this->Filename = $filename;
        return $this;
    }
    /**
     * Get Image value
     * @return string|null
     */
    public function getImage()
    {
        return $this->Image;
    }
    /**
     * Set Image value
     * @param string $image
     * @return \StructType\Business_Entity_Logo_Image_DataType
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        $this->Image = $image;
        return $this;
    }
}
