<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Pool_HierarchyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resource Pool Hierarchy Element.
 * @subpackage Structs
 */
class Resource_Pool_HierarchyType extends AbstractStructBase
{
    /**
     * The Resource_Pool_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Pool Hierarchy Reference.
     * - minOccurs: 0
     * @var \StructType\Resource_Pool_HierarchyObjectType
     */
    public $Resource_Pool_Hierarchy_Reference;
    /**
     * The Resource_Pool_Hierarchy_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Pool_Hierarchy_DataType[]
     */
    public $Resource_Pool_Hierarchy_Data;
    /**
     * Constructor method for Resource_Pool_HierarchyType
     * @uses Resource_Pool_HierarchyType::setResource_Pool_Hierarchy_Reference()
     * @uses Resource_Pool_HierarchyType::setResource_Pool_Hierarchy_Data()
     * @param \StructType\Resource_Pool_HierarchyObjectType $resource_Pool_Hierarchy_Reference
     * @param \StructType\Resource_Pool_Hierarchy_DataType[] $resource_Pool_Hierarchy_Data
     */
    public function __construct(\StructType\Resource_Pool_HierarchyObjectType $resource_Pool_Hierarchy_Reference = null, array $resource_Pool_Hierarchy_Data = array())
    {
        $this
            ->setResource_Pool_Hierarchy_Reference($resource_Pool_Hierarchy_Reference)
            ->setResource_Pool_Hierarchy_Data($resource_Pool_Hierarchy_Data);
    }
    /**
     * Get Resource_Pool_Hierarchy_Reference value
     * @return \StructType\Resource_Pool_HierarchyObjectType|null
     */
    public function getResource_Pool_Hierarchy_Reference()
    {
        return $this->Resource_Pool_Hierarchy_Reference;
    }
    /**
     * Set Resource_Pool_Hierarchy_Reference value
     * @param \StructType\Resource_Pool_HierarchyObjectType $resource_Pool_Hierarchy_Reference
     * @return \StructType\Resource_Pool_HierarchyType
     */
    public function setResource_Pool_Hierarchy_Reference(\StructType\Resource_Pool_HierarchyObjectType $resource_Pool_Hierarchy_Reference = null)
    {
        $this->Resource_Pool_Hierarchy_Reference = $resource_Pool_Hierarchy_Reference;
        return $this;
    }
    /**
     * Get Resource_Pool_Hierarchy_Data value
     * @return \StructType\Resource_Pool_Hierarchy_DataType[]|null
     */
    public function getResource_Pool_Hierarchy_Data()
    {
        return $this->Resource_Pool_Hierarchy_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Pool_Hierarchy_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Pool_Hierarchy_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Pool_Hierarchy_DataForArrayConstraintsFromSetResource_Pool_Hierarchy_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Pool_HierarchyTypeResource_Pool_Hierarchy_DataItem) {
            // validation for constraint: itemType
            if (!$resource_Pool_HierarchyTypeResource_Pool_Hierarchy_DataItem instanceof \StructType\Resource_Pool_Hierarchy_DataType) {
                $invalidValues[] = is_object($resource_Pool_HierarchyTypeResource_Pool_Hierarchy_DataItem) ? get_class($resource_Pool_HierarchyTypeResource_Pool_Hierarchy_DataItem) : sprintf('%s(%s)', gettype($resource_Pool_HierarchyTypeResource_Pool_Hierarchy_DataItem), var_export($resource_Pool_HierarchyTypeResource_Pool_Hierarchy_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Pool_Hierarchy_Data property can only contain items of type \StructType\Resource_Pool_Hierarchy_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Pool_Hierarchy_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Pool_Hierarchy_DataType[] $resource_Pool_Hierarchy_Data
     * @return \StructType\Resource_Pool_HierarchyType
     */
    public function setResource_Pool_Hierarchy_Data(array $resource_Pool_Hierarchy_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Pool_Hierarchy_DataArrayErrorMessage = self::validateResource_Pool_Hierarchy_DataForArrayConstraintsFromSetResource_Pool_Hierarchy_Data($resource_Pool_Hierarchy_Data))) {
            throw new \InvalidArgumentException($resource_Pool_Hierarchy_DataArrayErrorMessage, __LINE__);
        }
        $this->Resource_Pool_Hierarchy_Data = $resource_Pool_Hierarchy_Data;
        return $this;
    }
    /**
     * Add item to Resource_Pool_Hierarchy_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Pool_Hierarchy_DataType $item
     * @return \StructType\Resource_Pool_HierarchyType
     */
    public function addToResource_Pool_Hierarchy_Data(\StructType\Resource_Pool_Hierarchy_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Pool_Hierarchy_DataType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Pool_Hierarchy_Data property can only contain items of type \StructType\Resource_Pool_Hierarchy_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Pool_Hierarchy_Data[] = $item;
        return $this;
    }
}
