<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Report_Line_Credit_Card_Transaction_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the expense report line's credit card transaction data
 * @subpackage Structs
 */
class Expense_Report_Line_Credit_Card_Transaction_DataType extends AbstractStructBase
{
    /**
     * The Expense_Report_Line_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the expense was incurred.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Report_Line_Date;
    /**
     * The Expense_Credit_Card_Transaction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the expense credit card transaction for the expense.
     * - minOccurs: 0
     * @var \StructType\Credit_Card_TransactionObjectType
     */
    public $Expense_Credit_Card_Transaction_Reference;
    /**
     * The Posted_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the expense was posted.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Posted_Date;
    /**
     * The Transaction_Number
     * Meta information extracted from the WSDL
     * - documentation: The transaction number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Number;
    /**
     * The Expense_Credit_Card_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the credit card that the expense was paid with.
     * - minOccurs: 0
     * @var \StructType\Credit_CardObjectType
     */
    public $Expense_Credit_Card_Reference;
    /**
     * The Transaction_Amount
     * Meta information extracted from the WSDL
     * - documentation: Total amount in the transaction currency.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Transaction_Amount;
    /**
     * The Non_Personal_Transaction_Amount
     * Meta information extracted from the WSDL
     * - documentation: Total amount not marked as personal expense in the transaction currency.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Non_Personal_Transaction_Amount;
    /**
     * The Transaction_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the transaction currency.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Transaction_Currency_Reference;
    /**
     * The Credit_Card_Transaction_Billing_Currency_Conversion_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Credit_Card_Transaction_Billing_Currency_Conversion_DataType
     */
    public $Credit_Card_Transaction_Billing_Currency_Conversion_Data;
    /**
     * The Market_Code
     * Meta information extracted from the WSDL
     * - documentation: The market code for the credit card transaction for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Market_Code;
    /**
     * The Corporate_Account_Reference
     * Meta information extracted from the WSDL
     * - documentation: The corporate account for the credit card transaction for the expense.
     * - minOccurs: 0
     * @var \StructType\Corporate_Credit_Card_AccountObjectType
     */
    public $Corporate_Account_Reference;
    /**
     * Constructor method for Expense_Report_Line_Credit_Card_Transaction_DataType
     * @uses Expense_Report_Line_Credit_Card_Transaction_DataType::setExpense_Report_Line_Date()
     * @uses Expense_Report_Line_Credit_Card_Transaction_DataType::setExpense_Credit_Card_Transaction_Reference()
     * @uses Expense_Report_Line_Credit_Card_Transaction_DataType::setPosted_Date()
     * @uses Expense_Report_Line_Credit_Card_Transaction_DataType::setTransaction_Number()
     * @uses Expense_Report_Line_Credit_Card_Transaction_DataType::setExpense_Credit_Card_Reference()
     * @uses Expense_Report_Line_Credit_Card_Transaction_DataType::setTransaction_Amount()
     * @uses Expense_Report_Line_Credit_Card_Transaction_DataType::setNon_Personal_Transaction_Amount()
     * @uses Expense_Report_Line_Credit_Card_Transaction_DataType::setTransaction_Currency_Reference()
     * @uses Expense_Report_Line_Credit_Card_Transaction_DataType::setCredit_Card_Transaction_Billing_Currency_Conversion_Data()
     * @uses Expense_Report_Line_Credit_Card_Transaction_DataType::setMarket_Code()
     * @uses Expense_Report_Line_Credit_Card_Transaction_DataType::setCorporate_Account_Reference()
     * @param string $expense_Report_Line_Date
     * @param \StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference
     * @param string $posted_Date
     * @param string $transaction_Number
     * @param \StructType\Credit_CardObjectType $expense_Credit_Card_Reference
     * @param float $transaction_Amount
     * @param float $non_Personal_Transaction_Amount
     * @param \StructType\CurrencyObjectType $transaction_Currency_Reference
     * @param \StructType\Credit_Card_Transaction_Billing_Currency_Conversion_DataType $credit_Card_Transaction_Billing_Currency_Conversion_Data
     * @param string $market_Code
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Account_Reference
     */
    public function __construct($expense_Report_Line_Date = null, \StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference = null, $posted_Date = null, $transaction_Number = null, \StructType\Credit_CardObjectType $expense_Credit_Card_Reference = null, $transaction_Amount = null, $non_Personal_Transaction_Amount = null, \StructType\CurrencyObjectType $transaction_Currency_Reference = null, \StructType\Credit_Card_Transaction_Billing_Currency_Conversion_DataType $credit_Card_Transaction_Billing_Currency_Conversion_Data = null, $market_Code = null, \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Account_Reference = null)
    {
        $this
            ->setExpense_Report_Line_Date($expense_Report_Line_Date)
            ->setExpense_Credit_Card_Transaction_Reference($expense_Credit_Card_Transaction_Reference)
            ->setPosted_Date($posted_Date)
            ->setTransaction_Number($transaction_Number)
            ->setExpense_Credit_Card_Reference($expense_Credit_Card_Reference)
            ->setTransaction_Amount($transaction_Amount)
            ->setNon_Personal_Transaction_Amount($non_Personal_Transaction_Amount)
            ->setTransaction_Currency_Reference($transaction_Currency_Reference)
            ->setCredit_Card_Transaction_Billing_Currency_Conversion_Data($credit_Card_Transaction_Billing_Currency_Conversion_Data)
            ->setMarket_Code($market_Code)
            ->setCorporate_Account_Reference($corporate_Account_Reference);
    }
    /**
     * Get Expense_Report_Line_Date value
     * @return string|null
     */
    public function getExpense_Report_Line_Date()
    {
        return $this->Expense_Report_Line_Date;
    }
    /**
     * Set Expense_Report_Line_Date value
     * @param string $expense_Report_Line_Date
     * @return \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType
     */
    public function setExpense_Report_Line_Date($expense_Report_Line_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Report_Line_Date) && !is_string($expense_Report_Line_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Report_Line_Date, true), gettype($expense_Report_Line_Date)), __LINE__);
        }
        $this->Expense_Report_Line_Date = $expense_Report_Line_Date;
        return $this;
    }
    /**
     * Get Expense_Credit_Card_Transaction_Reference value
     * @return \StructType\Credit_Card_TransactionObjectType|null
     */
    public function getExpense_Credit_Card_Transaction_Reference()
    {
        return $this->Expense_Credit_Card_Transaction_Reference;
    }
    /**
     * Set Expense_Credit_Card_Transaction_Reference value
     * @param \StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference
     * @return \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType
     */
    public function setExpense_Credit_Card_Transaction_Reference(\StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference = null)
    {
        $this->Expense_Credit_Card_Transaction_Reference = $expense_Credit_Card_Transaction_Reference;
        return $this;
    }
    /**
     * Get Posted_Date value
     * @return string|null
     */
    public function getPosted_Date()
    {
        return $this->Posted_Date;
    }
    /**
     * Set Posted_Date value
     * @param string $posted_Date
     * @return \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType
     */
    public function setPosted_Date($posted_Date = null)
    {
        // validation for constraint: string
        if (!is_null($posted_Date) && !is_string($posted_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($posted_Date, true), gettype($posted_Date)), __LINE__);
        }
        $this->Posted_Date = $posted_Date;
        return $this;
    }
    /**
     * Get Transaction_Number value
     * @return string|null
     */
    public function getTransaction_Number()
    {
        return $this->Transaction_Number;
    }
    /**
     * Set Transaction_Number value
     * @param string $transaction_Number
     * @return \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType
     */
    public function setTransaction_Number($transaction_Number = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Number) && !is_string($transaction_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Number, true), gettype($transaction_Number)), __LINE__);
        }
        $this->Transaction_Number = $transaction_Number;
        return $this;
    }
    /**
     * Get Expense_Credit_Card_Reference value
     * @return \StructType\Credit_CardObjectType|null
     */
    public function getExpense_Credit_Card_Reference()
    {
        return $this->Expense_Credit_Card_Reference;
    }
    /**
     * Set Expense_Credit_Card_Reference value
     * @param \StructType\Credit_CardObjectType $expense_Credit_Card_Reference
     * @return \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType
     */
    public function setExpense_Credit_Card_Reference(\StructType\Credit_CardObjectType $expense_Credit_Card_Reference = null)
    {
        $this->Expense_Credit_Card_Reference = $expense_Credit_Card_Reference;
        return $this;
    }
    /**
     * Get Transaction_Amount value
     * @return float|null
     */
    public function getTransaction_Amount()
    {
        return $this->Transaction_Amount;
    }
    /**
     * Set Transaction_Amount value
     * @param float $transaction_Amount
     * @return \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType
     */
    public function setTransaction_Amount($transaction_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($transaction_Amount) && !(is_float($transaction_Amount) || is_numeric($transaction_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transaction_Amount, true), gettype($transaction_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($transaction_Amount) && mb_strlen(mb_substr($transaction_Amount, false !== mb_strpos($transaction_Amount, '.') ? mb_strpos($transaction_Amount, '.') + 1 : mb_strlen($transaction_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($transaction_Amount, true), mb_strlen(mb_substr($transaction_Amount, mb_strpos($transaction_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($transaction_Amount) && mb_strlen(preg_replace('/(\D)/', '', $transaction_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($transaction_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $transaction_Amount))), __LINE__);
        }
        $this->Transaction_Amount = $transaction_Amount;
        return $this;
    }
    /**
     * Get Non_Personal_Transaction_Amount value
     * @return float|null
     */
    public function getNon_Personal_Transaction_Amount()
    {
        return $this->{'Non-Personal_Transaction_Amount'};
    }
    /**
     * Set Non_Personal_Transaction_Amount value
     * @param float $non_Personal_Transaction_Amount
     * @return \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType
     */
    public function setNon_Personal_Transaction_Amount($non_Personal_Transaction_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($non_Personal_Transaction_Amount) && !(is_float($non_Personal_Transaction_Amount) || is_numeric($non_Personal_Transaction_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($non_Personal_Transaction_Amount, true), gettype($non_Personal_Transaction_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($non_Personal_Transaction_Amount) && mb_strlen(mb_substr($non_Personal_Transaction_Amount, false !== mb_strpos($non_Personal_Transaction_Amount, '.') ? mb_strpos($non_Personal_Transaction_Amount, '.') + 1 : mb_strlen($non_Personal_Transaction_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($non_Personal_Transaction_Amount, true), mb_strlen(mb_substr($non_Personal_Transaction_Amount, mb_strpos($non_Personal_Transaction_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($non_Personal_Transaction_Amount) && mb_strlen(preg_replace('/(\D)/', '', $non_Personal_Transaction_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($non_Personal_Transaction_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $non_Personal_Transaction_Amount))), __LINE__);
        }
        $this->Non_Personal_Transaction_Amount = $this->{'Non-Personal_Transaction_Amount'} = $non_Personal_Transaction_Amount;
        return $this;
    }
    /**
     * Get Transaction_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getTransaction_Currency_Reference()
    {
        return $this->Transaction_Currency_Reference;
    }
    /**
     * Set Transaction_Currency_Reference value
     * @param \StructType\CurrencyObjectType $transaction_Currency_Reference
     * @return \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType
     */
    public function setTransaction_Currency_Reference(\StructType\CurrencyObjectType $transaction_Currency_Reference = null)
    {
        $this->Transaction_Currency_Reference = $transaction_Currency_Reference;
        return $this;
    }
    /**
     * Get Credit_Card_Transaction_Billing_Currency_Conversion_Data value
     * @return \StructType\Credit_Card_Transaction_Billing_Currency_Conversion_DataType|null
     */
    public function getCredit_Card_Transaction_Billing_Currency_Conversion_Data()
    {
        return $this->Credit_Card_Transaction_Billing_Currency_Conversion_Data;
    }
    /**
     * Set Credit_Card_Transaction_Billing_Currency_Conversion_Data value
     * @param \StructType\Credit_Card_Transaction_Billing_Currency_Conversion_DataType $credit_Card_Transaction_Billing_Currency_Conversion_Data
     * @return \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType
     */
    public function setCredit_Card_Transaction_Billing_Currency_Conversion_Data(\StructType\Credit_Card_Transaction_Billing_Currency_Conversion_DataType $credit_Card_Transaction_Billing_Currency_Conversion_Data = null)
    {
        $this->Credit_Card_Transaction_Billing_Currency_Conversion_Data = $credit_Card_Transaction_Billing_Currency_Conversion_Data;
        return $this;
    }
    /**
     * Get Market_Code value
     * @return string|null
     */
    public function getMarket_Code()
    {
        return $this->Market_Code;
    }
    /**
     * Set Market_Code value
     * @param string $market_Code
     * @return \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType
     */
    public function setMarket_Code($market_Code = null)
    {
        // validation for constraint: string
        if (!is_null($market_Code) && !is_string($market_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($market_Code, true), gettype($market_Code)), __LINE__);
        }
        $this->Market_Code = $market_Code;
        return $this;
    }
    /**
     * Get Corporate_Account_Reference value
     * @return \StructType\Corporate_Credit_Card_AccountObjectType|null
     */
    public function getCorporate_Account_Reference()
    {
        return $this->Corporate_Account_Reference;
    }
    /**
     * Set Corporate_Account_Reference value
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Account_Reference
     * @return \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType
     */
    public function setCorporate_Account_Reference(\StructType\Corporate_Credit_Card_AccountObjectType $corporate_Account_Reference = null)
    {
        $this->Corporate_Account_Reference = $corporate_Account_Reference;
        return $this;
    }
}
