<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bulk_Import_Register_Asset_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for processing many instances of Asset.
 * @subpackage Structs
 */
class Bulk_Import_Register_Asset_RequestType extends AbstractStructBase
{
    /**
     * The Register_Asset_Request
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Register_Asset_RequestType[]
     */
    public $Register_Asset_Request;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Bulk_Import_Register_Asset_RequestType
     * @uses Bulk_Import_Register_Asset_RequestType::setRegister_Asset_Request()
     * @uses Bulk_Import_Register_Asset_RequestType::setVersion()
     * @param \StructType\Register_Asset_RequestType[] $register_Asset_Request
     * @param string $version
     */
    public function __construct(array $register_Asset_Request = array(), $version = null)
    {
        $this
            ->setRegister_Asset_Request($register_Asset_Request)
            ->setVersion($version);
    }
    /**
     * Get Register_Asset_Request value
     * @return \StructType\Register_Asset_RequestType[]|null
     */
    public function getRegister_Asset_Request()
    {
        return $this->Register_Asset_Request;
    }
    /**
     * This method is responsible for validating the values passed to the setRegister_Asset_Request method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRegister_Asset_Request method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRegister_Asset_RequestForArrayConstraintsFromSetRegister_Asset_Request(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bulk_Import_Register_Asset_RequestTypeRegister_Asset_RequestItem) {
            // validation for constraint: itemType
            if (!$bulk_Import_Register_Asset_RequestTypeRegister_Asset_RequestItem instanceof \StructType\Register_Asset_RequestType) {
                $invalidValues[] = is_object($bulk_Import_Register_Asset_RequestTypeRegister_Asset_RequestItem) ? get_class($bulk_Import_Register_Asset_RequestTypeRegister_Asset_RequestItem) : sprintf('%s(%s)', gettype($bulk_Import_Register_Asset_RequestTypeRegister_Asset_RequestItem), var_export($bulk_Import_Register_Asset_RequestTypeRegister_Asset_RequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Register_Asset_Request property can only contain items of type \StructType\Register_Asset_RequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Register_Asset_Request value
     * @throws \InvalidArgumentException
     * @param \StructType\Register_Asset_RequestType[] $register_Asset_Request
     * @return \StructType\Bulk_Import_Register_Asset_RequestType
     */
    public function setRegister_Asset_Request(array $register_Asset_Request = array())
    {
        // validation for constraint: array
        if ('' !== ($register_Asset_RequestArrayErrorMessage = self::validateRegister_Asset_RequestForArrayConstraintsFromSetRegister_Asset_Request($register_Asset_Request))) {
            throw new \InvalidArgumentException($register_Asset_RequestArrayErrorMessage, __LINE__);
        }
        $this->Register_Asset_Request = $register_Asset_Request;
        return $this;
    }
    /**
     * Add item to Register_Asset_Request value
     * @throws \InvalidArgumentException
     * @param \StructType\Register_Asset_RequestType $item
     * @return \StructType\Bulk_Import_Register_Asset_RequestType
     */
    public function addToRegister_Asset_Request(\StructType\Register_Asset_RequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Register_Asset_RequestType) {
            throw new \InvalidArgumentException(sprintf('The Register_Asset_Request property can only contain items of type \StructType\Register_Asset_RequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Register_Asset_Request[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Bulk_Import_Register_Asset_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
