<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Workday_Project_Hierarchy_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Submit Workday Project Hierarchy Response Element.
 * @subpackage Structs
 */
class Submit_Workday_Project_Hierarchy_ResponseType extends AbstractStructBase
{
    /**
     * The Project_Hierarchies_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Hierarchies Work Set in response element for Submit Workday Project Hierarchy web service
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_HierarchyObjectType[]
     */
    public $Project_Hierarchies_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Workday_Project_Hierarchy_ResponseType
     * @uses Submit_Workday_Project_Hierarchy_ResponseType::setProject_Hierarchies_Reference()
     * @uses Submit_Workday_Project_Hierarchy_ResponseType::setVersion()
     * @param \StructType\Project_HierarchyObjectType[] $project_Hierarchies_Reference
     * @param string $version
     */
    public function __construct(array $project_Hierarchies_Reference = array(), $version = null)
    {
        $this
            ->setProject_Hierarchies_Reference($project_Hierarchies_Reference)
            ->setVersion($version);
    }
    /**
     * Get Project_Hierarchies_Reference value
     * @return \StructType\Project_HierarchyObjectType[]|null
     */
    public function getProject_Hierarchies_Reference()
    {
        return $this->Project_Hierarchies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Hierarchies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Hierarchies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Hierarchies_ReferenceForArrayConstraintsFromSetProject_Hierarchies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Workday_Project_Hierarchy_ResponseTypeProject_Hierarchies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$submit_Workday_Project_Hierarchy_ResponseTypeProject_Hierarchies_ReferenceItem instanceof \StructType\Project_HierarchyObjectType) {
                $invalidValues[] = is_object($submit_Workday_Project_Hierarchy_ResponseTypeProject_Hierarchies_ReferenceItem) ? get_class($submit_Workday_Project_Hierarchy_ResponseTypeProject_Hierarchies_ReferenceItem) : sprintf('%s(%s)', gettype($submit_Workday_Project_Hierarchy_ResponseTypeProject_Hierarchies_ReferenceItem), var_export($submit_Workday_Project_Hierarchy_ResponseTypeProject_Hierarchies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Hierarchies_Reference property can only contain items of type \StructType\Project_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Hierarchies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_HierarchyObjectType[] $project_Hierarchies_Reference
     * @return \StructType\Submit_Workday_Project_Hierarchy_ResponseType
     */
    public function setProject_Hierarchies_Reference(array $project_Hierarchies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Hierarchies_ReferenceArrayErrorMessage = self::validateProject_Hierarchies_ReferenceForArrayConstraintsFromSetProject_Hierarchies_Reference($project_Hierarchies_Reference))) {
            throw new \InvalidArgumentException($project_Hierarchies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Hierarchies_Reference = $project_Hierarchies_Reference;
        return $this;
    }
    /**
     * Add item to Project_Hierarchies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_HierarchyObjectType $item
     * @return \StructType\Submit_Workday_Project_Hierarchy_ResponseType
     */
    public function addToProject_Hierarchies_Reference(\StructType\Project_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Hierarchies_Reference property can only contain items of type \StructType\Project_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Hierarchies_Reference[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Workday_Project_Hierarchy_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
