<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_AdjustmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Receipt Adjustment
 * @subpackage Structs
 */
class Receipt_AdjustmentType extends AbstractStructBase
{
    /**
     * The Receipt_Adjustment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Receipt Adjustment
     * - minOccurs: 0
     * @var \StructType\Receipt_AdjustmentObjectType
     */
    public $Receipt_Adjustment_Reference;
    /**
     * The Receipt_Adjustment_Number
     * Meta information extracted from the WSDL
     * - documentation: Document Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Adjustment_Number;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Receipt_Adjustment_Date
     * Meta information extracted from the WSDL
     * - documentation: Document Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Adjustment_Date;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Header level comment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Reference
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Receipt_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Receipt being Adjusted by Receipt Adjustment
     * - minOccurs: 0
     * @var \StructType\ReceiptObjectType
     */
    public $Receipt_Reference;
    /**
     * The Advanced_Ship_Notice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Advanced Ship Notice.
     * - minOccurs: 0
     * @var \StructType\Advanced_Ship_NoticeObjectType
     */
    public $Advanced_Ship_Notice_Reference;
    /**
     * The Carrier_Tracking_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Order Reference recorded on Receipt Adjustment.This field is outbound only; any data submitted will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier_Tracking_Number;
    /**
     * The Supplier_Order_Ref
     * Meta information extracted from the WSDL
     * - documentation: Supplier Order Reference recorded on Receipt Adjustment.This field is outbound only; any data submitted will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Order_Ref;
    /**
     * The Shipment_Ref
     * Meta information extracted from the WSDL
     * - documentation: Shipment Reference recorded for Receipt Adjustment. This field is outbound only; any data submitted will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_Ref;
    /**
     * The Bill_of_Lading_for_Receipt
     * Meta information extracted from the WSDL
     * - documentation: Bill of Lading recorded on Receipt Adjustment. This field is outbound only; any data submitted will be ignored.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bill_of_Lading_for_Receipt;
    /**
     * The Bill_of_Lading_Quantity_for_Receipt
     * Meta information extracted from the WSDL
     * - documentation: Bill of Lading Quantity recorded on Receipt Adjustment. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 20
     * @var float
     */
    public $Bill_of_Lading_Quantity_for_Receipt;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Currency used in Receipt Adjustment
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Created_by_Person_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Person that created the Receipt Adjustment
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Created_by_Person_Reference;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Document Status of the Receipt Adjustment. This field is outbound only; any data submitted will be ignored.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Document_Status_Reference;
    /**
     * The Item_Receipt_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing data for Item Receipt Adjustment Line data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receipt_Adjustment_Item_Line_DataType[]
     */
    public $Item_Receipt_Line_Data;
    /**
     * The Service_Receipt_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing data for Service Receipt Adjustment Line data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Receipt_Adjustment_Service_Line_DataType[]
     */
    public $Service_Receipt_Line_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_with_Attachment_Category_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Receipt_AdjustmentType
     * @uses Receipt_AdjustmentType::setReceipt_Adjustment_Reference()
     * @uses Receipt_AdjustmentType::setReceipt_Adjustment_Number()
     * @uses Receipt_AdjustmentType::setCompany_Reference()
     * @uses Receipt_AdjustmentType::setSupplier_Reference()
     * @uses Receipt_AdjustmentType::setReceipt_Adjustment_Date()
     * @uses Receipt_AdjustmentType::setMemo()
     * @uses Receipt_AdjustmentType::setPurchase_Order_Reference()
     * @uses Receipt_AdjustmentType::setReceipt_Reference()
     * @uses Receipt_AdjustmentType::setAdvanced_Ship_Notice_Reference()
     * @uses Receipt_AdjustmentType::setCarrier_Tracking_Number()
     * @uses Receipt_AdjustmentType::setSupplier_Order_Ref()
     * @uses Receipt_AdjustmentType::setShipment_Ref()
     * @uses Receipt_AdjustmentType::setBill_of_Lading_for_Receipt()
     * @uses Receipt_AdjustmentType::setBill_of_Lading_Quantity_for_Receipt()
     * @uses Receipt_AdjustmentType::setCurrency_Reference()
     * @uses Receipt_AdjustmentType::setCreated_by_Person_Reference()
     * @uses Receipt_AdjustmentType::setDocument_Status_Reference()
     * @uses Receipt_AdjustmentType::setItem_Receipt_Line_Data()
     * @uses Receipt_AdjustmentType::setService_Receipt_Line_Data()
     * @uses Receipt_AdjustmentType::setAttachment_Data()
     * @param \StructType\Receipt_AdjustmentObjectType $receipt_Adjustment_Reference
     * @param string $receipt_Adjustment_Number
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param string $receipt_Adjustment_Date
     * @param string $memo
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param \StructType\ReceiptObjectType $receipt_Reference
     * @param \StructType\Advanced_Ship_NoticeObjectType $advanced_Ship_Notice_Reference
     * @param string $carrier_Tracking_Number
     * @param string $supplier_Order_Ref
     * @param string $shipment_Ref
     * @param string $bill_of_Lading_for_Receipt
     * @param float $bill_of_Lading_Quantity_for_Receipt
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Unique_IdentifierObjectType $created_by_Person_Reference
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @param \StructType\Receipt_Adjustment_Item_Line_DataType[] $item_Receipt_Line_Data
     * @param \StructType\Receipt_Adjustment_Service_Line_DataType[] $service_Receipt_Line_Data
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     */
    public function __construct(\StructType\Receipt_AdjustmentObjectType $receipt_Adjustment_Reference = null, $receipt_Adjustment_Number = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, $receipt_Adjustment_Date = null, $memo = null, \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, \StructType\ReceiptObjectType $receipt_Reference = null, \StructType\Advanced_Ship_NoticeObjectType $advanced_Ship_Notice_Reference = null, $carrier_Tracking_Number = null, $supplier_Order_Ref = null, $shipment_Ref = null, $bill_of_Lading_for_Receipt = null, $bill_of_Lading_Quantity_for_Receipt = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Unique_IdentifierObjectType $created_by_Person_Reference = null, \StructType\Document_StatusObjectType $document_Status_Reference = null, array $item_Receipt_Line_Data = array(), array $service_Receipt_Line_Data = array(), array $attachment_Data = array())
    {
        $this
            ->setReceipt_Adjustment_Reference($receipt_Adjustment_Reference)
            ->setReceipt_Adjustment_Number($receipt_Adjustment_Number)
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setReceipt_Adjustment_Date($receipt_Adjustment_Date)
            ->setMemo($memo)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setReceipt_Reference($receipt_Reference)
            ->setAdvanced_Ship_Notice_Reference($advanced_Ship_Notice_Reference)
            ->setCarrier_Tracking_Number($carrier_Tracking_Number)
            ->setSupplier_Order_Ref($supplier_Order_Ref)
            ->setShipment_Ref($shipment_Ref)
            ->setBill_of_Lading_for_Receipt($bill_of_Lading_for_Receipt)
            ->setBill_of_Lading_Quantity_for_Receipt($bill_of_Lading_Quantity_for_Receipt)
            ->setCurrency_Reference($currency_Reference)
            ->setCreated_by_Person_Reference($created_by_Person_Reference)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setItem_Receipt_Line_Data($item_Receipt_Line_Data)
            ->setService_Receipt_Line_Data($service_Receipt_Line_Data)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Receipt_Adjustment_Reference value
     * @return \StructType\Receipt_AdjustmentObjectType|null
     */
    public function getReceipt_Adjustment_Reference()
    {
        return $this->Receipt_Adjustment_Reference;
    }
    /**
     * Set Receipt_Adjustment_Reference value
     * @param \StructType\Receipt_AdjustmentObjectType $receipt_Adjustment_Reference
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setReceipt_Adjustment_Reference(\StructType\Receipt_AdjustmentObjectType $receipt_Adjustment_Reference = null)
    {
        $this->Receipt_Adjustment_Reference = $receipt_Adjustment_Reference;
        return $this;
    }
    /**
     * Get Receipt_Adjustment_Number value
     * @return string|null
     */
    public function getReceipt_Adjustment_Number()
    {
        return $this->Receipt_Adjustment_Number;
    }
    /**
     * Set Receipt_Adjustment_Number value
     * @param string $receipt_Adjustment_Number
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setReceipt_Adjustment_Number($receipt_Adjustment_Number = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Adjustment_Number) && !is_string($receipt_Adjustment_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Adjustment_Number, true), gettype($receipt_Adjustment_Number)), __LINE__);
        }
        $this->Receipt_Adjustment_Number = $receipt_Adjustment_Number;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Receipt_Adjustment_Date value
     * @return string|null
     */
    public function getReceipt_Adjustment_Date()
    {
        return $this->Receipt_Adjustment_Date;
    }
    /**
     * Set Receipt_Adjustment_Date value
     * @param string $receipt_Adjustment_Date
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setReceipt_Adjustment_Date($receipt_Adjustment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Adjustment_Date) && !is_string($receipt_Adjustment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Adjustment_Date, true), gettype($receipt_Adjustment_Date)), __LINE__);
        }
        $this->Receipt_Adjustment_Date = $receipt_Adjustment_Date;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Receipt_Reference value
     * @return \StructType\ReceiptObjectType|null
     */
    public function getReceipt_Reference()
    {
        return $this->Receipt_Reference;
    }
    /**
     * Set Receipt_Reference value
     * @param \StructType\ReceiptObjectType $receipt_Reference
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setReceipt_Reference(\StructType\ReceiptObjectType $receipt_Reference = null)
    {
        $this->Receipt_Reference = $receipt_Reference;
        return $this;
    }
    /**
     * Get Advanced_Ship_Notice_Reference value
     * @return \StructType\Advanced_Ship_NoticeObjectType|null
     */
    public function getAdvanced_Ship_Notice_Reference()
    {
        return $this->Advanced_Ship_Notice_Reference;
    }
    /**
     * Set Advanced_Ship_Notice_Reference value
     * @param \StructType\Advanced_Ship_NoticeObjectType $advanced_Ship_Notice_Reference
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setAdvanced_Ship_Notice_Reference(\StructType\Advanced_Ship_NoticeObjectType $advanced_Ship_Notice_Reference = null)
    {
        $this->Advanced_Ship_Notice_Reference = $advanced_Ship_Notice_Reference;
        return $this;
    }
    /**
     * Get Carrier_Tracking_Number value
     * @return string|null
     */
    public function getCarrier_Tracking_Number()
    {
        return $this->Carrier_Tracking_Number;
    }
    /**
     * Set Carrier_Tracking_Number value
     * @param string $carrier_Tracking_Number
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setCarrier_Tracking_Number($carrier_Tracking_Number = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_Tracking_Number) && !is_string($carrier_Tracking_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_Tracking_Number, true), gettype($carrier_Tracking_Number)), __LINE__);
        }
        $this->Carrier_Tracking_Number = $carrier_Tracking_Number;
        return $this;
    }
    /**
     * Get Supplier_Order_Ref value
     * @return string|null
     */
    public function getSupplier_Order_Ref()
    {
        return $this->Supplier_Order_Ref;
    }
    /**
     * Set Supplier_Order_Ref value
     * @param string $supplier_Order_Ref
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setSupplier_Order_Ref($supplier_Order_Ref = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Order_Ref) && !is_string($supplier_Order_Ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Order_Ref, true), gettype($supplier_Order_Ref)), __LINE__);
        }
        $this->Supplier_Order_Ref = $supplier_Order_Ref;
        return $this;
    }
    /**
     * Get Shipment_Ref value
     * @return string|null
     */
    public function getShipment_Ref()
    {
        return $this->Shipment_Ref;
    }
    /**
     * Set Shipment_Ref value
     * @param string $shipment_Ref
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setShipment_Ref($shipment_Ref = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_Ref) && !is_string($shipment_Ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_Ref, true), gettype($shipment_Ref)), __LINE__);
        }
        $this->Shipment_Ref = $shipment_Ref;
        return $this;
    }
    /**
     * Get Bill_of_Lading_for_Receipt value
     * @return string|null
     */
    public function getBill_of_Lading_for_Receipt()
    {
        return $this->Bill_of_Lading_for_Receipt;
    }
    /**
     * Set Bill_of_Lading_for_Receipt value
     * @param string $bill_of_Lading_for_Receipt
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setBill_of_Lading_for_Receipt($bill_of_Lading_for_Receipt = null)
    {
        // validation for constraint: string
        if (!is_null($bill_of_Lading_for_Receipt) && !is_string($bill_of_Lading_for_Receipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bill_of_Lading_for_Receipt, true), gettype($bill_of_Lading_for_Receipt)), __LINE__);
        }
        $this->Bill_of_Lading_for_Receipt = $bill_of_Lading_for_Receipt;
        return $this;
    }
    /**
     * Get Bill_of_Lading_Quantity_for_Receipt value
     * @return float|null
     */
    public function getBill_of_Lading_Quantity_for_Receipt()
    {
        return $this->Bill_of_Lading_Quantity_for_Receipt;
    }
    /**
     * Set Bill_of_Lading_Quantity_for_Receipt value
     * @param float $bill_of_Lading_Quantity_for_Receipt
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setBill_of_Lading_Quantity_for_Receipt($bill_of_Lading_Quantity_for_Receipt = null)
    {
        // validation for constraint: float
        if (!is_null($bill_of_Lading_Quantity_for_Receipt) && !(is_float($bill_of_Lading_Quantity_for_Receipt) || is_numeric($bill_of_Lading_Quantity_for_Receipt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bill_of_Lading_Quantity_for_Receipt, true), gettype($bill_of_Lading_Quantity_for_Receipt)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($bill_of_Lading_Quantity_for_Receipt) && mb_strlen(mb_substr($bill_of_Lading_Quantity_for_Receipt, false !== mb_strpos($bill_of_Lading_Quantity_for_Receipt, '.') ? mb_strpos($bill_of_Lading_Quantity_for_Receipt, '.') + 1 : mb_strlen($bill_of_Lading_Quantity_for_Receipt))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($bill_of_Lading_Quantity_for_Receipt, true), mb_strlen(mb_substr($bill_of_Lading_Quantity_for_Receipt, mb_strpos($bill_of_Lading_Quantity_for_Receipt, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bill_of_Lading_Quantity_for_Receipt) && $bill_of_Lading_Quantity_for_Receipt < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bill_of_Lading_Quantity_for_Receipt, true)), __LINE__);
        }
        // validation for constraint: totalDigits(20)
        if (!is_null($bill_of_Lading_Quantity_for_Receipt) && mb_strlen(preg_replace('/(\D)/', '', $bill_of_Lading_Quantity_for_Receipt)) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 20 digits, "%d" given', var_export($bill_of_Lading_Quantity_for_Receipt, true), mb_strlen(preg_replace('/(\D)/', '', $bill_of_Lading_Quantity_for_Receipt))), __LINE__);
        }
        $this->Bill_of_Lading_Quantity_for_Receipt = $bill_of_Lading_Quantity_for_Receipt;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Created_by_Person_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getCreated_by_Person_Reference()
    {
        return $this->Created_by_Person_Reference;
    }
    /**
     * Set Created_by_Person_Reference value
     * @param \StructType\Unique_IdentifierObjectType $created_by_Person_Reference
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setCreated_by_Person_Reference(\StructType\Unique_IdentifierObjectType $created_by_Person_Reference = null)
    {
        $this->Created_by_Person_Reference = $created_by_Person_Reference;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * Set Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setDocument_Status_Reference(\StructType\Document_StatusObjectType $document_Status_Reference = null)
    {
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Get Item_Receipt_Line_Data value
     * @return \StructType\Receipt_Adjustment_Item_Line_DataType[]|null
     */
    public function getItem_Receipt_Line_Data()
    {
        return $this->Item_Receipt_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Receipt_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Receipt_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Receipt_Line_DataForArrayConstraintsFromSetItem_Receipt_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_AdjustmentTypeItem_Receipt_Line_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_AdjustmentTypeItem_Receipt_Line_DataItem instanceof \StructType\Receipt_Adjustment_Item_Line_DataType) {
                $invalidValues[] = is_object($receipt_AdjustmentTypeItem_Receipt_Line_DataItem) ? get_class($receipt_AdjustmentTypeItem_Receipt_Line_DataItem) : sprintf('%s(%s)', gettype($receipt_AdjustmentTypeItem_Receipt_Line_DataItem), var_export($receipt_AdjustmentTypeItem_Receipt_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Receipt_Line_Data property can only contain items of type \StructType\Receipt_Adjustment_Item_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Receipt_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Adjustment_Item_Line_DataType[] $item_Receipt_Line_Data
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setItem_Receipt_Line_Data(array $item_Receipt_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Receipt_Line_DataArrayErrorMessage = self::validateItem_Receipt_Line_DataForArrayConstraintsFromSetItem_Receipt_Line_Data($item_Receipt_Line_Data))) {
            throw new \InvalidArgumentException($item_Receipt_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Item_Receipt_Line_Data = $item_Receipt_Line_Data;
        return $this;
    }
    /**
     * Add item to Item_Receipt_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Adjustment_Item_Line_DataType $item
     * @return \StructType\Receipt_AdjustmentType
     */
    public function addToItem_Receipt_Line_Data(\StructType\Receipt_Adjustment_Item_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_Adjustment_Item_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Item_Receipt_Line_Data property can only contain items of type \StructType\Receipt_Adjustment_Item_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Receipt_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Service_Receipt_Line_Data value
     * @return \StructType\Receipt_Adjustment_Service_Line_DataType[]|null
     */
    public function getService_Receipt_Line_Data()
    {
        return $this->Service_Receipt_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setService_Receipt_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService_Receipt_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateService_Receipt_Line_DataForArrayConstraintsFromSetService_Receipt_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_AdjustmentTypeService_Receipt_Line_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_AdjustmentTypeService_Receipt_Line_DataItem instanceof \StructType\Receipt_Adjustment_Service_Line_DataType) {
                $invalidValues[] = is_object($receipt_AdjustmentTypeService_Receipt_Line_DataItem) ? get_class($receipt_AdjustmentTypeService_Receipt_Line_DataItem) : sprintf('%s(%s)', gettype($receipt_AdjustmentTypeService_Receipt_Line_DataItem), var_export($receipt_AdjustmentTypeService_Receipt_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service_Receipt_Line_Data property can only contain items of type \StructType\Receipt_Adjustment_Service_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service_Receipt_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Adjustment_Service_Line_DataType[] $service_Receipt_Line_Data
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setService_Receipt_Line_Data(array $service_Receipt_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($service_Receipt_Line_DataArrayErrorMessage = self::validateService_Receipt_Line_DataForArrayConstraintsFromSetService_Receipt_Line_Data($service_Receipt_Line_Data))) {
            throw new \InvalidArgumentException($service_Receipt_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Service_Receipt_Line_Data = $service_Receipt_Line_Data;
        return $this;
    }
    /**
     * Add item to Service_Receipt_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Receipt_Adjustment_Service_Line_DataType $item
     * @return \StructType\Receipt_AdjustmentType
     */
    public function addToService_Receipt_Line_Data(\StructType\Receipt_Adjustment_Service_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Receipt_Adjustment_Service_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Service_Receipt_Line_Data property can only contain items of type \StructType\Receipt_Adjustment_Service_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service_Receipt_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_AdjustmentTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$receipt_AdjustmentTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
                $invalidValues[] = is_object($receipt_AdjustmentTypeAttachment_DataItem) ? get_class($receipt_AdjustmentTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($receipt_AdjustmentTypeAttachment_DataItem), var_export($receipt_AdjustmentTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     * @return \StructType\Receipt_AdjustmentType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType $item
     * @return \StructType\Receipt_AdjustmentType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_with_Attachment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
