<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Standard_Cost_Rate_Sheet_Response_GroupType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Project Role Standard Cost Rate response grouping options
 * @subpackage Structs
 */
class Project_Standard_Cost_Rate_Sheet_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the Reference of the Project Role Standard Cost Rate Sheet is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Project_Role_Standard_Cost_Rate_Sheet_data
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the details of the Project Role Standard Cost Rate Sheet is included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Project_Role_Standard_Cost_Rate_Sheet_data;
    /**
     * Constructor method for Project_Standard_Cost_Rate_Sheet_Response_GroupType
     * @uses Project_Standard_Cost_Rate_Sheet_Response_GroupType::setInclude_Reference()
     * @uses Project_Standard_Cost_Rate_Sheet_Response_GroupType::setInclude_Project_Role_Standard_Cost_Rate_Sheet_data()
     * @param bool $include_Reference
     * @param bool $include_Project_Role_Standard_Cost_Rate_Sheet_data
     */
    public function __construct($include_Reference = null, $include_Project_Role_Standard_Cost_Rate_Sheet_data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Project_Role_Standard_Cost_Rate_Sheet_data($include_Project_Role_Standard_Cost_Rate_Sheet_data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Project_Role_Standard_Cost_Rate_Sheet_data value
     * @return bool|null
     */
    public function getInclude_Project_Role_Standard_Cost_Rate_Sheet_data()
    {
        return $this->Include_Project_Role_Standard_Cost_Rate_Sheet_data;
    }
    /**
     * Set Include_Project_Role_Standard_Cost_Rate_Sheet_data value
     * @param bool $include_Project_Role_Standard_Cost_Rate_Sheet_data
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_Response_GroupType
     */
    public function setInclude_Project_Role_Standard_Cost_Rate_Sheet_data($include_Project_Role_Standard_Cost_Rate_Sheet_data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Project_Role_Standard_Cost_Rate_Sheet_data) && !is_bool($include_Project_Role_Standard_Cost_Rate_Sheet_data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Project_Role_Standard_Cost_Rate_Sheet_data, true), gettype($include_Project_Role_Standard_Cost_Rate_Sheet_data)), __LINE__);
        }
        $this->Include_Project_Role_Standard_Cost_Rate_Sheet_data = $include_Project_Role_Standard_Cost_Rate_Sheet_data;
        return $this;
    }
}
