<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Standard_Cost_Rate_Sheet_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Project Standard Cost Rate Sheet data
 * @subpackage Structs
 */
class Project_Standard_Cost_Rate_Sheet_DataType extends AbstractStructBase
{
    /**
     * The Project_Standard_Cost_Rate_Sheet_ID
     * Meta information extracted from the WSDL
     * - documentation: Project Role Standard Cost Rate Sheet ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Standard_Cost_Rate_Sheet_ID;
    /**
     * The Standard_Cost_Rate_Sheet_Name
     * Meta information extracted from the WSDL
     * - documentation: Project Rate Sheet Name
     * - maxOccurs: 1
     * @var string
     */
    public $Standard_Cost_Rate_Sheet_Name;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Inactivate Standard Cost Rate Sheet
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Rate_Sheet_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Rate Sheet Currency
     * @var \StructType\CurrencyObjectType
     */
    public $Rate_Sheet_Currency_Reference;
    /**
     * The Project_Standard_Cost_Rate_Sheet_Snapshot_Data
     * Meta information extracted from the WSDL
     * - documentation: Project Standard Cost Rate Sheet Snapshot Details
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType[]
     */
    public $Project_Standard_Cost_Rate_Sheet_Snapshot_Data;
    /**
     * Constructor method for Project_Standard_Cost_Rate_Sheet_DataType
     * @uses Project_Standard_Cost_Rate_Sheet_DataType::setProject_Standard_Cost_Rate_Sheet_ID()
     * @uses Project_Standard_Cost_Rate_Sheet_DataType::setStandard_Cost_Rate_Sheet_Name()
     * @uses Project_Standard_Cost_Rate_Sheet_DataType::setInactive()
     * @uses Project_Standard_Cost_Rate_Sheet_DataType::setRate_Sheet_Currency_Reference()
     * @uses Project_Standard_Cost_Rate_Sheet_DataType::setProject_Standard_Cost_Rate_Sheet_Snapshot_Data()
     * @param string $project_Standard_Cost_Rate_Sheet_ID
     * @param string $standard_Cost_Rate_Sheet_Name
     * @param bool $inactive
     * @param \StructType\CurrencyObjectType $rate_Sheet_Currency_Reference
     * @param \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType[] $project_Standard_Cost_Rate_Sheet_Snapshot_Data
     */
    public function __construct($project_Standard_Cost_Rate_Sheet_ID = null, $standard_Cost_Rate_Sheet_Name = null, $inactive = null, \StructType\CurrencyObjectType $rate_Sheet_Currency_Reference = null, array $project_Standard_Cost_Rate_Sheet_Snapshot_Data = array())
    {
        $this
            ->setProject_Standard_Cost_Rate_Sheet_ID($project_Standard_Cost_Rate_Sheet_ID)
            ->setStandard_Cost_Rate_Sheet_Name($standard_Cost_Rate_Sheet_Name)
            ->setInactive($inactive)
            ->setRate_Sheet_Currency_Reference($rate_Sheet_Currency_Reference)
            ->setProject_Standard_Cost_Rate_Sheet_Snapshot_Data($project_Standard_Cost_Rate_Sheet_Snapshot_Data);
    }
    /**
     * Get Project_Standard_Cost_Rate_Sheet_ID value
     * @return string|null
     */
    public function getProject_Standard_Cost_Rate_Sheet_ID()
    {
        return $this->Project_Standard_Cost_Rate_Sheet_ID;
    }
    /**
     * Set Project_Standard_Cost_Rate_Sheet_ID value
     * @param string $project_Standard_Cost_Rate_Sheet_ID
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_DataType
     */
    public function setProject_Standard_Cost_Rate_Sheet_ID($project_Standard_Cost_Rate_Sheet_ID = null)
    {
        // validation for constraint: string
        if (!is_null($project_Standard_Cost_Rate_Sheet_ID) && !is_string($project_Standard_Cost_Rate_Sheet_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Standard_Cost_Rate_Sheet_ID, true), gettype($project_Standard_Cost_Rate_Sheet_ID)), __LINE__);
        }
        $this->Project_Standard_Cost_Rate_Sheet_ID = $project_Standard_Cost_Rate_Sheet_ID;
        return $this;
    }
    /**
     * Get Standard_Cost_Rate_Sheet_Name value
     * @return string|null
     */
    public function getStandard_Cost_Rate_Sheet_Name()
    {
        return $this->Standard_Cost_Rate_Sheet_Name;
    }
    /**
     * Set Standard_Cost_Rate_Sheet_Name value
     * @param string $standard_Cost_Rate_Sheet_Name
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_DataType
     */
    public function setStandard_Cost_Rate_Sheet_Name($standard_Cost_Rate_Sheet_Name = null)
    {
        // validation for constraint: string
        if (!is_null($standard_Cost_Rate_Sheet_Name) && !is_string($standard_Cost_Rate_Sheet_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standard_Cost_Rate_Sheet_Name, true), gettype($standard_Cost_Rate_Sheet_Name)), __LINE__);
        }
        $this->Standard_Cost_Rate_Sheet_Name = $standard_Cost_Rate_Sheet_Name;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Rate_Sheet_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getRate_Sheet_Currency_Reference()
    {
        return $this->Rate_Sheet_Currency_Reference;
    }
    /**
     * Set Rate_Sheet_Currency_Reference value
     * @param \StructType\CurrencyObjectType $rate_Sheet_Currency_Reference
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_DataType
     */
    public function setRate_Sheet_Currency_Reference(\StructType\CurrencyObjectType $rate_Sheet_Currency_Reference = null)
    {
        $this->Rate_Sheet_Currency_Reference = $rate_Sheet_Currency_Reference;
        return $this;
    }
    /**
     * Get Project_Standard_Cost_Rate_Sheet_Snapshot_Data value
     * @return \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType[]|null
     */
    public function getProject_Standard_Cost_Rate_Sheet_Snapshot_Data()
    {
        return $this->Project_Standard_Cost_Rate_Sheet_Snapshot_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Standard_Cost_Rate_Sheet_Snapshot_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Standard_Cost_Rate_Sheet_Snapshot_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Standard_Cost_Rate_Sheet_Snapshot_DataForArrayConstraintsFromSetProject_Standard_Cost_Rate_Sheet_Snapshot_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Standard_Cost_Rate_Sheet_DataTypeProject_Standard_Cost_Rate_Sheet_Snapshot_DataItem) {
            // validation for constraint: itemType
            if (!$project_Standard_Cost_Rate_Sheet_DataTypeProject_Standard_Cost_Rate_Sheet_Snapshot_DataItem instanceof \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType) {
                $invalidValues[] = is_object($project_Standard_Cost_Rate_Sheet_DataTypeProject_Standard_Cost_Rate_Sheet_Snapshot_DataItem) ? get_class($project_Standard_Cost_Rate_Sheet_DataTypeProject_Standard_Cost_Rate_Sheet_Snapshot_DataItem) : sprintf('%s(%s)', gettype($project_Standard_Cost_Rate_Sheet_DataTypeProject_Standard_Cost_Rate_Sheet_Snapshot_DataItem), var_export($project_Standard_Cost_Rate_Sheet_DataTypeProject_Standard_Cost_Rate_Sheet_Snapshot_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Standard_Cost_Rate_Sheet_Snapshot_Data property can only contain items of type \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Standard_Cost_Rate_Sheet_Snapshot_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType[] $project_Standard_Cost_Rate_Sheet_Snapshot_Data
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_DataType
     */
    public function setProject_Standard_Cost_Rate_Sheet_Snapshot_Data(array $project_Standard_Cost_Rate_Sheet_Snapshot_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Standard_Cost_Rate_Sheet_Snapshot_DataArrayErrorMessage = self::validateProject_Standard_Cost_Rate_Sheet_Snapshot_DataForArrayConstraintsFromSetProject_Standard_Cost_Rate_Sheet_Snapshot_Data($project_Standard_Cost_Rate_Sheet_Snapshot_Data))) {
            throw new \InvalidArgumentException($project_Standard_Cost_Rate_Sheet_Snapshot_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Standard_Cost_Rate_Sheet_Snapshot_Data = $project_Standard_Cost_Rate_Sheet_Snapshot_Data;
        return $this;
    }
    /**
     * Add item to Project_Standard_Cost_Rate_Sheet_Snapshot_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType $item
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_DataType
     */
    public function addToProject_Standard_Cost_Rate_Sheet_Snapshot_Data(\StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType) {
            throw new \InvalidArgumentException(sprintf('The Project_Standard_Cost_Rate_Sheet_Snapshot_Data property can only contain items of type \StructType\Project_Standard_Cost_Rate_Snapshot_DetailsType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Standard_Cost_Rate_Sheet_Snapshot_Data[] = $item;
        return $this;
    }
}
