<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Condition_Rule_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains each Procurement Condition Rule based on the Request References or Request Criteria.
 * @subpackage Structs
 */
class Procurement_Condition_Rule_Response_DataType extends AbstractStructBase
{
    /**
     * The Procurement_Condition_Rule
     * Meta information extracted from the WSDL
     * - documentation: Procurement Condition Rule
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Procurement_Condition_RuleType[]
     */
    public $Procurement_Condition_Rule;
    /**
     * Constructor method for Procurement_Condition_Rule_Response_DataType
     * @uses Procurement_Condition_Rule_Response_DataType::setProcurement_Condition_Rule()
     * @param \StructType\Procurement_Condition_RuleType[] $procurement_Condition_Rule
     */
    public function __construct(array $procurement_Condition_Rule = array())
    {
        $this
            ->setProcurement_Condition_Rule($procurement_Condition_Rule);
    }
    /**
     * Get Procurement_Condition_Rule value
     * @return \StructType\Procurement_Condition_RuleType[]|null
     */
    public function getProcurement_Condition_Rule()
    {
        return $this->Procurement_Condition_Rule;
    }
    /**
     * This method is responsible for validating the values passed to the setProcurement_Condition_Rule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcurement_Condition_Rule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcurement_Condition_RuleForArrayConstraintsFromSetProcurement_Condition_Rule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Condition_Rule_Response_DataTypeProcurement_Condition_RuleItem) {
            // validation for constraint: itemType
            if (!$procurement_Condition_Rule_Response_DataTypeProcurement_Condition_RuleItem instanceof \StructType\Procurement_Condition_RuleType) {
                $invalidValues[] = is_object($procurement_Condition_Rule_Response_DataTypeProcurement_Condition_RuleItem) ? get_class($procurement_Condition_Rule_Response_DataTypeProcurement_Condition_RuleItem) : sprintf('%s(%s)', gettype($procurement_Condition_Rule_Response_DataTypeProcurement_Condition_RuleItem), var_export($procurement_Condition_Rule_Response_DataTypeProcurement_Condition_RuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Procurement_Condition_Rule property can only contain items of type \StructType\Procurement_Condition_RuleType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Procurement_Condition_Rule value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Condition_RuleType[] $procurement_Condition_Rule
     * @return \StructType\Procurement_Condition_Rule_Response_DataType
     */
    public function setProcurement_Condition_Rule(array $procurement_Condition_Rule = array())
    {
        // validation for constraint: array
        if ('' !== ($procurement_Condition_RuleArrayErrorMessage = self::validateProcurement_Condition_RuleForArrayConstraintsFromSetProcurement_Condition_Rule($procurement_Condition_Rule))) {
            throw new \InvalidArgumentException($procurement_Condition_RuleArrayErrorMessage, __LINE__);
        }
        $this->Procurement_Condition_Rule = $procurement_Condition_Rule;
        return $this;
    }
    /**
     * Add item to Procurement_Condition_Rule value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Condition_RuleType $item
     * @return \StructType\Procurement_Condition_Rule_Response_DataType
     */
    public function addToProcurement_Condition_Rule(\StructType\Procurement_Condition_RuleType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_Condition_RuleType) {
            throw new \InvalidArgumentException(sprintf('The Procurement_Condition_Rule property can only contain items of type \StructType\Procurement_Condition_RuleType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Procurement_Condition_Rule[] = $item;
        return $this;
    }
}
