<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payroll_Timesheet_Day_Time_In_Time_Out_WWSType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element encapsulates a day tracked on a timesheet. It contains 0 or more "Payroll Timesheet Day Time In Time Out Hours" representing intervals of time worked and tracked against specific time codes.
 * @subpackage Structs
 */
class Payroll_Timesheet_Day_Time_In_Time_Out_WWSType extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - documentation: The date for the day on the timesheet must be within the date range of the Period selected. | The date for this day being tracked on the timesheet.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The Payroll_Timesheet_Day_Time_In_Time_Out_Hours
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType[]
     */
    public $Payroll_Timesheet_Day_Time_In_Time_Out_Hours;
    /**
     * Constructor method for Payroll_Timesheet_Day_Time_In_Time_Out_WWSType
     * @uses Payroll_Timesheet_Day_Time_In_Time_Out_WWSType::setDate()
     * @uses Payroll_Timesheet_Day_Time_In_Time_Out_WWSType::setPayroll_Timesheet_Day_Time_In_Time_Out_Hours()
     * @param string $date
     * @param \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType[] $payroll_Timesheet_Day_Time_In_Time_Out_Hours
     */
    public function __construct($date = null, array $payroll_Timesheet_Day_Time_In_Time_Out_Hours = array())
    {
        $this
            ->setDate($date)
            ->setPayroll_Timesheet_Day_Time_In_Time_Out_Hours($payroll_Timesheet_Day_Time_In_Time_Out_Hours);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Payroll_Timesheet_Day_Time_In_Time_Out_Hours value
     * @return \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType[]|null
     */
    public function getPayroll_Timesheet_Day_Time_In_Time_Out_Hours()
    {
        return $this->Payroll_Timesheet_Day_Time_In_Time_Out_Hours;
    }
    /**
     * This method is responsible for validating the values passed to the setPayroll_Timesheet_Day_Time_In_Time_Out_Hours method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayroll_Timesheet_Day_Time_In_Time_Out_Hours method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayroll_Timesheet_Day_Time_In_Time_Out_HoursForArrayConstraintsFromSetPayroll_Timesheet_Day_Time_In_Time_Out_Hours(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payroll_Timesheet_Day_Time_In_Time_Out_WWSTypePayroll_Timesheet_Day_Time_In_Time_Out_HoursItem) {
            // validation for constraint: itemType
            if (!$payroll_Timesheet_Day_Time_In_Time_Out_WWSTypePayroll_Timesheet_Day_Time_In_Time_Out_HoursItem instanceof \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType) {
                $invalidValues[] = is_object($payroll_Timesheet_Day_Time_In_Time_Out_WWSTypePayroll_Timesheet_Day_Time_In_Time_Out_HoursItem) ? get_class($payroll_Timesheet_Day_Time_In_Time_Out_WWSTypePayroll_Timesheet_Day_Time_In_Time_Out_HoursItem) : sprintf('%s(%s)', gettype($payroll_Timesheet_Day_Time_In_Time_Out_WWSTypePayroll_Timesheet_Day_Time_In_Time_Out_HoursItem), var_export($payroll_Timesheet_Day_Time_In_Time_Out_WWSTypePayroll_Timesheet_Day_Time_In_Time_Out_HoursItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payroll_Timesheet_Day_Time_In_Time_Out_Hours property can only contain items of type \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payroll_Timesheet_Day_Time_In_Time_Out_Hours value
     * @throws \InvalidArgumentException
     * @param \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType[] $payroll_Timesheet_Day_Time_In_Time_Out_Hours
     * @return \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType
     */
    public function setPayroll_Timesheet_Day_Time_In_Time_Out_Hours(array $payroll_Timesheet_Day_Time_In_Time_Out_Hours = array())
    {
        // validation for constraint: array
        if ('' !== ($payroll_Timesheet_Day_Time_In_Time_Out_HoursArrayErrorMessage = self::validatePayroll_Timesheet_Day_Time_In_Time_Out_HoursForArrayConstraintsFromSetPayroll_Timesheet_Day_Time_In_Time_Out_Hours($payroll_Timesheet_Day_Time_In_Time_Out_Hours))) {
            throw new \InvalidArgumentException($payroll_Timesheet_Day_Time_In_Time_Out_HoursArrayErrorMessage, __LINE__);
        }
        $this->Payroll_Timesheet_Day_Time_In_Time_Out_Hours = $payroll_Timesheet_Day_Time_In_Time_Out_Hours;
        return $this;
    }
    /**
     * Add item to Payroll_Timesheet_Day_Time_In_Time_Out_Hours value
     * @throws \InvalidArgumentException
     * @param \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType $item
     * @return \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType
     */
    public function addToPayroll_Timesheet_Day_Time_In_Time_Out_Hours(\StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Payroll_Timesheet_Day_Time_In_Time_Out_Hours property can only contain items of type \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payroll_Timesheet_Day_Time_In_Time_Out_Hours[] = $item;
        return $this;
    }
}
