<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Report_Line_Detail_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Distance to Expense is not an attribute of the selected expense item. | Round Trip is not an attribute of the selected expense item. | One-Way Daily Commute Distance is not an attribute of the selected expense item. | Trip Distance
 * is not an attribute of the selected expense item. | Estimated Distance of Driving Route is not an attribute of the selected expense item. | Destination Address is not an attribute of the selected expense item. | Origin Address is not an attribute of
 * the selected expense item. | Merchant City is not an attribute of the selected expense item. | Merchant Region is not an attribute of the selected expense item. | Merchant Country is not an attribute of the selected expense item. | Merchant Postal
 * Code is not an attribute of the selected expense item. | To edit Number of Days on expense reports, deselect Non-Editable Number of Days. | Edit Number of Days at expense line level. | Number of Hours cannot be greater than 24. | Configurable Decimal
 * 1 is not an attribute of the selected expense item. | Configurable Decimal 3 is not an attribute of the selected expense item. | Configurable Decimal 4 is not an attribute of the selected expense item. | Configurable Decimal 5 is not an attribute of
 * the selected expense item. | Configurable Decimal 2 is not an attribute of the selected expense item. | Configurable Numeric 3 is not an attribute of the selected expense item. | Configurable Numeric 2 is not an attribute of the selected expense
 * item. | Configurable Numeric 4 is not an attribute of the selected expense item. | Configurable Numeric 5 is not an attribute of the selected expense item. | When creating travel journals, Departure Date and Departure Time must differ from Arrival
 * Date and Arrival Time. | Configurable Numeric 1 is not an attribute of the selected expense item. | Configurable Date 3 is not an attribute of the selected expense item. | Configurable Date 4 is not an attribute of the selected expense item. |
 * Configurable Date 5 is not an attribute of the selected expense item. | Configurable Date 2 is not an attribute of the selected expense item. | Configurable Date 1 is not an attribute of the selected expense item. | Configurable Text 2 is not an
 * attribute of the selected expense item. | Configurable Text 4 is not an attribute of the selected expense item. | Configurable Text 3 is not an attribute of the selected expense item. | Configurable Text 5 is not an attribute of the selected expense
 * item. | Configurable Text 1 is not an attribute of the selected expense item. | Configurable Boolean 3 is not an attribute of the selected expense item. | Configurable Boolean 5 is not an attribute of the selected expense item. | Configurable Boolean
 * 2 is not an attribute of the selected expense item. | Configurable Boolean 4 is not an attribute of the selected expense item. | Configurable Boolean 1 is not an attribute of the selected expense item. | Merchant Address is not an attribute of the
 * selected expense item. | Document Number is not an attribute of the selected expense item. | Classes of Service is not an attribute of the selected expense item. | Invoice Type is not an attribute of the selected expense item. | Travel Region is not
 * an attribute of the selected expense item. | Number of Nights Private Accommodation is not an attribute of the selected expense item. | Eligibility is not an attribute of the selected expense item. | Departure Time is not an attribute of the selected
 * expense item. | Arrival Time is not an attribute of the selected expense item. | Merchant is not an attribute of the selected expense item. | Ticket Number is not an attribute of the selected expense item. | Reservation Number is not an attribute of
 * the selected expense item. | Business Reason is not an attribute of the selected expense item. | Passenger is not an attribute of the selected expense item. | Recipient is not an attribute of the selected expense item. | Origination Location is not
 * an attribute of the selected expense item. | Account Number is not an attribute of the selected expense item. | Number of Breakfasts Provided is not an attribute of the selected expense item. | Number of Days is not an attribute of the selected
 * expense item. | Number of Dinners Provided is not an attribute of the selected expense item. | Number of Hours is not an attribute of the selected expense item. | Number of Lunches Provided is not an attribute of the selected expense item. | Number
 * of Passengers is not an attribute of the selected expense item. | Engine Capacity is not an attribute of the selected expense item. | Fuel Type is not an attribute of the selected expense item. | Hotel is not an attribute of the selected expense
 * item. | Vehicle Plan is not an attribute of the selected expense item. | Vehicle Type is not an attribute of the selected expense item. | Car Rental Agency is not an attribute of the selected expense item. | Class of Service is not an attribute of
 * the selected expense item. | Country is not an attribute of the selected expense item. | Destination Location is not an attribute of the selected expense item. | Airline is not an attribute of the selected expense item. | Reference Number is not an
 * attribute of the selected expense item. | Daily Rate is not an attribute of the selected expense item. | Departure Date is required for the selected Expense Item. | Arrival Date is not an attribute of the selected expense item. | Business Topic is
 * not an attribute of the selected expense item. | Attendee is not an attribute of the selected expense item. | Merchant Tax ID is not an attribute of the selected expense item. | Passenger is required for the selected Expense Item. | Recipient is
 * required for the selected Expense Item. | Attendee is required for the selected Expense Item. | Element that encapsulates all of the expense item attributes (acct number, business topics, reservation number, ticket number, country, origination travel
 * location, destination travel location, hotel, car rental agency, airline, attendee). These attributes are configurable for the expense item. Only the attributes that are set up for the expense item should be entered. All others will be wiped out.
 * @subpackage Structs
 */
class Expense_Report_Line_Detail_DataType extends AbstractStructBase
{
    /**
     * The Origin_Address
     * Meta information extracted from the WSDL
     * - documentation: The origin address on the expense report line, used to estimate the distance of the driving route.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origin_Address;
    /**
     * The Round_Trip
     * Meta information extracted from the WSDL
     * - documentation: Representing the Round Trip for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Round_Trip;
    /**
     * The Destination_Address
     * Meta information extracted from the WSDL
     * - documentation: The destination address on the expense report line, used to estimate the distance of the driving route.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destination_Address;
    /**
     * The Estimated_Distance_of_Driving_Route
     * Meta information extracted from the WSDL
     * - documentation: Estimated Distance of Driving Route
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Estimated_Distance_of_Driving_Route;
    /**
     * The Trip_Distance_Including_Diversions
     * Meta information extracted from the WSDL
     * - documentation: The enterable trip distance values.
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Trip_Distance_Including_Diversions;
    /**
     * The One_Way_Daily_Commute_Distance
     * Meta information extracted from the WSDL
     * - documentation: The One-Way Daily Commute Distance to be deducted from the Distance to Expense.
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $One_Way_Daily_Commute_Distance;
    /**
     * The Distance_to_Expense
     * Meta information extracted from the WSDL
     * - documentation: The distance that you can expense based on a daily commute or round trip.
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Distance_to_Expense;
    /**
     * The Account_Number
     * Meta information extracted from the WSDL
     * - documentation: Account Number is required for the selected Expense Item and must have a value. | Text representing the account number for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Account_Number;
    /**
     * The Business_Topics
     * Meta information extracted from the WSDL
     * - documentation: Text representing the business topics for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Business_Topics;
    /**
     * The Business_Reason
     * Meta information extracted from the WSDL
     * - documentation: Text representing the business reason for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Business_Reason;
    /**
     * The Reservation_Number
     * Meta information extracted from the WSDL
     * - documentation: Text representing the reservation number for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reservation_Number;
    /**
     * The Ticket_Number
     * Meta information extracted from the WSDL
     * - documentation: Text representing the ticket number for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket_Number;
    /**
     * The Merchant
     * Meta information extracted from the WSDL
     * - documentation: Text representing the merchant name for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant;
    /**
     * The Merchant_Tax_ID
     * Meta information extracted from the WSDL
     * - documentation: Text representing the merchant tax id for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Tax_ID;
    /**
     * The Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Country and Destination Location combination must be valid. | Reference to the country where the trip ended.
     * - minOccurs: 0
     * @var \StructType\CountryObjectType
     */
    public $Country_Reference;
    /**
     * The Travel_Region_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Travel Region and Country of the destination location combination must be valid. | The Travel Region and Country combination must be valid. | Reference to the travel region where the trip ended.
     * - minOccurs: 0
     * @var \StructType\Country_RegionObjectType
     */
    public $Travel_Region_Reference;
    /**
     * The Origination_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the travel location where the trip originated from.
     * - minOccurs: 0
     * @var \StructType\Travel_LocationObjectType
     */
    public $Origination_Location_Reference;
    /**
     * The Destination_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the travel location where the trip ended.
     * - minOccurs: 0
     * @var \StructType\Travel_LocationObjectType
     */
    public $Destination_Location_Reference;
    /**
     * The Hotel_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the hotel that was used for the expense.
     * - minOccurs: 0
     * @var \StructType\HotelObjectType
     */
    public $Hotel_Reference;
    /**
     * The Car_Rental_Agency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the car rental agency that was used for the expense.
     * - minOccurs: 0
     * @var \StructType\Car_Rental_AgencyObjectType
     */
    public $Car_Rental_Agency_Reference;
    /**
     * The Airline_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the airline that was used for the expense.
     * - minOccurs: 0
     * @var \StructType\AirlineObjectType
     */
    public $Airline_Reference;
    /**
     * The Vehicle_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the vehicle plan for the vehicle used for the expense.
     * - minOccurs: 0
     * @var \StructType\Vehicle_PlanObjectType
     */
    public $Vehicle_Plan_Reference;
    /**
     * The Vehicle_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the vehicle type for the vehicle used for the expense.
     * - minOccurs: 0
     * @var \StructType\Vehicle_TypeObjectType
     */
    public $Vehicle_Type_Reference;
    /**
     * The Engine_Capacity_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the engine capacity for the vehicle used for the expense.
     * - minOccurs: 0
     * @var \StructType\Engine_CapacityObjectType
     */
    public $Engine_Capacity_Reference;
    /**
     * The Fuel_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the fuel type for the vehicle used for the expense.
     * - minOccurs: 0
     * @var \StructType\Fuel_TypeObjectType
     */
    public $Fuel_Type_Reference;
    /**
     * The Invoice_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the invoice type used on the expense.
     * - minOccurs: 0
     * @var \StructType\Invoice_TypeObjectType
     */
    public $Invoice_Type_Reference;
    /**
     * The Attendee_Reference_Data
     * Meta information extracted from the WSDL
     * - documentation: Reference to the attendee element that will list the type and name of the person who was an attendee for the expense. This can be used more than once for the expense.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Attendee_DataType[]
     */
    public $Attendee_Reference_Data;
    /**
     * The Recipient_Reference_Data
     * Meta information extracted from the WSDL
     * - documentation: Reference to the recipient element that will list the type and name of the person who was a recipient for the expense. This can be used more than once for the expense.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Recipient_DataType[]
     */
    public $Recipient_Reference_Data;
    /**
     * The Passenger_Reference_Data
     * Meta information extracted from the WSDL
     * - documentation: Reference to the passenger element that will list the type and name of the person who was a passenger for the expense. This can be used more than once for the expense.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Passenger_DataType[]
     */
    public $Passenger_Reference_Data;
    /**
     * The Number_of_Persons
     * Meta information extracted from the WSDL
     * - documentation: Number representing the number of passengers for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Persons;
    /**
     * The Arrival_Date
     * Meta information extracted from the WSDL
     * - documentation: Text representing the arrival date for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Arrival_Date;
    /**
     * The Arrival_Time
     * Meta information extracted from the WSDL
     * - documentation: Text representing the arrival time for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Arrival_Time;
    /**
     * The Departure_Date
     * Meta information extracted from the WSDL
     * - documentation: Text representing the departure date for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Departure_Date;
    /**
     * The Departure_Time
     * Meta information extracted from the WSDL
     * - documentation: Text representing the departure time for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Departure_Time;
    /**
     * The Number_of_Days
     * Meta information extracted from the WSDL
     * - documentation: Tracks the number of days an employee works from home per week. | Number representing the number of days or nights for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Days;
    /**
     * The Number_of_Hours
     * Meta information extracted from the WSDL
     * - documentation: Number representing the number of hours for the expense. This is evaluated as a fraction of a day for expenses with fixed expense items using expense rate tables.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Hours;
    /**
     * The Number_of_Breakfasts_Provided
     * Meta information extracted from the WSDL
     * - documentation: Number representing the number of breakfasts provided for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Breakfasts_Provided;
    /**
     * The Number_of_Lunches_Provided
     * Meta information extracted from the WSDL
     * - documentation: Number representing the number of lunches provided for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Lunches_Provided;
    /**
     * The Number_of_Dinners_Provided
     * Meta information extracted from the WSDL
     * - documentation: Number representing the number of dinners provided for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Dinners_Provided;
    /**
     * The Number_of_Nights_Private_Accommodation
     * Meta information extracted from the WSDL
     * - documentation: Text representing the Number of Nights of Private Accommodation for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Nights_Private_Accommodation;
    /**
     * The Eligibility_Reference
     * Meta information extracted from the WSDL
     * - documentation: Text representing the eligibility for the expense.
     * - minOccurs: 0
     * @var \StructType\Expense_EligibilityObjectType
     */
    public $Eligibility_Reference;
    /**
     * The Class_of_Service_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the class of service for an airline expense.
     * - minOccurs: 0
     * @var \StructType\Class_of_ServiceObjectType
     */
    public $Class_of_Service_Reference;
    /**
     * The Daily_Rate
     * Meta information extracted from the WSDL
     * - documentation: Text representing the daily rate for the expense. | Daily Rate
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Daily_Rate;
    /**
     * The Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Text representing a reference number for the expense. This can be used for a hotel folio number or anything else.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference_Number;
    /**
     * The Classes_of_Service_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to classes of service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Class_of_ServiceObjectType[]
     */
    public $Classes_of_Service_Reference;
    /**
     * The Document_Number
     * Meta information extracted from the WSDL
     * - documentation: Text representing the document number for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Number;
    /**
     * The Merchant_Postal_Code
     * Meta information extracted from the WSDL
     * - documentation: TEXT representing the Merchant Postal Code for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Postal_Code;
    /**
     * The Merchant_Address
     * Meta information extracted from the WSDL
     * - documentation: TEXT representing the Merchant Address for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Address;
    /**
     * The Merchant_City
     * Meta information extracted from the WSDL
     * - documentation: TEXT representing the Merchant City for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_City;
    /**
     * The Merchant_Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: PROMPT representing the Merchant Country for the expense.
     * - minOccurs: 0
     * @var \StructType\CountryObjectType
     */
    public $Merchant_Country_Reference;
    /**
     * The Merchant_Region_Reference
     * Meta information extracted from the WSDL
     * - documentation: PROMPT representing the Merchant Region for the expense.
     * - minOccurs: 0
     * @var \StructType\Country_RegionObjectType
     */
    public $Merchant_Region_Reference;
    /**
     * The Configurable_Boolean_1
     * Meta information extracted from the WSDL
     * - documentation: BOOLEAN representing the Configurable Boolean 1 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Configurable_Boolean_1;
    /**
     * The Configurable_Boolean_2
     * Meta information extracted from the WSDL
     * - documentation: BOOLEAN representing the Configurable Boolean 2 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Configurable_Boolean_2;
    /**
     * The Configurable_Boolean_3
     * Meta information extracted from the WSDL
     * - documentation: BOOLEAN representing the Configurable Boolean 3 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Configurable_Boolean_3;
    /**
     * The Configurable_Boolean_4
     * Meta information extracted from the WSDL
     * - documentation: BOOLEAN representing the Configurable Boolean 4 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Configurable_Boolean_4;
    /**
     * The Configurable_Boolean_5
     * Meta information extracted from the WSDL
     * - documentation: BOOLEAN representing the Configurable Boolean 5 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Configurable_Boolean_5;
    /**
     * The Configurable_Decimal_1
     * Meta information extracted from the WSDL
     * - documentation: NUMERIC representing the Configurable Decimal 1 for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Configurable_Decimal_1;
    /**
     * The Configurable_Decimal_2
     * Meta information extracted from the WSDL
     * - documentation: NUMERIC representing the Configurable Decimal 2 for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Configurable_Decimal_2;
    /**
     * The Configurable_Decimal_3
     * Meta information extracted from the WSDL
     * - documentation: NUMERIC representing the Configurable Decimal 3 for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Configurable_Decimal_3;
    /**
     * The Configurable_Decimal_4
     * Meta information extracted from the WSDL
     * - documentation: NUMERIC representing the Configurable Decimal 4 for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Configurable_Decimal_4;
    /**
     * The Configurable_Decimal_5
     * Meta information extracted from the WSDL
     * - documentation: NUMERIC representing the Configurable Decimal 5 for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Configurable_Decimal_5;
    /**
     * The Configurable_Numeric_1
     * Meta information extracted from the WSDL
     * - documentation: NUMERIC representing the Configurable Numeric 1 for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Configurable_Numeric_1;
    /**
     * The Configurable_Numeric_2
     * Meta information extracted from the WSDL
     * - documentation: NUMERIC representing the Configurable Numeric 2 for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Configurable_Numeric_2;
    /**
     * The Configurable_Numeric_3
     * Meta information extracted from the WSDL
     * - documentation: NUMERIC representing the Configurable Numeric 3 for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Configurable_Numeric_3;
    /**
     * The Configurable_Numeric_4
     * Meta information extracted from the WSDL
     * - documentation: NUMERIC representing the Configurable Numeric 4 for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Configurable_Numeric_4;
    /**
     * The Configurable_Numeric_5
     * Meta information extracted from the WSDL
     * - documentation: NUMERIC representing the Configurable Numeric 5 for the expense.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Configurable_Numeric_5;
    /**
     * The Configurable_Text_1
     * Meta information extracted from the WSDL
     * - documentation: TEXT representing the Configurable Text 1 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Configurable_Text_1;
    /**
     * The Configurable_Text_2
     * Meta information extracted from the WSDL
     * - documentation: TEXT representing the Configurable Text 2 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Configurable_Text_2;
    /**
     * The Configurable_Text_3
     * Meta information extracted from the WSDL
     * - documentation: TEXT representing the Configurable Text 3 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Configurable_Text_3;
    /**
     * The Configurable_Text_4
     * Meta information extracted from the WSDL
     * - documentation: TEXT representing the Configurable Text 4 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Configurable_Text_4;
    /**
     * The Configurable_Text_5
     * Meta information extracted from the WSDL
     * - documentation: TEXT representing the Configurable Text 5 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Configurable_Text_5;
    /**
     * The Configurable_Date_1
     * Meta information extracted from the WSDL
     * - documentation: DATE representing the Configurable Date 1 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Configurable_Date_1;
    /**
     * The Configurable_Date_2
     * Meta information extracted from the WSDL
     * - documentation: DATE representing the Configurable Date 2 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Configurable_Date_2;
    /**
     * The Configurable_Date_3
     * Meta information extracted from the WSDL
     * - documentation: DATE representing the Configurable Date 3 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Configurable_Date_3;
    /**
     * The Configurable_Date_4
     * Meta information extracted from the WSDL
     * - documentation: DATE representing the Configurable Date 4 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Configurable_Date_4;
    /**
     * The Configurable_Date_5
     * Meta information extracted from the WSDL
     * - documentation: DATE representing the Configurable Date 5 for the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Configurable_Date_5;
    /**
     * Constructor method for Expense_Report_Line_Detail_DataType
     * @uses Expense_Report_Line_Detail_DataType::setOrigin_Address()
     * @uses Expense_Report_Line_Detail_DataType::setRound_Trip()
     * @uses Expense_Report_Line_Detail_DataType::setDestination_Address()
     * @uses Expense_Report_Line_Detail_DataType::setEstimated_Distance_of_Driving_Route()
     * @uses Expense_Report_Line_Detail_DataType::setTrip_Distance_Including_Diversions()
     * @uses Expense_Report_Line_Detail_DataType::setOne_Way_Daily_Commute_Distance()
     * @uses Expense_Report_Line_Detail_DataType::setDistance_to_Expense()
     * @uses Expense_Report_Line_Detail_DataType::setAccount_Number()
     * @uses Expense_Report_Line_Detail_DataType::setBusiness_Topics()
     * @uses Expense_Report_Line_Detail_DataType::setBusiness_Reason()
     * @uses Expense_Report_Line_Detail_DataType::setReservation_Number()
     * @uses Expense_Report_Line_Detail_DataType::setTicket_Number()
     * @uses Expense_Report_Line_Detail_DataType::setMerchant()
     * @uses Expense_Report_Line_Detail_DataType::setMerchant_Tax_ID()
     * @uses Expense_Report_Line_Detail_DataType::setCountry_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setTravel_Region_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setOrigination_Location_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setDestination_Location_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setHotel_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setCar_Rental_Agency_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setAirline_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setVehicle_Plan_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setVehicle_Type_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setEngine_Capacity_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setFuel_Type_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setInvoice_Type_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setAttendee_Reference_Data()
     * @uses Expense_Report_Line_Detail_DataType::setRecipient_Reference_Data()
     * @uses Expense_Report_Line_Detail_DataType::setPassenger_Reference_Data()
     * @uses Expense_Report_Line_Detail_DataType::setNumber_of_Persons()
     * @uses Expense_Report_Line_Detail_DataType::setArrival_Date()
     * @uses Expense_Report_Line_Detail_DataType::setArrival_Time()
     * @uses Expense_Report_Line_Detail_DataType::setDeparture_Date()
     * @uses Expense_Report_Line_Detail_DataType::setDeparture_Time()
     * @uses Expense_Report_Line_Detail_DataType::setNumber_of_Days()
     * @uses Expense_Report_Line_Detail_DataType::setNumber_of_Hours()
     * @uses Expense_Report_Line_Detail_DataType::setNumber_of_Breakfasts_Provided()
     * @uses Expense_Report_Line_Detail_DataType::setNumber_of_Lunches_Provided()
     * @uses Expense_Report_Line_Detail_DataType::setNumber_of_Dinners_Provided()
     * @uses Expense_Report_Line_Detail_DataType::setNumber_of_Nights_Private_Accommodation()
     * @uses Expense_Report_Line_Detail_DataType::setEligibility_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setClass_of_Service_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setDaily_Rate()
     * @uses Expense_Report_Line_Detail_DataType::setReference_Number()
     * @uses Expense_Report_Line_Detail_DataType::setClasses_of_Service_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setDocument_Number()
     * @uses Expense_Report_Line_Detail_DataType::setMerchant_Postal_Code()
     * @uses Expense_Report_Line_Detail_DataType::setMerchant_Address()
     * @uses Expense_Report_Line_Detail_DataType::setMerchant_City()
     * @uses Expense_Report_Line_Detail_DataType::setMerchant_Country_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setMerchant_Region_Reference()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Boolean_1()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Boolean_2()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Boolean_3()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Boolean_4()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Boolean_5()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Decimal_1()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Decimal_2()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Decimal_3()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Decimal_4()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Decimal_5()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Numeric_1()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Numeric_2()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Numeric_3()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Numeric_4()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Numeric_5()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Text_1()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Text_2()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Text_3()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Text_4()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Text_5()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Date_1()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Date_2()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Date_3()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Date_4()
     * @uses Expense_Report_Line_Detail_DataType::setConfigurable_Date_5()
     * @param string $origin_Address
     * @param bool $round_Trip
     * @param string $destination_Address
     * @param float $estimated_Distance_of_Driving_Route
     * @param float $trip_Distance_Including_Diversions
     * @param float $one_Way_Daily_Commute_Distance
     * @param float $distance_to_Expense
     * @param string $account_Number
     * @param string $business_Topics
     * @param string $business_Reason
     * @param string $reservation_Number
     * @param string $ticket_Number
     * @param string $merchant
     * @param string $merchant_Tax_ID
     * @param \StructType\CountryObjectType $country_Reference
     * @param \StructType\Country_RegionObjectType $travel_Region_Reference
     * @param \StructType\Travel_LocationObjectType $origination_Location_Reference
     * @param \StructType\Travel_LocationObjectType $destination_Location_Reference
     * @param \StructType\HotelObjectType $hotel_Reference
     * @param \StructType\Car_Rental_AgencyObjectType $car_Rental_Agency_Reference
     * @param \StructType\AirlineObjectType $airline_Reference
     * @param \StructType\Vehicle_PlanObjectType $vehicle_Plan_Reference
     * @param \StructType\Vehicle_TypeObjectType $vehicle_Type_Reference
     * @param \StructType\Engine_CapacityObjectType $engine_Capacity_Reference
     * @param \StructType\Fuel_TypeObjectType $fuel_Type_Reference
     * @param \StructType\Invoice_TypeObjectType $invoice_Type_Reference
     * @param \StructType\Attendee_DataType[] $attendee_Reference_Data
     * @param \StructType\Recipient_DataType[] $recipient_Reference_Data
     * @param \StructType\Passenger_DataType[] $passenger_Reference_Data
     * @param float $number_of_Persons
     * @param string $arrival_Date
     * @param string $arrival_Time
     * @param string $departure_Date
     * @param string $departure_Time
     * @param float $number_of_Days
     * @param float $number_of_Hours
     * @param float $number_of_Breakfasts_Provided
     * @param float $number_of_Lunches_Provided
     * @param float $number_of_Dinners_Provided
     * @param float $number_of_Nights_Private_Accommodation
     * @param \StructType\Expense_EligibilityObjectType $eligibility_Reference
     * @param \StructType\Class_of_ServiceObjectType $class_of_Service_Reference
     * @param float $daily_Rate
     * @param string $reference_Number
     * @param \StructType\Class_of_ServiceObjectType[] $classes_of_Service_Reference
     * @param string $document_Number
     * @param string $merchant_Postal_Code
     * @param string $merchant_Address
     * @param string $merchant_City
     * @param \StructType\CountryObjectType $merchant_Country_Reference
     * @param \StructType\Country_RegionObjectType $merchant_Region_Reference
     * @param bool $configurable_Boolean_1
     * @param bool $configurable_Boolean_2
     * @param bool $configurable_Boolean_3
     * @param bool $configurable_Boolean_4
     * @param bool $configurable_Boolean_5
     * @param float $configurable_Decimal_1
     * @param float $configurable_Decimal_2
     * @param float $configurable_Decimal_3
     * @param float $configurable_Decimal_4
     * @param float $configurable_Decimal_5
     * @param float $configurable_Numeric_1
     * @param float $configurable_Numeric_2
     * @param float $configurable_Numeric_3
     * @param float $configurable_Numeric_4
     * @param float $configurable_Numeric_5
     * @param string $configurable_Text_1
     * @param string $configurable_Text_2
     * @param string $configurable_Text_3
     * @param string $configurable_Text_4
     * @param string $configurable_Text_5
     * @param string $configurable_Date_1
     * @param string $configurable_Date_2
     * @param string $configurable_Date_3
     * @param string $configurable_Date_4
     * @param string $configurable_Date_5
     */
    public function __construct($origin_Address = null, $round_Trip = null, $destination_Address = null, $estimated_Distance_of_Driving_Route = null, $trip_Distance_Including_Diversions = null, $one_Way_Daily_Commute_Distance = null, $distance_to_Expense = null, $account_Number = null, $business_Topics = null, $business_Reason = null, $reservation_Number = null, $ticket_Number = null, $merchant = null, $merchant_Tax_ID = null, \StructType\CountryObjectType $country_Reference = null, \StructType\Country_RegionObjectType $travel_Region_Reference = null, \StructType\Travel_LocationObjectType $origination_Location_Reference = null, \StructType\Travel_LocationObjectType $destination_Location_Reference = null, \StructType\HotelObjectType $hotel_Reference = null, \StructType\Car_Rental_AgencyObjectType $car_Rental_Agency_Reference = null, \StructType\AirlineObjectType $airline_Reference = null, \StructType\Vehicle_PlanObjectType $vehicle_Plan_Reference = null, \StructType\Vehicle_TypeObjectType $vehicle_Type_Reference = null, \StructType\Engine_CapacityObjectType $engine_Capacity_Reference = null, \StructType\Fuel_TypeObjectType $fuel_Type_Reference = null, \StructType\Invoice_TypeObjectType $invoice_Type_Reference = null, array $attendee_Reference_Data = array(), array $recipient_Reference_Data = array(), array $passenger_Reference_Data = array(), $number_of_Persons = null, $arrival_Date = null, $arrival_Time = null, $departure_Date = null, $departure_Time = null, $number_of_Days = null, $number_of_Hours = null, $number_of_Breakfasts_Provided = null, $number_of_Lunches_Provided = null, $number_of_Dinners_Provided = null, $number_of_Nights_Private_Accommodation = null, \StructType\Expense_EligibilityObjectType $eligibility_Reference = null, \StructType\Class_of_ServiceObjectType $class_of_Service_Reference = null, $daily_Rate = null, $reference_Number = null, array $classes_of_Service_Reference = array(), $document_Number = null, $merchant_Postal_Code = null, $merchant_Address = null, $merchant_City = null, \StructType\CountryObjectType $merchant_Country_Reference = null, \StructType\Country_RegionObjectType $merchant_Region_Reference = null, $configurable_Boolean_1 = null, $configurable_Boolean_2 = null, $configurable_Boolean_3 = null, $configurable_Boolean_4 = null, $configurable_Boolean_5 = null, $configurable_Decimal_1 = null, $configurable_Decimal_2 = null, $configurable_Decimal_3 = null, $configurable_Decimal_4 = null, $configurable_Decimal_5 = null, $configurable_Numeric_1 = null, $configurable_Numeric_2 = null, $configurable_Numeric_3 = null, $configurable_Numeric_4 = null, $configurable_Numeric_5 = null, $configurable_Text_1 = null, $configurable_Text_2 = null, $configurable_Text_3 = null, $configurable_Text_4 = null, $configurable_Text_5 = null, $configurable_Date_1 = null, $configurable_Date_2 = null, $configurable_Date_3 = null, $configurable_Date_4 = null, $configurable_Date_5 = null)
    {
        $this
            ->setOrigin_Address($origin_Address)
            ->setRound_Trip($round_Trip)
            ->setDestination_Address($destination_Address)
            ->setEstimated_Distance_of_Driving_Route($estimated_Distance_of_Driving_Route)
            ->setTrip_Distance_Including_Diversions($trip_Distance_Including_Diversions)
            ->setOne_Way_Daily_Commute_Distance($one_Way_Daily_Commute_Distance)
            ->setDistance_to_Expense($distance_to_Expense)
            ->setAccount_Number($account_Number)
            ->setBusiness_Topics($business_Topics)
            ->setBusiness_Reason($business_Reason)
            ->setReservation_Number($reservation_Number)
            ->setTicket_Number($ticket_Number)
            ->setMerchant($merchant)
            ->setMerchant_Tax_ID($merchant_Tax_ID)
            ->setCountry_Reference($country_Reference)
            ->setTravel_Region_Reference($travel_Region_Reference)
            ->setOrigination_Location_Reference($origination_Location_Reference)
            ->setDestination_Location_Reference($destination_Location_Reference)
            ->setHotel_Reference($hotel_Reference)
            ->setCar_Rental_Agency_Reference($car_Rental_Agency_Reference)
            ->setAirline_Reference($airline_Reference)
            ->setVehicle_Plan_Reference($vehicle_Plan_Reference)
            ->setVehicle_Type_Reference($vehicle_Type_Reference)
            ->setEngine_Capacity_Reference($engine_Capacity_Reference)
            ->setFuel_Type_Reference($fuel_Type_Reference)
            ->setInvoice_Type_Reference($invoice_Type_Reference)
            ->setAttendee_Reference_Data($attendee_Reference_Data)
            ->setRecipient_Reference_Data($recipient_Reference_Data)
            ->setPassenger_Reference_Data($passenger_Reference_Data)
            ->setNumber_of_Persons($number_of_Persons)
            ->setArrival_Date($arrival_Date)
            ->setArrival_Time($arrival_Time)
            ->setDeparture_Date($departure_Date)
            ->setDeparture_Time($departure_Time)
            ->setNumber_of_Days($number_of_Days)
            ->setNumber_of_Hours($number_of_Hours)
            ->setNumber_of_Breakfasts_Provided($number_of_Breakfasts_Provided)
            ->setNumber_of_Lunches_Provided($number_of_Lunches_Provided)
            ->setNumber_of_Dinners_Provided($number_of_Dinners_Provided)
            ->setNumber_of_Nights_Private_Accommodation($number_of_Nights_Private_Accommodation)
            ->setEligibility_Reference($eligibility_Reference)
            ->setClass_of_Service_Reference($class_of_Service_Reference)
            ->setDaily_Rate($daily_Rate)
            ->setReference_Number($reference_Number)
            ->setClasses_of_Service_Reference($classes_of_Service_Reference)
            ->setDocument_Number($document_Number)
            ->setMerchant_Postal_Code($merchant_Postal_Code)
            ->setMerchant_Address($merchant_Address)
            ->setMerchant_City($merchant_City)
            ->setMerchant_Country_Reference($merchant_Country_Reference)
            ->setMerchant_Region_Reference($merchant_Region_Reference)
            ->setConfigurable_Boolean_1($configurable_Boolean_1)
            ->setConfigurable_Boolean_2($configurable_Boolean_2)
            ->setConfigurable_Boolean_3($configurable_Boolean_3)
            ->setConfigurable_Boolean_4($configurable_Boolean_4)
            ->setConfigurable_Boolean_5($configurable_Boolean_5)
            ->setConfigurable_Decimal_1($configurable_Decimal_1)
            ->setConfigurable_Decimal_2($configurable_Decimal_2)
            ->setConfigurable_Decimal_3($configurable_Decimal_3)
            ->setConfigurable_Decimal_4($configurable_Decimal_4)
            ->setConfigurable_Decimal_5($configurable_Decimal_5)
            ->setConfigurable_Numeric_1($configurable_Numeric_1)
            ->setConfigurable_Numeric_2($configurable_Numeric_2)
            ->setConfigurable_Numeric_3($configurable_Numeric_3)
            ->setConfigurable_Numeric_4($configurable_Numeric_4)
            ->setConfigurable_Numeric_5($configurable_Numeric_5)
            ->setConfigurable_Text_1($configurable_Text_1)
            ->setConfigurable_Text_2($configurable_Text_2)
            ->setConfigurable_Text_3($configurable_Text_3)
            ->setConfigurable_Text_4($configurable_Text_4)
            ->setConfigurable_Text_5($configurable_Text_5)
            ->setConfigurable_Date_1($configurable_Date_1)
            ->setConfigurable_Date_2($configurable_Date_2)
            ->setConfigurable_Date_3($configurable_Date_3)
            ->setConfigurable_Date_4($configurable_Date_4)
            ->setConfigurable_Date_5($configurable_Date_5);
    }
    /**
     * Get Origin_Address value
     * @return string|null
     */
    public function getOrigin_Address()
    {
        return $this->Origin_Address;
    }
    /**
     * Set Origin_Address value
     * @param string $origin_Address
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setOrigin_Address($origin_Address = null)
    {
        // validation for constraint: string
        if (!is_null($origin_Address) && !is_string($origin_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origin_Address, true), gettype($origin_Address)), __LINE__);
        }
        $this->Origin_Address = $origin_Address;
        return $this;
    }
    /**
     * Get Round_Trip value
     * @return bool|null
     */
    public function getRound_Trip()
    {
        return $this->Round_Trip;
    }
    /**
     * Set Round_Trip value
     * @param bool $round_Trip
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setRound_Trip($round_Trip = null)
    {
        // validation for constraint: boolean
        if (!is_null($round_Trip) && !is_bool($round_Trip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($round_Trip, true), gettype($round_Trip)), __LINE__);
        }
        $this->Round_Trip = $round_Trip;
        return $this;
    }
    /**
     * Get Destination_Address value
     * @return string|null
     */
    public function getDestination_Address()
    {
        return $this->Destination_Address;
    }
    /**
     * Set Destination_Address value
     * @param string $destination_Address
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setDestination_Address($destination_Address = null)
    {
        // validation for constraint: string
        if (!is_null($destination_Address) && !is_string($destination_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination_Address, true), gettype($destination_Address)), __LINE__);
        }
        $this->Destination_Address = $destination_Address;
        return $this;
    }
    /**
     * Get Estimated_Distance_of_Driving_Route value
     * @return float|null
     */
    public function getEstimated_Distance_of_Driving_Route()
    {
        return $this->Estimated_Distance_of_Driving_Route;
    }
    /**
     * Set Estimated_Distance_of_Driving_Route value
     * @param float $estimated_Distance_of_Driving_Route
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setEstimated_Distance_of_Driving_Route($estimated_Distance_of_Driving_Route = null)
    {
        // validation for constraint: float
        if (!is_null($estimated_Distance_of_Driving_Route) && !(is_float($estimated_Distance_of_Driving_Route) || is_numeric($estimated_Distance_of_Driving_Route))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimated_Distance_of_Driving_Route, true), gettype($estimated_Distance_of_Driving_Route)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($estimated_Distance_of_Driving_Route) && mb_strlen(mb_substr($estimated_Distance_of_Driving_Route, false !== mb_strpos($estimated_Distance_of_Driving_Route, '.') ? mb_strpos($estimated_Distance_of_Driving_Route, '.') + 1 : mb_strlen($estimated_Distance_of_Driving_Route))) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($estimated_Distance_of_Driving_Route, true), mb_strlen(mb_substr($estimated_Distance_of_Driving_Route, mb_strpos($estimated_Distance_of_Driving_Route, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($estimated_Distance_of_Driving_Route) && $estimated_Distance_of_Driving_Route < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($estimated_Distance_of_Driving_Route, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($estimated_Distance_of_Driving_Route) && mb_strlen(preg_replace('/(\D)/', '', $estimated_Distance_of_Driving_Route)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($estimated_Distance_of_Driving_Route, true), mb_strlen(preg_replace('/(\D)/', '', $estimated_Distance_of_Driving_Route))), __LINE__);
        }
        $this->Estimated_Distance_of_Driving_Route = $estimated_Distance_of_Driving_Route;
        return $this;
    }
    /**
     * Get Trip_Distance_Including_Diversions value
     * @return float|null
     */
    public function getTrip_Distance_Including_Diversions()
    {
        return $this->Trip_Distance_Including_Diversions;
    }
    /**
     * Set Trip_Distance_Including_Diversions value
     * @param float $trip_Distance_Including_Diversions
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setTrip_Distance_Including_Diversions($trip_Distance_Including_Diversions = null)
    {
        // validation for constraint: float
        if (!is_null($trip_Distance_Including_Diversions) && !(is_float($trip_Distance_Including_Diversions) || is_numeric($trip_Distance_Including_Diversions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($trip_Distance_Including_Diversions, true), gettype($trip_Distance_Including_Diversions)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($trip_Distance_Including_Diversions) && mb_strlen(mb_substr($trip_Distance_Including_Diversions, false !== mb_strpos($trip_Distance_Including_Diversions, '.') ? mb_strpos($trip_Distance_Including_Diversions, '.') + 1 : mb_strlen($trip_Distance_Including_Diversions))) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($trip_Distance_Including_Diversions, true), mb_strlen(mb_substr($trip_Distance_Including_Diversions, mb_strpos($trip_Distance_Including_Diversions, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($trip_Distance_Including_Diversions) && $trip_Distance_Including_Diversions < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($trip_Distance_Including_Diversions, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($trip_Distance_Including_Diversions) && mb_strlen(preg_replace('/(\D)/', '', $trip_Distance_Including_Diversions)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($trip_Distance_Including_Diversions, true), mb_strlen(preg_replace('/(\D)/', '', $trip_Distance_Including_Diversions))), __LINE__);
        }
        $this->Trip_Distance_Including_Diversions = $trip_Distance_Including_Diversions;
        return $this;
    }
    /**
     * Get One_Way_Daily_Commute_Distance value
     * @return float|null
     */
    public function getOne_Way_Daily_Commute_Distance()
    {
        return $this->{'One-Way_Daily_Commute_Distance'};
    }
    /**
     * Set One_Way_Daily_Commute_Distance value
     * @param float $one_Way_Daily_Commute_Distance
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setOne_Way_Daily_Commute_Distance($one_Way_Daily_Commute_Distance = null)
    {
        // validation for constraint: float
        if (!is_null($one_Way_Daily_Commute_Distance) && !(is_float($one_Way_Daily_Commute_Distance) || is_numeric($one_Way_Daily_Commute_Distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($one_Way_Daily_Commute_Distance, true), gettype($one_Way_Daily_Commute_Distance)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($one_Way_Daily_Commute_Distance) && mb_strlen(mb_substr($one_Way_Daily_Commute_Distance, false !== mb_strpos($one_Way_Daily_Commute_Distance, '.') ? mb_strpos($one_Way_Daily_Commute_Distance, '.') + 1 : mb_strlen($one_Way_Daily_Commute_Distance))) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($one_Way_Daily_Commute_Distance, true), mb_strlen(mb_substr($one_Way_Daily_Commute_Distance, mb_strpos($one_Way_Daily_Commute_Distance, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($one_Way_Daily_Commute_Distance) && $one_Way_Daily_Commute_Distance < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($one_Way_Daily_Commute_Distance, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($one_Way_Daily_Commute_Distance) && mb_strlen(preg_replace('/(\D)/', '', $one_Way_Daily_Commute_Distance)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($one_Way_Daily_Commute_Distance, true), mb_strlen(preg_replace('/(\D)/', '', $one_Way_Daily_Commute_Distance))), __LINE__);
        }
        $this->One_Way_Daily_Commute_Distance = $this->{'One-Way_Daily_Commute_Distance'} = $one_Way_Daily_Commute_Distance;
        return $this;
    }
    /**
     * Get Distance_to_Expense value
     * @return float|null
     */
    public function getDistance_to_Expense()
    {
        return $this->Distance_to_Expense;
    }
    /**
     * Set Distance_to_Expense value
     * @param float $distance_to_Expense
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setDistance_to_Expense($distance_to_Expense = null)
    {
        // validation for constraint: float
        if (!is_null($distance_to_Expense) && !(is_float($distance_to_Expense) || is_numeric($distance_to_Expense))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distance_to_Expense, true), gettype($distance_to_Expense)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($distance_to_Expense) && mb_strlen(mb_substr($distance_to_Expense, false !== mb_strpos($distance_to_Expense, '.') ? mb_strpos($distance_to_Expense, '.') + 1 : mb_strlen($distance_to_Expense))) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($distance_to_Expense, true), mb_strlen(mb_substr($distance_to_Expense, mb_strpos($distance_to_Expense, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($distance_to_Expense) && $distance_to_Expense < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($distance_to_Expense, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($distance_to_Expense) && mb_strlen(preg_replace('/(\D)/', '', $distance_to_Expense)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($distance_to_Expense, true), mb_strlen(preg_replace('/(\D)/', '', $distance_to_Expense))), __LINE__);
        }
        $this->Distance_to_Expense = $distance_to_Expense;
        return $this;
    }
    /**
     * Get Account_Number value
     * @return string|null
     */
    public function getAccount_Number()
    {
        return $this->Account_Number;
    }
    /**
     * Set Account_Number value
     * @param string $account_Number
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setAccount_Number($account_Number = null)
    {
        // validation for constraint: string
        if (!is_null($account_Number) && !is_string($account_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account_Number, true), gettype($account_Number)), __LINE__);
        }
        $this->Account_Number = $account_Number;
        return $this;
    }
    /**
     * Get Business_Topics value
     * @return string|null
     */
    public function getBusiness_Topics()
    {
        return $this->Business_Topics;
    }
    /**
     * Set Business_Topics value
     * @param string $business_Topics
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setBusiness_Topics($business_Topics = null)
    {
        // validation for constraint: string
        if (!is_null($business_Topics) && !is_string($business_Topics)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Topics, true), gettype($business_Topics)), __LINE__);
        }
        $this->Business_Topics = $business_Topics;
        return $this;
    }
    /**
     * Get Business_Reason value
     * @return string|null
     */
    public function getBusiness_Reason()
    {
        return $this->Business_Reason;
    }
    /**
     * Set Business_Reason value
     * @param string $business_Reason
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setBusiness_Reason($business_Reason = null)
    {
        // validation for constraint: string
        if (!is_null($business_Reason) && !is_string($business_Reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Reason, true), gettype($business_Reason)), __LINE__);
        }
        $this->Business_Reason = $business_Reason;
        return $this;
    }
    /**
     * Get Reservation_Number value
     * @return string|null
     */
    public function getReservation_Number()
    {
        return $this->Reservation_Number;
    }
    /**
     * Set Reservation_Number value
     * @param string $reservation_Number
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setReservation_Number($reservation_Number = null)
    {
        // validation for constraint: string
        if (!is_null($reservation_Number) && !is_string($reservation_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservation_Number, true), gettype($reservation_Number)), __LINE__);
        }
        $this->Reservation_Number = $reservation_Number;
        return $this;
    }
    /**
     * Get Ticket_Number value
     * @return string|null
     */
    public function getTicket_Number()
    {
        return $this->Ticket_Number;
    }
    /**
     * Set Ticket_Number value
     * @param string $ticket_Number
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setTicket_Number($ticket_Number = null)
    {
        // validation for constraint: string
        if (!is_null($ticket_Number) && !is_string($ticket_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket_Number, true), gettype($ticket_Number)), __LINE__);
        }
        $this->Ticket_Number = $ticket_Number;
        return $this;
    }
    /**
     * Get Merchant value
     * @return string|null
     */
    public function getMerchant()
    {
        return $this->Merchant;
    }
    /**
     * Set Merchant value
     * @param string $merchant
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setMerchant($merchant = null)
    {
        // validation for constraint: string
        if (!is_null($merchant) && !is_string($merchant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant, true), gettype($merchant)), __LINE__);
        }
        $this->Merchant = $merchant;
        return $this;
    }
    /**
     * Get Merchant_Tax_ID value
     * @return string|null
     */
    public function getMerchant_Tax_ID()
    {
        return $this->Merchant_Tax_ID;
    }
    /**
     * Set Merchant_Tax_ID value
     * @param string $merchant_Tax_ID
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setMerchant_Tax_ID($merchant_Tax_ID = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Tax_ID) && !is_string($merchant_Tax_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Tax_ID, true), gettype($merchant_Tax_ID)), __LINE__);
        }
        $this->Merchant_Tax_ID = $merchant_Tax_ID;
        return $this;
    }
    /**
     * Get Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getCountry_Reference()
    {
        return $this->Country_Reference;
    }
    /**
     * Set Country_Reference value
     * @param \StructType\CountryObjectType $country_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setCountry_Reference(\StructType\CountryObjectType $country_Reference = null)
    {
        $this->Country_Reference = $country_Reference;
        return $this;
    }
    /**
     * Get Travel_Region_Reference value
     * @return \StructType\Country_RegionObjectType|null
     */
    public function getTravel_Region_Reference()
    {
        return $this->Travel_Region_Reference;
    }
    /**
     * Set Travel_Region_Reference value
     * @param \StructType\Country_RegionObjectType $travel_Region_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setTravel_Region_Reference(\StructType\Country_RegionObjectType $travel_Region_Reference = null)
    {
        $this->Travel_Region_Reference = $travel_Region_Reference;
        return $this;
    }
    /**
     * Get Origination_Location_Reference value
     * @return \StructType\Travel_LocationObjectType|null
     */
    public function getOrigination_Location_Reference()
    {
        return $this->Origination_Location_Reference;
    }
    /**
     * Set Origination_Location_Reference value
     * @param \StructType\Travel_LocationObjectType $origination_Location_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setOrigination_Location_Reference(\StructType\Travel_LocationObjectType $origination_Location_Reference = null)
    {
        $this->Origination_Location_Reference = $origination_Location_Reference;
        return $this;
    }
    /**
     * Get Destination_Location_Reference value
     * @return \StructType\Travel_LocationObjectType|null
     */
    public function getDestination_Location_Reference()
    {
        return $this->Destination_Location_Reference;
    }
    /**
     * Set Destination_Location_Reference value
     * @param \StructType\Travel_LocationObjectType $destination_Location_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setDestination_Location_Reference(\StructType\Travel_LocationObjectType $destination_Location_Reference = null)
    {
        $this->Destination_Location_Reference = $destination_Location_Reference;
        return $this;
    }
    /**
     * Get Hotel_Reference value
     * @return \StructType\HotelObjectType|null
     */
    public function getHotel_Reference()
    {
        return $this->Hotel_Reference;
    }
    /**
     * Set Hotel_Reference value
     * @param \StructType\HotelObjectType $hotel_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setHotel_Reference(\StructType\HotelObjectType $hotel_Reference = null)
    {
        $this->Hotel_Reference = $hotel_Reference;
        return $this;
    }
    /**
     * Get Car_Rental_Agency_Reference value
     * @return \StructType\Car_Rental_AgencyObjectType|null
     */
    public function getCar_Rental_Agency_Reference()
    {
        return $this->Car_Rental_Agency_Reference;
    }
    /**
     * Set Car_Rental_Agency_Reference value
     * @param \StructType\Car_Rental_AgencyObjectType $car_Rental_Agency_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setCar_Rental_Agency_Reference(\StructType\Car_Rental_AgencyObjectType $car_Rental_Agency_Reference = null)
    {
        $this->Car_Rental_Agency_Reference = $car_Rental_Agency_Reference;
        return $this;
    }
    /**
     * Get Airline_Reference value
     * @return \StructType\AirlineObjectType|null
     */
    public function getAirline_Reference()
    {
        return $this->Airline_Reference;
    }
    /**
     * Set Airline_Reference value
     * @param \StructType\AirlineObjectType $airline_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setAirline_Reference(\StructType\AirlineObjectType $airline_Reference = null)
    {
        $this->Airline_Reference = $airline_Reference;
        return $this;
    }
    /**
     * Get Vehicle_Plan_Reference value
     * @return \StructType\Vehicle_PlanObjectType|null
     */
    public function getVehicle_Plan_Reference()
    {
        return $this->Vehicle_Plan_Reference;
    }
    /**
     * Set Vehicle_Plan_Reference value
     * @param \StructType\Vehicle_PlanObjectType $vehicle_Plan_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setVehicle_Plan_Reference(\StructType\Vehicle_PlanObjectType $vehicle_Plan_Reference = null)
    {
        $this->Vehicle_Plan_Reference = $vehicle_Plan_Reference;
        return $this;
    }
    /**
     * Get Vehicle_Type_Reference value
     * @return \StructType\Vehicle_TypeObjectType|null
     */
    public function getVehicle_Type_Reference()
    {
        return $this->Vehicle_Type_Reference;
    }
    /**
     * Set Vehicle_Type_Reference value
     * @param \StructType\Vehicle_TypeObjectType $vehicle_Type_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setVehicle_Type_Reference(\StructType\Vehicle_TypeObjectType $vehicle_Type_Reference = null)
    {
        $this->Vehicle_Type_Reference = $vehicle_Type_Reference;
        return $this;
    }
    /**
     * Get Engine_Capacity_Reference value
     * @return \StructType\Engine_CapacityObjectType|null
     */
    public function getEngine_Capacity_Reference()
    {
        return $this->Engine_Capacity_Reference;
    }
    /**
     * Set Engine_Capacity_Reference value
     * @param \StructType\Engine_CapacityObjectType $engine_Capacity_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setEngine_Capacity_Reference(\StructType\Engine_CapacityObjectType $engine_Capacity_Reference = null)
    {
        $this->Engine_Capacity_Reference = $engine_Capacity_Reference;
        return $this;
    }
    /**
     * Get Fuel_Type_Reference value
     * @return \StructType\Fuel_TypeObjectType|null
     */
    public function getFuel_Type_Reference()
    {
        return $this->Fuel_Type_Reference;
    }
    /**
     * Set Fuel_Type_Reference value
     * @param \StructType\Fuel_TypeObjectType $fuel_Type_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setFuel_Type_Reference(\StructType\Fuel_TypeObjectType $fuel_Type_Reference = null)
    {
        $this->Fuel_Type_Reference = $fuel_Type_Reference;
        return $this;
    }
    /**
     * Get Invoice_Type_Reference value
     * @return \StructType\Invoice_TypeObjectType|null
     */
    public function getInvoice_Type_Reference()
    {
        return $this->Invoice_Type_Reference;
    }
    /**
     * Set Invoice_Type_Reference value
     * @param \StructType\Invoice_TypeObjectType $invoice_Type_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setInvoice_Type_Reference(\StructType\Invoice_TypeObjectType $invoice_Type_Reference = null)
    {
        $this->Invoice_Type_Reference = $invoice_Type_Reference;
        return $this;
    }
    /**
     * Get Attendee_Reference_Data value
     * @return \StructType\Attendee_DataType[]|null
     */
    public function getAttendee_Reference_Data()
    {
        return $this->Attendee_Reference_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttendee_Reference_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttendee_Reference_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttendee_Reference_DataForArrayConstraintsFromSetAttendee_Reference_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Line_Detail_DataTypeAttendee_Reference_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Line_Detail_DataTypeAttendee_Reference_DataItem instanceof \StructType\Attendee_DataType) {
                $invalidValues[] = is_object($expense_Report_Line_Detail_DataTypeAttendee_Reference_DataItem) ? get_class($expense_Report_Line_Detail_DataTypeAttendee_Reference_DataItem) : sprintf('%s(%s)', gettype($expense_Report_Line_Detail_DataTypeAttendee_Reference_DataItem), var_export($expense_Report_Line_Detail_DataTypeAttendee_Reference_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attendee_Reference_Data property can only contain items of type \StructType\Attendee_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attendee_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Attendee_DataType[] $attendee_Reference_Data
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setAttendee_Reference_Data(array $attendee_Reference_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attendee_Reference_DataArrayErrorMessage = self::validateAttendee_Reference_DataForArrayConstraintsFromSetAttendee_Reference_Data($attendee_Reference_Data))) {
            throw new \InvalidArgumentException($attendee_Reference_DataArrayErrorMessage, __LINE__);
        }
        $this->Attendee_Reference_Data = $attendee_Reference_Data;
        return $this;
    }
    /**
     * Add item to Attendee_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Attendee_DataType $item
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function addToAttendee_Reference_Data(\StructType\Attendee_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Attendee_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attendee_Reference_Data property can only contain items of type \StructType\Attendee_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attendee_Reference_Data[] = $item;
        return $this;
    }
    /**
     * Get Recipient_Reference_Data value
     * @return \StructType\Recipient_DataType[]|null
     */
    public function getRecipient_Reference_Data()
    {
        return $this->Recipient_Reference_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRecipient_Reference_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecipient_Reference_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecipient_Reference_DataForArrayConstraintsFromSetRecipient_Reference_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Line_Detail_DataTypeRecipient_Reference_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Line_Detail_DataTypeRecipient_Reference_DataItem instanceof \StructType\Recipient_DataType) {
                $invalidValues[] = is_object($expense_Report_Line_Detail_DataTypeRecipient_Reference_DataItem) ? get_class($expense_Report_Line_Detail_DataTypeRecipient_Reference_DataItem) : sprintf('%s(%s)', gettype($expense_Report_Line_Detail_DataTypeRecipient_Reference_DataItem), var_export($expense_Report_Line_Detail_DataTypeRecipient_Reference_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Recipient_Reference_Data property can only contain items of type \StructType\Recipient_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Recipient_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recipient_DataType[] $recipient_Reference_Data
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setRecipient_Reference_Data(array $recipient_Reference_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($recipient_Reference_DataArrayErrorMessage = self::validateRecipient_Reference_DataForArrayConstraintsFromSetRecipient_Reference_Data($recipient_Reference_Data))) {
            throw new \InvalidArgumentException($recipient_Reference_DataArrayErrorMessage, __LINE__);
        }
        $this->Recipient_Reference_Data = $recipient_Reference_Data;
        return $this;
    }
    /**
     * Add item to Recipient_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Recipient_DataType $item
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function addToRecipient_Reference_Data(\StructType\Recipient_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Recipient_DataType) {
            throw new \InvalidArgumentException(sprintf('The Recipient_Reference_Data property can only contain items of type \StructType\Recipient_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Recipient_Reference_Data[] = $item;
        return $this;
    }
    /**
     * Get Passenger_Reference_Data value
     * @return \StructType\Passenger_DataType[]|null
     */
    public function getPassenger_Reference_Data()
    {
        return $this->Passenger_Reference_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPassenger_Reference_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassenger_Reference_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassenger_Reference_DataForArrayConstraintsFromSetPassenger_Reference_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Line_Detail_DataTypePassenger_Reference_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Line_Detail_DataTypePassenger_Reference_DataItem instanceof \StructType\Passenger_DataType) {
                $invalidValues[] = is_object($expense_Report_Line_Detail_DataTypePassenger_Reference_DataItem) ? get_class($expense_Report_Line_Detail_DataTypePassenger_Reference_DataItem) : sprintf('%s(%s)', gettype($expense_Report_Line_Detail_DataTypePassenger_Reference_DataItem), var_export($expense_Report_Line_Detail_DataTypePassenger_Reference_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Passenger_Reference_Data property can only contain items of type \StructType\Passenger_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Passenger_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Passenger_DataType[] $passenger_Reference_Data
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setPassenger_Reference_Data(array $passenger_Reference_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($passenger_Reference_DataArrayErrorMessage = self::validatePassenger_Reference_DataForArrayConstraintsFromSetPassenger_Reference_Data($passenger_Reference_Data))) {
            throw new \InvalidArgumentException($passenger_Reference_DataArrayErrorMessage, __LINE__);
        }
        $this->Passenger_Reference_Data = $passenger_Reference_Data;
        return $this;
    }
    /**
     * Add item to Passenger_Reference_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Passenger_DataType $item
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function addToPassenger_Reference_Data(\StructType\Passenger_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Passenger_DataType) {
            throw new \InvalidArgumentException(sprintf('The Passenger_Reference_Data property can only contain items of type \StructType\Passenger_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Passenger_Reference_Data[] = $item;
        return $this;
    }
    /**
     * Get Number_of_Persons value
     * @return float|null
     */
    public function getNumber_of_Persons()
    {
        return $this->Number_of_Persons;
    }
    /**
     * Set Number_of_Persons value
     * @param float $number_of_Persons
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setNumber_of_Persons($number_of_Persons = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Persons) && !(is_float($number_of_Persons) || is_numeric($number_of_Persons))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Persons, true), gettype($number_of_Persons)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Persons) && mb_strlen(mb_substr($number_of_Persons, false !== mb_strpos($number_of_Persons, '.') ? mb_strpos($number_of_Persons, '.') + 1 : mb_strlen($number_of_Persons))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Persons, true), mb_strlen(mb_substr($number_of_Persons, mb_strpos($number_of_Persons, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Persons) && $number_of_Persons < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Persons, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Persons) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Persons)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Persons, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Persons))), __LINE__);
        }
        $this->Number_of_Persons = $number_of_Persons;
        return $this;
    }
    /**
     * Get Arrival_Date value
     * @return string|null
     */
    public function getArrival_Date()
    {
        return $this->Arrival_Date;
    }
    /**
     * Set Arrival_Date value
     * @param string $arrival_Date
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setArrival_Date($arrival_Date = null)
    {
        // validation for constraint: string
        if (!is_null($arrival_Date) && !is_string($arrival_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival_Date, true), gettype($arrival_Date)), __LINE__);
        }
        $this->Arrival_Date = $arrival_Date;
        return $this;
    }
    /**
     * Get Arrival_Time value
     * @return string|null
     */
    public function getArrival_Time()
    {
        return $this->Arrival_Time;
    }
    /**
     * Set Arrival_Time value
     * @param string $arrival_Time
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setArrival_Time($arrival_Time = null)
    {
        // validation for constraint: string
        if (!is_null($arrival_Time) && !is_string($arrival_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival_Time, true), gettype($arrival_Time)), __LINE__);
        }
        $this->Arrival_Time = $arrival_Time;
        return $this;
    }
    /**
     * Get Departure_Date value
     * @return string|null
     */
    public function getDeparture_Date()
    {
        return $this->Departure_Date;
    }
    /**
     * Set Departure_Date value
     * @param string $departure_Date
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setDeparture_Date($departure_Date = null)
    {
        // validation for constraint: string
        if (!is_null($departure_Date) && !is_string($departure_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure_Date, true), gettype($departure_Date)), __LINE__);
        }
        $this->Departure_Date = $departure_Date;
        return $this;
    }
    /**
     * Get Departure_Time value
     * @return string|null
     */
    public function getDeparture_Time()
    {
        return $this->Departure_Time;
    }
    /**
     * Set Departure_Time value
     * @param string $departure_Time
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setDeparture_Time($departure_Time = null)
    {
        // validation for constraint: string
        if (!is_null($departure_Time) && !is_string($departure_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure_Time, true), gettype($departure_Time)), __LINE__);
        }
        $this->Departure_Time = $departure_Time;
        return $this;
    }
    /**
     * Get Number_of_Days value
     * @return float|null
     */
    public function getNumber_of_Days()
    {
        return $this->Number_of_Days;
    }
    /**
     * Set Number_of_Days value
     * @param float $number_of_Days
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setNumber_of_Days($number_of_Days = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Days) && !(is_float($number_of_Days) || is_numeric($number_of_Days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Days, true), gettype($number_of_Days)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Days) && mb_strlen(mb_substr($number_of_Days, false !== mb_strpos($number_of_Days, '.') ? mb_strpos($number_of_Days, '.') + 1 : mb_strlen($number_of_Days))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Days, true), mb_strlen(mb_substr($number_of_Days, mb_strpos($number_of_Days, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Days) && $number_of_Days < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Days, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Days) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Days)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Days, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Days))), __LINE__);
        }
        $this->Number_of_Days = $number_of_Days;
        return $this;
    }
    /**
     * Get Number_of_Hours value
     * @return float|null
     */
    public function getNumber_of_Hours()
    {
        return $this->Number_of_Hours;
    }
    /**
     * Set Number_of_Hours value
     * @param float $number_of_Hours
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setNumber_of_Hours($number_of_Hours = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Hours) && !(is_float($number_of_Hours) || is_numeric($number_of_Hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Hours, true), gettype($number_of_Hours)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Hours) && mb_strlen(mb_substr($number_of_Hours, false !== mb_strpos($number_of_Hours, '.') ? mb_strpos($number_of_Hours, '.') + 1 : mb_strlen($number_of_Hours))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Hours, true), mb_strlen(mb_substr($number_of_Hours, mb_strpos($number_of_Hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Hours) && $number_of_Hours < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Hours, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Hours) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Hours)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Hours, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Hours))), __LINE__);
        }
        $this->Number_of_Hours = $number_of_Hours;
        return $this;
    }
    /**
     * Get Number_of_Breakfasts_Provided value
     * @return float|null
     */
    public function getNumber_of_Breakfasts_Provided()
    {
        return $this->Number_of_Breakfasts_Provided;
    }
    /**
     * Set Number_of_Breakfasts_Provided value
     * @param float $number_of_Breakfasts_Provided
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setNumber_of_Breakfasts_Provided($number_of_Breakfasts_Provided = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Breakfasts_Provided) && !(is_float($number_of_Breakfasts_Provided) || is_numeric($number_of_Breakfasts_Provided))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Breakfasts_Provided, true), gettype($number_of_Breakfasts_Provided)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Breakfasts_Provided) && mb_strlen(mb_substr($number_of_Breakfasts_Provided, false !== mb_strpos($number_of_Breakfasts_Provided, '.') ? mb_strpos($number_of_Breakfasts_Provided, '.') + 1 : mb_strlen($number_of_Breakfasts_Provided))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Breakfasts_Provided, true), mb_strlen(mb_substr($number_of_Breakfasts_Provided, mb_strpos($number_of_Breakfasts_Provided, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Breakfasts_Provided) && $number_of_Breakfasts_Provided < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Breakfasts_Provided, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Breakfasts_Provided) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Breakfasts_Provided)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Breakfasts_Provided, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Breakfasts_Provided))), __LINE__);
        }
        $this->Number_of_Breakfasts_Provided = $number_of_Breakfasts_Provided;
        return $this;
    }
    /**
     * Get Number_of_Lunches_Provided value
     * @return float|null
     */
    public function getNumber_of_Lunches_Provided()
    {
        return $this->Number_of_Lunches_Provided;
    }
    /**
     * Set Number_of_Lunches_Provided value
     * @param float $number_of_Lunches_Provided
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setNumber_of_Lunches_Provided($number_of_Lunches_Provided = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Lunches_Provided) && !(is_float($number_of_Lunches_Provided) || is_numeric($number_of_Lunches_Provided))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Lunches_Provided, true), gettype($number_of_Lunches_Provided)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Lunches_Provided) && mb_strlen(mb_substr($number_of_Lunches_Provided, false !== mb_strpos($number_of_Lunches_Provided, '.') ? mb_strpos($number_of_Lunches_Provided, '.') + 1 : mb_strlen($number_of_Lunches_Provided))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Lunches_Provided, true), mb_strlen(mb_substr($number_of_Lunches_Provided, mb_strpos($number_of_Lunches_Provided, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Lunches_Provided) && $number_of_Lunches_Provided < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Lunches_Provided, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Lunches_Provided) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Lunches_Provided)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Lunches_Provided, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Lunches_Provided))), __LINE__);
        }
        $this->Number_of_Lunches_Provided = $number_of_Lunches_Provided;
        return $this;
    }
    /**
     * Get Number_of_Dinners_Provided value
     * @return float|null
     */
    public function getNumber_of_Dinners_Provided()
    {
        return $this->Number_of_Dinners_Provided;
    }
    /**
     * Set Number_of_Dinners_Provided value
     * @param float $number_of_Dinners_Provided
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setNumber_of_Dinners_Provided($number_of_Dinners_Provided = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Dinners_Provided) && !(is_float($number_of_Dinners_Provided) || is_numeric($number_of_Dinners_Provided))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Dinners_Provided, true), gettype($number_of_Dinners_Provided)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Dinners_Provided) && mb_strlen(mb_substr($number_of_Dinners_Provided, false !== mb_strpos($number_of_Dinners_Provided, '.') ? mb_strpos($number_of_Dinners_Provided, '.') + 1 : mb_strlen($number_of_Dinners_Provided))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Dinners_Provided, true), mb_strlen(mb_substr($number_of_Dinners_Provided, mb_strpos($number_of_Dinners_Provided, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Dinners_Provided) && $number_of_Dinners_Provided < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Dinners_Provided, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Dinners_Provided) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Dinners_Provided)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Dinners_Provided, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Dinners_Provided))), __LINE__);
        }
        $this->Number_of_Dinners_Provided = $number_of_Dinners_Provided;
        return $this;
    }
    /**
     * Get Number_of_Nights_Private_Accommodation value
     * @return float|null
     */
    public function getNumber_of_Nights_Private_Accommodation()
    {
        return $this->Number_of_Nights_Private_Accommodation;
    }
    /**
     * Set Number_of_Nights_Private_Accommodation value
     * @param float $number_of_Nights_Private_Accommodation
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setNumber_of_Nights_Private_Accommodation($number_of_Nights_Private_Accommodation = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Nights_Private_Accommodation) && !(is_float($number_of_Nights_Private_Accommodation) || is_numeric($number_of_Nights_Private_Accommodation))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Nights_Private_Accommodation, true), gettype($number_of_Nights_Private_Accommodation)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Nights_Private_Accommodation) && mb_strlen(mb_substr($number_of_Nights_Private_Accommodation, false !== mb_strpos($number_of_Nights_Private_Accommodation, '.') ? mb_strpos($number_of_Nights_Private_Accommodation, '.') + 1 : mb_strlen($number_of_Nights_Private_Accommodation))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Nights_Private_Accommodation, true), mb_strlen(mb_substr($number_of_Nights_Private_Accommodation, mb_strpos($number_of_Nights_Private_Accommodation, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Nights_Private_Accommodation) && $number_of_Nights_Private_Accommodation < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Nights_Private_Accommodation, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Nights_Private_Accommodation) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Nights_Private_Accommodation)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Nights_Private_Accommodation, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Nights_Private_Accommodation))), __LINE__);
        }
        $this->Number_of_Nights_Private_Accommodation = $number_of_Nights_Private_Accommodation;
        return $this;
    }
    /**
     * Get Eligibility_Reference value
     * @return \StructType\Expense_EligibilityObjectType|null
     */
    public function getEligibility_Reference()
    {
        return $this->Eligibility_Reference;
    }
    /**
     * Set Eligibility_Reference value
     * @param \StructType\Expense_EligibilityObjectType $eligibility_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setEligibility_Reference(\StructType\Expense_EligibilityObjectType $eligibility_Reference = null)
    {
        $this->Eligibility_Reference = $eligibility_Reference;
        return $this;
    }
    /**
     * Get Class_of_Service_Reference value
     * @return \StructType\Class_of_ServiceObjectType|null
     */
    public function getClass_of_Service_Reference()
    {
        return $this->Class_of_Service_Reference;
    }
    /**
     * Set Class_of_Service_Reference value
     * @param \StructType\Class_of_ServiceObjectType $class_of_Service_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setClass_of_Service_Reference(\StructType\Class_of_ServiceObjectType $class_of_Service_Reference = null)
    {
        $this->Class_of_Service_Reference = $class_of_Service_Reference;
        return $this;
    }
    /**
     * Get Daily_Rate value
     * @return float|null
     */
    public function getDaily_Rate()
    {
        return $this->Daily_Rate;
    }
    /**
     * Set Daily_Rate value
     * @param float $daily_Rate
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setDaily_Rate($daily_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($daily_Rate) && !(is_float($daily_Rate) || is_numeric($daily_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($daily_Rate, true), gettype($daily_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($daily_Rate) && mb_strlen(mb_substr($daily_Rate, false !== mb_strpos($daily_Rate, '.') ? mb_strpos($daily_Rate, '.') + 1 : mb_strlen($daily_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($daily_Rate, true), mb_strlen(mb_substr($daily_Rate, mb_strpos($daily_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($daily_Rate) && mb_strlen(preg_replace('/(\D)/', '', $daily_Rate)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($daily_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $daily_Rate))), __LINE__);
        }
        $this->Daily_Rate = $daily_Rate;
        return $this;
    }
    /**
     * Get Reference_Number value
     * @return string|null
     */
    public function getReference_Number()
    {
        return $this->Reference_Number;
    }
    /**
     * Set Reference_Number value
     * @param string $reference_Number
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setReference_Number($reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($reference_Number) && !is_string($reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference_Number, true), gettype($reference_Number)), __LINE__);
        }
        $this->Reference_Number = $reference_Number;
        return $this;
    }
    /**
     * Get Classes_of_Service_Reference value
     * @return \StructType\Class_of_ServiceObjectType[]|null
     */
    public function getClasses_of_Service_Reference()
    {
        return $this->Classes_of_Service_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setClasses_of_Service_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClasses_of_Service_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClasses_of_Service_ReferenceForArrayConstraintsFromSetClasses_of_Service_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Line_Detail_DataTypeClasses_of_Service_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Line_Detail_DataTypeClasses_of_Service_ReferenceItem instanceof \StructType\Class_of_ServiceObjectType) {
                $invalidValues[] = is_object($expense_Report_Line_Detail_DataTypeClasses_of_Service_ReferenceItem) ? get_class($expense_Report_Line_Detail_DataTypeClasses_of_Service_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Report_Line_Detail_DataTypeClasses_of_Service_ReferenceItem), var_export($expense_Report_Line_Detail_DataTypeClasses_of_Service_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Classes_of_Service_Reference property can only contain items of type \StructType\Class_of_ServiceObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Classes_of_Service_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Class_of_ServiceObjectType[] $classes_of_Service_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setClasses_of_Service_Reference(array $classes_of_Service_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($classes_of_Service_ReferenceArrayErrorMessage = self::validateClasses_of_Service_ReferenceForArrayConstraintsFromSetClasses_of_Service_Reference($classes_of_Service_Reference))) {
            throw new \InvalidArgumentException($classes_of_Service_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Classes_of_Service_Reference = $classes_of_Service_Reference;
        return $this;
    }
    /**
     * Add item to Classes_of_Service_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Class_of_ServiceObjectType $item
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function addToClasses_of_Service_Reference(\StructType\Class_of_ServiceObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Class_of_ServiceObjectType) {
            throw new \InvalidArgumentException(sprintf('The Classes_of_Service_Reference property can only contain items of type \StructType\Class_of_ServiceObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Classes_of_Service_Reference[] = $item;
        return $this;
    }
    /**
     * Get Document_Number value
     * @return string|null
     */
    public function getDocument_Number()
    {
        return $this->Document_Number;
    }
    /**
     * Set Document_Number value
     * @param string $document_Number
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setDocument_Number($document_Number = null)
    {
        // validation for constraint: string
        if (!is_null($document_Number) && !is_string($document_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Number, true), gettype($document_Number)), __LINE__);
        }
        $this->Document_Number = $document_Number;
        return $this;
    }
    /**
     * Get Merchant_Postal_Code value
     * @return string|null
     */
    public function getMerchant_Postal_Code()
    {
        return $this->Merchant_Postal_Code;
    }
    /**
     * Set Merchant_Postal_Code value
     * @param string $merchant_Postal_Code
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setMerchant_Postal_Code($merchant_Postal_Code = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Postal_Code) && !is_string($merchant_Postal_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Postal_Code, true), gettype($merchant_Postal_Code)), __LINE__);
        }
        $this->Merchant_Postal_Code = $merchant_Postal_Code;
        return $this;
    }
    /**
     * Get Merchant_Address value
     * @return string|null
     */
    public function getMerchant_Address()
    {
        return $this->Merchant_Address;
    }
    /**
     * Set Merchant_Address value
     * @param string $merchant_Address
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setMerchant_Address($merchant_Address = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Address) && !is_string($merchant_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Address, true), gettype($merchant_Address)), __LINE__);
        }
        $this->Merchant_Address = $merchant_Address;
        return $this;
    }
    /**
     * Get Merchant_City value
     * @return string|null
     */
    public function getMerchant_City()
    {
        return $this->Merchant_City;
    }
    /**
     * Set Merchant_City value
     * @param string $merchant_City
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setMerchant_City($merchant_City = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_City) && !is_string($merchant_City)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_City, true), gettype($merchant_City)), __LINE__);
        }
        $this->Merchant_City = $merchant_City;
        return $this;
    }
    /**
     * Get Merchant_Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getMerchant_Country_Reference()
    {
        return $this->Merchant_Country_Reference;
    }
    /**
     * Set Merchant_Country_Reference value
     * @param \StructType\CountryObjectType $merchant_Country_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setMerchant_Country_Reference(\StructType\CountryObjectType $merchant_Country_Reference = null)
    {
        $this->Merchant_Country_Reference = $merchant_Country_Reference;
        return $this;
    }
    /**
     * Get Merchant_Region_Reference value
     * @return \StructType\Country_RegionObjectType|null
     */
    public function getMerchant_Region_Reference()
    {
        return $this->Merchant_Region_Reference;
    }
    /**
     * Set Merchant_Region_Reference value
     * @param \StructType\Country_RegionObjectType $merchant_Region_Reference
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setMerchant_Region_Reference(\StructType\Country_RegionObjectType $merchant_Region_Reference = null)
    {
        $this->Merchant_Region_Reference = $merchant_Region_Reference;
        return $this;
    }
    /**
     * Get configurable_Boolean value
     * @return configurable_Boolean
     */
    public function getConfigurable_Boolean_1()
    {
        return $this->Configurable_Boolean_1;
    }
    /**
     * Set configurable_Boolean value
     * @param configurable_Boolean $configurable_Boolean
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Boolean_1($configurable_Boolean_1 = null)
    {
        // validation for constraint: boolean
        if (!is_null($configurable_Boolean_1) && !is_bool($configurable_Boolean_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($configurable_Boolean_1, true), gettype($configurable_Boolean_1)), __LINE__);
        }
        $this->Configurable_Boolean_1 = $configurable_Boolean_1;
        return $this;
    }
    /**
     * Get configurable_Boolean value
     * @return configurable_Boolean
     */
    public function getConfigurable_Boolean_2()
    {
        return $this->Configurable_Boolean_2;
    }
    /**
     * Set configurable_Boolean value
     * @param configurable_Boolean $configurable_Boolean
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Boolean_2($configurable_Boolean_2 = null)
    {
        // validation for constraint: boolean
        if (!is_null($configurable_Boolean_2) && !is_bool($configurable_Boolean_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($configurable_Boolean_2, true), gettype($configurable_Boolean_2)), __LINE__);
        }
        $this->Configurable_Boolean_2 = $configurable_Boolean_2;
        return $this;
    }
    /**
     * Get configurable_Boolean value
     * @return configurable_Boolean
     */
    public function getConfigurable_Boolean_3()
    {
        return $this->Configurable_Boolean_3;
    }
    /**
     * Set configurable_Boolean value
     * @param configurable_Boolean $configurable_Boolean
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Boolean_3($configurable_Boolean_3 = null)
    {
        // validation for constraint: boolean
        if (!is_null($configurable_Boolean_3) && !is_bool($configurable_Boolean_3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($configurable_Boolean_3, true), gettype($configurable_Boolean_3)), __LINE__);
        }
        $this->Configurable_Boolean_3 = $configurable_Boolean_3;
        return $this;
    }
    /**
     * Get configurable_Boolean value
     * @return configurable_Boolean
     */
    public function getConfigurable_Boolean_4()
    {
        return $this->Configurable_Boolean_4;
    }
    /**
     * Set configurable_Boolean value
     * @param configurable_Boolean $configurable_Boolean
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Boolean_4($configurable_Boolean_4 = null)
    {
        // validation for constraint: boolean
        if (!is_null($configurable_Boolean_4) && !is_bool($configurable_Boolean_4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($configurable_Boolean_4, true), gettype($configurable_Boolean_4)), __LINE__);
        }
        $this->Configurable_Boolean_4 = $configurable_Boolean_4;
        return $this;
    }
    /**
     * Get configurable_Boolean value
     * @return configurable_Boolean
     */
    public function getConfigurable_Boolean_5()
    {
        return $this->Configurable_Boolean_5;
    }
    /**
     * Set configurable_Boolean value
     * @param configurable_Boolean $configurable_Boolean
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Boolean_5($configurable_Boolean_5 = null)
    {
        // validation for constraint: boolean
        if (!is_null($configurable_Boolean_5) && !is_bool($configurable_Boolean_5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($configurable_Boolean_5, true), gettype($configurable_Boolean_5)), __LINE__);
        }
        $this->Configurable_Boolean_5 = $configurable_Boolean_5;
        return $this;
    }
    /**
     * Get configurable_Decimal value
     * @return configurable_Decimal
     */
    public function getConfigurable_Decimal_1()
    {
        return $this->Configurable_Decimal_1;
    }
    /**
     * Set configurable_Decimal value
     * @param configurable_Decimal $configurable_Decimal
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Decimal_1($configurable_Decimal_1 = null)
    {
        // validation for constraint: float
        if (!is_null($configurable_Decimal_1) && !(is_float($configurable_Decimal_1) || is_numeric($configurable_Decimal_1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($configurable_Decimal_1, true), gettype($configurable_Decimal_1)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($configurable_Decimal_1) && mb_strlen(mb_substr($configurable_Decimal_1, false !== mb_strpos($configurable_Decimal_1, '.') ? mb_strpos($configurable_Decimal_1, '.') + 1 : mb_strlen($configurable_Decimal_1))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($configurable_Decimal_1, true), mb_strlen(mb_substr($configurable_Decimal_1, mb_strpos($configurable_Decimal_1, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($configurable_Decimal_1) && $configurable_Decimal_1 < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($configurable_Decimal_1, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($configurable_Decimal_1) && mb_strlen(preg_replace('/(\D)/', '', $configurable_Decimal_1)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($configurable_Decimal_1, true), mb_strlen(preg_replace('/(\D)/', '', $configurable_Decimal_1))), __LINE__);
        }
        $this->Configurable_Decimal_1 = $configurable_Decimal_1;
        return $this;
    }
    /**
     * Get configurable_Decimal value
     * @return configurable_Decimal
     */
    public function getConfigurable_Decimal_2()
    {
        return $this->Configurable_Decimal_2;
    }
    /**
     * Set configurable_Decimal value
     * @param configurable_Decimal $configurable_Decimal
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Decimal_2($configurable_Decimal_2 = null)
    {
        // validation for constraint: float
        if (!is_null($configurable_Decimal_2) && !(is_float($configurable_Decimal_2) || is_numeric($configurable_Decimal_2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($configurable_Decimal_2, true), gettype($configurable_Decimal_2)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($configurable_Decimal_2) && mb_strlen(mb_substr($configurable_Decimal_2, false !== mb_strpos($configurable_Decimal_2, '.') ? mb_strpos($configurable_Decimal_2, '.') + 1 : mb_strlen($configurable_Decimal_2))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($configurable_Decimal_2, true), mb_strlen(mb_substr($configurable_Decimal_2, mb_strpos($configurable_Decimal_2, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($configurable_Decimal_2) && $configurable_Decimal_2 < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($configurable_Decimal_2, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($configurable_Decimal_2) && mb_strlen(preg_replace('/(\D)/', '', $configurable_Decimal_2)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($configurable_Decimal_2, true), mb_strlen(preg_replace('/(\D)/', '', $configurable_Decimal_2))), __LINE__);
        }
        $this->Configurable_Decimal_2 = $configurable_Decimal_2;
        return $this;
    }
    /**
     * Get configurable_Decimal value
     * @return configurable_Decimal
     */
    public function getConfigurable_Decimal_3()
    {
        return $this->Configurable_Decimal_3;
    }
    /**
     * Set configurable_Decimal value
     * @param configurable_Decimal $configurable_Decimal
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Decimal_3($configurable_Decimal_3 = null)
    {
        // validation for constraint: float
        if (!is_null($configurable_Decimal_3) && !(is_float($configurable_Decimal_3) || is_numeric($configurable_Decimal_3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($configurable_Decimal_3, true), gettype($configurable_Decimal_3)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($configurable_Decimal_3) && mb_strlen(mb_substr($configurable_Decimal_3, false !== mb_strpos($configurable_Decimal_3, '.') ? mb_strpos($configurable_Decimal_3, '.') + 1 : mb_strlen($configurable_Decimal_3))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($configurable_Decimal_3, true), mb_strlen(mb_substr($configurable_Decimal_3, mb_strpos($configurable_Decimal_3, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($configurable_Decimal_3) && $configurable_Decimal_3 < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($configurable_Decimal_3, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($configurable_Decimal_3) && mb_strlen(preg_replace('/(\D)/', '', $configurable_Decimal_3)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($configurable_Decimal_3, true), mb_strlen(preg_replace('/(\D)/', '', $configurable_Decimal_3))), __LINE__);
        }
        $this->Configurable_Decimal_3 = $configurable_Decimal_3;
        return $this;
    }
    /**
     * Get configurable_Decimal value
     * @return configurable_Decimal
     */
    public function getConfigurable_Decimal_4()
    {
        return $this->Configurable_Decimal_4;
    }
    /**
     * Set configurable_Decimal value
     * @param configurable_Decimal $configurable_Decimal
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Decimal_4($configurable_Decimal_4 = null)
    {
        // validation for constraint: float
        if (!is_null($configurable_Decimal_4) && !(is_float($configurable_Decimal_4) || is_numeric($configurable_Decimal_4))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($configurable_Decimal_4, true), gettype($configurable_Decimal_4)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($configurable_Decimal_4) && mb_strlen(mb_substr($configurable_Decimal_4, false !== mb_strpos($configurable_Decimal_4, '.') ? mb_strpos($configurable_Decimal_4, '.') + 1 : mb_strlen($configurable_Decimal_4))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($configurable_Decimal_4, true), mb_strlen(mb_substr($configurable_Decimal_4, mb_strpos($configurable_Decimal_4, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($configurable_Decimal_4) && $configurable_Decimal_4 < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($configurable_Decimal_4, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($configurable_Decimal_4) && mb_strlen(preg_replace('/(\D)/', '', $configurable_Decimal_4)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($configurable_Decimal_4, true), mb_strlen(preg_replace('/(\D)/', '', $configurable_Decimal_4))), __LINE__);
        }
        $this->Configurable_Decimal_4 = $configurable_Decimal_4;
        return $this;
    }
    /**
     * Get configurable_Decimal value
     * @return configurable_Decimal
     */
    public function getConfigurable_Decimal_5()
    {
        return $this->Configurable_Decimal_5;
    }
    /**
     * Set configurable_Decimal value
     * @param configurable_Decimal $configurable_Decimal
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Decimal_5($configurable_Decimal_5 = null)
    {
        // validation for constraint: float
        if (!is_null($configurable_Decimal_5) && !(is_float($configurable_Decimal_5) || is_numeric($configurable_Decimal_5))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($configurable_Decimal_5, true), gettype($configurable_Decimal_5)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($configurable_Decimal_5) && mb_strlen(mb_substr($configurable_Decimal_5, false !== mb_strpos($configurable_Decimal_5, '.') ? mb_strpos($configurable_Decimal_5, '.') + 1 : mb_strlen($configurable_Decimal_5))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($configurable_Decimal_5, true), mb_strlen(mb_substr($configurable_Decimal_5, mb_strpos($configurable_Decimal_5, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($configurable_Decimal_5) && $configurable_Decimal_5 < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($configurable_Decimal_5, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($configurable_Decimal_5) && mb_strlen(preg_replace('/(\D)/', '', $configurable_Decimal_5)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($configurable_Decimal_5, true), mb_strlen(preg_replace('/(\D)/', '', $configurable_Decimal_5))), __LINE__);
        }
        $this->Configurable_Decimal_5 = $configurable_Decimal_5;
        return $this;
    }
    /**
     * Get configurable_Numeric value
     * @return configurable_Numeric
     */
    public function getConfigurable_Numeric_1()
    {
        return $this->Configurable_Numeric_1;
    }
    /**
     * Set configurable_Numeric value
     * @param configurable_Numeric $configurable_Numeric
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Numeric_1($configurable_Numeric_1 = null)
    {
        // validation for constraint: float
        if (!is_null($configurable_Numeric_1) && !(is_float($configurable_Numeric_1) || is_numeric($configurable_Numeric_1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($configurable_Numeric_1, true), gettype($configurable_Numeric_1)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($configurable_Numeric_1) && mb_strlen(mb_substr($configurable_Numeric_1, false !== mb_strpos($configurable_Numeric_1, '.') ? mb_strpos($configurable_Numeric_1, '.') + 1 : mb_strlen($configurable_Numeric_1))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($configurable_Numeric_1, true), mb_strlen(mb_substr($configurable_Numeric_1, mb_strpos($configurable_Numeric_1, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($configurable_Numeric_1) && $configurable_Numeric_1 < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($configurable_Numeric_1, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($configurable_Numeric_1) && mb_strlen(preg_replace('/(\D)/', '', $configurable_Numeric_1)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($configurable_Numeric_1, true), mb_strlen(preg_replace('/(\D)/', '', $configurable_Numeric_1))), __LINE__);
        }
        $this->Configurable_Numeric_1 = $configurable_Numeric_1;
        return $this;
    }
    /**
     * Get configurable_Numeric value
     * @return configurable_Numeric
     */
    public function getConfigurable_Numeric_2()
    {
        return $this->Configurable_Numeric_2;
    }
    /**
     * Set configurable_Numeric value
     * @param configurable_Numeric $configurable_Numeric
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Numeric_2($configurable_Numeric_2 = null)
    {
        // validation for constraint: float
        if (!is_null($configurable_Numeric_2) && !(is_float($configurable_Numeric_2) || is_numeric($configurable_Numeric_2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($configurable_Numeric_2, true), gettype($configurable_Numeric_2)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($configurable_Numeric_2) && mb_strlen(mb_substr($configurable_Numeric_2, false !== mb_strpos($configurable_Numeric_2, '.') ? mb_strpos($configurable_Numeric_2, '.') + 1 : mb_strlen($configurable_Numeric_2))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($configurable_Numeric_2, true), mb_strlen(mb_substr($configurable_Numeric_2, mb_strpos($configurable_Numeric_2, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($configurable_Numeric_2) && $configurable_Numeric_2 < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($configurable_Numeric_2, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($configurable_Numeric_2) && mb_strlen(preg_replace('/(\D)/', '', $configurable_Numeric_2)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($configurable_Numeric_2, true), mb_strlen(preg_replace('/(\D)/', '', $configurable_Numeric_2))), __LINE__);
        }
        $this->Configurable_Numeric_2 = $configurable_Numeric_2;
        return $this;
    }
    /**
     * Get configurable_Numeric value
     * @return configurable_Numeric
     */
    public function getConfigurable_Numeric_3()
    {
        return $this->Configurable_Numeric_3;
    }
    /**
     * Set configurable_Numeric value
     * @param configurable_Numeric $configurable_Numeric
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Numeric_3($configurable_Numeric_3 = null)
    {
        // validation for constraint: float
        if (!is_null($configurable_Numeric_3) && !(is_float($configurable_Numeric_3) || is_numeric($configurable_Numeric_3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($configurable_Numeric_3, true), gettype($configurable_Numeric_3)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($configurable_Numeric_3) && mb_strlen(mb_substr($configurable_Numeric_3, false !== mb_strpos($configurable_Numeric_3, '.') ? mb_strpos($configurable_Numeric_3, '.') + 1 : mb_strlen($configurable_Numeric_3))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($configurable_Numeric_3, true), mb_strlen(mb_substr($configurable_Numeric_3, mb_strpos($configurable_Numeric_3, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($configurable_Numeric_3) && $configurable_Numeric_3 < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($configurable_Numeric_3, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($configurable_Numeric_3) && mb_strlen(preg_replace('/(\D)/', '', $configurable_Numeric_3)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($configurable_Numeric_3, true), mb_strlen(preg_replace('/(\D)/', '', $configurable_Numeric_3))), __LINE__);
        }
        $this->Configurable_Numeric_3 = $configurable_Numeric_3;
        return $this;
    }
    /**
     * Get configurable_Numeric value
     * @return configurable_Numeric
     */
    public function getConfigurable_Numeric_4()
    {
        return $this->Configurable_Numeric_4;
    }
    /**
     * Set configurable_Numeric value
     * @param configurable_Numeric $configurable_Numeric
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Numeric_4($configurable_Numeric_4 = null)
    {
        // validation for constraint: float
        if (!is_null($configurable_Numeric_4) && !(is_float($configurable_Numeric_4) || is_numeric($configurable_Numeric_4))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($configurable_Numeric_4, true), gettype($configurable_Numeric_4)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($configurable_Numeric_4) && mb_strlen(mb_substr($configurable_Numeric_4, false !== mb_strpos($configurable_Numeric_4, '.') ? mb_strpos($configurable_Numeric_4, '.') + 1 : mb_strlen($configurable_Numeric_4))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($configurable_Numeric_4, true), mb_strlen(mb_substr($configurable_Numeric_4, mb_strpos($configurable_Numeric_4, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($configurable_Numeric_4) && $configurable_Numeric_4 < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($configurable_Numeric_4, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($configurable_Numeric_4) && mb_strlen(preg_replace('/(\D)/', '', $configurable_Numeric_4)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($configurable_Numeric_4, true), mb_strlen(preg_replace('/(\D)/', '', $configurable_Numeric_4))), __LINE__);
        }
        $this->Configurable_Numeric_4 = $configurable_Numeric_4;
        return $this;
    }
    /**
     * Get configurable_Numeric value
     * @return configurable_Numeric
     */
    public function getConfigurable_Numeric_5()
    {
        return $this->Configurable_Numeric_5;
    }
    /**
     * Set configurable_Numeric value
     * @param configurable_Numeric $configurable_Numeric
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Numeric_5($configurable_Numeric_5 = null)
    {
        // validation for constraint: float
        if (!is_null($configurable_Numeric_5) && !(is_float($configurable_Numeric_5) || is_numeric($configurable_Numeric_5))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($configurable_Numeric_5, true), gettype($configurable_Numeric_5)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($configurable_Numeric_5) && mb_strlen(mb_substr($configurable_Numeric_5, false !== mb_strpos($configurable_Numeric_5, '.') ? mb_strpos($configurable_Numeric_5, '.') + 1 : mb_strlen($configurable_Numeric_5))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($configurable_Numeric_5, true), mb_strlen(mb_substr($configurable_Numeric_5, mb_strpos($configurable_Numeric_5, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($configurable_Numeric_5) && $configurable_Numeric_5 < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($configurable_Numeric_5, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($configurable_Numeric_5) && mb_strlen(preg_replace('/(\D)/', '', $configurable_Numeric_5)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($configurable_Numeric_5, true), mb_strlen(preg_replace('/(\D)/', '', $configurable_Numeric_5))), __LINE__);
        }
        $this->Configurable_Numeric_5 = $configurable_Numeric_5;
        return $this;
    }
    /**
     * Get configurable_Text value
     * @return configurable_Text
     */
    public function getConfigurable_Text_1()
    {
        return $this->Configurable_Text_1;
    }
    /**
     * Set configurable_Text value
     * @param configurable_Text $configurable_Text
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Text_1($configurable_Text_1 = null)
    {
        // validation for constraint: string
        if (!is_null($configurable_Text_1) && !is_string($configurable_Text_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurable_Text_1, true), gettype($configurable_Text_1)), __LINE__);
        }
        $this->Configurable_Text_1 = $configurable_Text_1;
        return $this;
    }
    /**
     * Get configurable_Text value
     * @return configurable_Text
     */
    public function getConfigurable_Text_2()
    {
        return $this->Configurable_Text_2;
    }
    /**
     * Set configurable_Text value
     * @param configurable_Text $configurable_Text
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Text_2($configurable_Text_2 = null)
    {
        // validation for constraint: string
        if (!is_null($configurable_Text_2) && !is_string($configurable_Text_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurable_Text_2, true), gettype($configurable_Text_2)), __LINE__);
        }
        $this->Configurable_Text_2 = $configurable_Text_2;
        return $this;
    }
    /**
     * Get configurable_Text value
     * @return configurable_Text
     */
    public function getConfigurable_Text_3()
    {
        return $this->Configurable_Text_3;
    }
    /**
     * Set configurable_Text value
     * @param configurable_Text $configurable_Text
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Text_3($configurable_Text_3 = null)
    {
        // validation for constraint: string
        if (!is_null($configurable_Text_3) && !is_string($configurable_Text_3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurable_Text_3, true), gettype($configurable_Text_3)), __LINE__);
        }
        $this->Configurable_Text_3 = $configurable_Text_3;
        return $this;
    }
    /**
     * Get configurable_Text value
     * @return configurable_Text
     */
    public function getConfigurable_Text_4()
    {
        return $this->Configurable_Text_4;
    }
    /**
     * Set configurable_Text value
     * @param configurable_Text $configurable_Text
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Text_4($configurable_Text_4 = null)
    {
        // validation for constraint: string
        if (!is_null($configurable_Text_4) && !is_string($configurable_Text_4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurable_Text_4, true), gettype($configurable_Text_4)), __LINE__);
        }
        $this->Configurable_Text_4 = $configurable_Text_4;
        return $this;
    }
    /**
     * Get configurable_Text value
     * @return configurable_Text
     */
    public function getConfigurable_Text_5()
    {
        return $this->Configurable_Text_5;
    }
    /**
     * Set configurable_Text value
     * @param configurable_Text $configurable_Text
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Text_5($configurable_Text_5 = null)
    {
        // validation for constraint: string
        if (!is_null($configurable_Text_5) && !is_string($configurable_Text_5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurable_Text_5, true), gettype($configurable_Text_5)), __LINE__);
        }
        $this->Configurable_Text_5 = $configurable_Text_5;
        return $this;
    }
    /**
     * Get configurable_Date value
     * @return configurable_Date
     */
    public function getConfigurable_Date_1()
    {
        return $this->Configurable_Date_1;
    }
    /**
     * Set configurable_Date value
     * @param configurable_Date $configurable_Date
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Date_1($configurable_Date_1 = null)
    {
        // validation for constraint: string
        if (!is_null($configurable_Date_1) && !is_string($configurable_Date_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurable_Date_1, true), gettype($configurable_Date_1)), __LINE__);
        }
        $this->Configurable_Date_1 = $configurable_Date_1;
        return $this;
    }
    /**
     * Get configurable_Date value
     * @return configurable_Date
     */
    public function getConfigurable_Date_2()
    {
        return $this->Configurable_Date_2;
    }
    /**
     * Set configurable_Date value
     * @param configurable_Date $configurable_Date
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Date_2($configurable_Date_2 = null)
    {
        // validation for constraint: string
        if (!is_null($configurable_Date_2) && !is_string($configurable_Date_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurable_Date_2, true), gettype($configurable_Date_2)), __LINE__);
        }
        $this->Configurable_Date_2 = $configurable_Date_2;
        return $this;
    }
    /**
     * Get configurable_Date value
     * @return configurable_Date
     */
    public function getConfigurable_Date_3()
    {
        return $this->Configurable_Date_3;
    }
    /**
     * Set configurable_Date value
     * @param configurable_Date $configurable_Date
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Date_3($configurable_Date_3 = null)
    {
        // validation for constraint: string
        if (!is_null($configurable_Date_3) && !is_string($configurable_Date_3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurable_Date_3, true), gettype($configurable_Date_3)), __LINE__);
        }
        $this->Configurable_Date_3 = $configurable_Date_3;
        return $this;
    }
    /**
     * Get configurable_Date value
     * @return configurable_Date
     */
    public function getConfigurable_Date_4()
    {
        return $this->Configurable_Date_4;
    }
    /**
     * Set configurable_Date value
     * @param configurable_Date $configurable_Date
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Date_4($configurable_Date_4 = null)
    {
        // validation for constraint: string
        if (!is_null($configurable_Date_4) && !is_string($configurable_Date_4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurable_Date_4, true), gettype($configurable_Date_4)), __LINE__);
        }
        $this->Configurable_Date_4 = $configurable_Date_4;
        return $this;
    }
    /**
     * Get configurable_Date value
     * @return configurable_Date
     */
    public function getConfigurable_Date_5()
    {
        return $this->Configurable_Date_5;
    }
    /**
     * Set configurable_Date value
     * @param configurable_Date $configurable_Date
     * @return \StructType\Expense_Report_Line_Detail_DataType
     */
    public function setConfigurable_Date_5($configurable_Date_5 = null)
    {
        // validation for constraint: string
        if (!is_null($configurable_Date_5) && !is_string($configurable_Date_5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurable_Date_5, true), gettype($configurable_Date_5)), __LINE__);
        }
        $this->Configurable_Date_5 = $configurable_Date_5;
        return $this;
    }
}
