<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Carrier_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Use this element to retrieve the specific details of your carrier requests.
 * @subpackage Structs
 */
class Carrier_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Carrier_Name
     * Meta information extracted from the WSDL
     * - documentation: Carrier Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier_Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for Carrier_Request_CriteriaType
     * @uses Carrier_Request_CriteriaType::setCarrier_Name()
     * @uses Carrier_Request_CriteriaType::setDescription()
     * @param string $carrier_Name
     * @param string $description
     */
    public function __construct($carrier_Name = null, $description = null)
    {
        $this
            ->setCarrier_Name($carrier_Name)
            ->setDescription($description);
    }
    /**
     * Get Carrier_Name value
     * @return string|null
     */
    public function getCarrier_Name()
    {
        return $this->Carrier_Name;
    }
    /**
     * Set Carrier_Name value
     * @param string $carrier_Name
     * @return \StructType\Carrier_Request_CriteriaType
     */
    public function setCarrier_Name($carrier_Name = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_Name) && !is_string($carrier_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_Name, true), gettype($carrier_Name)), __LINE__);
        }
        $this->Carrier_Name = $carrier_Name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Carrier_Request_CriteriaType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
