<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Advanced_Ship_Notice_Data_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents the contents of the entire Advanced Ship Notice, Lines and Attachments.
 * @subpackage Structs
 */
class Advanced_Ship_Notice_Data_OutboundType extends AbstractStructBase
{
    /**
     * The Advanced_Ship_Notice_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Advanced_Ship_Notice_ID;
    /**
     * The Document_Number
     * Meta information extracted from the WSDL
     * - documentation: A unique Workday system generated Advanced Ship Notice Number. This value cannot be updated, but it can be used to reference an instance of Advanced Ship Notice.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Number;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company on the Advanced Ship Notice.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency on the Advanced Ship Notice.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Status of the Advanced Ship Notice.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Document_Status_Reference;
    /**
     * The Cancellation_Memo
     * Meta information extracted from the WSDL
     * - documentation: Cancellation memo.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cancellation_Memo;
    /**
     * The Canceled_On_Date
     * Meta information extracted from the WSDL
     * - documentation: The Cancellation Date of the Business Document
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Canceled_On_Date;
    /**
     * The Shipment_Date
     * Meta information extracted from the WSDL
     * - documentation: Shipment Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_Date;
    /**
     * The Bill_Of_Lading
     * Meta information extracted from the WSDL
     * - documentation: Bill Of Lading
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bill_Of_Lading;
    /**
     * The Carrier_Tracking_Number
     * Meta information extracted from the WSDL
     * - documentation: Carrier Tracking Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier_Tracking_Number;
    /**
     * The Shipment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipment Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_Reference;
    /**
     * The Supplier_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Order Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Order_Reference;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Reference
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Auto_submit_Receipt_for_Approval
     * Meta information extracted from the WSDL
     * - documentation: Auto Submit Receipt for Approval
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Auto_submit_Receipt_for_Approval;
    /**
     * The Origin_Reference
     * Meta information extracted from the WSDL
     * - documentation: References how the how Advance Ship Notice document got created. Possible values for the reference id (Source_Name) are 'Web Service' , 'EDI', 'Manual' .
     * - minOccurs: 0
     * @var \StructType\Document_Creation_MethodObjectType
     */
    public $Origin_Reference;
    /**
     * The Shipment_Contact
     * Meta information extracted from the WSDL
     * - documentation: Shipment Contact
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_Contact;
    /**
     * The Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Ship-To Address for Advance Ship Notice.
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Address_Reference;
    /**
     * The License_Plate
     * Meta information extracted from the WSDL
     * - documentation: License Plate Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $License_Plate;
    /**
     * The Bill_of_Lading_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Bill of Lading Quantity recorded on Receipt. This field is outbound only; any data submitted will be ignored. | Bill of Lading Quanatity
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 20
     * @var float
     */
    public $Bill_of_Lading_Quantity;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Comment at ASN document level.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Requisition_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Indicates the Requisition Types for the backing Requisitions
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_TypeObjectType[]
     */
    public $Requisition_Type_Reference;
    /**
     * The Advanced_Ship_Notice_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that represents Advanced Ship Notice Line information. An Advanced Ship Notice may have multiple lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Advanced_Ship_Notice_Line_Data_OutboundType[]
     */
    public $Advanced_Ship_Notice_Line_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_with_Attachment_Category_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Advanced_Ship_Notice_Data_OutboundType
     * @uses Advanced_Ship_Notice_Data_OutboundType::setAdvanced_Ship_Notice_ID()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setDocument_Number()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setCompany_Reference()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setCurrency_Reference()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setDocument_Status_Reference()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setCancellation_Memo()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setCanceled_On_Date()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setShipment_Date()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setBill_Of_Lading()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setCarrier_Tracking_Number()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setShipment_Reference()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setSupplier_Order_Reference()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setPurchase_Order_Reference()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setAuto_submit_Receipt_for_Approval()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setOrigin_Reference()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setShipment_Contact()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setAddress_Reference()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setLicense_Plate()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setBill_of_Lading_Quantity()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setMemo()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setRequisition_Type_Reference()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setAdvanced_Ship_Notice_Line_Data()
     * @uses Advanced_Ship_Notice_Data_OutboundType::setAttachment_Data()
     * @param string $advanced_Ship_Notice_ID
     * @param string $document_Number
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @param string $cancellation_Memo
     * @param string $canceled_On_Date
     * @param string $shipment_Date
     * @param string $bill_Of_Lading
     * @param string $carrier_Tracking_Number
     * @param string $shipment_Reference
     * @param string $supplier_Order_Reference
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param bool $auto_submit_Receipt_for_Approval
     * @param \StructType\Document_Creation_MethodObjectType $origin_Reference
     * @param string $shipment_Contact
     * @param \StructType\Address_ReferenceObjectType $address_Reference
     * @param string $license_Plate
     * @param float $bill_of_Lading_Quantity
     * @param string $memo
     * @param \StructType\Requisition_TypeObjectType[] $requisition_Type_Reference
     * @param \StructType\Advanced_Ship_Notice_Line_Data_OutboundType[] $advanced_Ship_Notice_Line_Data
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     */
    public function __construct($advanced_Ship_Notice_ID = null, $document_Number = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Document_StatusObjectType $document_Status_Reference = null, $cancellation_Memo = null, $canceled_On_Date = null, $shipment_Date = null, $bill_Of_Lading = null, $carrier_Tracking_Number = null, $shipment_Reference = null, $supplier_Order_Reference = null, \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, $auto_submit_Receipt_for_Approval = null, \StructType\Document_Creation_MethodObjectType $origin_Reference = null, $shipment_Contact = null, \StructType\Address_ReferenceObjectType $address_Reference = null, $license_Plate = null, $bill_of_Lading_Quantity = null, $memo = null, array $requisition_Type_Reference = array(), array $advanced_Ship_Notice_Line_Data = array(), array $attachment_Data = array())
    {
        $this
            ->setAdvanced_Ship_Notice_ID($advanced_Ship_Notice_ID)
            ->setDocument_Number($document_Number)
            ->setCompany_Reference($company_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setDocument_Status_Reference($document_Status_Reference)
            ->setCancellation_Memo($cancellation_Memo)
            ->setCanceled_On_Date($canceled_On_Date)
            ->setShipment_Date($shipment_Date)
            ->setBill_Of_Lading($bill_Of_Lading)
            ->setCarrier_Tracking_Number($carrier_Tracking_Number)
            ->setShipment_Reference($shipment_Reference)
            ->setSupplier_Order_Reference($supplier_Order_Reference)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setAuto_submit_Receipt_for_Approval($auto_submit_Receipt_for_Approval)
            ->setOrigin_Reference($origin_Reference)
            ->setShipment_Contact($shipment_Contact)
            ->setAddress_Reference($address_Reference)
            ->setLicense_Plate($license_Plate)
            ->setBill_of_Lading_Quantity($bill_of_Lading_Quantity)
            ->setMemo($memo)
            ->setRequisition_Type_Reference($requisition_Type_Reference)
            ->setAdvanced_Ship_Notice_Line_Data($advanced_Ship_Notice_Line_Data)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Advanced_Ship_Notice_ID value
     * @return string|null
     */
    public function getAdvanced_Ship_Notice_ID()
    {
        return $this->Advanced_Ship_Notice_ID;
    }
    /**
     * Set Advanced_Ship_Notice_ID value
     * @param string $advanced_Ship_Notice_ID
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setAdvanced_Ship_Notice_ID($advanced_Ship_Notice_ID = null)
    {
        // validation for constraint: string
        if (!is_null($advanced_Ship_Notice_ID) && !is_string($advanced_Ship_Notice_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advanced_Ship_Notice_ID, true), gettype($advanced_Ship_Notice_ID)), __LINE__);
        }
        $this->Advanced_Ship_Notice_ID = $advanced_Ship_Notice_ID;
        return $this;
    }
    /**
     * Get Document_Number value
     * @return string|null
     */
    public function getDocument_Number()
    {
        return $this->Document_Number;
    }
    /**
     * Set Document_Number value
     * @param string $document_Number
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setDocument_Number($document_Number = null)
    {
        // validation for constraint: string
        if (!is_null($document_Number) && !is_string($document_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Number, true), gettype($document_Number)), __LINE__);
        }
        $this->Document_Number = $document_Number;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getDocument_Status_Reference()
    {
        return $this->Document_Status_Reference;
    }
    /**
     * Set Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $document_Status_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setDocument_Status_Reference(\StructType\Document_StatusObjectType $document_Status_Reference = null)
    {
        $this->Document_Status_Reference = $document_Status_Reference;
        return $this;
    }
    /**
     * Get Cancellation_Memo value
     * @return string|null
     */
    public function getCancellation_Memo()
    {
        return $this->Cancellation_Memo;
    }
    /**
     * Set Cancellation_Memo value
     * @param string $cancellation_Memo
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setCancellation_Memo($cancellation_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($cancellation_Memo) && !is_string($cancellation_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellation_Memo, true), gettype($cancellation_Memo)), __LINE__);
        }
        $this->Cancellation_Memo = $cancellation_Memo;
        return $this;
    }
    /**
     * Get Canceled_On_Date value
     * @return string|null
     */
    public function getCanceled_On_Date()
    {
        return $this->Canceled_On_Date;
    }
    /**
     * Set Canceled_On_Date value
     * @param string $canceled_On_Date
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setCanceled_On_Date($canceled_On_Date = null)
    {
        // validation for constraint: string
        if (!is_null($canceled_On_Date) && !is_string($canceled_On_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($canceled_On_Date, true), gettype($canceled_On_Date)), __LINE__);
        }
        $this->Canceled_On_Date = $canceled_On_Date;
        return $this;
    }
    /**
     * Get Shipment_Date value
     * @return string|null
     */
    public function getShipment_Date()
    {
        return $this->Shipment_Date;
    }
    /**
     * Set Shipment_Date value
     * @param string $shipment_Date
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setShipment_Date($shipment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_Date) && !is_string($shipment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_Date, true), gettype($shipment_Date)), __LINE__);
        }
        $this->Shipment_Date = $shipment_Date;
        return $this;
    }
    /**
     * Get Bill_Of_Lading value
     * @return string|null
     */
    public function getBill_Of_Lading()
    {
        return $this->Bill_Of_Lading;
    }
    /**
     * Set Bill_Of_Lading value
     * @param string $bill_Of_Lading
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setBill_Of_Lading($bill_Of_Lading = null)
    {
        // validation for constraint: string
        if (!is_null($bill_Of_Lading) && !is_string($bill_Of_Lading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bill_Of_Lading, true), gettype($bill_Of_Lading)), __LINE__);
        }
        $this->Bill_Of_Lading = $bill_Of_Lading;
        return $this;
    }
    /**
     * Get Carrier_Tracking_Number value
     * @return string|null
     */
    public function getCarrier_Tracking_Number()
    {
        return $this->Carrier_Tracking_Number;
    }
    /**
     * Set Carrier_Tracking_Number value
     * @param string $carrier_Tracking_Number
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setCarrier_Tracking_Number($carrier_Tracking_Number = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_Tracking_Number) && !is_string($carrier_Tracking_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_Tracking_Number, true), gettype($carrier_Tracking_Number)), __LINE__);
        }
        $this->Carrier_Tracking_Number = $carrier_Tracking_Number;
        return $this;
    }
    /**
     * Get Shipment_Reference value
     * @return string|null
     */
    public function getShipment_Reference()
    {
        return $this->Shipment_Reference;
    }
    /**
     * Set Shipment_Reference value
     * @param string $shipment_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setShipment_Reference($shipment_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_Reference) && !is_string($shipment_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_Reference, true), gettype($shipment_Reference)), __LINE__);
        }
        $this->Shipment_Reference = $shipment_Reference;
        return $this;
    }
    /**
     * Get Supplier_Order_Reference value
     * @return string|null
     */
    public function getSupplier_Order_Reference()
    {
        return $this->Supplier_Order_Reference;
    }
    /**
     * Set Supplier_Order_Reference value
     * @param string $supplier_Order_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setSupplier_Order_Reference($supplier_Order_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Order_Reference) && !is_string($supplier_Order_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Order_Reference, true), gettype($supplier_Order_Reference)), __LINE__);
        }
        $this->Supplier_Order_Reference = $supplier_Order_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Auto_submit_Receipt_for_Approval value
     * @return bool|null
     */
    public function getAuto_submit_Receipt_for_Approval()
    {
        return $this->{'Auto-submit_Receipt_for_Approval'};
    }
    /**
     * Set Auto_submit_Receipt_for_Approval value
     * @param bool $auto_submit_Receipt_for_Approval
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setAuto_submit_Receipt_for_Approval($auto_submit_Receipt_for_Approval = null)
    {
        // validation for constraint: boolean
        if (!is_null($auto_submit_Receipt_for_Approval) && !is_bool($auto_submit_Receipt_for_Approval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($auto_submit_Receipt_for_Approval, true), gettype($auto_submit_Receipt_for_Approval)), __LINE__);
        }
        $this->Auto_submit_Receipt_for_Approval = $this->{'Auto-submit_Receipt_for_Approval'} = $auto_submit_Receipt_for_Approval;
        return $this;
    }
    /**
     * Get Origin_Reference value
     * @return \StructType\Document_Creation_MethodObjectType|null
     */
    public function getOrigin_Reference()
    {
        return $this->Origin_Reference;
    }
    /**
     * Set Origin_Reference value
     * @param \StructType\Document_Creation_MethodObjectType $origin_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setOrigin_Reference(\StructType\Document_Creation_MethodObjectType $origin_Reference = null)
    {
        $this->Origin_Reference = $origin_Reference;
        return $this;
    }
    /**
     * Get Shipment_Contact value
     * @return string|null
     */
    public function getShipment_Contact()
    {
        return $this->Shipment_Contact;
    }
    /**
     * Set Shipment_Contact value
     * @param string $shipment_Contact
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setShipment_Contact($shipment_Contact = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_Contact) && !is_string($shipment_Contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_Contact, true), gettype($shipment_Contact)), __LINE__);
        }
        $this->Shipment_Contact = $shipment_Contact;
        return $this;
    }
    /**
     * Get Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getAddress_Reference()
    {
        return $this->Address_Reference;
    }
    /**
     * Set Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $address_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setAddress_Reference(\StructType\Address_ReferenceObjectType $address_Reference = null)
    {
        $this->Address_Reference = $address_Reference;
        return $this;
    }
    /**
     * Get License_Plate value
     * @return string|null
     */
    public function getLicense_Plate()
    {
        return $this->License_Plate;
    }
    /**
     * Set License_Plate value
     * @param string $license_Plate
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setLicense_Plate($license_Plate = null)
    {
        // validation for constraint: string
        if (!is_null($license_Plate) && !is_string($license_Plate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($license_Plate, true), gettype($license_Plate)), __LINE__);
        }
        $this->License_Plate = $license_Plate;
        return $this;
    }
    /**
     * Get Bill_of_Lading_Quantity value
     * @return float|null
     */
    public function getBill_of_Lading_Quantity()
    {
        return $this->Bill_of_Lading_Quantity;
    }
    /**
     * Set Bill_of_Lading_Quantity value
     * @param float $bill_of_Lading_Quantity
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setBill_of_Lading_Quantity($bill_of_Lading_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($bill_of_Lading_Quantity) && !(is_float($bill_of_Lading_Quantity) || is_numeric($bill_of_Lading_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bill_of_Lading_Quantity, true), gettype($bill_of_Lading_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($bill_of_Lading_Quantity) && mb_strlen(mb_substr($bill_of_Lading_Quantity, false !== mb_strpos($bill_of_Lading_Quantity, '.') ? mb_strpos($bill_of_Lading_Quantity, '.') + 1 : mb_strlen($bill_of_Lading_Quantity))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($bill_of_Lading_Quantity, true), mb_strlen(mb_substr($bill_of_Lading_Quantity, mb_strpos($bill_of_Lading_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bill_of_Lading_Quantity) && $bill_of_Lading_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bill_of_Lading_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(20)
        if (!is_null($bill_of_Lading_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $bill_of_Lading_Quantity)) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 20 digits, "%d" given', var_export($bill_of_Lading_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $bill_of_Lading_Quantity))), __LINE__);
        }
        $this->Bill_of_Lading_Quantity = $bill_of_Lading_Quantity;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Requisition_Type_Reference value
     * @return \StructType\Requisition_TypeObjectType[]|null
     */
    public function getRequisition_Type_Reference()
    {
        return $this->Requisition_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Type_ReferenceForArrayConstraintsFromSetRequisition_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Data_OutboundTypeRequisition_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Data_OutboundTypeRequisition_Type_ReferenceItem instanceof \StructType\Requisition_TypeObjectType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Data_OutboundTypeRequisition_Type_ReferenceItem) ? get_class($advanced_Ship_Notice_Data_OutboundTypeRequisition_Type_ReferenceItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Data_OutboundTypeRequisition_Type_ReferenceItem), var_export($advanced_Ship_Notice_Data_OutboundTypeRequisition_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Type_Reference property can only contain items of type \StructType\Requisition_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TypeObjectType[] $requisition_Type_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setRequisition_Type_Reference(array $requisition_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Type_ReferenceArrayErrorMessage = self::validateRequisition_Type_ReferenceForArrayConstraintsFromSetRequisition_Type_Reference($requisition_Type_Reference))) {
            throw new \InvalidArgumentException($requisition_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Type_Reference = $requisition_Type_Reference;
        return $this;
    }
    /**
     * Add item to Requisition_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TypeObjectType $item
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function addToRequisition_Type_Reference(\StructType\Requisition_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Type_Reference property can only contain items of type \StructType\Requisition_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Advanced_Ship_Notice_Line_Data value
     * @return \StructType\Advanced_Ship_Notice_Line_Data_OutboundType[]|null
     */
    public function getAdvanced_Ship_Notice_Line_Data()
    {
        return $this->Advanced_Ship_Notice_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAdvanced_Ship_Notice_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdvanced_Ship_Notice_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdvanced_Ship_Notice_Line_DataForArrayConstraintsFromSetAdvanced_Ship_Notice_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Data_OutboundTypeAdvanced_Ship_Notice_Line_DataItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Data_OutboundTypeAdvanced_Ship_Notice_Line_DataItem instanceof \StructType\Advanced_Ship_Notice_Line_Data_OutboundType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Data_OutboundTypeAdvanced_Ship_Notice_Line_DataItem) ? get_class($advanced_Ship_Notice_Data_OutboundTypeAdvanced_Ship_Notice_Line_DataItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Data_OutboundTypeAdvanced_Ship_Notice_Line_DataItem), var_export($advanced_Ship_Notice_Data_OutboundTypeAdvanced_Ship_Notice_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Advanced_Ship_Notice_Line_Data property can only contain items of type \StructType\Advanced_Ship_Notice_Line_Data_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Advanced_Ship_Notice_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Advanced_Ship_Notice_Line_Data_OutboundType[] $advanced_Ship_Notice_Line_Data
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setAdvanced_Ship_Notice_Line_Data(array $advanced_Ship_Notice_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($advanced_Ship_Notice_Line_DataArrayErrorMessage = self::validateAdvanced_Ship_Notice_Line_DataForArrayConstraintsFromSetAdvanced_Ship_Notice_Line_Data($advanced_Ship_Notice_Line_Data))) {
            throw new \InvalidArgumentException($advanced_Ship_Notice_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Advanced_Ship_Notice_Line_Data = $advanced_Ship_Notice_Line_Data;
        return $this;
    }
    /**
     * Add item to Advanced_Ship_Notice_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Advanced_Ship_Notice_Line_Data_OutboundType $item
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function addToAdvanced_Ship_Notice_Line_Data(\StructType\Advanced_Ship_Notice_Line_Data_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Advanced_Ship_Notice_Line_Data_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Advanced_Ship_Notice_Line_Data property can only contain items of type \StructType\Advanced_Ship_Notice_Line_Data_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Advanced_Ship_Notice_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Data_OutboundTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Data_OutboundTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Data_OutboundTypeAttachment_DataItem) ? get_class($advanced_Ship_Notice_Data_OutboundTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Data_OutboundTypeAttachment_DataItem), var_export($advanced_Ship_Notice_Data_OutboundTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType $item
     * @return \StructType\Advanced_Ship_Notice_Data_OutboundType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_with_Attachment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
