<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Advanced_Ship_Notice_Data_InboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Advanced Ship Notice Data.
 * @subpackage Structs
 */
class Advanced_Ship_Notice_Data_InboundType extends AbstractStructBase
{
    /**
     * The Advanced_Ship_Notice_ID
     * Meta information extracted from the WSDL
     * - documentation: Advanced Ship Notice Reference ID. This is optional and will be auto-generated if left blank on the Web Service request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Advanced_Ship_Notice_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag to indicate whether the Advanced Ship Notice should be submitted to the business process.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Auto_Submit_Receipt_for_Approval
     * Meta information extracted from the WSDL
     * - documentation: Auto Submit Receipt for Approval
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Auto_Submit_Receipt_for_Approval;
    /**
     * The Bill_Of_Lading
     * Meta information extracted from the WSDL
     * - documentation: Bill Of Lading
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Bill_Of_Lading;
    /**
     * The Carrier_Tracking_Number
     * Meta information extracted from the WSDL
     * - documentation: Carrier Tracking Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier_Tracking_Number;
    /**
     * The Origin_Reference
     * Meta information extracted from the WSDL
     * - documentation: References how the how Advance Ship Notice document got created. Possible values for the reference id (Source_Name) are 'Web Service' , 'EDI', 'Manual' .
     * - minOccurs: 0
     * @var \StructType\Document_Creation_MethodObjectType
     */
    public $Origin_Reference;
    /**
     * The Shipment_Contact
     * Meta information extracted from the WSDL
     * - documentation: Shipment Contact
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_Contact;
    /**
     * The Shipment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipment Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_Reference;
    /**
     * The Supplier_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Order Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Order_Reference;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Purchase Order for which the Advanced Ship Notice is created.
     * @var \StructType\Purchase_OrderObjectType
     */
    public $Purchase_Order_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Comment at ASN document level.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The License_Plate
     * Meta information extracted from the WSDL
     * - documentation: License Plate Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $License_Plate;
    /**
     * The Bill_of_Lading_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Bill of Lading Quantity recorded on Receipt. This field is outbound only; any data submitted will be ignored. | Bill of Lading Quanatity
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 20
     * @var float
     */
    public $Bill_of_Lading_Quantity;
    /**
     * The Shipment_Date
     * Meta information extracted from the WSDL
     * - documentation: Shipment Date
     * - maxOccurs: 1
     * @var string
     */
    public $Shipment_Date;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Ship-To Address for Advance Ship Notice. If value is not provided defaults to Ship-To Address of Purchase Order.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Address_Global_Location_Number
     * Meta information extracted from the WSDL
     * - documentation: User can provide Global Location Number here; the Location assigned to it will be used to populate the Ship-to Address
     * - choice: Ship-To_Address_Global_Location_Number | Ship-To_Address_Customer_Account_Number
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ship_To_Address_Global_Location_Number;
    /**
     * The Ship_To_Address_Customer_Account_Number
     * Meta information extracted from the WSDL
     * - documentation: User can provide EDI Customer Account Number here; the Location assigned to it will be used to populate the Ship-to Address
     * - base: xsd:string
     * - choice: Ship-To_Address_Global_Location_Number | Ship-To_Address_Customer_Account_Number
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ship_To_Address_Customer_Account_Number;
    /**
     * The Advanced_Ship_Notice_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that captures Advanced Ship Notice Line information. An Advanced Ship Notice can have one or more Advanced Ship Notice Lines
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Advanced_Ship_Notice_Line_Data_InboundType[]
     */
    public $Advanced_Ship_Notice_Line_Data;
    /**
     * The Business_Document_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_with_Attachment_Category_DataType[]
     */
    public $Business_Document_Attachment_Data;
    /**
     * Constructor method for Advanced_Ship_Notice_Data_InboundType
     * @uses Advanced_Ship_Notice_Data_InboundType::setAdvanced_Ship_Notice_ID()
     * @uses Advanced_Ship_Notice_Data_InboundType::setSubmit()
     * @uses Advanced_Ship_Notice_Data_InboundType::setAuto_Submit_Receipt_for_Approval()
     * @uses Advanced_Ship_Notice_Data_InboundType::setBill_Of_Lading()
     * @uses Advanced_Ship_Notice_Data_InboundType::setCarrier_Tracking_Number()
     * @uses Advanced_Ship_Notice_Data_InboundType::setOrigin_Reference()
     * @uses Advanced_Ship_Notice_Data_InboundType::setShipment_Contact()
     * @uses Advanced_Ship_Notice_Data_InboundType::setShipment_Reference()
     * @uses Advanced_Ship_Notice_Data_InboundType::setSupplier_Order_Reference()
     * @uses Advanced_Ship_Notice_Data_InboundType::setPurchase_Order_Reference()
     * @uses Advanced_Ship_Notice_Data_InboundType::setMemo()
     * @uses Advanced_Ship_Notice_Data_InboundType::setLicense_Plate()
     * @uses Advanced_Ship_Notice_Data_InboundType::setBill_of_Lading_Quantity()
     * @uses Advanced_Ship_Notice_Data_InboundType::setShipment_Date()
     * @uses Advanced_Ship_Notice_Data_InboundType::setShip_To_Address_Reference()
     * @uses Advanced_Ship_Notice_Data_InboundType::setShip_To_Address_Global_Location_Number()
     * @uses Advanced_Ship_Notice_Data_InboundType::setShip_To_Address_Customer_Account_Number()
     * @uses Advanced_Ship_Notice_Data_InboundType::setAdvanced_Ship_Notice_Line_Data()
     * @uses Advanced_Ship_Notice_Data_InboundType::setBusiness_Document_Attachment_Data()
     * @param string $advanced_Ship_Notice_ID
     * @param bool $submit
     * @param bool $auto_Submit_Receipt_for_Approval
     * @param string $bill_Of_Lading
     * @param string $carrier_Tracking_Number
     * @param \StructType\Document_Creation_MethodObjectType $origin_Reference
     * @param string $shipment_Contact
     * @param string $shipment_Reference
     * @param string $supplier_Order_Reference
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @param string $memo
     * @param string $license_Plate
     * @param float $bill_of_Lading_Quantity
     * @param string $shipment_Date
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @param string $ship_To_Address_Global_Location_Number
     * @param string $ship_To_Address_Customer_Account_Number
     * @param \StructType\Advanced_Ship_Notice_Line_Data_InboundType[] $advanced_Ship_Notice_Line_Data
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $business_Document_Attachment_Data
     */
    public function __construct($advanced_Ship_Notice_ID = null, $submit = null, $auto_Submit_Receipt_for_Approval = null, $bill_Of_Lading = null, $carrier_Tracking_Number = null, \StructType\Document_Creation_MethodObjectType $origin_Reference = null, $shipment_Contact = null, $shipment_Reference = null, $supplier_Order_Reference = null, \StructType\Purchase_OrderObjectType $purchase_Order_Reference = null, $memo = null, $license_Plate = null, $bill_of_Lading_Quantity = null, $shipment_Date = null, \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null, $ship_To_Address_Global_Location_Number = null, $ship_To_Address_Customer_Account_Number = null, array $advanced_Ship_Notice_Line_Data = array(), array $business_Document_Attachment_Data = array())
    {
        $this
            ->setAdvanced_Ship_Notice_ID($advanced_Ship_Notice_ID)
            ->setSubmit($submit)
            ->setAuto_Submit_Receipt_for_Approval($auto_Submit_Receipt_for_Approval)
            ->setBill_Of_Lading($bill_Of_Lading)
            ->setCarrier_Tracking_Number($carrier_Tracking_Number)
            ->setOrigin_Reference($origin_Reference)
            ->setShipment_Contact($shipment_Contact)
            ->setShipment_Reference($shipment_Reference)
            ->setSupplier_Order_Reference($supplier_Order_Reference)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setMemo($memo)
            ->setLicense_Plate($license_Plate)
            ->setBill_of_Lading_Quantity($bill_of_Lading_Quantity)
            ->setShipment_Date($shipment_Date)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Address_Global_Location_Number($ship_To_Address_Global_Location_Number)
            ->setShip_To_Address_Customer_Account_Number($ship_To_Address_Customer_Account_Number)
            ->setAdvanced_Ship_Notice_Line_Data($advanced_Ship_Notice_Line_Data)
            ->setBusiness_Document_Attachment_Data($business_Document_Attachment_Data);
    }
    /**
     * Get Advanced_Ship_Notice_ID value
     * @return string|null
     */
    public function getAdvanced_Ship_Notice_ID()
    {
        return $this->Advanced_Ship_Notice_ID;
    }
    /**
     * Set Advanced_Ship_Notice_ID value
     * @param string $advanced_Ship_Notice_ID
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setAdvanced_Ship_Notice_ID($advanced_Ship_Notice_ID = null)
    {
        // validation for constraint: string
        if (!is_null($advanced_Ship_Notice_ID) && !is_string($advanced_Ship_Notice_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advanced_Ship_Notice_ID, true), gettype($advanced_Ship_Notice_ID)), __LINE__);
        }
        $this->Advanced_Ship_Notice_ID = $advanced_Ship_Notice_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Auto_Submit_Receipt_for_Approval value
     * @return bool|null
     */
    public function getAuto_Submit_Receipt_for_Approval()
    {
        return $this->Auto_Submit_Receipt_for_Approval;
    }
    /**
     * Set Auto_Submit_Receipt_for_Approval value
     * @param bool $auto_Submit_Receipt_for_Approval
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setAuto_Submit_Receipt_for_Approval($auto_Submit_Receipt_for_Approval = null)
    {
        // validation for constraint: boolean
        if (!is_null($auto_Submit_Receipt_for_Approval) && !is_bool($auto_Submit_Receipt_for_Approval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($auto_Submit_Receipt_for_Approval, true), gettype($auto_Submit_Receipt_for_Approval)), __LINE__);
        }
        $this->Auto_Submit_Receipt_for_Approval = $auto_Submit_Receipt_for_Approval;
        return $this;
    }
    /**
     * Get Bill_Of_Lading value
     * @return string|null
     */
    public function getBill_Of_Lading()
    {
        return $this->Bill_Of_Lading;
    }
    /**
     * Set Bill_Of_Lading value
     * @param string $bill_Of_Lading
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setBill_Of_Lading($bill_Of_Lading = null)
    {
        // validation for constraint: string
        if (!is_null($bill_Of_Lading) && !is_string($bill_Of_Lading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bill_Of_Lading, true), gettype($bill_Of_Lading)), __LINE__);
        }
        $this->Bill_Of_Lading = $bill_Of_Lading;
        return $this;
    }
    /**
     * Get Carrier_Tracking_Number value
     * @return string|null
     */
    public function getCarrier_Tracking_Number()
    {
        return $this->Carrier_Tracking_Number;
    }
    /**
     * Set Carrier_Tracking_Number value
     * @param string $carrier_Tracking_Number
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setCarrier_Tracking_Number($carrier_Tracking_Number = null)
    {
        // validation for constraint: string
        if (!is_null($carrier_Tracking_Number) && !is_string($carrier_Tracking_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carrier_Tracking_Number, true), gettype($carrier_Tracking_Number)), __LINE__);
        }
        $this->Carrier_Tracking_Number = $carrier_Tracking_Number;
        return $this;
    }
    /**
     * Get Origin_Reference value
     * @return \StructType\Document_Creation_MethodObjectType|null
     */
    public function getOrigin_Reference()
    {
        return $this->Origin_Reference;
    }
    /**
     * Set Origin_Reference value
     * @param \StructType\Document_Creation_MethodObjectType $origin_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setOrigin_Reference(\StructType\Document_Creation_MethodObjectType $origin_Reference = null)
    {
        $this->Origin_Reference = $origin_Reference;
        return $this;
    }
    /**
     * Get Shipment_Contact value
     * @return string|null
     */
    public function getShipment_Contact()
    {
        return $this->Shipment_Contact;
    }
    /**
     * Set Shipment_Contact value
     * @param string $shipment_Contact
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setShipment_Contact($shipment_Contact = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_Contact) && !is_string($shipment_Contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_Contact, true), gettype($shipment_Contact)), __LINE__);
        }
        $this->Shipment_Contact = $shipment_Contact;
        return $this;
    }
    /**
     * Get Shipment_Reference value
     * @return string|null
     */
    public function getShipment_Reference()
    {
        return $this->Shipment_Reference;
    }
    /**
     * Set Shipment_Reference value
     * @param string $shipment_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setShipment_Reference($shipment_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_Reference) && !is_string($shipment_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_Reference, true), gettype($shipment_Reference)), __LINE__);
        }
        $this->Shipment_Reference = $shipment_Reference;
        return $this;
    }
    /**
     * Get Supplier_Order_Reference value
     * @return string|null
     */
    public function getSupplier_Order_Reference()
    {
        return $this->Supplier_Order_Reference;
    }
    /**
     * Set Supplier_Order_Reference value
     * @param string $supplier_Order_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setSupplier_Order_Reference($supplier_Order_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Order_Reference) && !is_string($supplier_Order_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Order_Reference, true), gettype($supplier_Order_Reference)), __LINE__);
        }
        $this->Supplier_Order_Reference = $supplier_Order_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * Set Purchase_Order_Reference value
     * @param \StructType\Purchase_OrderObjectType $purchase_Order_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $purchase_Order_Reference = null)
    {
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get License_Plate value
     * @return string|null
     */
    public function getLicense_Plate()
    {
        return $this->License_Plate;
    }
    /**
     * Set License_Plate value
     * @param string $license_Plate
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setLicense_Plate($license_Plate = null)
    {
        // validation for constraint: string
        if (!is_null($license_Plate) && !is_string($license_Plate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($license_Plate, true), gettype($license_Plate)), __LINE__);
        }
        $this->License_Plate = $license_Plate;
        return $this;
    }
    /**
     * Get Bill_of_Lading_Quantity value
     * @return float|null
     */
    public function getBill_of_Lading_Quantity()
    {
        return $this->Bill_of_Lading_Quantity;
    }
    /**
     * Set Bill_of_Lading_Quantity value
     * @param float $bill_of_Lading_Quantity
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setBill_of_Lading_Quantity($bill_of_Lading_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($bill_of_Lading_Quantity) && !(is_float($bill_of_Lading_Quantity) || is_numeric($bill_of_Lading_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bill_of_Lading_Quantity, true), gettype($bill_of_Lading_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($bill_of_Lading_Quantity) && mb_strlen(mb_substr($bill_of_Lading_Quantity, false !== mb_strpos($bill_of_Lading_Quantity, '.') ? mb_strpos($bill_of_Lading_Quantity, '.') + 1 : mb_strlen($bill_of_Lading_Quantity))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($bill_of_Lading_Quantity, true), mb_strlen(mb_substr($bill_of_Lading_Quantity, mb_strpos($bill_of_Lading_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bill_of_Lading_Quantity) && $bill_of_Lading_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bill_of_Lading_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(20)
        if (!is_null($bill_of_Lading_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $bill_of_Lading_Quantity)) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 20 digits, "%d" given', var_export($bill_of_Lading_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $bill_of_Lading_Quantity))), __LINE__);
        }
        $this->Bill_of_Lading_Quantity = $bill_of_Lading_Quantity;
        return $this;
    }
    /**
     * Get Shipment_Date value
     * @return string|null
     */
    public function getShipment_Date()
    {
        return $this->Shipment_Date;
    }
    /**
     * Set Shipment_Date value
     * @param string $shipment_Date
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setShipment_Date($shipment_Date = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_Date) && !is_string($shipment_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_Date, true), gettype($shipment_Date)), __LINE__);
        }
        $this->Shipment_Date = $shipment_Date;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Address_Global_Location_Number value
     * @return string|null
     */
    public function getShip_To_Address_Global_Location_Number()
    {
        return isset($this->{'Ship-To_Address_Global_Location_Number'}) ? $this->{'Ship-To_Address_Global_Location_Number'} : null;
    }
    /**
     * This method is responsible for validating the value passed to the setShip_To_Address_Global_Location_Number method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShip_To_Address_Global_Location_Number method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateShip_To_Address_Global_Location_NumberForChoiceConstraintsFromSetShip_To_Address_Global_Location_Number($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Ship_To_Address_Customer_Account_Number',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Ship-To_Address_Global_Location_Number can\'t be set as the property %s is already set. Only one property must be set among these properties: Ship-To_Address_Global_Location_Number, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Ship_To_Address_Global_Location_Number value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $ship_To_Address_Global_Location_Number
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setShip_To_Address_Global_Location_Number($ship_To_Address_Global_Location_Number = null)
    {
        // validation for constraint: string
        if (!is_null($ship_To_Address_Global_Location_Number) && !is_string($ship_To_Address_Global_Location_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ship_To_Address_Global_Location_Number, true), gettype($ship_To_Address_Global_Location_Number)), __LINE__);
        }
        // validation for constraint: choice(Ship-To_Address_Global_Location_Number, Ship-To_Address_Customer_Account_Number)
        if ('' !== ($ship_To_Address_Global_Location_NumberChoiceErrorMessage = self::validateShip_To_Address_Global_Location_NumberForChoiceConstraintsFromSetShip_To_Address_Global_Location_Number($ship_To_Address_Global_Location_Number))) {
            throw new \InvalidArgumentException($ship_To_Address_Global_Location_NumberChoiceErrorMessage, __LINE__);
        }
        if (is_null($ship_To_Address_Global_Location_Number) || (is_array($ship_To_Address_Global_Location_Number) && empty($ship_To_Address_Global_Location_Number))) {
            unset($this->Ship_To_Address_Global_Location_Number, $this->{'Ship-To_Address_Global_Location_Number'});
        } else {
            $this->Ship_To_Address_Global_Location_Number = $this->{'Ship-To_Address_Global_Location_Number'} = $ship_To_Address_Global_Location_Number;
        }
        return $this;
    }
    /**
     * Get Ship_To_Address_Customer_Account_Number value
     * @return string|null
     */
    public function getShip_To_Address_Customer_Account_Number()
    {
        return isset($this->{'Ship-To_Address_Customer_Account_Number'}) ? $this->{'Ship-To_Address_Customer_Account_Number'} : null;
    }
    /**
     * This method is responsible for validating the value passed to the setShip_To_Address_Customer_Account_Number method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShip_To_Address_Customer_Account_Number method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateShip_To_Address_Customer_Account_NumberForChoiceConstraintsFromSetShip_To_Address_Customer_Account_Number($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Ship_To_Address_Global_Location_Number',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Ship-To_Address_Customer_Account_Number can\'t be set as the property %s is already set. Only one property must be set among these properties: Ship-To_Address_Customer_Account_Number, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Ship_To_Address_Customer_Account_Number value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $ship_To_Address_Customer_Account_Number
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setShip_To_Address_Customer_Account_Number($ship_To_Address_Customer_Account_Number = null)
    {
        // validation for constraint: string
        if (!is_null($ship_To_Address_Customer_Account_Number) && !is_string($ship_To_Address_Customer_Account_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ship_To_Address_Customer_Account_Number, true), gettype($ship_To_Address_Customer_Account_Number)), __LINE__);
        }
        // validation for constraint: choice(Ship-To_Address_Global_Location_Number, Ship-To_Address_Customer_Account_Number)
        if ('' !== ($ship_To_Address_Customer_Account_NumberChoiceErrorMessage = self::validateShip_To_Address_Customer_Account_NumberForChoiceConstraintsFromSetShip_To_Address_Customer_Account_Number($ship_To_Address_Customer_Account_Number))) {
            throw new \InvalidArgumentException($ship_To_Address_Customer_Account_NumberChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($ship_To_Address_Customer_Account_Number) && mb_strlen($ship_To_Address_Customer_Account_Number) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($ship_To_Address_Customer_Account_Number)), __LINE__);
        }
        if (is_null($ship_To_Address_Customer_Account_Number) || (is_array($ship_To_Address_Customer_Account_Number) && empty($ship_To_Address_Customer_Account_Number))) {
            unset($this->Ship_To_Address_Customer_Account_Number, $this->{'Ship-To_Address_Customer_Account_Number'});
        } else {
            $this->Ship_To_Address_Customer_Account_Number = $this->{'Ship-To_Address_Customer_Account_Number'} = $ship_To_Address_Customer_Account_Number;
        }
        return $this;
    }
    /**
     * Get Advanced_Ship_Notice_Line_Data value
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType[]|null
     */
    public function getAdvanced_Ship_Notice_Line_Data()
    {
        return $this->Advanced_Ship_Notice_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAdvanced_Ship_Notice_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdvanced_Ship_Notice_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdvanced_Ship_Notice_Line_DataForArrayConstraintsFromSetAdvanced_Ship_Notice_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Data_InboundTypeAdvanced_Ship_Notice_Line_DataItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Data_InboundTypeAdvanced_Ship_Notice_Line_DataItem instanceof \StructType\Advanced_Ship_Notice_Line_Data_InboundType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Data_InboundTypeAdvanced_Ship_Notice_Line_DataItem) ? get_class($advanced_Ship_Notice_Data_InboundTypeAdvanced_Ship_Notice_Line_DataItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Data_InboundTypeAdvanced_Ship_Notice_Line_DataItem), var_export($advanced_Ship_Notice_Data_InboundTypeAdvanced_Ship_Notice_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Advanced_Ship_Notice_Line_Data property can only contain items of type \StructType\Advanced_Ship_Notice_Line_Data_InboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Advanced_Ship_Notice_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Advanced_Ship_Notice_Line_Data_InboundType[] $advanced_Ship_Notice_Line_Data
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setAdvanced_Ship_Notice_Line_Data(array $advanced_Ship_Notice_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($advanced_Ship_Notice_Line_DataArrayErrorMessage = self::validateAdvanced_Ship_Notice_Line_DataForArrayConstraintsFromSetAdvanced_Ship_Notice_Line_Data($advanced_Ship_Notice_Line_Data))) {
            throw new \InvalidArgumentException($advanced_Ship_Notice_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Advanced_Ship_Notice_Line_Data = $advanced_Ship_Notice_Line_Data;
        return $this;
    }
    /**
     * Add item to Advanced_Ship_Notice_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Advanced_Ship_Notice_Line_Data_InboundType $item
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function addToAdvanced_Ship_Notice_Line_Data(\StructType\Advanced_Ship_Notice_Line_Data_InboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Advanced_Ship_Notice_Line_Data_InboundType) {
            throw new \InvalidArgumentException(sprintf('The Advanced_Ship_Notice_Line_Data property can only contain items of type \StructType\Advanced_Ship_Notice_Line_Data_InboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Advanced_Ship_Notice_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Business_Document_Attachment_Data value
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType[]|null
     */
    public function getBusiness_Document_Attachment_Data()
    {
        return $this->Business_Document_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Document_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Document_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Document_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Data_InboundTypeBusiness_Document_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Data_InboundTypeBusiness_Document_Attachment_DataItem instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Data_InboundTypeBusiness_Document_Attachment_DataItem) ? get_class($advanced_Ship_Notice_Data_InboundTypeBusiness_Document_Attachment_DataItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Data_InboundTypeBusiness_Document_Attachment_DataItem), var_export($advanced_Ship_Notice_Data_InboundTypeBusiness_Document_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Document_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Document_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $business_Document_Attachment_Data
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function setBusiness_Document_Attachment_Data(array $business_Document_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Document_Attachment_DataArrayErrorMessage = self::validateBusiness_Document_Attachment_DataForArrayConstraintsFromSetBusiness_Document_Attachment_Data($business_Document_Attachment_Data))) {
            throw new \InvalidArgumentException($business_Document_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Document_Attachment_Data = $business_Document_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Business_Document_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType $item
     * @return \StructType\Advanced_Ship_Notice_Data_InboundType
     */
    public function addToBusiness_Document_Attachment_Data(\StructType\Financials_Attachment_with_Attachment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Document_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Document_Attachment_Data[] = $item;
        return $this;
    }
}
