<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_History_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing all the data fields for the Supplier Invoice History object.
 * @subpackage Structs
 */
class Supplier_Invoice_History_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_History_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice History ID. This is the Supplier Invoice History unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_History_ID;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the company that tranasction is for. This is the reference id value of the company.
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Supplier the Invoice History is for.
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Suppliers_Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: Text value for Supplier Reference Number.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Suppliers_Invoice_Number;
    /**
     * The Total_Invoice_Amount
     * Meta information extracted from the WSDL
     * - documentation: Currency amount for the Total Invoice Amount to use as search criteria to find Supplier Invoice Histories. | Currency amount for the Total Invoice Amount. This amount corresponds with the Currency in Supplier Invoice History Currency
     * Reference.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Invoice_Amount;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice History Currency Reference is required if Supplier Invoice History Total Invoice Amount is specified. | Reference to the Currency used in this Supplier Invoice History.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Date value for the Supplier Invoice History date. Format is MM/DD/YYYY.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Date;
    /**
     * The External_PO_Number
     * Meta information extracted from the WSDL
     * - documentation: Text value for an External Purchase Order Number recorded on the Supplier Invoice History.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_PO_Number;
    /**
     * The Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: Text value for the Document Number of the Supplier Invoice History.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Number;
    /**
     * The Source_Integration_System
     * Meta information extracted from the WSDL
     * - documentation: Text value of the Source Integration System of the Supplier Invoice History.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Source_Integration_System;
    /**
     * Constructor method for Supplier_Invoice_History_DataType
     * @uses Supplier_Invoice_History_DataType::setSupplier_Invoice_History_ID()
     * @uses Supplier_Invoice_History_DataType::setCompany_Reference()
     * @uses Supplier_Invoice_History_DataType::setSupplier_Reference()
     * @uses Supplier_Invoice_History_DataType::setSuppliers_Invoice_Number()
     * @uses Supplier_Invoice_History_DataType::setTotal_Invoice_Amount()
     * @uses Supplier_Invoice_History_DataType::setCurrency_Reference()
     * @uses Supplier_Invoice_History_DataType::setInvoice_Date()
     * @uses Supplier_Invoice_History_DataType::setExternal_PO_Number()
     * @uses Supplier_Invoice_History_DataType::setInvoice_Number()
     * @uses Supplier_Invoice_History_DataType::setSource_Integration_System()
     * @param string $supplier_Invoice_History_ID
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param string $suppliers_Invoice_Number
     * @param float $total_Invoice_Amount
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param string $invoice_Date
     * @param string $external_PO_Number
     * @param string $invoice_Number
     * @param string $source_Integration_System
     */
    public function __construct($supplier_Invoice_History_ID = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, $suppliers_Invoice_Number = null, $total_Invoice_Amount = null, \StructType\CurrencyObjectType $currency_Reference = null, $invoice_Date = null, $external_PO_Number = null, $invoice_Number = null, $source_Integration_System = null)
    {
        $this
            ->setSupplier_Invoice_History_ID($supplier_Invoice_History_ID)
            ->setCompany_Reference($company_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setSuppliers_Invoice_Number($suppliers_Invoice_Number)
            ->setTotal_Invoice_Amount($total_Invoice_Amount)
            ->setCurrency_Reference($currency_Reference)
            ->setInvoice_Date($invoice_Date)
            ->setExternal_PO_Number($external_PO_Number)
            ->setInvoice_Number($invoice_Number)
            ->setSource_Integration_System($source_Integration_System);
    }
    /**
     * Get Supplier_Invoice_History_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_History_ID()
    {
        return $this->Supplier_Invoice_History_ID;
    }
    /**
     * Set Supplier_Invoice_History_ID value
     * @param string $supplier_Invoice_History_ID
     * @return \StructType\Supplier_Invoice_History_DataType
     */
    public function setSupplier_Invoice_History_ID($supplier_Invoice_History_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_History_ID) && !is_string($supplier_Invoice_History_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_History_ID, true), gettype($supplier_Invoice_History_ID)), __LINE__);
        }
        $this->Supplier_Invoice_History_ID = $supplier_Invoice_History_ID;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Supplier_Invoice_History_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Supplier_Invoice_History_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Suppliers_Invoice_Number value
     * @return string|null
     */
    public function getSuppliers_Invoice_Number()
    {
        return $this->Suppliers_Invoice_Number;
    }
    /**
     * Set Suppliers_Invoice_Number value
     * @param string $suppliers_Invoice_Number
     * @return \StructType\Supplier_Invoice_History_DataType
     */
    public function setSuppliers_Invoice_Number($suppliers_Invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($suppliers_Invoice_Number) && !is_string($suppliers_Invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suppliers_Invoice_Number, true), gettype($suppliers_Invoice_Number)), __LINE__);
        }
        $this->Suppliers_Invoice_Number = $suppliers_Invoice_Number;
        return $this;
    }
    /**
     * Get Total_Invoice_Amount value
     * @return float|null
     */
    public function getTotal_Invoice_Amount()
    {
        return $this->Total_Invoice_Amount;
    }
    /**
     * Set Total_Invoice_Amount value
     * @param float $total_Invoice_Amount
     * @return \StructType\Supplier_Invoice_History_DataType
     */
    public function setTotal_Invoice_Amount($total_Invoice_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($total_Invoice_Amount) && !(is_float($total_Invoice_Amount) || is_numeric($total_Invoice_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Invoice_Amount, true), gettype($total_Invoice_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Invoice_Amount) && mb_strlen(mb_substr($total_Invoice_Amount, false !== mb_strpos($total_Invoice_Amount, '.') ? mb_strpos($total_Invoice_Amount, '.') + 1 : mb_strlen($total_Invoice_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Invoice_Amount, true), mb_strlen(mb_substr($total_Invoice_Amount, mb_strpos($total_Invoice_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Invoice_Amount) && mb_strlen(preg_replace('/(\D)/', '', $total_Invoice_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Invoice_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $total_Invoice_Amount))), __LINE__);
        }
        $this->Total_Invoice_Amount = $total_Invoice_Amount;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Invoice_History_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Invoice_Date value
     * @return string|null
     */
    public function getInvoice_Date()
    {
        return $this->Invoice_Date;
    }
    /**
     * Set Invoice_Date value
     * @param string $invoice_Date
     * @return \StructType\Supplier_Invoice_History_DataType
     */
    public function setInvoice_Date($invoice_Date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Date) && !is_string($invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Date, true), gettype($invoice_Date)), __LINE__);
        }
        $this->Invoice_Date = $invoice_Date;
        return $this;
    }
    /**
     * Get External_PO_Number value
     * @return string|null
     */
    public function getExternal_PO_Number()
    {
        return $this->External_PO_Number;
    }
    /**
     * Set External_PO_Number value
     * @param string $external_PO_Number
     * @return \StructType\Supplier_Invoice_History_DataType
     */
    public function setExternal_PO_Number($external_PO_Number = null)
    {
        // validation for constraint: string
        if (!is_null($external_PO_Number) && !is_string($external_PO_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_PO_Number, true), gettype($external_PO_Number)), __LINE__);
        }
        $this->External_PO_Number = $external_PO_Number;
        return $this;
    }
    /**
     * Get Invoice_Number value
     * @return string|null
     */
    public function getInvoice_Number()
    {
        return $this->Invoice_Number;
    }
    /**
     * Set Invoice_Number value
     * @param string $invoice_Number
     * @return \StructType\Supplier_Invoice_History_DataType
     */
    public function setInvoice_Number($invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Number) && !is_string($invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Number, true), gettype($invoice_Number)), __LINE__);
        }
        $this->Invoice_Number = $invoice_Number;
        return $this;
    }
    /**
     * Get Source_Integration_System value
     * @return string|null
     */
    public function getSource_Integration_System()
    {
        return $this->Source_Integration_System;
    }
    /**
     * Set Source_Integration_System value
     * @param string $source_Integration_System
     * @return \StructType\Supplier_Invoice_History_DataType
     */
    public function setSource_Integration_System($source_Integration_System = null)
    {
        // validation for constraint: string
        if (!is_null($source_Integration_System) && !is_string($source_Integration_System)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source_Integration_System, true), gettype($source_Integration_System)), __LINE__);
        }
        $this->Source_Integration_System = $source_Integration_System;
        return $this;
    }
}
