<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Amendment_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Contract Amendment response grouping options
 * @subpackage Structs
 */
class Supplier_Contract_Amendment_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Include Reference
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the attachment data within Supplier Contract Amendment is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Attachment_Data;
    /**
     * Constructor method for Supplier_Contract_Amendment_Response_GroupType
     * @uses Supplier_Contract_Amendment_Response_GroupType::setInclude_Reference()
     * @uses Supplier_Contract_Amendment_Response_GroupType::setInclude_Attachment_Data()
     * @param bool $include_Reference
     * @param bool $include_Attachment_Data
     */
    public function __construct($include_Reference = null, $include_Attachment_Data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Attachment_Data($include_Attachment_Data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Supplier_Contract_Amendment_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Attachment_Data value
     * @return bool|null
     */
    public function getInclude_Attachment_Data()
    {
        return $this->Include_Attachment_Data;
    }
    /**
     * Set Include_Attachment_Data value
     * @param bool $include_Attachment_Data
     * @return \StructType\Supplier_Contract_Amendment_Response_GroupType
     */
    public function setInclude_Attachment_Data($include_Attachment_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Attachment_Data) && !is_bool($include_Attachment_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Attachment_Data, true), gettype($include_Attachment_Data)), __LINE__);
        }
        $this->Include_Attachment_Data = $include_Attachment_Data;
        return $this;
    }
}
