<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Identifier_Type_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Item Identifier Type Data element used as response from Get Item Identifier Types and incoming element for Put tem Identifier Type.
 * @subpackage Structs
 */
class Item_Identifier_Type_DataType extends AbstractStructBase
{
    /**
     * The Item_Identifier_Type_ID
     * Meta information extracted from the WSDL
     * - documentation: Unique ID for the Item Identifier Type
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Identifier_Type_ID;
    /**
     * The Item_Identifier_Type_Name
     * Meta information extracted from the WSDL
     * - documentation: Item Identifier Type Name text Attribute
     * - maxOccurs: 1
     * @var string
     */
    public $Item_Identifier_Type_Name;
    /**
     * The Item_Identifier_Type_Length
     * Meta information extracted from the WSDL
     * - documentation: Item Identifier Type Length attribute
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Item_Identifier_Type_Length;
    /**
     * The Item_Identifier_Type_Description
     * Meta information extracted from the WSDL
     * - documentation: Item Identifier Type Description attribute
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Identifier_Type_Description;
    /**
     * The Universal_Item_Identifier_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The universal item identifier type mapping for the item identifier type.
     * - minOccurs: 0
     * @var \StructType\Universal_Item_Identifier_TypeObjectType
     */
    public $Universal_Item_Identifier_Type_Reference;
    /**
     * The For_Item_UOM
     * Meta information extracted from the WSDL
     * - documentation: Indicate whether the Item Identifier is UOM Specific. This is a derived value from its associated universal item identifier type, and the provided value will be ignored in put item identifier type operation.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $For_Item_UOM;
    /**
     * The Allow_Multiples
     * Meta information extracted from the WSDL
     * - documentation: Allow Multiples Boolean flag
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Allow_Multiples;
    /**
     * The Item_Identifier_is_Unique
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate Item Identifier Type is Unique.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Item_Identifier_is_Unique;
    /**
     * The Use_in_Supplier_Catalog_Mapping
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate Item Identifier Type is Supplier Catalog Item Mapping.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_in_Supplier_Catalog_Mapping;
    /**
     * The Item_Identifier_is_External
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate Item Identifier Type is External.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Item_Identifier_is_External;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate Item Identifier Type is inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Item_Identifier_Type_DataType
     * @uses Item_Identifier_Type_DataType::setItem_Identifier_Type_ID()
     * @uses Item_Identifier_Type_DataType::setItem_Identifier_Type_Name()
     * @uses Item_Identifier_Type_DataType::setItem_Identifier_Type_Length()
     * @uses Item_Identifier_Type_DataType::setItem_Identifier_Type_Description()
     * @uses Item_Identifier_Type_DataType::setUniversal_Item_Identifier_Type_Reference()
     * @uses Item_Identifier_Type_DataType::setFor_Item_UOM()
     * @uses Item_Identifier_Type_DataType::setAllow_Multiples()
     * @uses Item_Identifier_Type_DataType::setItem_Identifier_is_Unique()
     * @uses Item_Identifier_Type_DataType::setUse_in_Supplier_Catalog_Mapping()
     * @uses Item_Identifier_Type_DataType::setItem_Identifier_is_External()
     * @uses Item_Identifier_Type_DataType::setInactive()
     * @param string $item_Identifier_Type_ID
     * @param string $item_Identifier_Type_Name
     * @param float $item_Identifier_Type_Length
     * @param string $item_Identifier_Type_Description
     * @param \StructType\Universal_Item_Identifier_TypeObjectType $universal_Item_Identifier_Type_Reference
     * @param bool $for_Item_UOM
     * @param bool $allow_Multiples
     * @param bool $item_Identifier_is_Unique
     * @param bool $use_in_Supplier_Catalog_Mapping
     * @param bool $item_Identifier_is_External
     * @param bool $inactive
     */
    public function __construct($item_Identifier_Type_ID = null, $item_Identifier_Type_Name = null, $item_Identifier_Type_Length = null, $item_Identifier_Type_Description = null, \StructType\Universal_Item_Identifier_TypeObjectType $universal_Item_Identifier_Type_Reference = null, $for_Item_UOM = null, $allow_Multiples = null, $item_Identifier_is_Unique = null, $use_in_Supplier_Catalog_Mapping = null, $item_Identifier_is_External = null, $inactive = null)
    {
        $this
            ->setItem_Identifier_Type_ID($item_Identifier_Type_ID)
            ->setItem_Identifier_Type_Name($item_Identifier_Type_Name)
            ->setItem_Identifier_Type_Length($item_Identifier_Type_Length)
            ->setItem_Identifier_Type_Description($item_Identifier_Type_Description)
            ->setUniversal_Item_Identifier_Type_Reference($universal_Item_Identifier_Type_Reference)
            ->setFor_Item_UOM($for_Item_UOM)
            ->setAllow_Multiples($allow_Multiples)
            ->setItem_Identifier_is_Unique($item_Identifier_is_Unique)
            ->setUse_in_Supplier_Catalog_Mapping($use_in_Supplier_Catalog_Mapping)
            ->setItem_Identifier_is_External($item_Identifier_is_External)
            ->setInactive($inactive);
    }
    /**
     * Get Item_Identifier_Type_ID value
     * @return string|null
     */
    public function getItem_Identifier_Type_ID()
    {
        return $this->Item_Identifier_Type_ID;
    }
    /**
     * Set Item_Identifier_Type_ID value
     * @param string $item_Identifier_Type_ID
     * @return \StructType\Item_Identifier_Type_DataType
     */
    public function setItem_Identifier_Type_ID($item_Identifier_Type_ID = null)
    {
        // validation for constraint: string
        if (!is_null($item_Identifier_Type_ID) && !is_string($item_Identifier_Type_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Identifier_Type_ID, true), gettype($item_Identifier_Type_ID)), __LINE__);
        }
        $this->Item_Identifier_Type_ID = $item_Identifier_Type_ID;
        return $this;
    }
    /**
     * Get Item_Identifier_Type_Name value
     * @return string|null
     */
    public function getItem_Identifier_Type_Name()
    {
        return $this->Item_Identifier_Type_Name;
    }
    /**
     * Set Item_Identifier_Type_Name value
     * @param string $item_Identifier_Type_Name
     * @return \StructType\Item_Identifier_Type_DataType
     */
    public function setItem_Identifier_Type_Name($item_Identifier_Type_Name = null)
    {
        // validation for constraint: string
        if (!is_null($item_Identifier_Type_Name) && !is_string($item_Identifier_Type_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Identifier_Type_Name, true), gettype($item_Identifier_Type_Name)), __LINE__);
        }
        $this->Item_Identifier_Type_Name = $item_Identifier_Type_Name;
        return $this;
    }
    /**
     * Get Item_Identifier_Type_Length value
     * @return float|null
     */
    public function getItem_Identifier_Type_Length()
    {
        return $this->Item_Identifier_Type_Length;
    }
    /**
     * Set Item_Identifier_Type_Length value
     * @param float $item_Identifier_Type_Length
     * @return \StructType\Item_Identifier_Type_DataType
     */
    public function setItem_Identifier_Type_Length($item_Identifier_Type_Length = null)
    {
        // validation for constraint: float
        if (!is_null($item_Identifier_Type_Length) && !(is_float($item_Identifier_Type_Length) || is_numeric($item_Identifier_Type_Length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($item_Identifier_Type_Length, true), gettype($item_Identifier_Type_Length)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($item_Identifier_Type_Length) && mb_strlen(mb_substr($item_Identifier_Type_Length, false !== mb_strpos($item_Identifier_Type_Length, '.') ? mb_strpos($item_Identifier_Type_Length, '.') + 1 : mb_strlen($item_Identifier_Type_Length))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($item_Identifier_Type_Length, true), mb_strlen(mb_substr($item_Identifier_Type_Length, mb_strpos($item_Identifier_Type_Length, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($item_Identifier_Type_Length) && $item_Identifier_Type_Length < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($item_Identifier_Type_Length, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($item_Identifier_Type_Length) && mb_strlen(preg_replace('/(\D)/', '', $item_Identifier_Type_Length)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($item_Identifier_Type_Length, true), mb_strlen(preg_replace('/(\D)/', '', $item_Identifier_Type_Length))), __LINE__);
        }
        $this->Item_Identifier_Type_Length = $item_Identifier_Type_Length;
        return $this;
    }
    /**
     * Get Item_Identifier_Type_Description value
     * @return string|null
     */
    public function getItem_Identifier_Type_Description()
    {
        return $this->Item_Identifier_Type_Description;
    }
    /**
     * Set Item_Identifier_Type_Description value
     * @param string $item_Identifier_Type_Description
     * @return \StructType\Item_Identifier_Type_DataType
     */
    public function setItem_Identifier_Type_Description($item_Identifier_Type_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Identifier_Type_Description) && !is_string($item_Identifier_Type_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Identifier_Type_Description, true), gettype($item_Identifier_Type_Description)), __LINE__);
        }
        $this->Item_Identifier_Type_Description = $item_Identifier_Type_Description;
        return $this;
    }
    /**
     * Get Universal_Item_Identifier_Type_Reference value
     * @return \StructType\Universal_Item_Identifier_TypeObjectType|null
     */
    public function getUniversal_Item_Identifier_Type_Reference()
    {
        return $this->Universal_Item_Identifier_Type_Reference;
    }
    /**
     * Set Universal_Item_Identifier_Type_Reference value
     * @param \StructType\Universal_Item_Identifier_TypeObjectType $universal_Item_Identifier_Type_Reference
     * @return \StructType\Item_Identifier_Type_DataType
     */
    public function setUniversal_Item_Identifier_Type_Reference(\StructType\Universal_Item_Identifier_TypeObjectType $universal_Item_Identifier_Type_Reference = null)
    {
        $this->Universal_Item_Identifier_Type_Reference = $universal_Item_Identifier_Type_Reference;
        return $this;
    }
    /**
     * Get For_Item_UOM value
     * @return bool|null
     */
    public function getFor_Item_UOM()
    {
        return $this->For_Item_UOM;
    }
    /**
     * Set For_Item_UOM value
     * @param bool $for_Item_UOM
     * @return \StructType\Item_Identifier_Type_DataType
     */
    public function setFor_Item_UOM($for_Item_UOM = null)
    {
        // validation for constraint: boolean
        if (!is_null($for_Item_UOM) && !is_bool($for_Item_UOM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($for_Item_UOM, true), gettype($for_Item_UOM)), __LINE__);
        }
        $this->For_Item_UOM = $for_Item_UOM;
        return $this;
    }
    /**
     * Get Allow_Multiples value
     * @return bool|null
     */
    public function getAllow_Multiples()
    {
        return $this->Allow_Multiples;
    }
    /**
     * Set Allow_Multiples value
     * @param bool $allow_Multiples
     * @return \StructType\Item_Identifier_Type_DataType
     */
    public function setAllow_Multiples($allow_Multiples = null)
    {
        // validation for constraint: boolean
        if (!is_null($allow_Multiples) && !is_bool($allow_Multiples)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allow_Multiples, true), gettype($allow_Multiples)), __LINE__);
        }
        $this->Allow_Multiples = $allow_Multiples;
        return $this;
    }
    /**
     * Get Item_Identifier_is_Unique value
     * @return bool|null
     */
    public function getItem_Identifier_is_Unique()
    {
        return $this->Item_Identifier_is_Unique;
    }
    /**
     * Set Item_Identifier_is_Unique value
     * @param bool $item_Identifier_is_Unique
     * @return \StructType\Item_Identifier_Type_DataType
     */
    public function setItem_Identifier_is_Unique($item_Identifier_is_Unique = null)
    {
        // validation for constraint: boolean
        if (!is_null($item_Identifier_is_Unique) && !is_bool($item_Identifier_is_Unique)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($item_Identifier_is_Unique, true), gettype($item_Identifier_is_Unique)), __LINE__);
        }
        $this->Item_Identifier_is_Unique = $item_Identifier_is_Unique;
        return $this;
    }
    /**
     * Get Use_in_Supplier_Catalog_Mapping value
     * @return bool|null
     */
    public function getUse_in_Supplier_Catalog_Mapping()
    {
        return $this->Use_in_Supplier_Catalog_Mapping;
    }
    /**
     * Set Use_in_Supplier_Catalog_Mapping value
     * @param bool $use_in_Supplier_Catalog_Mapping
     * @return \StructType\Item_Identifier_Type_DataType
     */
    public function setUse_in_Supplier_Catalog_Mapping($use_in_Supplier_Catalog_Mapping = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_in_Supplier_Catalog_Mapping) && !is_bool($use_in_Supplier_Catalog_Mapping)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_in_Supplier_Catalog_Mapping, true), gettype($use_in_Supplier_Catalog_Mapping)), __LINE__);
        }
        $this->Use_in_Supplier_Catalog_Mapping = $use_in_Supplier_Catalog_Mapping;
        return $this;
    }
    /**
     * Get Item_Identifier_is_External value
     * @return bool|null
     */
    public function getItem_Identifier_is_External()
    {
        return $this->Item_Identifier_is_External;
    }
    /**
     * Set Item_Identifier_is_External value
     * @param bool $item_Identifier_is_External
     * @return \StructType\Item_Identifier_Type_DataType
     */
    public function setItem_Identifier_is_External($item_Identifier_is_External = null)
    {
        // validation for constraint: boolean
        if (!is_null($item_Identifier_is_External) && !is_bool($item_Identifier_is_External)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($item_Identifier_is_External, true), gettype($item_Identifier_is_External)), __LINE__);
        }
        $this->Item_Identifier_is_External = $item_Identifier_is_External;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Item_Identifier_Type_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
