<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hours_Worked_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Hours Worked Data. Contains the applicable time code and number of hours worked.
 * @subpackage Structs
 */
class Hours_Worked_DataType extends AbstractStructBase
{
    /**
     * The Time_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Time Code for the hours worked. For example, Regular or Overtime.
     * @var \StructType\Time_Entry_CodeObjectType
     */
    public $Time_Code_Reference;
    /**
     * The Hours
     * Meta information extracted from the WSDL
     * - documentation: The total hours worked on this day. | Hours worked.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - totalDigits: 14
     * @var float
     */
    public $Hours;
    /**
     * Constructor method for Hours_Worked_DataType
     * @uses Hours_Worked_DataType::setTime_Code_Reference()
     * @uses Hours_Worked_DataType::setHours()
     * @param \StructType\Time_Entry_CodeObjectType $time_Code_Reference
     * @param float $hours
     */
    public function __construct(\StructType\Time_Entry_CodeObjectType $time_Code_Reference = null, $hours = null)
    {
        $this
            ->setTime_Code_Reference($time_Code_Reference)
            ->setHours($hours);
    }
    /**
     * Get Time_Code_Reference value
     * @return \StructType\Time_Entry_CodeObjectType|null
     */
    public function getTime_Code_Reference()
    {
        return $this->Time_Code_Reference;
    }
    /**
     * Set Time_Code_Reference value
     * @param \StructType\Time_Entry_CodeObjectType $time_Code_Reference
     * @return \StructType\Hours_Worked_DataType
     */
    public function setTime_Code_Reference(\StructType\Time_Entry_CodeObjectType $time_Code_Reference = null)
    {
        $this->Time_Code_Reference = $time_Code_Reference;
        return $this;
    }
    /**
     * Get Hours value
     * @return float|null
     */
    public function getHours()
    {
        return $this->Hours;
    }
    /**
     * Set Hours value
     * @param float $hours
     * @return \StructType\Hours_Worked_DataType
     */
    public function setHours($hours = null)
    {
        // validation for constraint: float
        if (!is_null($hours) && !(is_float($hours) || is_numeric($hours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hours, true), gettype($hours)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($hours) && mb_strlen(mb_substr($hours, false !== mb_strpos($hours, '.') ? mb_strpos($hours, '.') + 1 : mb_strlen($hours))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($hours, true), mb_strlen(mb_substr($hours, mb_strpos($hours, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($hours) && mb_strlen(preg_replace('/(\D)/', '', $hours)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($hours, true), mb_strlen(preg_replace('/(\D)/', '', $hours))), __LINE__);
        }
        $this->Hours = $hours;
        return $this;
    }
}
