<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Report_Line_WWS_Outbound_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that encapsulates all data for 1 expense report line (date, credit card, credit card transaction, expense item, quantity, amount, currency, currency rate, converted amount, receipt included, billable, worktags, expense item
 * attributes).
 * @subpackage Structs
 */
class Expense_Report_Line_WWS_Outbound_DataType extends AbstractStructBase
{
    /**
     * The Expense_Report_Line_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the expense was incurred.
     * - maxOccurs: 1
     * @var string
     */
    public $Expense_Report_Line_Date;
    /**
     * The Travel_Booking_Record_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the travel booking record where the expense was reported.
     * - minOccurs: 0
     * @var \StructType\Travel_Booking_RecordObjectType
     */
    public $Travel_Booking_Record_Reference;
    /**
     * The Expense_Credit_Card_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the credit card that the expense was paid with. This can only be used for credit cards that require manual entry.
     * - choice: Expense_Credit_Card_Reference | Expense_Credit_Card_Transaction_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Worker_Credit_CardObjectType
     */
    public $Expense_Credit_Card_Reference;
    /**
     * The Expense_Credit_Card_Transaction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the credit card transaction where the expense was reported. This cannot be used at the same time as the credit card reference or the mobile expense reference.
     * - choice: Expense_Credit_Card_Reference | Expense_Credit_Card_Transaction_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Credit_Card_TransactionObjectType
     */
    public $Expense_Credit_Card_Transaction_Reference;
    /**
     * The Mobile_Expense_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the mobile expense where the expense was reported. This cannot be used at the same time as the credit card reference or the expense credit card transaction reference.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Mobile_Expense_Reference;
    /**
     * The Expense_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the expense item the expense is for.
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Expense_Item_Reference;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount for the project subtask. | Unit cost for the expense report line. Leave blank if you are entering a credit card transaction. | The amount of the installment line. | Transaction Extended Amount | The payment amount for this
     * lease payment line.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Amount;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the tax applicability.If this is blank and there invoice line has a sales item, Workday will default tax applicability from the sales item. If the invoice line has a tax code then tax applicability
     * is required.
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the tax code.If this is blank, Workday will default in the default tax code from the invoice header if there is one. If the invoice line has a tax applicability value, Workday will validate that the
     * invoice line also has a tax code.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Enter 1 or more lines with tax applicability on an invoice with Tax Amount. This tax applicability must be taxable, non-recoverable, and allocate non-recoverable tax. | Total Tax Amount for Tax Code and Tax Applicability | Tax Amount
     * for Expense Line | The tax amount to report for the expense. The tax code is defined on the itemized line. | Total Tax Amount for Tax Rate | Tax can only be entered if the Tax Option is Enter Tax Due to Supplier. | Expense Credit Card Extended Tax
     * Amount | Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Tax_Amount;
    /**
     * The Tax_Rate_Recoverabilities_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tax_Rate_Options_DataType
     */
    public $Tax_Rate_Recoverabilities_Data;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the currency the expense was incurred in. Leave blank if you are entering a credit card transaction.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Currency_Rate
     * Meta information extracted from the WSDL
     * - documentation: The conversion rate between the currency the expense was incurred in and the currency the expense will be reported in. This cannot be used if you are entering the converted amount. Leave blank if you are entering a credit card
     * transaction.
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 27
     * @var float
     */
    public $Currency_Rate;
    /**
     * The Converted_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount the expense is converted to if it was incurred in a different currency. This cannot be used if you are entering the currency rate. Leave blank if you are entering a credit card transaction. | Converted AmountThis
     * information is for outbound purposes only and is not processed on inbound Workday Web Services requests. | Expense Credit Card Converted Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Converted_Amount;
    /**
     * The Total_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount to report for the expense. This will only be used for viewing. | Installment Line Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Amount;
    /**
     * The Total_Itemized_Lines_Converted_Amount
     * Meta information extracted from the WSDL
     * - documentation: The total amount of the converted amounts for the itemized lines. This field is READ ONLY.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Itemized_Lines_Converted_Amount;
    /**
     * The Receipt_Included
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag that represents whether or not a receipt is included.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Receipt_Included;
    /**
     * The Personal_Expense
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag that represents whether or not the expense was for personal use.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Personal_Expense;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag that represents whether or not the expense is billable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Billable;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Expense Report Line Override Company
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation
     * when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Text describing the use or purpose of the expense.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Available_Spend_Authorization_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Spend Authorization Line to be linked to the Expense Report Line. Only applicable if Commitment Accounting is enabled for the company.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Available_Spend_Authorization_Line_Reference;
    /**
     * The Send_Back_Reason_For_Line
     * Meta information extracted from the WSDL
     * - documentation: The reason for sending back this Expense Report Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Send_Back_Reason_For_Line;
    /**
     * The Expense_Item_Details_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Expense_Report_Line_Detail_DataType
     */
    public $Expense_Item_Details_Data;
    /**
     * The Itemized_Expense_Report_Lines_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Itemized_Expense_Report_Line_WWS_Outbound_DataType[]
     */
    public $Itemized_Expense_Report_Lines_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Reimbursement_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount that represents reimbursement amount in the reimbursement currency. This field is READ ONLY.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Reimbursement_Amount;
    /**
     * The Reimbursable
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag that represents whether or not the expense is reimbursable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Reimbursable;
    /**
     * Constructor method for Expense_Report_Line_WWS_Outbound_DataType
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setExpense_Report_Line_Date()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setTravel_Booking_Record_Reference()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setExpense_Credit_Card_Reference()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setExpense_Credit_Card_Transaction_Reference()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setMobile_Expense_Reference()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setExpense_Item_Reference()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setQuantity()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setAmount()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setTax_Applicability_Reference()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setTax_Code_Reference()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setTax_Amount()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setTax_Rate_Recoverabilities_Data()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setCurrency_Reference()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setCurrency_Rate()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setConverted_Amount()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setTotal_Amount()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setTotal_Itemized_Lines_Converted_Amount()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setReceipt_Included()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setPersonal_Expense()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setBillable()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setCompany_Reference()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setWorktag_Reference()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setMemo()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setAvailable_Spend_Authorization_Line_Reference()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setSend_Back_Reason_For_Line()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setExpense_Item_Details_Data()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setItemized_Expense_Report_Lines_Data()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setAttachment_Data()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setReimbursement_Amount()
     * @uses Expense_Report_Line_WWS_Outbound_DataType::setReimbursable()
     * @param string $expense_Report_Line_Date
     * @param \StructType\Travel_Booking_RecordObjectType $travel_Booking_Record_Reference
     * @param \StructType\Worker_Credit_CardObjectType $expense_Credit_Card_Reference
     * @param \StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference
     * @param \StructType\Unique_IdentifierObjectType[] $mobile_Expense_Reference
     * @param \StructType\Item_DescriptorObjectType $expense_Item_Reference
     * @param float $quantity
     * @param float $amount
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param float $tax_Amount
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param float $currency_Rate
     * @param float $converted_Amount
     * @param float $total_Amount
     * @param float $total_Itemized_Lines_Converted_Amount
     * @param bool $receipt_Included
     * @param bool $personal_Expense
     * @param bool $billable
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @param string $memo
     * @param \StructType\Unique_IdentifierObjectType $available_Spend_Authorization_Line_Reference
     * @param string $send_Back_Reason_For_Line
     * @param \StructType\Expense_Report_Line_Detail_DataType $expense_Item_Details_Data
     * @param \StructType\Itemized_Expense_Report_Line_WWS_Outbound_DataType[] $itemized_Expense_Report_Lines_Data
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @param float $reimbursement_Amount
     * @param bool $reimbursable
     */
    public function __construct($expense_Report_Line_Date = null, \StructType\Travel_Booking_RecordObjectType $travel_Booking_Record_Reference = null, \StructType\Worker_Credit_CardObjectType $expense_Credit_Card_Reference = null, \StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference = null, array $mobile_Expense_Reference = array(), \StructType\Item_DescriptorObjectType $expense_Item_Reference = null, $quantity = null, $amount = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, $tax_Amount = null, \StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data = null, \StructType\CurrencyObjectType $currency_Reference = null, $currency_Rate = null, $converted_Amount = null, $total_Amount = null, $total_Itemized_Lines_Converted_Amount = null, $receipt_Included = null, $personal_Expense = null, $billable = null, \StructType\CompanyObjectType $company_Reference = null, array $worktag_Reference = array(), $memo = null, \StructType\Unique_IdentifierObjectType $available_Spend_Authorization_Line_Reference = null, $send_Back_Reason_For_Line = null, \StructType\Expense_Report_Line_Detail_DataType $expense_Item_Details_Data = null, array $itemized_Expense_Report_Lines_Data = array(), array $attachment_Data = array(), $reimbursement_Amount = null, $reimbursable = null)
    {
        $this
            ->setExpense_Report_Line_Date($expense_Report_Line_Date)
            ->setTravel_Booking_Record_Reference($travel_Booking_Record_Reference)
            ->setExpense_Credit_Card_Reference($expense_Credit_Card_Reference)
            ->setExpense_Credit_Card_Transaction_Reference($expense_Credit_Card_Transaction_Reference)
            ->setMobile_Expense_Reference($mobile_Expense_Reference)
            ->setExpense_Item_Reference($expense_Item_Reference)
            ->setQuantity($quantity)
            ->setAmount($amount)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setTax_Amount($tax_Amount)
            ->setTax_Rate_Recoverabilities_Data($tax_Rate_Recoverabilities_Data)
            ->setCurrency_Reference($currency_Reference)
            ->setCurrency_Rate($currency_Rate)
            ->setConverted_Amount($converted_Amount)
            ->setTotal_Amount($total_Amount)
            ->setTotal_Itemized_Lines_Converted_Amount($total_Itemized_Lines_Converted_Amount)
            ->setReceipt_Included($receipt_Included)
            ->setPersonal_Expense($personal_Expense)
            ->setBillable($billable)
            ->setCompany_Reference($company_Reference)
            ->setWorktag_Reference($worktag_Reference)
            ->setMemo($memo)
            ->setAvailable_Spend_Authorization_Line_Reference($available_Spend_Authorization_Line_Reference)
            ->setSend_Back_Reason_For_Line($send_Back_Reason_For_Line)
            ->setExpense_Item_Details_Data($expense_Item_Details_Data)
            ->setItemized_Expense_Report_Lines_Data($itemized_Expense_Report_Lines_Data)
            ->setAttachment_Data($attachment_Data)
            ->setReimbursement_Amount($reimbursement_Amount)
            ->setReimbursable($reimbursable);
    }
    /**
     * Get Expense_Report_Line_Date value
     * @return string|null
     */
    public function getExpense_Report_Line_Date()
    {
        return $this->Expense_Report_Line_Date;
    }
    /**
     * Set Expense_Report_Line_Date value
     * @param string $expense_Report_Line_Date
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setExpense_Report_Line_Date($expense_Report_Line_Date = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Report_Line_Date) && !is_string($expense_Report_Line_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Report_Line_Date, true), gettype($expense_Report_Line_Date)), __LINE__);
        }
        $this->Expense_Report_Line_Date = $expense_Report_Line_Date;
        return $this;
    }
    /**
     * Get Travel_Booking_Record_Reference value
     * @return \StructType\Travel_Booking_RecordObjectType|null
     */
    public function getTravel_Booking_Record_Reference()
    {
        return $this->Travel_Booking_Record_Reference;
    }
    /**
     * Set Travel_Booking_Record_Reference value
     * @param \StructType\Travel_Booking_RecordObjectType $travel_Booking_Record_Reference
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setTravel_Booking_Record_Reference(\StructType\Travel_Booking_RecordObjectType $travel_Booking_Record_Reference = null)
    {
        $this->Travel_Booking_Record_Reference = $travel_Booking_Record_Reference;
        return $this;
    }
    /**
     * Get Expense_Credit_Card_Reference value
     * @return \StructType\Worker_Credit_CardObjectType|null
     */
    public function getExpense_Credit_Card_Reference()
    {
        return isset($this->Expense_Credit_Card_Reference) ? $this->Expense_Credit_Card_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExpense_Credit_Card_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Credit_Card_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExpense_Credit_Card_ReferenceForChoiceConstraintsFromSetExpense_Credit_Card_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Expense_Credit_Card_Transaction_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Expense_Credit_Card_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Expense_Credit_Card_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Expense_Credit_Card_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Credit_CardObjectType $expense_Credit_Card_Reference
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setExpense_Credit_Card_Reference(\StructType\Worker_Credit_CardObjectType $expense_Credit_Card_Reference = null)
    {
        // validation for constraint: choice(Expense_Credit_Card_Reference, Expense_Credit_Card_Transaction_Reference)
        if ('' !== ($expense_Credit_Card_ReferenceChoiceErrorMessage = self::validateExpense_Credit_Card_ReferenceForChoiceConstraintsFromSetExpense_Credit_Card_Reference($expense_Credit_Card_Reference))) {
            throw new \InvalidArgumentException($expense_Credit_Card_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($expense_Credit_Card_Reference) || (is_array($expense_Credit_Card_Reference) && empty($expense_Credit_Card_Reference))) {
            unset($this->Expense_Credit_Card_Reference);
        } else {
            $this->Expense_Credit_Card_Reference = $expense_Credit_Card_Reference;
        }
        return $this;
    }
    /**
     * Get Expense_Credit_Card_Transaction_Reference value
     * @return \StructType\Credit_Card_TransactionObjectType|null
     */
    public function getExpense_Credit_Card_Transaction_Reference()
    {
        return isset($this->Expense_Credit_Card_Transaction_Reference) ? $this->Expense_Credit_Card_Transaction_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setExpense_Credit_Card_Transaction_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Credit_Card_Transaction_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateExpense_Credit_Card_Transaction_ReferenceForChoiceConstraintsFromSetExpense_Credit_Card_Transaction_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Expense_Credit_Card_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Expense_Credit_Card_Transaction_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Expense_Credit_Card_Transaction_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Expense_Credit_Card_Transaction_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setExpense_Credit_Card_Transaction_Reference(\StructType\Credit_Card_TransactionObjectType $expense_Credit_Card_Transaction_Reference = null)
    {
        // validation for constraint: choice(Expense_Credit_Card_Reference, Expense_Credit_Card_Transaction_Reference)
        if ('' !== ($expense_Credit_Card_Transaction_ReferenceChoiceErrorMessage = self::validateExpense_Credit_Card_Transaction_ReferenceForChoiceConstraintsFromSetExpense_Credit_Card_Transaction_Reference($expense_Credit_Card_Transaction_Reference))) {
            throw new \InvalidArgumentException($expense_Credit_Card_Transaction_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($expense_Credit_Card_Transaction_Reference) || (is_array($expense_Credit_Card_Transaction_Reference) && empty($expense_Credit_Card_Transaction_Reference))) {
            unset($this->Expense_Credit_Card_Transaction_Reference);
        } else {
            $this->Expense_Credit_Card_Transaction_Reference = $expense_Credit_Card_Transaction_Reference;
        }
        return $this;
    }
    /**
     * Get Mobile_Expense_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getMobile_Expense_Reference()
    {
        return $this->Mobile_Expense_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setMobile_Expense_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMobile_Expense_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMobile_Expense_ReferenceForArrayConstraintsFromSetMobile_Expense_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Line_WWS_Outbound_DataTypeMobile_Expense_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Line_WWS_Outbound_DataTypeMobile_Expense_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($expense_Report_Line_WWS_Outbound_DataTypeMobile_Expense_ReferenceItem) ? get_class($expense_Report_Line_WWS_Outbound_DataTypeMobile_Expense_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Report_Line_WWS_Outbound_DataTypeMobile_Expense_ReferenceItem), var_export($expense_Report_Line_WWS_Outbound_DataTypeMobile_Expense_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Mobile_Expense_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Mobile_Expense_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $mobile_Expense_Reference
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setMobile_Expense_Reference(array $mobile_Expense_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($mobile_Expense_ReferenceArrayErrorMessage = self::validateMobile_Expense_ReferenceForArrayConstraintsFromSetMobile_Expense_Reference($mobile_Expense_Reference))) {
            throw new \InvalidArgumentException($mobile_Expense_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Mobile_Expense_Reference = $mobile_Expense_Reference;
        return $this;
    }
    /**
     * Add item to Mobile_Expense_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function addToMobile_Expense_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Mobile_Expense_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Mobile_Expense_Reference[] = $item;
        return $this;
    }
    /**
     * Get Expense_Item_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getExpense_Item_Reference()
    {
        return $this->Expense_Item_Reference;
    }
    /**
     * Set Expense_Item_Reference value
     * @param \StructType\Item_DescriptorObjectType $expense_Item_Reference
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setExpense_Item_Reference(\StructType\Item_DescriptorObjectType $expense_Item_Reference = null)
    {
        $this->Expense_Item_Reference = $expense_Item_Reference;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, false !== mb_strpos($amount, '.') ? mb_strpos($amount, '.') + 1 : mb_strlen($amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($amount) && mb_strlen(preg_replace('/(\D)/', '', $amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($amount, true), mb_strlen(preg_replace('/(\D)/', '', $amount))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Tax_Amount value
     * @return float|null
     */
    public function getTax_Amount()
    {
        return $this->Tax_Amount;
    }
    /**
     * Set Tax_Amount value
     * @param float $tax_Amount
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setTax_Amount($tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($tax_Amount) && !(is_float($tax_Amount) || is_numeric($tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax_Amount, true), gettype($tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($tax_Amount) && mb_strlen(mb_substr($tax_Amount, false !== mb_strpos($tax_Amount, '.') ? mb_strpos($tax_Amount, '.') + 1 : mb_strlen($tax_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($tax_Amount, true), mb_strlen(mb_substr($tax_Amount, mb_strpos($tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $tax_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $tax_Amount))), __LINE__);
        }
        $this->Tax_Amount = $tax_Amount;
        return $this;
    }
    /**
     * Get Tax_Rate_Recoverabilities_Data value
     * @return \StructType\Tax_Rate_Options_DataType|null
     */
    public function getTax_Rate_Recoverabilities_Data()
    {
        return $this->Tax_Rate_Recoverabilities_Data;
    }
    /**
     * Set Tax_Rate_Recoverabilities_Data value
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setTax_Rate_Recoverabilities_Data(\StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data = null)
    {
        $this->Tax_Rate_Recoverabilities_Data = $tax_Rate_Recoverabilities_Data;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Currency_Rate value
     * @return float|null
     */
    public function getCurrency_Rate()
    {
        return $this->Currency_Rate;
    }
    /**
     * Set Currency_Rate value
     * @param float $currency_Rate
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setCurrency_Rate($currency_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($currency_Rate) && !(is_float($currency_Rate) || is_numeric($currency_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currency_Rate, true), gettype($currency_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($currency_Rate) && mb_strlen(mb_substr($currency_Rate, false !== mb_strpos($currency_Rate, '.') ? mb_strpos($currency_Rate, '.') + 1 : mb_strlen($currency_Rate))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($currency_Rate, true), mb_strlen(mb_substr($currency_Rate, mb_strpos($currency_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(27)
        if (!is_null($currency_Rate) && mb_strlen(preg_replace('/(\D)/', '', $currency_Rate)) > 27) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 27 digits, "%d" given', var_export($currency_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $currency_Rate))), __LINE__);
        }
        $this->Currency_Rate = $currency_Rate;
        return $this;
    }
    /**
     * Get Converted_Amount value
     * @return float|null
     */
    public function getConverted_Amount()
    {
        return $this->Converted_Amount;
    }
    /**
     * Set Converted_Amount value
     * @param float $converted_Amount
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setConverted_Amount($converted_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($converted_Amount) && !(is_float($converted_Amount) || is_numeric($converted_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($converted_Amount, true), gettype($converted_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($converted_Amount) && mb_strlen(mb_substr($converted_Amount, false !== mb_strpos($converted_Amount, '.') ? mb_strpos($converted_Amount, '.') + 1 : mb_strlen($converted_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($converted_Amount, true), mb_strlen(mb_substr($converted_Amount, mb_strpos($converted_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($converted_Amount) && mb_strlen(preg_replace('/(\D)/', '', $converted_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($converted_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $converted_Amount))), __LINE__);
        }
        $this->Converted_Amount = $converted_Amount;
        return $this;
    }
    /**
     * Get Total_Amount value
     * @return float|null
     */
    public function getTotal_Amount()
    {
        return $this->Total_Amount;
    }
    /**
     * Set Total_Amount value
     * @param float $total_Amount
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setTotal_Amount($total_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($total_Amount) && !(is_float($total_Amount) || is_numeric($total_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Amount, true), gettype($total_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Amount) && mb_strlen(mb_substr($total_Amount, false !== mb_strpos($total_Amount, '.') ? mb_strpos($total_Amount, '.') + 1 : mb_strlen($total_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Amount, true), mb_strlen(mb_substr($total_Amount, mb_strpos($total_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Amount) && mb_strlen(preg_replace('/(\D)/', '', $total_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $total_Amount))), __LINE__);
        }
        $this->Total_Amount = $total_Amount;
        return $this;
    }
    /**
     * Get Total_Itemized_Lines_Converted_Amount value
     * @return float|null
     */
    public function getTotal_Itemized_Lines_Converted_Amount()
    {
        return $this->Total_Itemized_Lines_Converted_Amount;
    }
    /**
     * Set Total_Itemized_Lines_Converted_Amount value
     * @param float $total_Itemized_Lines_Converted_Amount
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setTotal_Itemized_Lines_Converted_Amount($total_Itemized_Lines_Converted_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($total_Itemized_Lines_Converted_Amount) && !(is_float($total_Itemized_Lines_Converted_Amount) || is_numeric($total_Itemized_Lines_Converted_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Itemized_Lines_Converted_Amount, true), gettype($total_Itemized_Lines_Converted_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Itemized_Lines_Converted_Amount) && mb_strlen(mb_substr($total_Itemized_Lines_Converted_Amount, false !== mb_strpos($total_Itemized_Lines_Converted_Amount, '.') ? mb_strpos($total_Itemized_Lines_Converted_Amount, '.') + 1 : mb_strlen($total_Itemized_Lines_Converted_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Itemized_Lines_Converted_Amount, true), mb_strlen(mb_substr($total_Itemized_Lines_Converted_Amount, mb_strpos($total_Itemized_Lines_Converted_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Itemized_Lines_Converted_Amount) && mb_strlen(preg_replace('/(\D)/', '', $total_Itemized_Lines_Converted_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Itemized_Lines_Converted_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $total_Itemized_Lines_Converted_Amount))), __LINE__);
        }
        $this->Total_Itemized_Lines_Converted_Amount = $total_Itemized_Lines_Converted_Amount;
        return $this;
    }
    /**
     * Get Receipt_Included value
     * @return bool|null
     */
    public function getReceipt_Included()
    {
        return $this->Receipt_Included;
    }
    /**
     * Set Receipt_Included value
     * @param bool $receipt_Included
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setReceipt_Included($receipt_Included = null)
    {
        // validation for constraint: boolean
        if (!is_null($receipt_Included) && !is_bool($receipt_Included)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($receipt_Included, true), gettype($receipt_Included)), __LINE__);
        }
        $this->Receipt_Included = $receipt_Included;
        return $this;
    }
    /**
     * Get Personal_Expense value
     * @return bool|null
     */
    public function getPersonal_Expense()
    {
        return $this->Personal_Expense;
    }
    /**
     * Set Personal_Expense value
     * @param bool $personal_Expense
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setPersonal_Expense($personal_Expense = null)
    {
        // validation for constraint: boolean
        if (!is_null($personal_Expense) && !is_bool($personal_Expense)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($personal_Expense, true), gettype($personal_Expense)), __LINE__);
        }
        $this->Personal_Expense = $personal_Expense;
        return $this;
    }
    /**
     * Get Billable value
     * @return bool|null
     */
    public function getBillable()
    {
        return $this->Billable;
    }
    /**
     * Set Billable value
     * @param bool $billable
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setBillable($billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($billable) && !is_bool($billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billable, true), gettype($billable)), __LINE__);
        }
        $this->Billable = $billable;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Line_WWS_Outbound_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Line_WWS_Outbound_DataTypeWorktag_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($expense_Report_Line_WWS_Outbound_DataTypeWorktag_ReferenceItem) ? get_class($expense_Report_Line_WWS_Outbound_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Report_Line_WWS_Outbound_DataTypeWorktag_ReferenceItem), var_export($expense_Report_Line_WWS_Outbound_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function addToWorktag_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Available_Spend_Authorization_Line_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getAvailable_Spend_Authorization_Line_Reference()
    {
        return $this->Available_Spend_Authorization_Line_Reference;
    }
    /**
     * Set Available_Spend_Authorization_Line_Reference value
     * @param \StructType\Unique_IdentifierObjectType $available_Spend_Authorization_Line_Reference
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setAvailable_Spend_Authorization_Line_Reference(\StructType\Unique_IdentifierObjectType $available_Spend_Authorization_Line_Reference = null)
    {
        $this->Available_Spend_Authorization_Line_Reference = $available_Spend_Authorization_Line_Reference;
        return $this;
    }
    /**
     * Get Send_Back_Reason_For_Line value
     * @return string|null
     */
    public function getSend_Back_Reason_For_Line()
    {
        return $this->Send_Back_Reason_For_Line;
    }
    /**
     * Set Send_Back_Reason_For_Line value
     * @param string $send_Back_Reason_For_Line
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setSend_Back_Reason_For_Line($send_Back_Reason_For_Line = null)
    {
        // validation for constraint: string
        if (!is_null($send_Back_Reason_For_Line) && !is_string($send_Back_Reason_For_Line)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($send_Back_Reason_For_Line, true), gettype($send_Back_Reason_For_Line)), __LINE__);
        }
        $this->Send_Back_Reason_For_Line = $send_Back_Reason_For_Line;
        return $this;
    }
    /**
     * Get Expense_Item_Details_Data value
     * @return \StructType\Expense_Report_Line_Detail_DataType|null
     */
    public function getExpense_Item_Details_Data()
    {
        return $this->Expense_Item_Details_Data;
    }
    /**
     * Set Expense_Item_Details_Data value
     * @param \StructType\Expense_Report_Line_Detail_DataType $expense_Item_Details_Data
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setExpense_Item_Details_Data(\StructType\Expense_Report_Line_Detail_DataType $expense_Item_Details_Data = null)
    {
        $this->Expense_Item_Details_Data = $expense_Item_Details_Data;
        return $this;
    }
    /**
     * Get Itemized_Expense_Report_Lines_Data value
     * @return \StructType\Itemized_Expense_Report_Line_WWS_Outbound_DataType[]|null
     */
    public function getItemized_Expense_Report_Lines_Data()
    {
        return $this->Itemized_Expense_Report_Lines_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItemized_Expense_Report_Lines_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemized_Expense_Report_Lines_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemized_Expense_Report_Lines_DataForArrayConstraintsFromSetItemized_Expense_Report_Lines_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Line_WWS_Outbound_DataTypeItemized_Expense_Report_Lines_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Line_WWS_Outbound_DataTypeItemized_Expense_Report_Lines_DataItem instanceof \StructType\Itemized_Expense_Report_Line_WWS_Outbound_DataType) {
                $invalidValues[] = is_object($expense_Report_Line_WWS_Outbound_DataTypeItemized_Expense_Report_Lines_DataItem) ? get_class($expense_Report_Line_WWS_Outbound_DataTypeItemized_Expense_Report_Lines_DataItem) : sprintf('%s(%s)', gettype($expense_Report_Line_WWS_Outbound_DataTypeItemized_Expense_Report_Lines_DataItem), var_export($expense_Report_Line_WWS_Outbound_DataTypeItemized_Expense_Report_Lines_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Itemized_Expense_Report_Lines_Data property can only contain items of type \StructType\Itemized_Expense_Report_Line_WWS_Outbound_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Itemized_Expense_Report_Lines_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Itemized_Expense_Report_Line_WWS_Outbound_DataType[] $itemized_Expense_Report_Lines_Data
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setItemized_Expense_Report_Lines_Data(array $itemized_Expense_Report_Lines_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($itemized_Expense_Report_Lines_DataArrayErrorMessage = self::validateItemized_Expense_Report_Lines_DataForArrayConstraintsFromSetItemized_Expense_Report_Lines_Data($itemized_Expense_Report_Lines_Data))) {
            throw new \InvalidArgumentException($itemized_Expense_Report_Lines_DataArrayErrorMessage, __LINE__);
        }
        $this->Itemized_Expense_Report_Lines_Data = $itemized_Expense_Report_Lines_Data;
        return $this;
    }
    /**
     * Add item to Itemized_Expense_Report_Lines_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Itemized_Expense_Report_Line_WWS_Outbound_DataType $item
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function addToItemized_Expense_Report_Lines_Data(\StructType\Itemized_Expense_Report_Line_WWS_Outbound_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Itemized_Expense_Report_Line_WWS_Outbound_DataType) {
            throw new \InvalidArgumentException(sprintf('The Itemized_Expense_Report_Lines_Data property can only contain items of type \StructType\Itemized_Expense_Report_Line_WWS_Outbound_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Itemized_Expense_Report_Lines_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Line_WWS_Outbound_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Line_WWS_Outbound_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($expense_Report_Line_WWS_Outbound_DataTypeAttachment_DataItem) ? get_class($expense_Report_Line_WWS_Outbound_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($expense_Report_Line_WWS_Outbound_DataTypeAttachment_DataItem), var_export($expense_Report_Line_WWS_Outbound_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Reimbursement_Amount value
     * @return float|null
     */
    public function getReimbursement_Amount()
    {
        return $this->Reimbursement_Amount;
    }
    /**
     * Set Reimbursement_Amount value
     * @param float $reimbursement_Amount
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setReimbursement_Amount($reimbursement_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($reimbursement_Amount) && !(is_float($reimbursement_Amount) || is_numeric($reimbursement_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reimbursement_Amount, true), gettype($reimbursement_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($reimbursement_Amount) && mb_strlen(mb_substr($reimbursement_Amount, false !== mb_strpos($reimbursement_Amount, '.') ? mb_strpos($reimbursement_Amount, '.') + 1 : mb_strlen($reimbursement_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($reimbursement_Amount, true), mb_strlen(mb_substr($reimbursement_Amount, mb_strpos($reimbursement_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($reimbursement_Amount) && mb_strlen(preg_replace('/(\D)/', '', $reimbursement_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($reimbursement_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $reimbursement_Amount))), __LINE__);
        }
        $this->Reimbursement_Amount = $reimbursement_Amount;
        return $this;
    }
    /**
     * Get Reimbursable value
     * @return bool|null
     */
    public function getReimbursable()
    {
        return $this->Reimbursable;
    }
    /**
     * Set Reimbursable value
     * @param bool $reimbursable
     * @return \StructType\Expense_Report_Line_WWS_Outbound_DataType
     */
    public function setReimbursable($reimbursable = null)
    {
        // validation for constraint: boolean
        if (!is_null($reimbursable) && !is_bool($reimbursable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reimbursable, true), gettype($reimbursable)), __LINE__);
        }
        $this->Reimbursable = $reimbursable;
        return $this;
    }
}
