<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax_ID_Widget_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can only select the Tax ID Type once for a Country. | If Delete is set to true, Replace All must be set to false in Tax ID Widget Data. | You can only have 1 Primary Tax ID. | If HMRC Office Number, Employer PAYE Reference, or
 * Employer Accounts Office Reference Number is defined, the three Tax IDs need to be defined. | You can only select 1 Transaction Tax ID for a country. Unselect the Transaction Tax ID check box for the Tax IDs that you don't want to use for recording
 * transaction tax. | Tax ID Widget Element to include 1 or more Tax ID Data WSS elements
 * @subpackage Structs
 */
class Tax_ID_Widget_DataType extends AbstractStructBase
{
    /**
     * The Tax_ID_Data
     * Meta information extracted from the WSDL
     * - documentation: Tax ID Data
     * - maxOccurs: unbounded
     * @var \StructType\Tax_ID_WWS_DataType[]
     */
    public $Tax_ID_Data;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: Replace All boolean to replace (True) or update (False) Tax ID information for a Supplier.
     * @var bool
     */
    public $Replace_All;
    /**
     * Constructor method for Tax_ID_Widget_DataType
     * @uses Tax_ID_Widget_DataType::setTax_ID_Data()
     * @uses Tax_ID_Widget_DataType::setReplace_All()
     * @param \StructType\Tax_ID_WWS_DataType[] $tax_ID_Data
     * @param bool $replace_All
     */
    public function __construct(array $tax_ID_Data = array(), $replace_All = null)
    {
        $this
            ->setTax_ID_Data($tax_ID_Data)
            ->setReplace_All($replace_All);
    }
    /**
     * Get Tax_ID_Data value
     * @return \StructType\Tax_ID_WWS_DataType[]|null
     */
    public function getTax_ID_Data()
    {
        return $this->Tax_ID_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_ID_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_ID_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_ID_DataForArrayConstraintsFromSetTax_ID_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tax_ID_Widget_DataTypeTax_ID_DataItem) {
            // validation for constraint: itemType
            if (!$tax_ID_Widget_DataTypeTax_ID_DataItem instanceof \StructType\Tax_ID_WWS_DataType) {
                $invalidValues[] = is_object($tax_ID_Widget_DataTypeTax_ID_DataItem) ? get_class($tax_ID_Widget_DataTypeTax_ID_DataItem) : sprintf('%s(%s)', gettype($tax_ID_Widget_DataTypeTax_ID_DataItem), var_export($tax_ID_Widget_DataTypeTax_ID_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_ID_Data property can only contain items of type \StructType\Tax_ID_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax_ID_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_ID_WWS_DataType[] $tax_ID_Data
     * @return \StructType\Tax_ID_Widget_DataType
     */
    public function setTax_ID_Data(array $tax_ID_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_ID_DataArrayErrorMessage = self::validateTax_ID_DataForArrayConstraintsFromSetTax_ID_Data($tax_ID_Data))) {
            throw new \InvalidArgumentException($tax_ID_DataArrayErrorMessage, __LINE__);
        }
        $this->Tax_ID_Data = $tax_ID_Data;
        return $this;
    }
    /**
     * Add item to Tax_ID_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_ID_WWS_DataType $item
     * @return \StructType\Tax_ID_Widget_DataType
     */
    public function addToTax_ID_Data(\StructType\Tax_ID_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_ID_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Tax_ID_Data property can only contain items of type \StructType\Tax_ID_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_ID_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Tax_ID_Widget_DataType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
}
