<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Order_Contract_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier reference is for a supplier that can be used as a basic worktag only. | Organization Reference must be Companies or Company Hierarchies | Contract End Date On or After must be earlier than Contract End Date On or Before. |
 * Contract Start Date On or After must be earlier than Contract Start Date On or Before. | Get Supplier Order Contracts Request Criteria
 * @subpackage Structs
 */
class Supplier_Order_Contract_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Organization_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to an existing Company or Company Hierarchy
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Organization_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to an existing Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Contract_Name
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Name;
    /**
     * The Contract_Start_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Contract Effective Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Start_Date_On_or_After;
    /**
     * The Contract_Start_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Contract Effective Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_Start_Date_On_or_Before;
    /**
     * The Contract_End_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Contract End Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_End_Date_On_or_After;
    /**
     * The Contract_End_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Contract End Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Contract_End_Date_On_or_Before;
    /**
     * The Supplier_Order_Contract_Status
     * Meta information extracted from the WSDL
     * - documentation: Supplier Order Contract Status. Examples of valid statuses are In Progress, Canceled, Approved, Denied, Draft
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Order_Contract_Status;
    /**
     * The Supplier_Contract_Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Contract_Reference_Number;
    /**
     * The Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Creating Worker for Supplier Order Contract
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Buyer_Reference;
    /**
     * Constructor method for Supplier_Order_Contract_Request_CriteriaType
     * @uses Supplier_Order_Contract_Request_CriteriaType::setOrganization_Reference()
     * @uses Supplier_Order_Contract_Request_CriteriaType::setSupplier_Reference()
     * @uses Supplier_Order_Contract_Request_CriteriaType::setContract_Name()
     * @uses Supplier_Order_Contract_Request_CriteriaType::setContract_Start_Date_On_or_After()
     * @uses Supplier_Order_Contract_Request_CriteriaType::setContract_Start_Date_On_or_Before()
     * @uses Supplier_Order_Contract_Request_CriteriaType::setContract_End_Date_On_or_After()
     * @uses Supplier_Order_Contract_Request_CriteriaType::setContract_End_Date_On_or_Before()
     * @uses Supplier_Order_Contract_Request_CriteriaType::setSupplier_Order_Contract_Status()
     * @uses Supplier_Order_Contract_Request_CriteriaType::setSupplier_Contract_Reference_Number()
     * @uses Supplier_Order_Contract_Request_CriteriaType::setBuyer_Reference()
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param string $contract_Name
     * @param string $contract_Start_Date_On_or_After
     * @param string $contract_Start_Date_On_or_Before
     * @param string $contract_End_Date_On_or_After
     * @param string $contract_End_Date_On_or_Before
     * @param string $supplier_Order_Contract_Status
     * @param string $supplier_Contract_Reference_Number
     * @param \StructType\WorkerObjectType[] $buyer_Reference
     */
    public function __construct(array $organization_Reference = array(), array $supplier_Reference = array(), $contract_Name = null, $contract_Start_Date_On_or_After = null, $contract_Start_Date_On_or_Before = null, $contract_End_Date_On_or_After = null, $contract_End_Date_On_or_Before = null, $supplier_Order_Contract_Status = null, $supplier_Contract_Reference_Number = null, array $buyer_Reference = array())
    {
        $this
            ->setOrganization_Reference($organization_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setContract_Name($contract_Name)
            ->setContract_Start_Date_On_or_After($contract_Start_Date_On_or_After)
            ->setContract_Start_Date_On_or_Before($contract_Start_Date_On_or_Before)
            ->setContract_End_Date_On_or_After($contract_End_Date_On_or_After)
            ->setContract_End_Date_On_or_Before($contract_End_Date_On_or_Before)
            ->setSupplier_Order_Contract_Status($supplier_Order_Contract_Status)
            ->setSupplier_Contract_Reference_Number($supplier_Contract_Reference_Number)
            ->setBuyer_Reference($buyer_Reference);
    }
    /**
     * Get Organization_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getOrganization_Reference()
    {
        return $this->Organization_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganization_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganization_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Order_Contract_Request_CriteriaTypeOrganization_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Order_Contract_Request_CriteriaTypeOrganization_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($supplier_Order_Contract_Request_CriteriaTypeOrganization_ReferenceItem) ? get_class($supplier_Order_Contract_Request_CriteriaTypeOrganization_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Order_Contract_Request_CriteriaTypeOrganization_ReferenceItem), var_export($supplier_Order_Contract_Request_CriteriaTypeOrganization_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $organization_Reference
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function setOrganization_Reference(array $organization_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($organization_ReferenceArrayErrorMessage = self::validateOrganization_ReferenceForArrayConstraintsFromSetOrganization_Reference($organization_Reference))) {
            throw new \InvalidArgumentException($organization_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Organization_Reference = $organization_Reference;
        return $this;
    }
    /**
     * Add item to Organization_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function addToOrganization_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Organization_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Organization_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Order_Contract_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Order_Contract_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($supplier_Order_Contract_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($supplier_Order_Contract_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Order_Contract_Request_CriteriaTypeSupplier_ReferenceItem), var_export($supplier_Order_Contract_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Contract_Name value
     * @return string|null
     */
    public function getContract_Name()
    {
        return $this->Contract_Name;
    }
    /**
     * Set Contract_Name value
     * @param string $contract_Name
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function setContract_Name($contract_Name = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Name) && !is_string($contract_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Name, true), gettype($contract_Name)), __LINE__);
        }
        $this->Contract_Name = $contract_Name;
        return $this;
    }
    /**
     * Get Contract_Start_Date_On_or_After value
     * @return string|null
     */
    public function getContract_Start_Date_On_or_After()
    {
        return $this->Contract_Start_Date_On_or_After;
    }
    /**
     * Set Contract_Start_Date_On_or_After value
     * @param string $contract_Start_Date_On_or_After
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function setContract_Start_Date_On_or_After($contract_Start_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Start_Date_On_or_After) && !is_string($contract_Start_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Start_Date_On_or_After, true), gettype($contract_Start_Date_On_or_After)), __LINE__);
        }
        $this->Contract_Start_Date_On_or_After = $contract_Start_Date_On_or_After;
        return $this;
    }
    /**
     * Get Contract_Start_Date_On_or_Before value
     * @return string|null
     */
    public function getContract_Start_Date_On_or_Before()
    {
        return $this->Contract_Start_Date_On_or_Before;
    }
    /**
     * Set Contract_Start_Date_On_or_Before value
     * @param string $contract_Start_Date_On_or_Before
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function setContract_Start_Date_On_or_Before($contract_Start_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($contract_Start_Date_On_or_Before) && !is_string($contract_Start_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_Start_Date_On_or_Before, true), gettype($contract_Start_Date_On_or_Before)), __LINE__);
        }
        $this->Contract_Start_Date_On_or_Before = $contract_Start_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Contract_End_Date_On_or_After value
     * @return string|null
     */
    public function getContract_End_Date_On_or_After()
    {
        return $this->Contract_End_Date_On_or_After;
    }
    /**
     * Set Contract_End_Date_On_or_After value
     * @param string $contract_End_Date_On_or_After
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function setContract_End_Date_On_or_After($contract_End_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($contract_End_Date_On_or_After) && !is_string($contract_End_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_End_Date_On_or_After, true), gettype($contract_End_Date_On_or_After)), __LINE__);
        }
        $this->Contract_End_Date_On_or_After = $contract_End_Date_On_or_After;
        return $this;
    }
    /**
     * Get Contract_End_Date_On_or_Before value
     * @return string|null
     */
    public function getContract_End_Date_On_or_Before()
    {
        return $this->Contract_End_Date_On_or_Before;
    }
    /**
     * Set Contract_End_Date_On_or_Before value
     * @param string $contract_End_Date_On_or_Before
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function setContract_End_Date_On_or_Before($contract_End_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($contract_End_Date_On_or_Before) && !is_string($contract_End_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contract_End_Date_On_or_Before, true), gettype($contract_End_Date_On_or_Before)), __LINE__);
        }
        $this->Contract_End_Date_On_or_Before = $contract_End_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Supplier_Order_Contract_Status value
     * @return string|null
     */
    public function getSupplier_Order_Contract_Status()
    {
        return $this->Supplier_Order_Contract_Status;
    }
    /**
     * Set Supplier_Order_Contract_Status value
     * @param string $supplier_Order_Contract_Status
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function setSupplier_Order_Contract_Status($supplier_Order_Contract_Status = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Order_Contract_Status) && !is_string($supplier_Order_Contract_Status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Order_Contract_Status, true), gettype($supplier_Order_Contract_Status)), __LINE__);
        }
        $this->Supplier_Order_Contract_Status = $supplier_Order_Contract_Status;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference_Number value
     * @return string|null
     */
    public function getSupplier_Contract_Reference_Number()
    {
        return $this->Supplier_Contract_Reference_Number;
    }
    /**
     * Set Supplier_Contract_Reference_Number value
     * @param string $supplier_Contract_Reference_Number
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function setSupplier_Contract_Reference_Number($supplier_Contract_Reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Contract_Reference_Number) && !is_string($supplier_Contract_Reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Contract_Reference_Number, true), gettype($supplier_Contract_Reference_Number)), __LINE__);
        }
        $this->Supplier_Contract_Reference_Number = $supplier_Contract_Reference_Number;
        return $this;
    }
    /**
     * Get Buyer_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getBuyer_Reference()
    {
        return $this->Buyer_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setBuyer_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBuyer_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBuyer_ReferenceForArrayConstraintsFromSetBuyer_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Order_Contract_Request_CriteriaTypeBuyer_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Order_Contract_Request_CriteriaTypeBuyer_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($supplier_Order_Contract_Request_CriteriaTypeBuyer_ReferenceItem) ? get_class($supplier_Order_Contract_Request_CriteriaTypeBuyer_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Order_Contract_Request_CriteriaTypeBuyer_ReferenceItem), var_export($supplier_Order_Contract_Request_CriteriaTypeBuyer_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Buyer_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Buyer_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $buyer_Reference
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function setBuyer_Reference(array $buyer_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($buyer_ReferenceArrayErrorMessage = self::validateBuyer_ReferenceForArrayConstraintsFromSetBuyer_Reference($buyer_Reference))) {
            throw new \InvalidArgumentException($buyer_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Buyer_Reference = $buyer_Reference;
        return $this;
    }
    /**
     * Add item to Buyer_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Supplier_Order_Contract_Request_CriteriaType
     */
    public function addToBuyer_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Buyer_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Buyer_Reference[] = $item;
        return $this;
    }
}
