<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Plan_Line_Requirement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resource Plan Line Requirement Data
 * @subpackage Structs
 */
class Resource_Plan_Line_Requirement_DataType extends AbstractStructBase
{
    /**
     * The Resource_Plan_Line_Requirement_ID
     * Meta information extracted from the WSDL
     * - documentation: Resource Plan Line Requirement ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Plan_Line_Requirement_ID;
    /**
     * The Resource_Plan_Detail_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Plan Detail Reference
     * @var \StructType\Project_Resource_Plan_DetailObjectType
     */
    public $Resource_Plan_Detail_Reference;
    /**
     * The Resource_Plan_Line_Requirement_Parameter_Data
     * Meta information extracted from the WSDL
     * - documentation: Resource Plan Requirement Parameter Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Plan_Requirement_Parameter_DataType[]
     */
    public $Resource_Plan_Line_Requirement_Parameter_Data;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Delete
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Resource_Plan_Line_Requirement_DataType
     * @uses Resource_Plan_Line_Requirement_DataType::setResource_Plan_Line_Requirement_ID()
     * @uses Resource_Plan_Line_Requirement_DataType::setResource_Plan_Detail_Reference()
     * @uses Resource_Plan_Line_Requirement_DataType::setResource_Plan_Line_Requirement_Parameter_Data()
     * @uses Resource_Plan_Line_Requirement_DataType::setDelete()
     * @param string $resource_Plan_Line_Requirement_ID
     * @param \StructType\Project_Resource_Plan_DetailObjectType $resource_Plan_Detail_Reference
     * @param \StructType\Resource_Plan_Requirement_Parameter_DataType[] $resource_Plan_Line_Requirement_Parameter_Data
     * @param bool $delete
     */
    public function __construct($resource_Plan_Line_Requirement_ID = null, \StructType\Project_Resource_Plan_DetailObjectType $resource_Plan_Detail_Reference = null, array $resource_Plan_Line_Requirement_Parameter_Data = array(), $delete = null)
    {
        $this
            ->setResource_Plan_Line_Requirement_ID($resource_Plan_Line_Requirement_ID)
            ->setResource_Plan_Detail_Reference($resource_Plan_Detail_Reference)
            ->setResource_Plan_Line_Requirement_Parameter_Data($resource_Plan_Line_Requirement_Parameter_Data)
            ->setDelete($delete);
    }
    /**
     * Get Resource_Plan_Line_Requirement_ID value
     * @return string|null
     */
    public function getResource_Plan_Line_Requirement_ID()
    {
        return $this->Resource_Plan_Line_Requirement_ID;
    }
    /**
     * Set Resource_Plan_Line_Requirement_ID value
     * @param string $resource_Plan_Line_Requirement_ID
     * @return \StructType\Resource_Plan_Line_Requirement_DataType
     */
    public function setResource_Plan_Line_Requirement_ID($resource_Plan_Line_Requirement_ID = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Plan_Line_Requirement_ID) && !is_string($resource_Plan_Line_Requirement_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Plan_Line_Requirement_ID, true), gettype($resource_Plan_Line_Requirement_ID)), __LINE__);
        }
        $this->Resource_Plan_Line_Requirement_ID = $resource_Plan_Line_Requirement_ID;
        return $this;
    }
    /**
     * Get Resource_Plan_Detail_Reference value
     * @return \StructType\Project_Resource_Plan_DetailObjectType|null
     */
    public function getResource_Plan_Detail_Reference()
    {
        return $this->Resource_Plan_Detail_Reference;
    }
    /**
     * Set Resource_Plan_Detail_Reference value
     * @param \StructType\Project_Resource_Plan_DetailObjectType $resource_Plan_Detail_Reference
     * @return \StructType\Resource_Plan_Line_Requirement_DataType
     */
    public function setResource_Plan_Detail_Reference(\StructType\Project_Resource_Plan_DetailObjectType $resource_Plan_Detail_Reference = null)
    {
        $this->Resource_Plan_Detail_Reference = $resource_Plan_Detail_Reference;
        return $this;
    }
    /**
     * Get Resource_Plan_Line_Requirement_Parameter_Data value
     * @return \StructType\Resource_Plan_Requirement_Parameter_DataType[]|null
     */
    public function getResource_Plan_Line_Requirement_Parameter_Data()
    {
        return $this->Resource_Plan_Line_Requirement_Parameter_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Plan_Line_Requirement_Parameter_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Plan_Line_Requirement_Parameter_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Plan_Line_Requirement_Parameter_DataForArrayConstraintsFromSetResource_Plan_Line_Requirement_Parameter_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Plan_Line_Requirement_DataTypeResource_Plan_Line_Requirement_Parameter_DataItem) {
            // validation for constraint: itemType
            if (!$resource_Plan_Line_Requirement_DataTypeResource_Plan_Line_Requirement_Parameter_DataItem instanceof \StructType\Resource_Plan_Requirement_Parameter_DataType) {
                $invalidValues[] = is_object($resource_Plan_Line_Requirement_DataTypeResource_Plan_Line_Requirement_Parameter_DataItem) ? get_class($resource_Plan_Line_Requirement_DataTypeResource_Plan_Line_Requirement_Parameter_DataItem) : sprintf('%s(%s)', gettype($resource_Plan_Line_Requirement_DataTypeResource_Plan_Line_Requirement_Parameter_DataItem), var_export($resource_Plan_Line_Requirement_DataTypeResource_Plan_Line_Requirement_Parameter_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Plan_Line_Requirement_Parameter_Data property can only contain items of type \StructType\Resource_Plan_Requirement_Parameter_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Plan_Line_Requirement_Parameter_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Plan_Requirement_Parameter_DataType[] $resource_Plan_Line_Requirement_Parameter_Data
     * @return \StructType\Resource_Plan_Line_Requirement_DataType
     */
    public function setResource_Plan_Line_Requirement_Parameter_Data(array $resource_Plan_Line_Requirement_Parameter_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Plan_Line_Requirement_Parameter_DataArrayErrorMessage = self::validateResource_Plan_Line_Requirement_Parameter_DataForArrayConstraintsFromSetResource_Plan_Line_Requirement_Parameter_Data($resource_Plan_Line_Requirement_Parameter_Data))) {
            throw new \InvalidArgumentException($resource_Plan_Line_Requirement_Parameter_DataArrayErrorMessage, __LINE__);
        }
        $this->Resource_Plan_Line_Requirement_Parameter_Data = $resource_Plan_Line_Requirement_Parameter_Data;
        return $this;
    }
    /**
     * Add item to Resource_Plan_Line_Requirement_Parameter_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Plan_Requirement_Parameter_DataType $item
     * @return \StructType\Resource_Plan_Line_Requirement_DataType
     */
    public function addToResource_Plan_Line_Requirement_Parameter_Data(\StructType\Resource_Plan_Requirement_Parameter_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Plan_Requirement_Parameter_DataType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Plan_Line_Requirement_Parameter_Data property can only contain items of type \StructType\Resource_Plan_Requirement_Parameter_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Plan_Line_Requirement_Parameter_Data[] = $item;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Resource_Plan_Line_Requirement_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
