<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Supplier_Invoice_Links_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Update Supplier Invoice Links Response Data
 * @subpackage Structs
 */
class Put_Supplier_Invoice_Links_ResponseType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Document
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_DocumentObjectType
     */
    public $Supplier_Invoice_Reference;
    /**
     * The Document_Link
     * Meta information extracted from the WSDL
     * - documentation: Document Link
     * - minOccurs: 0
     * @var string
     */
    public $Document_Link;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Supplier_Invoice_Links_ResponseType
     * @uses Put_Supplier_Invoice_Links_ResponseType::setSupplier_Invoice_Reference()
     * @uses Put_Supplier_Invoice_Links_ResponseType::setDocument_Link()
     * @uses Put_Supplier_Invoice_Links_ResponseType::setVersion()
     * @param \StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Reference
     * @param string $document_Link
     * @param string $version
     */
    public function __construct(\StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Reference = null, $document_Link = null, $version = null)
    {
        $this
            ->setSupplier_Invoice_Reference($supplier_Invoice_Reference)
            ->setDocument_Link($document_Link)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Invoice_Reference value
     * @return \StructType\Supplier_Invoice_DocumentObjectType|null
     */
    public function getSupplier_Invoice_Reference()
    {
        return $this->Supplier_Invoice_Reference;
    }
    /**
     * Set Supplier_Invoice_Reference value
     * @param \StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Reference
     * @return \StructType\Put_Supplier_Invoice_Links_ResponseType
     */
    public function setSupplier_Invoice_Reference(\StructType\Supplier_Invoice_DocumentObjectType $supplier_Invoice_Reference = null)
    {
        $this->Supplier_Invoice_Reference = $supplier_Invoice_Reference;
        return $this;
    }
    /**
     * Get Document_Link value
     * @return string|null
     */
    public function getDocument_Link()
    {
        return $this->Document_Link;
    }
    /**
     * Set Document_Link value
     * @param string $document_Link
     * @return \StructType\Put_Supplier_Invoice_Links_ResponseType
     */
    public function setDocument_Link($document_Link = null)
    {
        // validation for constraint: string
        if (!is_null($document_Link) && !is_string($document_Link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Link, true), gettype($document_Link)), __LINE__);
        }
        $this->Document_Link = $document_Link;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Supplier_Invoice_Links_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
