<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Portfolio_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Project Portfolio Response Data
 * @subpackage Structs
 */
class Project_Portfolio_Response_DataType extends AbstractStructBase
{
    /**
     * The Project_Portfolio
     * Meta information extracted from the WSDL
     * - documentation: Project Portfolio
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_PortfolioType[]
     */
    public $Project_Portfolio;
    /**
     * Constructor method for Project_Portfolio_Response_DataType
     * @uses Project_Portfolio_Response_DataType::setProject_Portfolio()
     * @param \StructType\Project_PortfolioType[] $project_Portfolio
     */
    public function __construct(array $project_Portfolio = array())
    {
        $this
            ->setProject_Portfolio($project_Portfolio);
    }
    /**
     * Get Project_Portfolio value
     * @return \StructType\Project_PortfolioType[]|null
     */
    public function getProject_Portfolio()
    {
        return $this->Project_Portfolio;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Portfolio method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Portfolio method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_PortfolioForArrayConstraintsFromSetProject_Portfolio(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Portfolio_Response_DataTypeProject_PortfolioItem) {
            // validation for constraint: itemType
            if (!$project_Portfolio_Response_DataTypeProject_PortfolioItem instanceof \StructType\Project_PortfolioType) {
                $invalidValues[] = is_object($project_Portfolio_Response_DataTypeProject_PortfolioItem) ? get_class($project_Portfolio_Response_DataTypeProject_PortfolioItem) : sprintf('%s(%s)', gettype($project_Portfolio_Response_DataTypeProject_PortfolioItem), var_export($project_Portfolio_Response_DataTypeProject_PortfolioItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Portfolio property can only contain items of type \StructType\Project_PortfolioType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Portfolio value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_PortfolioType[] $project_Portfolio
     * @return \StructType\Project_Portfolio_Response_DataType
     */
    public function setProject_Portfolio(array $project_Portfolio = array())
    {
        // validation for constraint: array
        if ('' !== ($project_PortfolioArrayErrorMessage = self::validateProject_PortfolioForArrayConstraintsFromSetProject_Portfolio($project_Portfolio))) {
            throw new \InvalidArgumentException($project_PortfolioArrayErrorMessage, __LINE__);
        }
        $this->Project_Portfolio = $project_Portfolio;
        return $this;
    }
    /**
     * Add item to Project_Portfolio value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_PortfolioType $item
     * @return \StructType\Project_Portfolio_Response_DataType
     */
    public function addToProject_Portfolio(\StructType\Project_PortfolioType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_PortfolioType) {
            throw new \InvalidArgumentException(sprintf('The Project_Portfolio property can only contain items of type \StructType\Project_PortfolioType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Portfolio[] = $item;
        return $this;
    }
}
