<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This validation prevents users from erroneously adding a non-configured Worktag Type as a Balancing Worktag. | This validation prevents customers from adding a customer contract template to an opportunity project. | This validation
 * requires the customer field when the project references a valid customer contract template. | This validation prevents entering a customer contract template without project lines. | This validation requires the company field when the project
 * references a valid customer contract template. | This validation requires the billable field when the project references a valid customer contract template. | This validation prevents adding, removing, or replacing a valid customer contract template
 * on an approved project. | Confirms that the allowed related worktags are valid for use with the company. | Confirms that the default related worktags are valid for use with the company. | Added Validation to check the balancing worktag is valid to
 * use with the company. | Added Validation to check the optional balancing worktags are valid to use with the company. | Added validation to require the user to specify a value for Optional Balancing Worktags that were set as Default Required | Added a
 * validation to prevent a Project from being tagged with a Project Optional Balancing Worktag. | Added validation to check that a project cannot have 2 Optional Balancing Worktags of the same Worktag Type. | Added validation to check that the Optional
 * Balancing Worktag types are among the allowed Worktag Types specified by the Maintain Worktag Balancing Configuration task. | Added a validation to ensure that the project is a capital project and that capital project transactions do not already
 * exist on the project if you submit Optional Balancing Worktags. | Element containing project data to be submitted for approval. The actual project object will not be created unless the project is approved.
 * @subpackage Structs
 */
class Project_DataType extends AbstractStructBase
{
    /**
     * The Workday_Project_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for the Project
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Workday_Project_ID;
    /**
     * The Locked_in_Workday
     * Meta information extracted from the WSDL
     * - documentation: Set to True to disable editing of the Project inside the Workday application. Project, Project Task and Project Pools can only be updated from the web service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Locked_in_Workday;
    /**
     * The Project_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Hierarchy - this is required for creating a project.
     * - minOccurs: 0
     * @var \StructType\Project_HierarchyObjectType
     */
    public $Project_Hierarchy_Reference;
    /**
     * The Optional_Project_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Optional project hierarchies.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_HierarchyObjectType[]
     */
    public $Optional_Project_Hierarchy_Reference;
    /**
     * The Project_Event_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: Project event status (Approved, Canceled, Denied or In Progress)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $Project_Event_Status_Reference;
    /**
     * The Associated_Templates_from_Project_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Project Template.
     * - minOccurs: 0
     * @var \StructType\Project_TemplateObjectType
     */
    public $Associated_Templates_from_Project_Template_Reference;
    /**
     * The Customer_Contract_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Customer Contract Template that has project lines.
     * - minOccurs: 0
     * @var \StructType\Customer_Contract_TemplateObjectType
     */
    public $Customer_Contract_Template_Reference;
    /**
     * The Project_Name
     * Meta information extracted from the WSDL
     * - documentation: Free form text field for a meaningful Project Name
     * - maxOccurs: 1
     * @var string
     */
    public $Project_Name;
    /**
     * The Worktag_Only
     * Meta information extracted from the WSDL
     * - documentation: Boolean to indicate if project is used as a worktag only and not a complete workday project instance
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Worktag_Only;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates the Project is inactive. A project may also be inactivated by a project hierarchy as indicated by the 'Inactivated By Hierarchy Reference'. In which case, the project is considered Inactive even though this Boolean returns
     * False. Changes to an inactive project are ignored. Reactivating a project can only be done on the project if it was explicitly marked 'Inactive' or by reactivating the hierarchy that made the project inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Project_State_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the state of the project. This can be Opportunity Project or Project.
     * @var \StructType\Project_StateObjectType
     */
    public $Project_State_Reference;
    /**
     * The Project_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the status of the project.
     * - minOccurs: 0
     * @var \StructType\Project_StageObjectType
     */
    public $Project_Status_Reference;
    /**
     * The Include_Project_ID_in_Name
     * Meta information extracted from the WSDL
     * - documentation: Boolean value indicating if the Project ID will be included in the display of the Project Name.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Project_ID_in_Name;
    /**
     * The Project_Owner_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the worker who owns the project
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Project_Owner_Reference;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Project Start Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: Project End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency reference. Defaults to the tenant currency if no value is provided.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Resource_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Resource Plan Reference
     * - minOccurs: 0
     * @var \StructType\Project_Resource_PlanObjectType
     */
    public $Resource_Plan_Reference;
    /**
     * The Billable
     * Meta information extracted from the WSDL
     * - documentation: Boolean indicating whether the Project is billable or non-billable. Defaults to non-billable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Billable;
    /**
     * The Capital
     * Meta information extracted from the WSDL
     * - documentation: Boolean indicating whether the Project is capital or non-capital. Defaults to non-capital.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Capital;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Free form text field for a meaningful Project Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Overall_Percent_Complete
     * Meta information extracted from the WSDL
     * - documentation: Percent in decimal format, ex: enter 1 for 100%, .5 for 50%, etc
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Overall_Percent_Complete;
    /**
     * The Probability
     * Meta information extracted from the WSDL
     * - documentation: Percent in decimal format, ex: enter 1 for 100%, .5 for 50%, etc
     * - base: xsd:decimal
     * - fractionDigits: 4
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 7
     * @var float
     */
    public $Probability;
    /**
     * The Risk_Level_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a rating indicating the Risk Level of the project.
     * - minOccurs: 0
     * @var \StructType\Risk_LevelObjectType
     */
    public $Risk_Level_Reference;
    /**
     * The Priority_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a rating indicating the Work Priority of the project.
     * - minOccurs: 0
     * @var \StructType\Work_PriorityObjectType
     */
    public $Priority_Reference;
    /**
     * The Importance_Rating_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a rating indicating the Importance Rating of the project.
     * - minOccurs: 0
     * @var \StructType\Importance_RatingObjectType
     */
    public $Importance_Rating_Reference;
    /**
     * The Success_Rating_Reference
     * Meta information extracted from the WSDL
     * - documentation: Success rating reference for the Project. This value is only persisted if the project's Overall Percent Complete equals 100%.
     * - minOccurs: 0
     * @var \StructType\Success_RatingObjectType
     */
    public $Success_Rating_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company that the project is for.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Customer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Customer that the Project is for.
     * - minOccurs: 0
     * @var \StructType\CustomerObjectType
     */
    public $Customer_Reference;
    /**
     * The Project_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Project Group that the project belongs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_GroupObjectType[]
     */
    public $Project_Group_Reference;
    /**
     * The External_Project_Reference_Name
     * Meta information extracted from the WSDL
     * - documentation: Free form text field to provide Project Reference description. This is not a Workday reference instance.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Project_Reference_Name;
    /**
     * The External_Link
     * Meta information extracted from the WSDL
     * - documentation: The link to an external site.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Link;
    /**
     * The Problem_Statement
     * Meta information extracted from the WSDL
     * - documentation: Free form rich text field providing details of the problem that the project hopes to resolve.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Problem_Statement;
    /**
     * The Objective
     * Meta information extracted from the WSDL
     * - documentation: Free form rich text field providing details of the overall objective of the project.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Objective;
    /**
     * The In_Scope
     * Meta information extracted from the WSDL
     * - documentation: Free form rich text field providing details of what portions of the project are in scope.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $In_Scope;
    /**
     * The Out_of_Scope
     * Meta information extracted from the WSDL
     * - documentation: Free form rich text field providing details of what portions of the project are out of scope.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Out_of_Scope;
    /**
     * The Measures_of_Success
     * Meta information extracted from the WSDL
     * - documentation: Free form rich text field providing details of how the project will be measured for success.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Measures_of_Success;
    /**
     * The Project_Overview
     * Meta information extracted from the WSDL
     * - documentation: Free form rich text field that provides more specific details about the project beyond the brief project description.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Overview;
    /**
     * The Initiative_Reference
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: Initiative that the Project belongs to.
     * - minOccurs: 0
     * @var \StructType\InitiativeObjectType
     */
    public $Initiative_Reference;
    /**
     * The Estimated_Budget
     * Meta information extracted from the WSDL
     * - documentation: The estimated project budget amount in the currency context identified for the project.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Estimated_Budget;
    /**
     * The Estimated_Revenue
     * Meta information extracted from the WSDL
     * - documentation: The estimated revenue amount in the currency context identified for the project.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Estimated_Revenue;
    /**
     * The Realized_Revenue
     * Meta information extracted from the WSDL
     * - documentation: The realized revenue amount in the currency context identified for the project.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Realized_Revenue;
    /**
     * The Worktags_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Related_Worktag_Widget_DataType
     */
    public $Worktags_Data;
    /**
     * The Balancing_Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Balancing Worktag.
     * - minOccurs: 0
     * @var \StructType\Balancing_WorktagObjectType
     */
    public $Balancing_Worktag_Reference;
    /**
     * The Optional_Balancing_Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Existing Optional Balancing Worktag.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Optional_Balancing_Worktag_Reference;
    /**
     * The Project_Dependencies_Reference
     * Meta information extracted from the WSDL
     * - documentation: The list of projects defined as dependencies to this project.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProjectObjectType[]
     */
    public $Project_Dependencies_Reference;
    /**
     * The Project_Prerequisite_For_Reference
     * Meta information extracted from the WSDL
     * - documentation: READ ONLY: The list of projects defined as prerequisites to this project.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_AbstractObjectType[]
     */
    public $Project_Prerequisite_For_Reference;
    /**
     * The Project_Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Project_Attachment_Data;
    /**
     * Constructor method for Project_DataType
     * @uses Project_DataType::setWorkday_Project_ID()
     * @uses Project_DataType::setLocked_in_Workday()
     * @uses Project_DataType::setProject_Hierarchy_Reference()
     * @uses Project_DataType::setOptional_Project_Hierarchy_Reference()
     * @uses Project_DataType::setProject_Event_Status_Reference()
     * @uses Project_DataType::setAssociated_Templates_from_Project_Template_Reference()
     * @uses Project_DataType::setCustomer_Contract_Template_Reference()
     * @uses Project_DataType::setProject_Name()
     * @uses Project_DataType::setWorktag_Only()
     * @uses Project_DataType::setInactive()
     * @uses Project_DataType::setProject_State_Reference()
     * @uses Project_DataType::setProject_Status_Reference()
     * @uses Project_DataType::setInclude_Project_ID_in_Name()
     * @uses Project_DataType::setProject_Owner_Reference()
     * @uses Project_DataType::setStart_Date()
     * @uses Project_DataType::setEnd_Date()
     * @uses Project_DataType::setCurrency_Reference()
     * @uses Project_DataType::setResource_Plan_Reference()
     * @uses Project_DataType::setBillable()
     * @uses Project_DataType::setCapital()
     * @uses Project_DataType::setDescription()
     * @uses Project_DataType::setOverall_Percent_Complete()
     * @uses Project_DataType::setProbability()
     * @uses Project_DataType::setRisk_Level_Reference()
     * @uses Project_DataType::setPriority_Reference()
     * @uses Project_DataType::setImportance_Rating_Reference()
     * @uses Project_DataType::setSuccess_Rating_Reference()
     * @uses Project_DataType::setCompany_Reference()
     * @uses Project_DataType::setCustomer_Reference()
     * @uses Project_DataType::setProject_Group_Reference()
     * @uses Project_DataType::setExternal_Project_Reference_Name()
     * @uses Project_DataType::setExternal_Link()
     * @uses Project_DataType::setProblem_Statement()
     * @uses Project_DataType::setObjective()
     * @uses Project_DataType::setIn_Scope()
     * @uses Project_DataType::setOut_of_Scope()
     * @uses Project_DataType::setMeasures_of_Success()
     * @uses Project_DataType::setProject_Overview()
     * @uses Project_DataType::setInitiative_Reference()
     * @uses Project_DataType::setEstimated_Budget()
     * @uses Project_DataType::setEstimated_Revenue()
     * @uses Project_DataType::setRealized_Revenue()
     * @uses Project_DataType::setWorktags_Data()
     * @uses Project_DataType::setBalancing_Worktag_Reference()
     * @uses Project_DataType::setOptional_Balancing_Worktag_Reference()
     * @uses Project_DataType::setProject_Dependencies_Reference()
     * @uses Project_DataType::setProject_Prerequisite_For_Reference()
     * @uses Project_DataType::setProject_Attachment_Data()
     * @param string $workday_Project_ID
     * @param bool $locked_in_Workday
     * @param \StructType\Project_HierarchyObjectType $project_Hierarchy_Reference
     * @param \StructType\Project_HierarchyObjectType[] $optional_Project_Hierarchy_Reference
     * @param \StructType\Document_StatusObjectType[] $project_Event_Status_Reference
     * @param \StructType\Project_TemplateObjectType $associated_Templates_from_Project_Template_Reference
     * @param \StructType\Customer_Contract_TemplateObjectType $customer_Contract_Template_Reference
     * @param string $project_Name
     * @param bool $worktag_Only
     * @param bool $inactive
     * @param \StructType\Project_StateObjectType $project_State_Reference
     * @param \StructType\Project_StageObjectType $project_Status_Reference
     * @param bool $include_Project_ID_in_Name
     * @param \StructType\WorkerObjectType $project_Owner_Reference
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Project_Resource_PlanObjectType $resource_Plan_Reference
     * @param bool $billable
     * @param bool $capital
     * @param string $description
     * @param float $overall_Percent_Complete
     * @param float $probability
     * @param \StructType\Risk_LevelObjectType $risk_Level_Reference
     * @param \StructType\Work_PriorityObjectType $priority_Reference
     * @param \StructType\Importance_RatingObjectType $importance_Rating_Reference
     * @param \StructType\Success_RatingObjectType $success_Rating_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\CustomerObjectType $customer_Reference
     * @param \StructType\Project_GroupObjectType[] $project_Group_Reference
     * @param string $external_Project_Reference_Name
     * @param string $external_Link
     * @param string $problem_Statement
     * @param string $objective
     * @param string $in_Scope
     * @param string $out_of_Scope
     * @param string $measures_of_Success
     * @param string $project_Overview
     * @param \StructType\InitiativeObjectType $initiative_Reference
     * @param float $estimated_Budget
     * @param float $estimated_Revenue
     * @param float $realized_Revenue
     * @param \StructType\Related_Worktag_Widget_DataType $worktags_Data
     * @param \StructType\Balancing_WorktagObjectType $balancing_Worktag_Reference
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $optional_Balancing_Worktag_Reference
     * @param \StructType\ProjectObjectType[] $project_Dependencies_Reference
     * @param \StructType\Project_AbstractObjectType[] $project_Prerequisite_For_Reference
     * @param \StructType\Financials_Attachment_DataType[] $project_Attachment_Data
     */
    public function __construct($workday_Project_ID = null, $locked_in_Workday = null, \StructType\Project_HierarchyObjectType $project_Hierarchy_Reference = null, array $optional_Project_Hierarchy_Reference = array(), array $project_Event_Status_Reference = array(), \StructType\Project_TemplateObjectType $associated_Templates_from_Project_Template_Reference = null, \StructType\Customer_Contract_TemplateObjectType $customer_Contract_Template_Reference = null, $project_Name = null, $worktag_Only = null, $inactive = null, \StructType\Project_StateObjectType $project_State_Reference = null, \StructType\Project_StageObjectType $project_Status_Reference = null, $include_Project_ID_in_Name = null, \StructType\WorkerObjectType $project_Owner_Reference = null, $start_Date = null, $end_Date = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\Project_Resource_PlanObjectType $resource_Plan_Reference = null, $billable = null, $capital = null, $description = null, $overall_Percent_Complete = null, $probability = null, \StructType\Risk_LevelObjectType $risk_Level_Reference = null, \StructType\Work_PriorityObjectType $priority_Reference = null, \StructType\Importance_RatingObjectType $importance_Rating_Reference = null, \StructType\Success_RatingObjectType $success_Rating_Reference = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\CustomerObjectType $customer_Reference = null, array $project_Group_Reference = array(), $external_Project_Reference_Name = null, $external_Link = null, $problem_Statement = null, $objective = null, $in_Scope = null, $out_of_Scope = null, $measures_of_Success = null, $project_Overview = null, \StructType\InitiativeObjectType $initiative_Reference = null, $estimated_Budget = null, $estimated_Revenue = null, $realized_Revenue = null, \StructType\Related_Worktag_Widget_DataType $worktags_Data = null, \StructType\Balancing_WorktagObjectType $balancing_Worktag_Reference = null, array $optional_Balancing_Worktag_Reference = array(), array $project_Dependencies_Reference = array(), array $project_Prerequisite_For_Reference = array(), array $project_Attachment_Data = array())
    {
        $this
            ->setWorkday_Project_ID($workday_Project_ID)
            ->setLocked_in_Workday($locked_in_Workday)
            ->setProject_Hierarchy_Reference($project_Hierarchy_Reference)
            ->setOptional_Project_Hierarchy_Reference($optional_Project_Hierarchy_Reference)
            ->setProject_Event_Status_Reference($project_Event_Status_Reference)
            ->setAssociated_Templates_from_Project_Template_Reference($associated_Templates_from_Project_Template_Reference)
            ->setCustomer_Contract_Template_Reference($customer_Contract_Template_Reference)
            ->setProject_Name($project_Name)
            ->setWorktag_Only($worktag_Only)
            ->setInactive($inactive)
            ->setProject_State_Reference($project_State_Reference)
            ->setProject_Status_Reference($project_Status_Reference)
            ->setInclude_Project_ID_in_Name($include_Project_ID_in_Name)
            ->setProject_Owner_Reference($project_Owner_Reference)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setCurrency_Reference($currency_Reference)
            ->setResource_Plan_Reference($resource_Plan_Reference)
            ->setBillable($billable)
            ->setCapital($capital)
            ->setDescription($description)
            ->setOverall_Percent_Complete($overall_Percent_Complete)
            ->setProbability($probability)
            ->setRisk_Level_Reference($risk_Level_Reference)
            ->setPriority_Reference($priority_Reference)
            ->setImportance_Rating_Reference($importance_Rating_Reference)
            ->setSuccess_Rating_Reference($success_Rating_Reference)
            ->setCompany_Reference($company_Reference)
            ->setCustomer_Reference($customer_Reference)
            ->setProject_Group_Reference($project_Group_Reference)
            ->setExternal_Project_Reference_Name($external_Project_Reference_Name)
            ->setExternal_Link($external_Link)
            ->setProblem_Statement($problem_Statement)
            ->setObjective($objective)
            ->setIn_Scope($in_Scope)
            ->setOut_of_Scope($out_of_Scope)
            ->setMeasures_of_Success($measures_of_Success)
            ->setProject_Overview($project_Overview)
            ->setInitiative_Reference($initiative_Reference)
            ->setEstimated_Budget($estimated_Budget)
            ->setEstimated_Revenue($estimated_Revenue)
            ->setRealized_Revenue($realized_Revenue)
            ->setWorktags_Data($worktags_Data)
            ->setBalancing_Worktag_Reference($balancing_Worktag_Reference)
            ->setOptional_Balancing_Worktag_Reference($optional_Balancing_Worktag_Reference)
            ->setProject_Dependencies_Reference($project_Dependencies_Reference)
            ->setProject_Prerequisite_For_Reference($project_Prerequisite_For_Reference)
            ->setProject_Attachment_Data($project_Attachment_Data);
    }
    /**
     * Get Workday_Project_ID value
     * @return string|null
     */
    public function getWorkday_Project_ID()
    {
        return $this->Workday_Project_ID;
    }
    /**
     * Set Workday_Project_ID value
     * @param string $workday_Project_ID
     * @return \StructType\Project_DataType
     */
    public function setWorkday_Project_ID($workday_Project_ID = null)
    {
        // validation for constraint: string
        if (!is_null($workday_Project_ID) && !is_string($workday_Project_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workday_Project_ID, true), gettype($workday_Project_ID)), __LINE__);
        }
        $this->Workday_Project_ID = $workday_Project_ID;
        return $this;
    }
    /**
     * Get Locked_in_Workday value
     * @return bool|null
     */
    public function getLocked_in_Workday()
    {
        return $this->Locked_in_Workday;
    }
    /**
     * Set Locked_in_Workday value
     * @param bool $locked_in_Workday
     * @return \StructType\Project_DataType
     */
    public function setLocked_in_Workday($locked_in_Workday = null)
    {
        // validation for constraint: boolean
        if (!is_null($locked_in_Workday) && !is_bool($locked_in_Workday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locked_in_Workday, true), gettype($locked_in_Workday)), __LINE__);
        }
        $this->Locked_in_Workday = $locked_in_Workday;
        return $this;
    }
    /**
     * Get Project_Hierarchy_Reference value
     * @return \StructType\Project_HierarchyObjectType|null
     */
    public function getProject_Hierarchy_Reference()
    {
        return $this->Project_Hierarchy_Reference;
    }
    /**
     * Set Project_Hierarchy_Reference value
     * @param \StructType\Project_HierarchyObjectType $project_Hierarchy_Reference
     * @return \StructType\Project_DataType
     */
    public function setProject_Hierarchy_Reference(\StructType\Project_HierarchyObjectType $project_Hierarchy_Reference = null)
    {
        $this->Project_Hierarchy_Reference = $project_Hierarchy_Reference;
        return $this;
    }
    /**
     * Get Optional_Project_Hierarchy_Reference value
     * @return \StructType\Project_HierarchyObjectType[]|null
     */
    public function getOptional_Project_Hierarchy_Reference()
    {
        return $this->Optional_Project_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOptional_Project_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptional_Project_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptional_Project_Hierarchy_ReferenceForArrayConstraintsFromSetOptional_Project_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_DataTypeOptional_Project_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_DataTypeOptional_Project_Hierarchy_ReferenceItem instanceof \StructType\Project_HierarchyObjectType) {
                $invalidValues[] = is_object($project_DataTypeOptional_Project_Hierarchy_ReferenceItem) ? get_class($project_DataTypeOptional_Project_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($project_DataTypeOptional_Project_Hierarchy_ReferenceItem), var_export($project_DataTypeOptional_Project_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Optional_Project_Hierarchy_Reference property can only contain items of type \StructType\Project_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Optional_Project_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_HierarchyObjectType[] $optional_Project_Hierarchy_Reference
     * @return \StructType\Project_DataType
     */
    public function setOptional_Project_Hierarchy_Reference(array $optional_Project_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($optional_Project_Hierarchy_ReferenceArrayErrorMessage = self::validateOptional_Project_Hierarchy_ReferenceForArrayConstraintsFromSetOptional_Project_Hierarchy_Reference($optional_Project_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($optional_Project_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Optional_Project_Hierarchy_Reference = $optional_Project_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Optional_Project_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_HierarchyObjectType $item
     * @return \StructType\Project_DataType
     */
    public function addToOptional_Project_Hierarchy_Reference(\StructType\Project_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Optional_Project_Hierarchy_Reference property can only contain items of type \StructType\Project_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Optional_Project_Hierarchy_Reference[] = $item;
        return $this;
    }
    /**
     * Get Project_Event_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getProject_Event_Status_Reference()
    {
        return $this->Project_Event_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Event_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Event_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Event_Status_ReferenceForArrayConstraintsFromSetProject_Event_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_DataTypeProject_Event_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_DataTypeProject_Event_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($project_DataTypeProject_Event_Status_ReferenceItem) ? get_class($project_DataTypeProject_Event_Status_ReferenceItem) : sprintf('%s(%s)', gettype($project_DataTypeProject_Event_Status_ReferenceItem), var_export($project_DataTypeProject_Event_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Event_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Event_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $project_Event_Status_Reference
     * @return \StructType\Project_DataType
     */
    public function setProject_Event_Status_Reference(array $project_Event_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Event_Status_ReferenceArrayErrorMessage = self::validateProject_Event_Status_ReferenceForArrayConstraintsFromSetProject_Event_Status_Reference($project_Event_Status_Reference))) {
            throw new \InvalidArgumentException($project_Event_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Event_Status_Reference = $project_Event_Status_Reference;
        return $this;
    }
    /**
     * Add item to Project_Event_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Project_DataType
     */
    public function addToProject_Event_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Event_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Event_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Associated_Templates_from_Project_Template_Reference value
     * @return \StructType\Project_TemplateObjectType|null
     */
    public function getAssociated_Templates_from_Project_Template_Reference()
    {
        return $this->Associated_Templates_from_Project_Template_Reference;
    }
    /**
     * Set Associated_Templates_from_Project_Template_Reference value
     * @param \StructType\Project_TemplateObjectType $associated_Templates_from_Project_Template_Reference
     * @return \StructType\Project_DataType
     */
    public function setAssociated_Templates_from_Project_Template_Reference(\StructType\Project_TemplateObjectType $associated_Templates_from_Project_Template_Reference = null)
    {
        $this->Associated_Templates_from_Project_Template_Reference = $associated_Templates_from_Project_Template_Reference;
        return $this;
    }
    /**
     * Get Customer_Contract_Template_Reference value
     * @return \StructType\Customer_Contract_TemplateObjectType|null
     */
    public function getCustomer_Contract_Template_Reference()
    {
        return $this->Customer_Contract_Template_Reference;
    }
    /**
     * Set Customer_Contract_Template_Reference value
     * @param \StructType\Customer_Contract_TemplateObjectType $customer_Contract_Template_Reference
     * @return \StructType\Project_DataType
     */
    public function setCustomer_Contract_Template_Reference(\StructType\Customer_Contract_TemplateObjectType $customer_Contract_Template_Reference = null)
    {
        $this->Customer_Contract_Template_Reference = $customer_Contract_Template_Reference;
        return $this;
    }
    /**
     * Get Project_Name value
     * @return string|null
     */
    public function getProject_Name()
    {
        return $this->Project_Name;
    }
    /**
     * Set Project_Name value
     * @param string $project_Name
     * @return \StructType\Project_DataType
     */
    public function setProject_Name($project_Name = null)
    {
        // validation for constraint: string
        if (!is_null($project_Name) && !is_string($project_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Name, true), gettype($project_Name)), __LINE__);
        }
        $this->Project_Name = $project_Name;
        return $this;
    }
    /**
     * Get Worktag_Only value
     * @return bool|null
     */
    public function getWorktag_Only()
    {
        return $this->Worktag_Only;
    }
    /**
     * Set Worktag_Only value
     * @param bool $worktag_Only
     * @return \StructType\Project_DataType
     */
    public function setWorktag_Only($worktag_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($worktag_Only) && !is_bool($worktag_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($worktag_Only, true), gettype($worktag_Only)), __LINE__);
        }
        $this->Worktag_Only = $worktag_Only;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Project_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Project_State_Reference value
     * @return \StructType\Project_StateObjectType|null
     */
    public function getProject_State_Reference()
    {
        return $this->Project_State_Reference;
    }
    /**
     * Set Project_State_Reference value
     * @param \StructType\Project_StateObjectType $project_State_Reference
     * @return \StructType\Project_DataType
     */
    public function setProject_State_Reference(\StructType\Project_StateObjectType $project_State_Reference = null)
    {
        $this->Project_State_Reference = $project_State_Reference;
        return $this;
    }
    /**
     * Get Project_Status_Reference value
     * @return \StructType\Project_StageObjectType|null
     */
    public function getProject_Status_Reference()
    {
        return $this->Project_Status_Reference;
    }
    /**
     * Set Project_Status_Reference value
     * @param \StructType\Project_StageObjectType $project_Status_Reference
     * @return \StructType\Project_DataType
     */
    public function setProject_Status_Reference(\StructType\Project_StageObjectType $project_Status_Reference = null)
    {
        $this->Project_Status_Reference = $project_Status_Reference;
        return $this;
    }
    /**
     * Get Include_Project_ID_in_Name value
     * @return bool|null
     */
    public function getInclude_Project_ID_in_Name()
    {
        return $this->Include_Project_ID_in_Name;
    }
    /**
     * Set Include_Project_ID_in_Name value
     * @param bool $include_Project_ID_in_Name
     * @return \StructType\Project_DataType
     */
    public function setInclude_Project_ID_in_Name($include_Project_ID_in_Name = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Project_ID_in_Name) && !is_bool($include_Project_ID_in_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Project_ID_in_Name, true), gettype($include_Project_ID_in_Name)), __LINE__);
        }
        $this->Include_Project_ID_in_Name = $include_Project_ID_in_Name;
        return $this;
    }
    /**
     * Get Project_Owner_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getProject_Owner_Reference()
    {
        return $this->Project_Owner_Reference;
    }
    /**
     * Set Project_Owner_Reference value
     * @param \StructType\WorkerObjectType $project_Owner_Reference
     * @return \StructType\Project_DataType
     */
    public function setProject_Owner_Reference(\StructType\WorkerObjectType $project_Owner_Reference = null)
    {
        $this->Project_Owner_Reference = $project_Owner_Reference;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Project_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Project_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Project_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Resource_Plan_Reference value
     * @return \StructType\Project_Resource_PlanObjectType|null
     */
    public function getResource_Plan_Reference()
    {
        return $this->Resource_Plan_Reference;
    }
    /**
     * Set Resource_Plan_Reference value
     * @param \StructType\Project_Resource_PlanObjectType $resource_Plan_Reference
     * @return \StructType\Project_DataType
     */
    public function setResource_Plan_Reference(\StructType\Project_Resource_PlanObjectType $resource_Plan_Reference = null)
    {
        $this->Resource_Plan_Reference = $resource_Plan_Reference;
        return $this;
    }
    /**
     * Get Billable value
     * @return bool|null
     */
    public function getBillable()
    {
        return $this->Billable;
    }
    /**
     * Set Billable value
     * @param bool $billable
     * @return \StructType\Project_DataType
     */
    public function setBillable($billable = null)
    {
        // validation for constraint: boolean
        if (!is_null($billable) && !is_bool($billable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($billable, true), gettype($billable)), __LINE__);
        }
        $this->Billable = $billable;
        return $this;
    }
    /**
     * Get Capital value
     * @return bool|null
     */
    public function getCapital()
    {
        return $this->Capital;
    }
    /**
     * Set Capital value
     * @param bool $capital
     * @return \StructType\Project_DataType
     */
    public function setCapital($capital = null)
    {
        // validation for constraint: boolean
        if (!is_null($capital) && !is_bool($capital)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($capital, true), gettype($capital)), __LINE__);
        }
        $this->Capital = $capital;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Project_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Overall_Percent_Complete value
     * @return float|null
     */
    public function getOverall_Percent_Complete()
    {
        return $this->Overall_Percent_Complete;
    }
    /**
     * Set Overall_Percent_Complete value
     * @param float $overall_Percent_Complete
     * @return \StructType\Project_DataType
     */
    public function setOverall_Percent_Complete($overall_Percent_Complete = null)
    {
        // validation for constraint: float
        if (!is_null($overall_Percent_Complete) && !(is_float($overall_Percent_Complete) || is_numeric($overall_Percent_Complete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($overall_Percent_Complete, true), gettype($overall_Percent_Complete)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($overall_Percent_Complete) && mb_strlen(mb_substr($overall_Percent_Complete, false !== mb_strpos($overall_Percent_Complete, '.') ? mb_strpos($overall_Percent_Complete, '.') + 1 : mb_strlen($overall_Percent_Complete))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($overall_Percent_Complete, true), mb_strlen(mb_substr($overall_Percent_Complete, mb_strpos($overall_Percent_Complete, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($overall_Percent_Complete) && $overall_Percent_Complete < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($overall_Percent_Complete, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($overall_Percent_Complete) && mb_strlen(preg_replace('/(\D)/', '', $overall_Percent_Complete)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($overall_Percent_Complete, true), mb_strlen(preg_replace('/(\D)/', '', $overall_Percent_Complete))), __LINE__);
        }
        $this->Overall_Percent_Complete = $overall_Percent_Complete;
        return $this;
    }
    /**
     * Get Probability value
     * @return float|null
     */
    public function getProbability()
    {
        return $this->Probability;
    }
    /**
     * Set Probability value
     * @param float $probability
     * @return \StructType\Project_DataType
     */
    public function setProbability($probability = null)
    {
        // validation for constraint: float
        if (!is_null($probability) && !(is_float($probability) || is_numeric($probability))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($probability, true), gettype($probability)), __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($probability) && mb_strlen(mb_substr($probability, false !== mb_strpos($probability, '.') ? mb_strpos($probability, '.') + 1 : mb_strlen($probability))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($probability, true), mb_strlen(mb_substr($probability, mb_strpos($probability, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($probability) && $probability < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($probability, true)), __LINE__);
        }
        // validation for constraint: totalDigits(7)
        if (!is_null($probability) && mb_strlen(preg_replace('/(\D)/', '', $probability)) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 7 digits, "%d" given', var_export($probability, true), mb_strlen(preg_replace('/(\D)/', '', $probability))), __LINE__);
        }
        $this->Probability = $probability;
        return $this;
    }
    /**
     * Get Risk_Level_Reference value
     * @return \StructType\Risk_LevelObjectType|null
     */
    public function getRisk_Level_Reference()
    {
        return $this->Risk_Level_Reference;
    }
    /**
     * Set Risk_Level_Reference value
     * @param \StructType\Risk_LevelObjectType $risk_Level_Reference
     * @return \StructType\Project_DataType
     */
    public function setRisk_Level_Reference(\StructType\Risk_LevelObjectType $risk_Level_Reference = null)
    {
        $this->Risk_Level_Reference = $risk_Level_Reference;
        return $this;
    }
    /**
     * Get Priority_Reference value
     * @return \StructType\Work_PriorityObjectType|null
     */
    public function getPriority_Reference()
    {
        return $this->Priority_Reference;
    }
    /**
     * Set Priority_Reference value
     * @param \StructType\Work_PriorityObjectType $priority_Reference
     * @return \StructType\Project_DataType
     */
    public function setPriority_Reference(\StructType\Work_PriorityObjectType $priority_Reference = null)
    {
        $this->Priority_Reference = $priority_Reference;
        return $this;
    }
    /**
     * Get Importance_Rating_Reference value
     * @return \StructType\Importance_RatingObjectType|null
     */
    public function getImportance_Rating_Reference()
    {
        return $this->Importance_Rating_Reference;
    }
    /**
     * Set Importance_Rating_Reference value
     * @param \StructType\Importance_RatingObjectType $importance_Rating_Reference
     * @return \StructType\Project_DataType
     */
    public function setImportance_Rating_Reference(\StructType\Importance_RatingObjectType $importance_Rating_Reference = null)
    {
        $this->Importance_Rating_Reference = $importance_Rating_Reference;
        return $this;
    }
    /**
     * Get Success_Rating_Reference value
     * @return \StructType\Success_RatingObjectType|null
     */
    public function getSuccess_Rating_Reference()
    {
        return $this->Success_Rating_Reference;
    }
    /**
     * Set Success_Rating_Reference value
     * @param \StructType\Success_RatingObjectType $success_Rating_Reference
     * @return \StructType\Project_DataType
     */
    public function setSuccess_Rating_Reference(\StructType\Success_RatingObjectType $success_Rating_Reference = null)
    {
        $this->Success_Rating_Reference = $success_Rating_Reference;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Project_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Customer_Reference value
     * @return \StructType\CustomerObjectType|null
     */
    public function getCustomer_Reference()
    {
        return $this->Customer_Reference;
    }
    /**
     * Set Customer_Reference value
     * @param \StructType\CustomerObjectType $customer_Reference
     * @return \StructType\Project_DataType
     */
    public function setCustomer_Reference(\StructType\CustomerObjectType $customer_Reference = null)
    {
        $this->Customer_Reference = $customer_Reference;
        return $this;
    }
    /**
     * Get Project_Group_Reference value
     * @return \StructType\Project_GroupObjectType[]|null
     */
    public function getProject_Group_Reference()
    {
        return $this->Project_Group_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Group_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Group_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Group_ReferenceForArrayConstraintsFromSetProject_Group_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_DataTypeProject_Group_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_DataTypeProject_Group_ReferenceItem instanceof \StructType\Project_GroupObjectType) {
                $invalidValues[] = is_object($project_DataTypeProject_Group_ReferenceItem) ? get_class($project_DataTypeProject_Group_ReferenceItem) : sprintf('%s(%s)', gettype($project_DataTypeProject_Group_ReferenceItem), var_export($project_DataTypeProject_Group_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Group_Reference property can only contain items of type \StructType\Project_GroupObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_GroupObjectType[] $project_Group_Reference
     * @return \StructType\Project_DataType
     */
    public function setProject_Group_Reference(array $project_Group_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Group_ReferenceArrayErrorMessage = self::validateProject_Group_ReferenceForArrayConstraintsFromSetProject_Group_Reference($project_Group_Reference))) {
            throw new \InvalidArgumentException($project_Group_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Group_Reference = $project_Group_Reference;
        return $this;
    }
    /**
     * Add item to Project_Group_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_GroupObjectType $item
     * @return \StructType\Project_DataType
     */
    public function addToProject_Group_Reference(\StructType\Project_GroupObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_GroupObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Group_Reference property can only contain items of type \StructType\Project_GroupObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Group_Reference[] = $item;
        return $this;
    }
    /**
     * Get External_Project_Reference_Name value
     * @return string|null
     */
    public function getExternal_Project_Reference_Name()
    {
        return $this->External_Project_Reference_Name;
    }
    /**
     * Set External_Project_Reference_Name value
     * @param string $external_Project_Reference_Name
     * @return \StructType\Project_DataType
     */
    public function setExternal_Project_Reference_Name($external_Project_Reference_Name = null)
    {
        // validation for constraint: string
        if (!is_null($external_Project_Reference_Name) && !is_string($external_Project_Reference_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Project_Reference_Name, true), gettype($external_Project_Reference_Name)), __LINE__);
        }
        $this->External_Project_Reference_Name = $external_Project_Reference_Name;
        return $this;
    }
    /**
     * Get External_Link value
     * @return string|null
     */
    public function getExternal_Link()
    {
        return $this->External_Link;
    }
    /**
     * Set External_Link value
     * @param string $external_Link
     * @return \StructType\Project_DataType
     */
    public function setExternal_Link($external_Link = null)
    {
        // validation for constraint: string
        if (!is_null($external_Link) && !is_string($external_Link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Link, true), gettype($external_Link)), __LINE__);
        }
        $this->External_Link = $external_Link;
        return $this;
    }
    /**
     * Get Problem_Statement value
     * @return string|null
     */
    public function getProblem_Statement()
    {
        return $this->Problem_Statement;
    }
    /**
     * Set Problem_Statement value
     * @param string $problem_Statement
     * @return \StructType\Project_DataType
     */
    public function setProblem_Statement($problem_Statement = null)
    {
        // validation for constraint: string
        if (!is_null($problem_Statement) && !is_string($problem_Statement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($problem_Statement, true), gettype($problem_Statement)), __LINE__);
        }
        $this->Problem_Statement = $problem_Statement;
        return $this;
    }
    /**
     * Get Objective value
     * @return string|null
     */
    public function getObjective()
    {
        return $this->Objective;
    }
    /**
     * Set Objective value
     * @param string $objective
     * @return \StructType\Project_DataType
     */
    public function setObjective($objective = null)
    {
        // validation for constraint: string
        if (!is_null($objective) && !is_string($objective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objective, true), gettype($objective)), __LINE__);
        }
        $this->Objective = $objective;
        return $this;
    }
    /**
     * Get In_Scope value
     * @return string|null
     */
    public function getIn_Scope()
    {
        return $this->In_Scope;
    }
    /**
     * Set In_Scope value
     * @param string $in_Scope
     * @return \StructType\Project_DataType
     */
    public function setIn_Scope($in_Scope = null)
    {
        // validation for constraint: string
        if (!is_null($in_Scope) && !is_string($in_Scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($in_Scope, true), gettype($in_Scope)), __LINE__);
        }
        $this->In_Scope = $in_Scope;
        return $this;
    }
    /**
     * Get Out_of_Scope value
     * @return string|null
     */
    public function getOut_of_Scope()
    {
        return $this->Out_of_Scope;
    }
    /**
     * Set Out_of_Scope value
     * @param string $out_of_Scope
     * @return \StructType\Project_DataType
     */
    public function setOut_of_Scope($out_of_Scope = null)
    {
        // validation for constraint: string
        if (!is_null($out_of_Scope) && !is_string($out_of_Scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($out_of_Scope, true), gettype($out_of_Scope)), __LINE__);
        }
        $this->Out_of_Scope = $out_of_Scope;
        return $this;
    }
    /**
     * Get Measures_of_Success value
     * @return string|null
     */
    public function getMeasures_of_Success()
    {
        return $this->Measures_of_Success;
    }
    /**
     * Set Measures_of_Success value
     * @param string $measures_of_Success
     * @return \StructType\Project_DataType
     */
    public function setMeasures_of_Success($measures_of_Success = null)
    {
        // validation for constraint: string
        if (!is_null($measures_of_Success) && !is_string($measures_of_Success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measures_of_Success, true), gettype($measures_of_Success)), __LINE__);
        }
        $this->Measures_of_Success = $measures_of_Success;
        return $this;
    }
    /**
     * Get Project_Overview value
     * @return string|null
     */
    public function getProject_Overview()
    {
        return $this->Project_Overview;
    }
    /**
     * Set Project_Overview value
     * @param string $project_Overview
     * @return \StructType\Project_DataType
     */
    public function setProject_Overview($project_Overview = null)
    {
        // validation for constraint: string
        if (!is_null($project_Overview) && !is_string($project_Overview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Overview, true), gettype($project_Overview)), __LINE__);
        }
        $this->Project_Overview = $project_Overview;
        return $this;
    }
    /**
     * Get Initiative_Reference value
     * @return \StructType\InitiativeObjectType|null
     */
    public function getInitiative_Reference()
    {
        return $this->Initiative_Reference;
    }
    /**
     * Set Initiative_Reference value
     * @param \StructType\InitiativeObjectType $initiative_Reference
     * @return \StructType\Project_DataType
     */
    public function setInitiative_Reference(\StructType\InitiativeObjectType $initiative_Reference = null)
    {
        $this->Initiative_Reference = $initiative_Reference;
        return $this;
    }
    /**
     * Get Estimated_Budget value
     * @return float|null
     */
    public function getEstimated_Budget()
    {
        return $this->Estimated_Budget;
    }
    /**
     * Set Estimated_Budget value
     * @param float $estimated_Budget
     * @return \StructType\Project_DataType
     */
    public function setEstimated_Budget($estimated_Budget = null)
    {
        // validation for constraint: float
        if (!is_null($estimated_Budget) && !(is_float($estimated_Budget) || is_numeric($estimated_Budget))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimated_Budget, true), gettype($estimated_Budget)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($estimated_Budget) && mb_strlen(mb_substr($estimated_Budget, false !== mb_strpos($estimated_Budget, '.') ? mb_strpos($estimated_Budget, '.') + 1 : mb_strlen($estimated_Budget))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($estimated_Budget, true), mb_strlen(mb_substr($estimated_Budget, mb_strpos($estimated_Budget, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($estimated_Budget) && $estimated_Budget < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($estimated_Budget, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($estimated_Budget) && mb_strlen(preg_replace('/(\D)/', '', $estimated_Budget)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($estimated_Budget, true), mb_strlen(preg_replace('/(\D)/', '', $estimated_Budget))), __LINE__);
        }
        $this->Estimated_Budget = $estimated_Budget;
        return $this;
    }
    /**
     * Get Estimated_Revenue value
     * @return float|null
     */
    public function getEstimated_Revenue()
    {
        return $this->Estimated_Revenue;
    }
    /**
     * Set Estimated_Revenue value
     * @param float $estimated_Revenue
     * @return \StructType\Project_DataType
     */
    public function setEstimated_Revenue($estimated_Revenue = null)
    {
        // validation for constraint: float
        if (!is_null($estimated_Revenue) && !(is_float($estimated_Revenue) || is_numeric($estimated_Revenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimated_Revenue, true), gettype($estimated_Revenue)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($estimated_Revenue) && mb_strlen(mb_substr($estimated_Revenue, false !== mb_strpos($estimated_Revenue, '.') ? mb_strpos($estimated_Revenue, '.') + 1 : mb_strlen($estimated_Revenue))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($estimated_Revenue, true), mb_strlen(mb_substr($estimated_Revenue, mb_strpos($estimated_Revenue, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($estimated_Revenue) && $estimated_Revenue < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($estimated_Revenue, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($estimated_Revenue) && mb_strlen(preg_replace('/(\D)/', '', $estimated_Revenue)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($estimated_Revenue, true), mb_strlen(preg_replace('/(\D)/', '', $estimated_Revenue))), __LINE__);
        }
        $this->Estimated_Revenue = $estimated_Revenue;
        return $this;
    }
    /**
     * Get Realized_Revenue value
     * @return float|null
     */
    public function getRealized_Revenue()
    {
        return $this->Realized_Revenue;
    }
    /**
     * Set Realized_Revenue value
     * @param float $realized_Revenue
     * @return \StructType\Project_DataType
     */
    public function setRealized_Revenue($realized_Revenue = null)
    {
        // validation for constraint: float
        if (!is_null($realized_Revenue) && !(is_float($realized_Revenue) || is_numeric($realized_Revenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($realized_Revenue, true), gettype($realized_Revenue)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($realized_Revenue) && mb_strlen(mb_substr($realized_Revenue, false !== mb_strpos($realized_Revenue, '.') ? mb_strpos($realized_Revenue, '.') + 1 : mb_strlen($realized_Revenue))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($realized_Revenue, true), mb_strlen(mb_substr($realized_Revenue, mb_strpos($realized_Revenue, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($realized_Revenue) && $realized_Revenue < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($realized_Revenue, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($realized_Revenue) && mb_strlen(preg_replace('/(\D)/', '', $realized_Revenue)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($realized_Revenue, true), mb_strlen(preg_replace('/(\D)/', '', $realized_Revenue))), __LINE__);
        }
        $this->Realized_Revenue = $realized_Revenue;
        return $this;
    }
    /**
     * Get Worktags_Data value
     * @return \StructType\Related_Worktag_Widget_DataType|null
     */
    public function getWorktags_Data()
    {
        return $this->Worktags_Data;
    }
    /**
     * Set Worktags_Data value
     * @param \StructType\Related_Worktag_Widget_DataType $worktags_Data
     * @return \StructType\Project_DataType
     */
    public function setWorktags_Data(\StructType\Related_Worktag_Widget_DataType $worktags_Data = null)
    {
        $this->Worktags_Data = $worktags_Data;
        return $this;
    }
    /**
     * Get Balancing_Worktag_Reference value
     * @return \StructType\Balancing_WorktagObjectType|null
     */
    public function getBalancing_Worktag_Reference()
    {
        return $this->Balancing_Worktag_Reference;
    }
    /**
     * Set Balancing_Worktag_Reference value
     * @param \StructType\Balancing_WorktagObjectType $balancing_Worktag_Reference
     * @return \StructType\Project_DataType
     */
    public function setBalancing_Worktag_Reference(\StructType\Balancing_WorktagObjectType $balancing_Worktag_Reference = null)
    {
        $this->Balancing_Worktag_Reference = $balancing_Worktag_Reference;
        return $this;
    }
    /**
     * Get Optional_Balancing_Worktag_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getOptional_Balancing_Worktag_Reference()
    {
        return $this->Optional_Balancing_Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setOptional_Balancing_Worktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptional_Balancing_Worktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptional_Balancing_Worktag_ReferenceForArrayConstraintsFromSetOptional_Balancing_Worktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_DataTypeOptional_Balancing_Worktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_DataTypeOptional_Balancing_Worktag_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($project_DataTypeOptional_Balancing_Worktag_ReferenceItem) ? get_class($project_DataTypeOptional_Balancing_Worktag_ReferenceItem) : sprintf('%s(%s)', gettype($project_DataTypeOptional_Balancing_Worktag_ReferenceItem), var_export($project_DataTypeOptional_Balancing_Worktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Optional_Balancing_Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Optional_Balancing_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $optional_Balancing_Worktag_Reference
     * @return \StructType\Project_DataType
     */
    public function setOptional_Balancing_Worktag_Reference(array $optional_Balancing_Worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($optional_Balancing_Worktag_ReferenceArrayErrorMessage = self::validateOptional_Balancing_Worktag_ReferenceForArrayConstraintsFromSetOptional_Balancing_Worktag_Reference($optional_Balancing_Worktag_Reference))) {
            throw new \InvalidArgumentException($optional_Balancing_Worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Optional_Balancing_Worktag_Reference = $optional_Balancing_Worktag_Reference;
        return $this;
    }
    /**
     * Add item to Optional_Balancing_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Project_DataType
     */
    public function addToOptional_Balancing_Worktag_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Optional_Balancing_Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Optional_Balancing_Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Project_Dependencies_Reference value
     * @return \StructType\ProjectObjectType[]|null
     */
    public function getProject_Dependencies_Reference()
    {
        return $this->Project_Dependencies_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Dependencies_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Dependencies_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Dependencies_ReferenceForArrayConstraintsFromSetProject_Dependencies_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_DataTypeProject_Dependencies_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_DataTypeProject_Dependencies_ReferenceItem instanceof \StructType\ProjectObjectType) {
                $invalidValues[] = is_object($project_DataTypeProject_Dependencies_ReferenceItem) ? get_class($project_DataTypeProject_Dependencies_ReferenceItem) : sprintf('%s(%s)', gettype($project_DataTypeProject_Dependencies_ReferenceItem), var_export($project_DataTypeProject_Dependencies_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Dependencies_Reference property can only contain items of type \StructType\ProjectObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Dependencies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectObjectType[] $project_Dependencies_Reference
     * @return \StructType\Project_DataType
     */
    public function setProject_Dependencies_Reference(array $project_Dependencies_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Dependencies_ReferenceArrayErrorMessage = self::validateProject_Dependencies_ReferenceForArrayConstraintsFromSetProject_Dependencies_Reference($project_Dependencies_Reference))) {
            throw new \InvalidArgumentException($project_Dependencies_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Dependencies_Reference = $project_Dependencies_Reference;
        return $this;
    }
    /**
     * Add item to Project_Dependencies_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ProjectObjectType $item
     * @return \StructType\Project_DataType
     */
    public function addToProject_Dependencies_Reference(\StructType\ProjectObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProjectObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Dependencies_Reference property can only contain items of type \StructType\ProjectObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Dependencies_Reference[] = $item;
        return $this;
    }
    /**
     * Get Project_Prerequisite_For_Reference value
     * @return \StructType\Project_AbstractObjectType[]|null
     */
    public function getProject_Prerequisite_For_Reference()
    {
        return $this->Project_Prerequisite_For_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Prerequisite_For_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Prerequisite_For_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Prerequisite_For_ReferenceForArrayConstraintsFromSetProject_Prerequisite_For_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_DataTypeProject_Prerequisite_For_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_DataTypeProject_Prerequisite_For_ReferenceItem instanceof \StructType\Project_AbstractObjectType) {
                $invalidValues[] = is_object($project_DataTypeProject_Prerequisite_For_ReferenceItem) ? get_class($project_DataTypeProject_Prerequisite_For_ReferenceItem) : sprintf('%s(%s)', gettype($project_DataTypeProject_Prerequisite_For_ReferenceItem), var_export($project_DataTypeProject_Prerequisite_For_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Prerequisite_For_Reference property can only contain items of type \StructType\Project_AbstractObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Prerequisite_For_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_AbstractObjectType[] $project_Prerequisite_For_Reference
     * @return \StructType\Project_DataType
     */
    public function setProject_Prerequisite_For_Reference(array $project_Prerequisite_For_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Prerequisite_For_ReferenceArrayErrorMessage = self::validateProject_Prerequisite_For_ReferenceForArrayConstraintsFromSetProject_Prerequisite_For_Reference($project_Prerequisite_For_Reference))) {
            throw new \InvalidArgumentException($project_Prerequisite_For_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Prerequisite_For_Reference = $project_Prerequisite_For_Reference;
        return $this;
    }
    /**
     * Add item to Project_Prerequisite_For_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_AbstractObjectType $item
     * @return \StructType\Project_DataType
     */
    public function addToProject_Prerequisite_For_Reference(\StructType\Project_AbstractObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_AbstractObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Prerequisite_For_Reference property can only contain items of type \StructType\Project_AbstractObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Prerequisite_For_Reference[] = $item;
        return $this;
    }
    /**
     * Get Project_Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getProject_Attachment_Data()
    {
        return $this->Project_Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Attachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Attachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Attachment_DataForArrayConstraintsFromSetProject_Attachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_DataTypeProject_Attachment_DataItem) {
            // validation for constraint: itemType
            if (!$project_DataTypeProject_Attachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($project_DataTypeProject_Attachment_DataItem) ? get_class($project_DataTypeProject_Attachment_DataItem) : sprintf('%s(%s)', gettype($project_DataTypeProject_Attachment_DataItem), var_export($project_DataTypeProject_Attachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $project_Attachment_Data
     * @return \StructType\Project_DataType
     */
    public function setProject_Attachment_Data(array $project_Attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Attachment_DataArrayErrorMessage = self::validateProject_Attachment_DataForArrayConstraintsFromSetProject_Attachment_Data($project_Attachment_Data))) {
            throw new \InvalidArgumentException($project_Attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Attachment_Data = $project_Attachment_Data;
        return $this;
    }
    /**
     * Add item to Project_Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Project_DataType
     */
    public function addToProject_Attachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Attachment_Data[] = $item;
        return $this;
    }
}
