<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Depreciation_Detail_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains details for each depreciation expense line for the asset.
 * @subpackage Structs
 */
class Asset_Depreciation_Detail_Line_DataType extends AbstractStructBase
{
    /**
     * The Depreciation_Period
     * Meta information extracted from the WSDL
     * - documentation: The sequence number of the depreciation line.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Depreciation_Period;
    /**
     * The Period_Ending_Date
     * Meta information extracted from the WSDL
     * - documentation: The end date of the ledger period this depreciation line is for.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Period_Ending_Date;
    /**
     * The Depreciation_Number_Of_Days
     * Meta information extracted from the WSDL
     * - documentation: The number of depreciation days for this transaction.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Depreciation_Number_Of_Days;
    /**
     * The Period_Depreciation_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount of depreciation recorded for this transaction.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Period_Depreciation_Amount;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to worktags associated with this depreciation expense.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Depreciation_Adjustment_Transaction_Type
     * Meta information extracted from the WSDL
     * - documentation: The type of transaction for this depreciation transaction.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Depreciation_Adjustment_Transaction_Type;
    /**
     * The Bonus_Depreciation
     * Meta information extracted from the WSDL
     * - documentation: Any bonus depreciation applied for this transaction.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Bonus_Depreciation;
    /**
     * The Recorded_On_Date
     * Meta information extracted from the WSDL
     * - documentation: The date this depreciation activity was recorded on. If it has not been recorded yet, this value is blank.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Recorded_On_Date;
    /**
     * Constructor method for Asset_Depreciation_Detail_Line_DataType
     * @uses Asset_Depreciation_Detail_Line_DataType::setDepreciation_Period()
     * @uses Asset_Depreciation_Detail_Line_DataType::setPeriod_Ending_Date()
     * @uses Asset_Depreciation_Detail_Line_DataType::setDepreciation_Number_Of_Days()
     * @uses Asset_Depreciation_Detail_Line_DataType::setPeriod_Depreciation_Amount()
     * @uses Asset_Depreciation_Detail_Line_DataType::setWorktag_Reference()
     * @uses Asset_Depreciation_Detail_Line_DataType::setDepreciation_Adjustment_Transaction_Type()
     * @uses Asset_Depreciation_Detail_Line_DataType::setBonus_Depreciation()
     * @uses Asset_Depreciation_Detail_Line_DataType::setRecorded_On_Date()
     * @param float $depreciation_Period
     * @param string $period_Ending_Date
     * @param float $depreciation_Number_Of_Days
     * @param float $period_Depreciation_Amount
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @param string $depreciation_Adjustment_Transaction_Type
     * @param bool $bonus_Depreciation
     * @param string $recorded_On_Date
     */
    public function __construct($depreciation_Period = null, $period_Ending_Date = null, $depreciation_Number_Of_Days = null, $period_Depreciation_Amount = null, array $worktag_Reference = array(), $depreciation_Adjustment_Transaction_Type = null, $bonus_Depreciation = null, $recorded_On_Date = null)
    {
        $this
            ->setDepreciation_Period($depreciation_Period)
            ->setPeriod_Ending_Date($period_Ending_Date)
            ->setDepreciation_Number_Of_Days($depreciation_Number_Of_Days)
            ->setPeriod_Depreciation_Amount($period_Depreciation_Amount)
            ->setWorktag_Reference($worktag_Reference)
            ->setDepreciation_Adjustment_Transaction_Type($depreciation_Adjustment_Transaction_Type)
            ->setBonus_Depreciation($bonus_Depreciation)
            ->setRecorded_On_Date($recorded_On_Date);
    }
    /**
     * Get Depreciation_Period value
     * @return float|null
     */
    public function getDepreciation_Period()
    {
        return $this->Depreciation_Period;
    }
    /**
     * Set Depreciation_Period value
     * @param float $depreciation_Period
     * @return \StructType\Asset_Depreciation_Detail_Line_DataType
     */
    public function setDepreciation_Period($depreciation_Period = null)
    {
        // validation for constraint: float
        if (!is_null($depreciation_Period) && !(is_float($depreciation_Period) || is_numeric($depreciation_Period))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depreciation_Period, true), gettype($depreciation_Period)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($depreciation_Period) && mb_strlen(mb_substr($depreciation_Period, false !== mb_strpos($depreciation_Period, '.') ? mb_strpos($depreciation_Period, '.') + 1 : mb_strlen($depreciation_Period))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($depreciation_Period, true), mb_strlen(mb_substr($depreciation_Period, mb_strpos($depreciation_Period, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($depreciation_Period) && $depreciation_Period < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($depreciation_Period, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($depreciation_Period) && mb_strlen(preg_replace('/(\D)/', '', $depreciation_Period)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($depreciation_Period, true), mb_strlen(preg_replace('/(\D)/', '', $depreciation_Period))), __LINE__);
        }
        $this->Depreciation_Period = $depreciation_Period;
        return $this;
    }
    /**
     * Get Period_Ending_Date value
     * @return string|null
     */
    public function getPeriod_Ending_Date()
    {
        return $this->Period_Ending_Date;
    }
    /**
     * Set Period_Ending_Date value
     * @param string $period_Ending_Date
     * @return \StructType\Asset_Depreciation_Detail_Line_DataType
     */
    public function setPeriod_Ending_Date($period_Ending_Date = null)
    {
        // validation for constraint: string
        if (!is_null($period_Ending_Date) && !is_string($period_Ending_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($period_Ending_Date, true), gettype($period_Ending_Date)), __LINE__);
        }
        $this->Period_Ending_Date = $period_Ending_Date;
        return $this;
    }
    /**
     * Get Depreciation_Number_Of_Days value
     * @return float|null
     */
    public function getDepreciation_Number_Of_Days()
    {
        return $this->Depreciation_Number_Of_Days;
    }
    /**
     * Set Depreciation_Number_Of_Days value
     * @param float $depreciation_Number_Of_Days
     * @return \StructType\Asset_Depreciation_Detail_Line_DataType
     */
    public function setDepreciation_Number_Of_Days($depreciation_Number_Of_Days = null)
    {
        // validation for constraint: float
        if (!is_null($depreciation_Number_Of_Days) && !(is_float($depreciation_Number_Of_Days) || is_numeric($depreciation_Number_Of_Days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depreciation_Number_Of_Days, true), gettype($depreciation_Number_Of_Days)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($depreciation_Number_Of_Days) && mb_strlen(mb_substr($depreciation_Number_Of_Days, false !== mb_strpos($depreciation_Number_Of_Days, '.') ? mb_strpos($depreciation_Number_Of_Days, '.') + 1 : mb_strlen($depreciation_Number_Of_Days))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($depreciation_Number_Of_Days, true), mb_strlen(mb_substr($depreciation_Number_Of_Days, mb_strpos($depreciation_Number_Of_Days, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($depreciation_Number_Of_Days) && $depreciation_Number_Of_Days < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($depreciation_Number_Of_Days, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($depreciation_Number_Of_Days) && mb_strlen(preg_replace('/(\D)/', '', $depreciation_Number_Of_Days)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($depreciation_Number_Of_Days, true), mb_strlen(preg_replace('/(\D)/', '', $depreciation_Number_Of_Days))), __LINE__);
        }
        $this->Depreciation_Number_Of_Days = $depreciation_Number_Of_Days;
        return $this;
    }
    /**
     * Get Period_Depreciation_Amount value
     * @return float|null
     */
    public function getPeriod_Depreciation_Amount()
    {
        return $this->Period_Depreciation_Amount;
    }
    /**
     * Set Period_Depreciation_Amount value
     * @param float $period_Depreciation_Amount
     * @return \StructType\Asset_Depreciation_Detail_Line_DataType
     */
    public function setPeriod_Depreciation_Amount($period_Depreciation_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($period_Depreciation_Amount) && !(is_float($period_Depreciation_Amount) || is_numeric($period_Depreciation_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($period_Depreciation_Amount, true), gettype($period_Depreciation_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($period_Depreciation_Amount) && mb_strlen(mb_substr($period_Depreciation_Amount, false !== mb_strpos($period_Depreciation_Amount, '.') ? mb_strpos($period_Depreciation_Amount, '.') + 1 : mb_strlen($period_Depreciation_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($period_Depreciation_Amount, true), mb_strlen(mb_substr($period_Depreciation_Amount, mb_strpos($period_Depreciation_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($period_Depreciation_Amount) && mb_strlen(preg_replace('/(\D)/', '', $period_Depreciation_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($period_Depreciation_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $period_Depreciation_Amount))), __LINE__);
        }
        $this->Period_Depreciation_Amount = $period_Depreciation_Amount;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Depreciation_Detail_Line_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Depreciation_Detail_Line_DataTypeWorktag_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($asset_Depreciation_Detail_Line_DataTypeWorktag_ReferenceItem) ? get_class($asset_Depreciation_Detail_Line_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Depreciation_Detail_Line_DataTypeWorktag_ReferenceItem), var_export($asset_Depreciation_Detail_Line_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Asset_Depreciation_Detail_Line_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Asset_Depreciation_Detail_Line_DataType
     */
    public function addToWorktag_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Depreciation_Adjustment_Transaction_Type value
     * @return string|null
     */
    public function getDepreciation_Adjustment_Transaction_Type()
    {
        return $this->Depreciation_Adjustment_Transaction_Type;
    }
    /**
     * Set Depreciation_Adjustment_Transaction_Type value
     * @param string $depreciation_Adjustment_Transaction_Type
     * @return \StructType\Asset_Depreciation_Detail_Line_DataType
     */
    public function setDepreciation_Adjustment_Transaction_Type($depreciation_Adjustment_Transaction_Type = null)
    {
        // validation for constraint: string
        if (!is_null($depreciation_Adjustment_Transaction_Type) && !is_string($depreciation_Adjustment_Transaction_Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depreciation_Adjustment_Transaction_Type, true), gettype($depreciation_Adjustment_Transaction_Type)), __LINE__);
        }
        $this->Depreciation_Adjustment_Transaction_Type = $depreciation_Adjustment_Transaction_Type;
        return $this;
    }
    /**
     * Get Bonus_Depreciation value
     * @return bool|null
     */
    public function getBonus_Depreciation()
    {
        return $this->Bonus_Depreciation;
    }
    /**
     * Set Bonus_Depreciation value
     * @param bool $bonus_Depreciation
     * @return \StructType\Asset_Depreciation_Detail_Line_DataType
     */
    public function setBonus_Depreciation($bonus_Depreciation = null)
    {
        // validation for constraint: boolean
        if (!is_null($bonus_Depreciation) && !is_bool($bonus_Depreciation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bonus_Depreciation, true), gettype($bonus_Depreciation)), __LINE__);
        }
        $this->Bonus_Depreciation = $bonus_Depreciation;
        return $this;
    }
    /**
     * Get Recorded_On_Date value
     * @return string|null
     */
    public function getRecorded_On_Date()
    {
        return $this->Recorded_On_Date;
    }
    /**
     * Set Recorded_On_Date value
     * @param string $recorded_On_Date
     * @return \StructType\Asset_Depreciation_Detail_Line_DataType
     */
    public function setRecorded_On_Date($recorded_On_Date = null)
    {
        // validation for constraint: string
        if (!is_null($recorded_On_Date) && !is_string($recorded_On_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recorded_On_Date, true), gettype($recorded_On_Date)), __LINE__);
        }
        $this->Recorded_On_Date = $recorded_On_Date;
        return $this;
    }
}
