<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Advanced_Ship_Notice_Line_Data_InboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that captures Advanced Ship Notice Line information.
 * @subpackage Structs
 */
class Advanced_Ship_Notice_Line_Data_InboundType extends AbstractStructBase
{
    /**
     * The Advanced_Ship_Notice_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Advanced Ship Notice Line Reference ID. This is optional and will be auto-generated if left blank.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Advanced_Ship_Notice_Line_ID;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Shipment_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipment Line Reference.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Shipment_Line_Reference;
    /**
     * The Shipped_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Shipped Quantity on Advanced Ship Notice Line.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Shipped_Quantity;
    /**
     * The Shipped_Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of the Unit Of Measure for the Shipped Quantity. If value is not provided, it defaults to Unit of Measure from the corresponding Purchase Order line.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Shipped_Unit_of_Measure_Reference;
    /**
     * The Shipped_Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: The unit cost of the item specified in the currency associated to the Purchase Order currency. If value is not provided, defaults to unit cost of corresponding line in Purchase Order.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Shipped_Unit_Cost;
    /**
     * The Conversion_Factor
     * Meta information extracted from the WSDL
     * - documentation: The conversion factor to be used when converting the unit of measure to the base unit of measure for the catalog item. | Conversion Factor for the ordering unit of measure to the base unit of measure of the catalog item. | Purchase
     * Item stocking Unit of measure Conversion factor | Positive numeric value used to calculate the Ordered Quantity that is shipped from Shipped Quantity provided at Advance Shipment Line. If Shipped Quantity is five and Conversion Factor is two , then
     * Quantity shipped is calculated as Ten. Default value for Conversion Factor is one. | Conversion Factor between the Ordering Unit of Measure and the Base Unit of Measure of Catalog Load Item. | Conversion factor to the base UOM. | Conversion Factor
     * from Ordering Unit of Measure to Purchase Item's Base Unit of Measure. | Conversion Factor for the JIT UOM of the Catalog or Supplier Item. | Conversion Factor for the Bulk UOM of the Catalog or Supplier Item. | The conversion factor of the web
     * item's ordering unit of measure to the linked purchase item's base unit of measure.
     * - base: xsd:decimal
     * - fractionDigits: 9
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Conversion_Factor;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The location where the items will be delivered.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Deliver_To_Location_Global_Location_Number
     * Meta information extracted from the WSDL
     * - documentation: User can provide Global Location Number here; the Location assigned to it will be used to populate the Deliver-to Location
     * - choice: Deliver_To_Location_Global_Location_Number | Deliver_To_Location_Customer_Account_Number
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Deliver_To_Location_Global_Location_Number;
    /**
     * The Deliver_To_Location_Customer_Account_Number
     * Meta information extracted from the WSDL
     * - documentation: User can provide EDI Customer Account Number here; the Location assigned to it will be used to populate the Deliver-To Location
     * - base: xsd:string
     * - choice: Deliver_To_Location_Global_Location_Number | Deliver_To_Location_Customer_Account_Number
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Deliver_To_Location_Customer_Account_Number;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Line Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Goods line from a Purchase Order for which the Advanced Ship Notice Line is created.
     * @var \StructType\Item_Order_LineObjectType
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Alternate_Item_Identifier_Data
     * Meta information extracted from the WSDL
     * - documentation: Alternate Item Identifiers for Item on Advance Ship Notice Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType[]
     */
    public $Alternate_Item_Identifier_Data;
    /**
     * The Lot_Information_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that contains Lot Information for Item on Advance Ship Notice Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ASN_Line_Lot_Information_Data_InboundType[]
     */
    public $Lot_Information_Data;
    /**
     * Constructor method for Advanced_Ship_Notice_Line_Data_InboundType
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setAdvanced_Ship_Notice_Line_ID()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setItem_Description()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setShipment_Line_Reference()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setShipped_Quantity()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setShipped_Unit_of_Measure_Reference()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setShipped_Unit_Cost()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setConversion_Factor()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setDeliver_To_Location_Reference()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setDeliver_To_Location_Global_Location_Number()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setDeliver_To_Location_Customer_Account_Number()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setMemo()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setPurchase_Order_Line_Reference()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setAlternate_Item_Identifier_Data()
     * @uses Advanced_Ship_Notice_Line_Data_InboundType::setLot_Information_Data()
     * @param string $advanced_Ship_Notice_Line_ID
     * @param string $item_Description
     * @param string $shipment_Line_Reference
     * @param float $shipped_Quantity
     * @param \StructType\Unit_of_MeasureObjectType $shipped_Unit_of_Measure_Reference
     * @param float $shipped_Unit_Cost
     * @param float $conversion_Factor
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param string $deliver_To_Location_Global_Location_Number
     * @param string $deliver_To_Location_Customer_Account_Number
     * @param string $memo
     * @param \StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference
     * @param \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType[] $alternate_Item_Identifier_Data
     * @param \StructType\ASN_Line_Lot_Information_Data_InboundType[] $lot_Information_Data
     */
    public function __construct($advanced_Ship_Notice_Line_ID = null, $item_Description = null, $shipment_Line_Reference = null, $shipped_Quantity = null, \StructType\Unit_of_MeasureObjectType $shipped_Unit_of_Measure_Reference = null, $shipped_Unit_Cost = null, $conversion_Factor = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, $deliver_To_Location_Global_Location_Number = null, $deliver_To_Location_Customer_Account_Number = null, $memo = null, \StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference = null, array $alternate_Item_Identifier_Data = array(), array $lot_Information_Data = array())
    {
        $this
            ->setAdvanced_Ship_Notice_Line_ID($advanced_Ship_Notice_Line_ID)
            ->setItem_Description($item_Description)
            ->setShipment_Line_Reference($shipment_Line_Reference)
            ->setShipped_Quantity($shipped_Quantity)
            ->setShipped_Unit_of_Measure_Reference($shipped_Unit_of_Measure_Reference)
            ->setShipped_Unit_Cost($shipped_Unit_Cost)
            ->setConversion_Factor($conversion_Factor)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setDeliver_To_Location_Global_Location_Number($deliver_To_Location_Global_Location_Number)
            ->setDeliver_To_Location_Customer_Account_Number($deliver_To_Location_Customer_Account_Number)
            ->setMemo($memo)
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setAlternate_Item_Identifier_Data($alternate_Item_Identifier_Data)
            ->setLot_Information_Data($lot_Information_Data);
    }
    /**
     * Get Advanced_Ship_Notice_Line_ID value
     * @return string|null
     */
    public function getAdvanced_Ship_Notice_Line_ID()
    {
        return $this->Advanced_Ship_Notice_Line_ID;
    }
    /**
     * Set Advanced_Ship_Notice_Line_ID value
     * @param string $advanced_Ship_Notice_Line_ID
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setAdvanced_Ship_Notice_Line_ID($advanced_Ship_Notice_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($advanced_Ship_Notice_Line_ID) && !is_string($advanced_Ship_Notice_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($advanced_Ship_Notice_Line_ID, true), gettype($advanced_Ship_Notice_Line_ID)), __LINE__);
        }
        $this->Advanced_Ship_Notice_Line_ID = $advanced_Ship_Notice_Line_ID;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Shipment_Line_Reference value
     * @return string|null
     */
    public function getShipment_Line_Reference()
    {
        return $this->Shipment_Line_Reference;
    }
    /**
     * Set Shipment_Line_Reference value
     * @param string $shipment_Line_Reference
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setShipment_Line_Reference($shipment_Line_Reference = null)
    {
        // validation for constraint: string
        if (!is_null($shipment_Line_Reference) && !is_string($shipment_Line_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipment_Line_Reference, true), gettype($shipment_Line_Reference)), __LINE__);
        }
        $this->Shipment_Line_Reference = $shipment_Line_Reference;
        return $this;
    }
    /**
     * Get Shipped_Quantity value
     * @return float|null
     */
    public function getShipped_Quantity()
    {
        return $this->Shipped_Quantity;
    }
    /**
     * Set Shipped_Quantity value
     * @param float $shipped_Quantity
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setShipped_Quantity($shipped_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($shipped_Quantity) && !(is_float($shipped_Quantity) || is_numeric($shipped_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipped_Quantity, true), gettype($shipped_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($shipped_Quantity) && mb_strlen(mb_substr($shipped_Quantity, false !== mb_strpos($shipped_Quantity, '.') ? mb_strpos($shipped_Quantity, '.') + 1 : mb_strlen($shipped_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($shipped_Quantity, true), mb_strlen(mb_substr($shipped_Quantity, mb_strpos($shipped_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($shipped_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $shipped_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($shipped_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $shipped_Quantity))), __LINE__);
        }
        $this->Shipped_Quantity = $shipped_Quantity;
        return $this;
    }
    /**
     * Get Shipped_Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getShipped_Unit_of_Measure_Reference()
    {
        return $this->Shipped_Unit_of_Measure_Reference;
    }
    /**
     * Set Shipped_Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $shipped_Unit_of_Measure_Reference
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setShipped_Unit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $shipped_Unit_of_Measure_Reference = null)
    {
        $this->Shipped_Unit_of_Measure_Reference = $shipped_Unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Shipped_Unit_Cost value
     * @return float|null
     */
    public function getShipped_Unit_Cost()
    {
        return $this->Shipped_Unit_Cost;
    }
    /**
     * Set Shipped_Unit_Cost value
     * @param float $shipped_Unit_Cost
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setShipped_Unit_Cost($shipped_Unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($shipped_Unit_Cost) && !(is_float($shipped_Unit_Cost) || is_numeric($shipped_Unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($shipped_Unit_Cost, true), gettype($shipped_Unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($shipped_Unit_Cost) && mb_strlen(mb_substr($shipped_Unit_Cost, false !== mb_strpos($shipped_Unit_Cost, '.') ? mb_strpos($shipped_Unit_Cost, '.') + 1 : mb_strlen($shipped_Unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($shipped_Unit_Cost, true), mb_strlen(mb_substr($shipped_Unit_Cost, mb_strpos($shipped_Unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($shipped_Unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $shipped_Unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($shipped_Unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $shipped_Unit_Cost))), __LINE__);
        }
        $this->Shipped_Unit_Cost = $shipped_Unit_Cost;
        return $this;
    }
    /**
     * Get Conversion_Factor value
     * @return float|null
     */
    public function getConversion_Factor()
    {
        return $this->Conversion_Factor;
    }
    /**
     * Set Conversion_Factor value
     * @param float $conversion_Factor
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setConversion_Factor($conversion_Factor = null)
    {
        // validation for constraint: float
        if (!is_null($conversion_Factor) && !(is_float($conversion_Factor) || is_numeric($conversion_Factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversion_Factor, true), gettype($conversion_Factor)), __LINE__);
        }
        // validation for constraint: fractionDigits(9)
        if (!is_null($conversion_Factor) && mb_strlen(mb_substr($conversion_Factor, false !== mb_strpos($conversion_Factor, '.') ? mb_strpos($conversion_Factor, '.') + 1 : mb_strlen($conversion_Factor))) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 9 fraction digits, %d given', var_export($conversion_Factor, true), mb_strlen(mb_substr($conversion_Factor, mb_strpos($conversion_Factor, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($conversion_Factor) && $conversion_Factor < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($conversion_Factor, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($conversion_Factor) && mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($conversion_Factor, true), mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor))), __LINE__);
        }
        $this->Conversion_Factor = $conversion_Factor;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->Deliver_To_Location_Reference;
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Global_Location_Number value
     * @return string|null
     */
    public function getDeliver_To_Location_Global_Location_Number()
    {
        return isset($this->Deliver_To_Location_Global_Location_Number) ? $this->Deliver_To_Location_Global_Location_Number : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDeliver_To_Location_Global_Location_Number method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliver_To_Location_Global_Location_Number method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDeliver_To_Location_Global_Location_NumberForChoiceConstraintsFromSetDeliver_To_Location_Global_Location_Number($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Deliver_To_Location_Customer_Account_Number',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Deliver_To_Location_Global_Location_Number can\'t be set as the property %s is already set. Only one property must be set among these properties: Deliver_To_Location_Global_Location_Number, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Deliver_To_Location_Global_Location_Number value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $deliver_To_Location_Global_Location_Number
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setDeliver_To_Location_Global_Location_Number($deliver_To_Location_Global_Location_Number = null)
    {
        // validation for constraint: string
        if (!is_null($deliver_To_Location_Global_Location_Number) && !is_string($deliver_To_Location_Global_Location_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliver_To_Location_Global_Location_Number, true), gettype($deliver_To_Location_Global_Location_Number)), __LINE__);
        }
        // validation for constraint: choice(Deliver_To_Location_Global_Location_Number, Deliver_To_Location_Customer_Account_Number)
        if ('' !== ($deliver_To_Location_Global_Location_NumberChoiceErrorMessage = self::validateDeliver_To_Location_Global_Location_NumberForChoiceConstraintsFromSetDeliver_To_Location_Global_Location_Number($deliver_To_Location_Global_Location_Number))) {
            throw new \InvalidArgumentException($deliver_To_Location_Global_Location_NumberChoiceErrorMessage, __LINE__);
        }
        if (is_null($deliver_To_Location_Global_Location_Number) || (is_array($deliver_To_Location_Global_Location_Number) && empty($deliver_To_Location_Global_Location_Number))) {
            unset($this->Deliver_To_Location_Global_Location_Number);
        } else {
            $this->Deliver_To_Location_Global_Location_Number = $deliver_To_Location_Global_Location_Number;
        }
        return $this;
    }
    /**
     * Get Deliver_To_Location_Customer_Account_Number value
     * @return string|null
     */
    public function getDeliver_To_Location_Customer_Account_Number()
    {
        return isset($this->Deliver_To_Location_Customer_Account_Number) ? $this->Deliver_To_Location_Customer_Account_Number : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDeliver_To_Location_Customer_Account_Number method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliver_To_Location_Customer_Account_Number method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDeliver_To_Location_Customer_Account_NumberForChoiceConstraintsFromSetDeliver_To_Location_Customer_Account_Number($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Deliver_To_Location_Global_Location_Number',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Deliver_To_Location_Customer_Account_Number can\'t be set as the property %s is already set. Only one property must be set among these properties: Deliver_To_Location_Customer_Account_Number, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Deliver_To_Location_Customer_Account_Number value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $deliver_To_Location_Customer_Account_Number
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setDeliver_To_Location_Customer_Account_Number($deliver_To_Location_Customer_Account_Number = null)
    {
        // validation for constraint: string
        if (!is_null($deliver_To_Location_Customer_Account_Number) && !is_string($deliver_To_Location_Customer_Account_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliver_To_Location_Customer_Account_Number, true), gettype($deliver_To_Location_Customer_Account_Number)), __LINE__);
        }
        // validation for constraint: choice(Deliver_To_Location_Global_Location_Number, Deliver_To_Location_Customer_Account_Number)
        if ('' !== ($deliver_To_Location_Customer_Account_NumberChoiceErrorMessage = self::validateDeliver_To_Location_Customer_Account_NumberForChoiceConstraintsFromSetDeliver_To_Location_Customer_Account_Number($deliver_To_Location_Customer_Account_Number))) {
            throw new \InvalidArgumentException($deliver_To_Location_Customer_Account_NumberChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($deliver_To_Location_Customer_Account_Number) && mb_strlen($deliver_To_Location_Customer_Account_Number) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($deliver_To_Location_Customer_Account_Number)), __LINE__);
        }
        if (is_null($deliver_To_Location_Customer_Account_Number) || (is_array($deliver_To_Location_Customer_Account_Number) && empty($deliver_To_Location_Customer_Account_Number))) {
            unset($this->Deliver_To_Location_Customer_Account_Number);
        } else {
            $this->Deliver_To_Location_Customer_Account_Number = $deliver_To_Location_Customer_Account_Number;
        }
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Item_Order_LineObjectType|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @param \StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setPurchase_Order_Line_Reference(\StructType\Item_Order_LineObjectType $purchase_Order_Line_Reference = null)
    {
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Get Alternate_Item_Identifier_Data value
     * @return \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType[]|null
     */
    public function getAlternate_Item_Identifier_Data()
    {
        return $this->Alternate_Item_Identifier_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Item_Identifier_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Item_Identifier_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Item_Identifier_DataForArrayConstraintsFromSetAlternate_Item_Identifier_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Line_Data_InboundTypeAlternate_Item_Identifier_DataItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Line_Data_InboundTypeAlternate_Item_Identifier_DataItem instanceof \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Line_Data_InboundTypeAlternate_Item_Identifier_DataItem) ? get_class($advanced_Ship_Notice_Line_Data_InboundTypeAlternate_Item_Identifier_DataItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Line_Data_InboundTypeAlternate_Item_Identifier_DataItem), var_export($advanced_Ship_Notice_Line_Data_InboundTypeAlternate_Item_Identifier_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Item_Identifier_Data property can only contain items of type \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Item_Identifier_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType[] $alternate_Item_Identifier_Data
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setAlternate_Item_Identifier_Data(array $alternate_Item_Identifier_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Item_Identifier_DataArrayErrorMessage = self::validateAlternate_Item_Identifier_DataForArrayConstraintsFromSetAlternate_Item_Identifier_Data($alternate_Item_Identifier_Data))) {
            throw new \InvalidArgumentException($alternate_Item_Identifier_DataArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Item_Identifier_Data = $alternate_Item_Identifier_Data;
        return $this;
    }
    /**
     * Add item to Alternate_Item_Identifier_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType $item
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function addToAlternate_Item_Identifier_Data(\StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Item_Identifier_Data property can only contain items of type \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Item_Identifier_Data[] = $item;
        return $this;
    }
    /**
     * Get Lot_Information_Data value
     * @return \StructType\ASN_Line_Lot_Information_Data_InboundType[]|null
     */
    public function getLot_Information_Data()
    {
        return $this->Lot_Information_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setLot_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLot_Information_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLot_Information_DataForArrayConstraintsFromSetLot_Information_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $advanced_Ship_Notice_Line_Data_InboundTypeLot_Information_DataItem) {
            // validation for constraint: itemType
            if (!$advanced_Ship_Notice_Line_Data_InboundTypeLot_Information_DataItem instanceof \StructType\ASN_Line_Lot_Information_Data_InboundType) {
                $invalidValues[] = is_object($advanced_Ship_Notice_Line_Data_InboundTypeLot_Information_DataItem) ? get_class($advanced_Ship_Notice_Line_Data_InboundTypeLot_Information_DataItem) : sprintf('%s(%s)', gettype($advanced_Ship_Notice_Line_Data_InboundTypeLot_Information_DataItem), var_export($advanced_Ship_Notice_Line_Data_InboundTypeLot_Information_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Lot_Information_Data property can only contain items of type \StructType\ASN_Line_Lot_Information_Data_InboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Lot_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\ASN_Line_Lot_Information_Data_InboundType[] $lot_Information_Data
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function setLot_Information_Data(array $lot_Information_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($lot_Information_DataArrayErrorMessage = self::validateLot_Information_DataForArrayConstraintsFromSetLot_Information_Data($lot_Information_Data))) {
            throw new \InvalidArgumentException($lot_Information_DataArrayErrorMessage, __LINE__);
        }
        $this->Lot_Information_Data = $lot_Information_Data;
        return $this;
    }
    /**
     * Add item to Lot_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\ASN_Line_Lot_Information_Data_InboundType $item
     * @return \StructType\Advanced_Ship_Notice_Line_Data_InboundType
     */
    public function addToLot_Information_Data(\StructType\ASN_Line_Lot_Information_Data_InboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ASN_Line_Lot_Information_Data_InboundType) {
            throw new \InvalidArgumentException(sprintf('The Lot_Information_Data property can only contain items of type \StructType\ASN_Line_Lot_Information_Data_InboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Lot_Information_Data[] = $item;
        return $this;
    }
}
