<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location_Customer_Account_Number_DetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element for Location Customer Account Number Detail Reference and Location Customer Account Number Detail Data.
 * @subpackage Structs
 */
class Location_Customer_Account_Number_DetailType extends AbstractStructBase
{
    /**
     * The Location_Customer_Account_Number_Detail_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Location Customer Account Number Detail.
     * - minOccurs: 0
     * @var \StructType\Location_Customer_Account_Number_DetailObjectType
     */
    public $Location_Customer_Account_Number_Detail_Reference;
    /**
     * The Location_Customer_Account_Number_Detail_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Location Customer Account Number Detail Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Location_Customer_Account_Number_Detail_DataType[]
     */
    public $Location_Customer_Account_Number_Detail_Data;
    /**
     * Constructor method for Location_Customer_Account_Number_DetailType
     * @uses Location_Customer_Account_Number_DetailType::setLocation_Customer_Account_Number_Detail_Reference()
     * @uses Location_Customer_Account_Number_DetailType::setLocation_Customer_Account_Number_Detail_Data()
     * @param \StructType\Location_Customer_Account_Number_DetailObjectType $location_Customer_Account_Number_Detail_Reference
     * @param \StructType\Location_Customer_Account_Number_Detail_DataType[] $location_Customer_Account_Number_Detail_Data
     */
    public function __construct(\StructType\Location_Customer_Account_Number_DetailObjectType $location_Customer_Account_Number_Detail_Reference = null, array $location_Customer_Account_Number_Detail_Data = array())
    {
        $this
            ->setLocation_Customer_Account_Number_Detail_Reference($location_Customer_Account_Number_Detail_Reference)
            ->setLocation_Customer_Account_Number_Detail_Data($location_Customer_Account_Number_Detail_Data);
    }
    /**
     * Get Location_Customer_Account_Number_Detail_Reference value
     * @return \StructType\Location_Customer_Account_Number_DetailObjectType|null
     */
    public function getLocation_Customer_Account_Number_Detail_Reference()
    {
        return $this->Location_Customer_Account_Number_Detail_Reference;
    }
    /**
     * Set Location_Customer_Account_Number_Detail_Reference value
     * @param \StructType\Location_Customer_Account_Number_DetailObjectType $location_Customer_Account_Number_Detail_Reference
     * @return \StructType\Location_Customer_Account_Number_DetailType
     */
    public function setLocation_Customer_Account_Number_Detail_Reference(\StructType\Location_Customer_Account_Number_DetailObjectType $location_Customer_Account_Number_Detail_Reference = null)
    {
        $this->Location_Customer_Account_Number_Detail_Reference = $location_Customer_Account_Number_Detail_Reference;
        return $this;
    }
    /**
     * Get Location_Customer_Account_Number_Detail_Data value
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType[]|null
     */
    public function getLocation_Customer_Account_Number_Detail_Data()
    {
        return $this->Location_Customer_Account_Number_Detail_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation_Customer_Account_Number_Detail_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation_Customer_Account_Number_Detail_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocation_Customer_Account_Number_Detail_DataForArrayConstraintsFromSetLocation_Customer_Account_Number_Detail_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $location_Customer_Account_Number_DetailTypeLocation_Customer_Account_Number_Detail_DataItem) {
            // validation for constraint: itemType
            if (!$location_Customer_Account_Number_DetailTypeLocation_Customer_Account_Number_Detail_DataItem instanceof \StructType\Location_Customer_Account_Number_Detail_DataType) {
                $invalidValues[] = is_object($location_Customer_Account_Number_DetailTypeLocation_Customer_Account_Number_Detail_DataItem) ? get_class($location_Customer_Account_Number_DetailTypeLocation_Customer_Account_Number_Detail_DataItem) : sprintf('%s(%s)', gettype($location_Customer_Account_Number_DetailTypeLocation_Customer_Account_Number_Detail_DataItem), var_export($location_Customer_Account_Number_DetailTypeLocation_Customer_Account_Number_Detail_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location_Customer_Account_Number_Detail_Data property can only contain items of type \StructType\Location_Customer_Account_Number_Detail_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location_Customer_Account_Number_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Location_Customer_Account_Number_Detail_DataType[] $location_Customer_Account_Number_Detail_Data
     * @return \StructType\Location_Customer_Account_Number_DetailType
     */
    public function setLocation_Customer_Account_Number_Detail_Data(array $location_Customer_Account_Number_Detail_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($location_Customer_Account_Number_Detail_DataArrayErrorMessage = self::validateLocation_Customer_Account_Number_Detail_DataForArrayConstraintsFromSetLocation_Customer_Account_Number_Detail_Data($location_Customer_Account_Number_Detail_Data))) {
            throw new \InvalidArgumentException($location_Customer_Account_Number_Detail_DataArrayErrorMessage, __LINE__);
        }
        $this->Location_Customer_Account_Number_Detail_Data = $location_Customer_Account_Number_Detail_Data;
        return $this;
    }
    /**
     * Add item to Location_Customer_Account_Number_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Location_Customer_Account_Number_Detail_DataType $item
     * @return \StructType\Location_Customer_Account_Number_DetailType
     */
    public function addToLocation_Customer_Account_Number_Detail_Data(\StructType\Location_Customer_Account_Number_Detail_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Location_Customer_Account_Number_Detail_DataType) {
            throw new \InvalidArgumentException(sprintf('The Location_Customer_Account_Number_Detail_Data property can only contain items of type \StructType\Location_Customer_Account_Number_Detail_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location_Customer_Account_Number_Detail_Data[] = $item;
        return $this;
    }
}
