<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_Booking_FileType StructType
 * Meta information extracted from the WSDL
 * - documentation: Travel Booking File.
 * @subpackage Structs
 */
class Travel_Booking_FileType extends AbstractStructBase
{
    /**
     * The Travel_Booking_File_Reference
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking File Reference.
     * - minOccurs: 0
     * @var \StructType\Travel_Booking_FileObjectType
     */
    public $Travel_Booking_File_Reference;
    /**
     * The Travel_Booking_File_Data
     * Meta information extracted from the WSDL
     * - documentation: Travel Booking File Date.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Travel_Booking_File_DataType[]
     */
    public $Travel_Booking_File_Data;
    /**
     * Constructor method for Travel_Booking_FileType
     * @uses Travel_Booking_FileType::setTravel_Booking_File_Reference()
     * @uses Travel_Booking_FileType::setTravel_Booking_File_Data()
     * @param \StructType\Travel_Booking_FileObjectType $travel_Booking_File_Reference
     * @param \StructType\Travel_Booking_File_DataType[] $travel_Booking_File_Data
     */
    public function __construct(\StructType\Travel_Booking_FileObjectType $travel_Booking_File_Reference = null, array $travel_Booking_File_Data = array())
    {
        $this
            ->setTravel_Booking_File_Reference($travel_Booking_File_Reference)
            ->setTravel_Booking_File_Data($travel_Booking_File_Data);
    }
    /**
     * Get Travel_Booking_File_Reference value
     * @return \StructType\Travel_Booking_FileObjectType|null
     */
    public function getTravel_Booking_File_Reference()
    {
        return $this->Travel_Booking_File_Reference;
    }
    /**
     * Set Travel_Booking_File_Reference value
     * @param \StructType\Travel_Booking_FileObjectType $travel_Booking_File_Reference
     * @return \StructType\Travel_Booking_FileType
     */
    public function setTravel_Booking_File_Reference(\StructType\Travel_Booking_FileObjectType $travel_Booking_File_Reference = null)
    {
        $this->Travel_Booking_File_Reference = $travel_Booking_File_Reference;
        return $this;
    }
    /**
     * Get Travel_Booking_File_Data value
     * @return \StructType\Travel_Booking_File_DataType[]|null
     */
    public function getTravel_Booking_File_Data()
    {
        return $this->Travel_Booking_File_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_Booking_File_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_Booking_File_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_Booking_File_DataForArrayConstraintsFromSetTravel_Booking_File_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Booking_FileTypeTravel_Booking_File_DataItem) {
            // validation for constraint: itemType
            if (!$travel_Booking_FileTypeTravel_Booking_File_DataItem instanceof \StructType\Travel_Booking_File_DataType) {
                $invalidValues[] = is_object($travel_Booking_FileTypeTravel_Booking_File_DataItem) ? get_class($travel_Booking_FileTypeTravel_Booking_File_DataItem) : sprintf('%s(%s)', gettype($travel_Booking_FileTypeTravel_Booking_File_DataItem), var_export($travel_Booking_FileTypeTravel_Booking_File_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_Booking_File_Data property can only contain items of type \StructType\Travel_Booking_File_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_Booking_File_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_File_DataType[] $travel_Booking_File_Data
     * @return \StructType\Travel_Booking_FileType
     */
    public function setTravel_Booking_File_Data(array $travel_Booking_File_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_Booking_File_DataArrayErrorMessage = self::validateTravel_Booking_File_DataForArrayConstraintsFromSetTravel_Booking_File_Data($travel_Booking_File_Data))) {
            throw new \InvalidArgumentException($travel_Booking_File_DataArrayErrorMessage, __LINE__);
        }
        $this->Travel_Booking_File_Data = $travel_Booking_File_Data;
        return $this;
    }
    /**
     * Add item to Travel_Booking_File_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_File_DataType $item
     * @return \StructType\Travel_Booking_FileType
     */
    public function addToTravel_Booking_File_Data(\StructType\Travel_Booking_File_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Travel_Booking_File_DataType) {
            throw new \InvalidArgumentException(sprintf('The Travel_Booking_File_Data property can only contain items of type \StructType\Travel_Booking_File_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_Booking_File_Data[] = $item;
        return $this;
    }
}
