<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing Request for Quote response data for requested references or criteria and for requested response group
 * @subpackage Structs
 */
class Request_for_Quote_Response_DataType extends AbstractStructBase
{
    /**
     * The Request_for_Quote
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element for Request for Quote Reference and Request for Quote Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_OutboundType[]
     */
    public $Request_for_Quote;
    /**
     * Constructor method for Request_for_Quote_Response_DataType
     * @uses Request_for_Quote_Response_DataType::setRequest_for_Quote()
     * @param \StructType\Request_for_Quote_OutboundType[] $request_for_Quote
     */
    public function __construct(array $request_for_Quote = array())
    {
        $this
            ->setRequest_for_Quote($request_for_Quote);
    }
    /**
     * Get Request_for_Quote value
     * @return \StructType\Request_for_Quote_OutboundType[]|null
     */
    public function getRequest_for_Quote()
    {
        return $this->Request_for_Quote;
    }
    /**
     * This method is responsible for validating the values passed to the setRequest_for_Quote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequest_for_Quote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequest_for_QuoteForArrayConstraintsFromSetRequest_for_Quote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Response_DataTypeRequest_for_QuoteItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Response_DataTypeRequest_for_QuoteItem instanceof \StructType\Request_for_Quote_OutboundType) {
                $invalidValues[] = is_object($request_for_Quote_Response_DataTypeRequest_for_QuoteItem) ? get_class($request_for_Quote_Response_DataTypeRequest_for_QuoteItem) : sprintf('%s(%s)', gettype($request_for_Quote_Response_DataTypeRequest_for_QuoteItem), var_export($request_for_Quote_Response_DataTypeRequest_for_QuoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Request_for_Quote property can only contain items of type \StructType\Request_for_Quote_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Request_for_Quote value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_OutboundType[] $request_for_Quote
     * @return \StructType\Request_for_Quote_Response_DataType
     */
    public function setRequest_for_Quote(array $request_for_Quote = array())
    {
        // validation for constraint: array
        if ('' !== ($request_for_QuoteArrayErrorMessage = self::validateRequest_for_QuoteForArrayConstraintsFromSetRequest_for_Quote($request_for_Quote))) {
            throw new \InvalidArgumentException($request_for_QuoteArrayErrorMessage, __LINE__);
        }
        $this->Request_for_Quote = $request_for_Quote;
        return $this;
    }
    /**
     * Add item to Request_for_Quote value
     * @throws \InvalidArgumentException
     * @param \StructType\Request_for_Quote_OutboundType $item
     * @return \StructType\Request_for_Quote_Response_DataType
     */
    public function addToRequest_for_Quote(\StructType\Request_for_Quote_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Request_for_Quote_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Request_for_Quote property can only contain items of type \StructType\Request_for_Quote_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Request_for_Quote[] = $item;
        return $this;
    }
}
