<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reclassify_Asset_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data used to process the asset reclassification
 * @subpackage Structs
 */
class Reclassify_Asset_RequestType extends AbstractStructBase
{
    /**
     * The Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: The asset is part of a lease contract. You can't reclassify leased assets. | The asset specified cannot currently be reclassified because it has other activities in progress. | You can't reclassify removed assets, disposed assets,
     * assets that have no posted depreciation, or assets that have been impaired. | A reference to the asset that should be reclassified
     * @var \StructType\Business_AssetObjectType
     */
    public $Business_Asset_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Reclassify_Asset_Data
     * @var \StructType\Reclassify_Asset_DataType
     */
    public $Reclassify_Asset_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Reclassify_Asset_RequestType
     * @uses Reclassify_Asset_RequestType::setBusiness_Asset_Reference()
     * @uses Reclassify_Asset_RequestType::setBusiness_Process_Parameters()
     * @uses Reclassify_Asset_RequestType::setReclassify_Asset_Data()
     * @uses Reclassify_Asset_RequestType::setVersion()
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Reclassify_Asset_DataType $reclassify_Asset_Data
     * @param string $version
     */
    public function __construct(\StructType\Business_AssetObjectType $business_Asset_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Reclassify_Asset_DataType $reclassify_Asset_Data = null, $version = null)
    {
        $this
            ->setBusiness_Asset_Reference($business_Asset_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setReclassify_Asset_Data($reclassify_Asset_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getBusiness_Asset_Reference()
    {
        return $this->Business_Asset_Reference;
    }
    /**
     * Set Business_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @return \StructType\Reclassify_Asset_RequestType
     */
    public function setBusiness_Asset_Reference(\StructType\Business_AssetObjectType $business_Asset_Reference = null)
    {
        $this->Business_Asset_Reference = $business_Asset_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Reclassify_Asset_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Reclassify_Asset_Data value
     * @return \StructType\Reclassify_Asset_DataType|null
     */
    public function getReclassify_Asset_Data()
    {
        return $this->Reclassify_Asset_Data;
    }
    /**
     * Set Reclassify_Asset_Data value
     * @param \StructType\Reclassify_Asset_DataType $reclassify_Asset_Data
     * @return \StructType\Reclassify_Asset_RequestType
     */
    public function setReclassify_Asset_Data(\StructType\Reclassify_Asset_DataType $reclassify_Asset_Data = null)
    {
        $this->Reclassify_Asset_Data = $reclassify_Asset_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Reclassify_Asset_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
