<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Airline_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the Airline Reference and Data that is sent in the response
 * @subpackage Structs
 */
class Put_Airline_ResponseType extends AbstractStructBase
{
    /**
     * The Airline_Reference
     * Meta information extracted from the WSDL
     * - documentation: Airline Reference
     * - minOccurs: 0
     * @var \StructType\AirlineObjectType
     */
    public $Airline_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Airline_ResponseType
     * @uses Put_Airline_ResponseType::setAirline_Reference()
     * @uses Put_Airline_ResponseType::setVersion()
     * @param \StructType\AirlineObjectType $airline_Reference
     * @param string $version
     */
    public function __construct(\StructType\AirlineObjectType $airline_Reference = null, $version = null)
    {
        $this
            ->setAirline_Reference($airline_Reference)
            ->setVersion($version);
    }
    /**
     * Get Airline_Reference value
     * @return \StructType\AirlineObjectType|null
     */
    public function getAirline_Reference()
    {
        return $this->Airline_Reference;
    }
    /**
     * Set Airline_Reference value
     * @param \StructType\AirlineObjectType $airline_Reference
     * @return \StructType\Put_Airline_ResponseType
     */
    public function setAirline_Reference(\StructType\AirlineObjectType $airline_Reference = null)
    {
        $this->Airline_Reference = $airline_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Airline_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
