<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Request_Template_Response_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Purchase Item Request Templates Response
 * @subpackage Structs
 */
class Purchase_Item_Request_Template_Response_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Request_Template
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Request Template Response Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_Request_Template_Outbound_DataType[]
     */
    public $Purchase_Item_Request_Template;
    /**
     * Constructor method for Purchase_Item_Request_Template_Response_DataType
     * @uses Purchase_Item_Request_Template_Response_DataType::setPurchase_Item_Request_Template()
     * @param \StructType\Purchase_Item_Request_Template_Outbound_DataType[] $purchase_Item_Request_Template
     */
    public function __construct(array $purchase_Item_Request_Template = array())
    {
        $this
            ->setPurchase_Item_Request_Template($purchase_Item_Request_Template);
    }
    /**
     * Get Purchase_Item_Request_Template value
     * @return \StructType\Purchase_Item_Request_Template_Outbound_DataType[]|null
     */
    public function getPurchase_Item_Request_Template()
    {
        return $this->Purchase_Item_Request_Template;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_Request_Template method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_Request_Template method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_Request_TemplateForArrayConstraintsFromSetPurchase_Item_Request_Template(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_Template_Response_DataTypePurchase_Item_Request_TemplateItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_Template_Response_DataTypePurchase_Item_Request_TemplateItem instanceof \StructType\Purchase_Item_Request_Template_Outbound_DataType) {
                $invalidValues[] = is_object($purchase_Item_Request_Template_Response_DataTypePurchase_Item_Request_TemplateItem) ? get_class($purchase_Item_Request_Template_Response_DataTypePurchase_Item_Request_TemplateItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_Template_Response_DataTypePurchase_Item_Request_TemplateItem), var_export($purchase_Item_Request_Template_Response_DataTypePurchase_Item_Request_TemplateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_Request_Template property can only contain items of type \StructType\Purchase_Item_Request_Template_Outbound_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_Request_Template value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_Template_Outbound_DataType[] $purchase_Item_Request_Template
     * @return \StructType\Purchase_Item_Request_Template_Response_DataType
     */
    public function setPurchase_Item_Request_Template(array $purchase_Item_Request_Template = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_Request_TemplateArrayErrorMessage = self::validatePurchase_Item_Request_TemplateForArrayConstraintsFromSetPurchase_Item_Request_Template($purchase_Item_Request_Template))) {
            throw new \InvalidArgumentException($purchase_Item_Request_TemplateArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_Request_Template = $purchase_Item_Request_Template;
        return $this;
    }
    /**
     * Add item to Purchase_Item_Request_Template value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Item_Request_Template_Outbound_DataType $item
     * @return \StructType\Purchase_Item_Request_Template_Response_DataType
     */
    public function addToPurchase_Item_Request_Template(\StructType\Purchase_Item_Request_Template_Outbound_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Item_Request_Template_Outbound_DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_Request_Template property can only contain items of type \StructType\Purchase_Item_Request_Template_Outbound_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_Request_Template[] = $item;
        return $this;
    }
}
