<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice_TypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element that includes Invoice Type instance and data.
 * @subpackage Structs
 */
class Invoice_TypeType extends AbstractStructBase
{
    /**
     * The Invoice_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Invoice Type Reference
     * - minOccurs: 0
     * @var \StructType\Invoice_TypeObjectType
     */
    public $Invoice_Type_Reference;
    /**
     * The Invoice_Type_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that encapsulates all of the data related to the Invoice Type.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Invoice_Type_DataType[]
     */
    public $Invoice_Type_Data;
    /**
     * Constructor method for Invoice_TypeType
     * @uses Invoice_TypeType::setInvoice_Type_Reference()
     * @uses Invoice_TypeType::setInvoice_Type_Data()
     * @param \StructType\Invoice_TypeObjectType $invoice_Type_Reference
     * @param \StructType\Invoice_Type_DataType[] $invoice_Type_Data
     */
    public function __construct(\StructType\Invoice_TypeObjectType $invoice_Type_Reference = null, array $invoice_Type_Data = array())
    {
        $this
            ->setInvoice_Type_Reference($invoice_Type_Reference)
            ->setInvoice_Type_Data($invoice_Type_Data);
    }
    /**
     * Get Invoice_Type_Reference value
     * @return \StructType\Invoice_TypeObjectType|null
     */
    public function getInvoice_Type_Reference()
    {
        return $this->Invoice_Type_Reference;
    }
    /**
     * Set Invoice_Type_Reference value
     * @param \StructType\Invoice_TypeObjectType $invoice_Type_Reference
     * @return \StructType\Invoice_TypeType
     */
    public function setInvoice_Type_Reference(\StructType\Invoice_TypeObjectType $invoice_Type_Reference = null)
    {
        $this->Invoice_Type_Reference = $invoice_Type_Reference;
        return $this;
    }
    /**
     * Get Invoice_Type_Data value
     * @return \StructType\Invoice_Type_DataType[]|null
     */
    public function getInvoice_Type_Data()
    {
        return $this->Invoice_Type_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoice_Type_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoice_Type_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoice_Type_DataForArrayConstraintsFromSetInvoice_Type_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoice_TypeTypeInvoice_Type_DataItem) {
            // validation for constraint: itemType
            if (!$invoice_TypeTypeInvoice_Type_DataItem instanceof \StructType\Invoice_Type_DataType) {
                $invalidValues[] = is_object($invoice_TypeTypeInvoice_Type_DataItem) ? get_class($invoice_TypeTypeInvoice_Type_DataItem) : sprintf('%s(%s)', gettype($invoice_TypeTypeInvoice_Type_DataItem), var_export($invoice_TypeTypeInvoice_Type_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Invoice_Type_Data property can only contain items of type \StructType\Invoice_Type_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Invoice_Type_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Invoice_Type_DataType[] $invoice_Type_Data
     * @return \StructType\Invoice_TypeType
     */
    public function setInvoice_Type_Data(array $invoice_Type_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($invoice_Type_DataArrayErrorMessage = self::validateInvoice_Type_DataForArrayConstraintsFromSetInvoice_Type_Data($invoice_Type_Data))) {
            throw new \InvalidArgumentException($invoice_Type_DataArrayErrorMessage, __LINE__);
        }
        $this->Invoice_Type_Data = $invoice_Type_Data;
        return $this;
    }
    /**
     * Add item to Invoice_Type_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Invoice_Type_DataType $item
     * @return \StructType\Invoice_TypeType
     */
    public function addToInvoice_Type_Data(\StructType\Invoice_Type_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Invoice_Type_DataType) {
            throw new \InvalidArgumentException(sprintf('The Invoice_Type_Data property can only contain items of type \StructType\Invoice_Type_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Invoice_Type_Data[] = $item;
        return $this;
    }
}
