<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Get_Supplier_Contact_Information_Response_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains the Supplier Reference and its Contact Information
 * @subpackage Structs
 */
class Get_Supplier_Contact_Information_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Contact_Information
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contact_InformationType[]
     */
    public $Supplier_Contact_Information;
    /**
     * Constructor method for Get_Supplier_Contact_Information_Response_DataType
     * @uses Get_Supplier_Contact_Information_Response_DataType::setSupplier_Contact_Information()
     * @param \StructType\Supplier_Contact_InformationType[] $supplier_Contact_Information
     */
    public function __construct(array $supplier_Contact_Information = array())
    {
        $this
            ->setSupplier_Contact_Information($supplier_Contact_Information);
    }
    /**
     * Get Supplier_Contact_Information value
     * @return \StructType\Supplier_Contact_InformationType[]|null
     */
    public function getSupplier_Contact_Information()
    {
        return $this->Supplier_Contact_Information;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Contact_Information method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Contact_Information method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Contact_InformationForArrayConstraintsFromSetSupplier_Contact_Information(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $get_Supplier_Contact_Information_Response_DataTypeSupplier_Contact_InformationItem) {
            // validation for constraint: itemType
            if (!$get_Supplier_Contact_Information_Response_DataTypeSupplier_Contact_InformationItem instanceof \StructType\Supplier_Contact_InformationType) {
                $invalidValues[] = is_object($get_Supplier_Contact_Information_Response_DataTypeSupplier_Contact_InformationItem) ? get_class($get_Supplier_Contact_Information_Response_DataTypeSupplier_Contact_InformationItem) : sprintf('%s(%s)', gettype($get_Supplier_Contact_Information_Response_DataTypeSupplier_Contact_InformationItem), var_export($get_Supplier_Contact_Information_Response_DataTypeSupplier_Contact_InformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Contact_Information property can only contain items of type \StructType\Supplier_Contact_InformationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Contact_Information value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contact_InformationType[] $supplier_Contact_Information
     * @return \StructType\Get_Supplier_Contact_Information_Response_DataType
     */
    public function setSupplier_Contact_Information(array $supplier_Contact_Information = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Contact_InformationArrayErrorMessage = self::validateSupplier_Contact_InformationForArrayConstraintsFromSetSupplier_Contact_Information($supplier_Contact_Information))) {
            throw new \InvalidArgumentException($supplier_Contact_InformationArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Contact_Information = $supplier_Contact_Information;
        return $this;
    }
    /**
     * Add item to Supplier_Contact_Information value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contact_InformationType $item
     * @return \StructType\Get_Supplier_Contact_Information_Response_DataType
     */
    public function addToSupplier_Contact_Information(\StructType\Supplier_Contact_InformationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contact_InformationType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Contact_Information property can only contain items of type \StructType\Supplier_Contact_InformationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Contact_Information[] = $item;
        return $this;
    }
}
