<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Prepaid_Spend_Amortization_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Prepaid Spend Amortization Business Processing Options and all Prepaid Spend Amortization data items required to submit a Prepaid Spend Amortization
 * @subpackage Structs
 */
class Submit_Prepaid_Spend_Amortization_RequestType extends AbstractStructBase
{
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Prepaid_Spend_Amortization_Data
     * Meta information extracted from the WSDL
     * - documentation: Prepaid Spend Amortization Data
     * - minOccurs: 0
     * @var \StructType\Prepaid_Spend_Amortization_DataType
     */
    public $Prepaid_Spend_Amortization_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Prepaid_Spend_Amortization_RequestType
     * @uses Submit_Prepaid_Spend_Amortization_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Prepaid_Spend_Amortization_RequestType::setPrepaid_Spend_Amortization_Data()
     * @uses Submit_Prepaid_Spend_Amortization_RequestType::setVersion()
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Prepaid_Spend_Amortization_DataType $prepaid_Spend_Amortization_Data
     * @param string $version
     */
    public function __construct(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Prepaid_Spend_Amortization_DataType $prepaid_Spend_Amortization_Data = null, $version = null)
    {
        $this
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setPrepaid_Spend_Amortization_Data($prepaid_Spend_Amortization_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Prepaid_Spend_Amortization_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Prepaid_Spend_Amortization_Data value
     * @return \StructType\Prepaid_Spend_Amortization_DataType|null
     */
    public function getPrepaid_Spend_Amortization_Data()
    {
        return $this->Prepaid_Spend_Amortization_Data;
    }
    /**
     * Set Prepaid_Spend_Amortization_Data value
     * @param \StructType\Prepaid_Spend_Amortization_DataType $prepaid_Spend_Amortization_Data
     * @return \StructType\Submit_Prepaid_Spend_Amortization_RequestType
     */
    public function setPrepaid_Spend_Amortization_Data(\StructType\Prepaid_Spend_Amortization_DataType $prepaid_Spend_Amortization_Data = null)
    {
        $this->Prepaid_Spend_Amortization_Data = $prepaid_Spend_Amortization_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Prepaid_Spend_Amortization_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
