<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Purchase_Order_Line_Additional_Data_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: The Put Purchase Order Line Additional Data Response
 * @subpackage Structs
 */
class Put_Purchase_Order_Line_Additional_Data_ResponseType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Additional_Data_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Line Additional Data
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_LineObjectType
     */
    public $Purchase_Order_Line_Additional_Data_Reference;
    /**
     * The Non_Effective_Dated_Web_Service_Additional_Data
     * Meta information extracted from the WSDL
     * - documentation: Non Effective Dated Web Service Additional Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Non_Effective_Dated_Web_Service_Additional_DataType[]
     */
    public $Non_Effective_Dated_Web_Service_Additional_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Purchase_Order_Line_Additional_Data_ResponseType
     * @uses Put_Purchase_Order_Line_Additional_Data_ResponseType::setPurchase_Order_Line_Additional_Data_Reference()
     * @uses Put_Purchase_Order_Line_Additional_Data_ResponseType::setNon_Effective_Dated_Web_Service_Additional_Data()
     * @uses Put_Purchase_Order_Line_Additional_Data_ResponseType::setVersion()
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Additional_Data_Reference
     * @param \StructType\Non_Effective_Dated_Web_Service_Additional_DataType[] $non_Effective_Dated_Web_Service_Additional_Data
     * @param string $version
     */
    public function __construct(\StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Additional_Data_Reference = null, array $non_Effective_Dated_Web_Service_Additional_Data = array(), $version = null)
    {
        $this
            ->setPurchase_Order_Line_Additional_Data_Reference($purchase_Order_Line_Additional_Data_Reference)
            ->setNon_Effective_Dated_Web_Service_Additional_Data($non_Effective_Dated_Web_Service_Additional_Data)
            ->setVersion($version);
    }
    /**
     * Get Purchase_Order_Line_Additional_Data_Reference value
     * @return \StructType\Purchase_Order_LineObjectType|null
     */
    public function getPurchase_Order_Line_Additional_Data_Reference()
    {
        return $this->Purchase_Order_Line_Additional_Data_Reference;
    }
    /**
     * Set Purchase_Order_Line_Additional_Data_Reference value
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Additional_Data_Reference
     * @return \StructType\Put_Purchase_Order_Line_Additional_Data_ResponseType
     */
    public function setPurchase_Order_Line_Additional_Data_Reference(\StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Additional_Data_Reference = null)
    {
        $this->Purchase_Order_Line_Additional_Data_Reference = $purchase_Order_Line_Additional_Data_Reference;
        return $this;
    }
    /**
     * Get Non_Effective_Dated_Web_Service_Additional_Data value
     * @return \StructType\Non_Effective_Dated_Web_Service_Additional_DataType[]|null
     */
    public function getNon_Effective_Dated_Web_Service_Additional_Data()
    {
        return $this->Non_Effective_Dated_Web_Service_Additional_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setNon_Effective_Dated_Web_Service_Additional_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNon_Effective_Dated_Web_Service_Additional_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNon_Effective_Dated_Web_Service_Additional_DataForArrayConstraintsFromSetNon_Effective_Dated_Web_Service_Additional_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $put_Purchase_Order_Line_Additional_Data_ResponseTypeNon_Effective_Dated_Web_Service_Additional_DataItem) {
            // validation for constraint: itemType
            if (!$put_Purchase_Order_Line_Additional_Data_ResponseTypeNon_Effective_Dated_Web_Service_Additional_DataItem instanceof \StructType\Non_Effective_Dated_Web_Service_Additional_DataType) {
                $invalidValues[] = is_object($put_Purchase_Order_Line_Additional_Data_ResponseTypeNon_Effective_Dated_Web_Service_Additional_DataItem) ? get_class($put_Purchase_Order_Line_Additional_Data_ResponseTypeNon_Effective_Dated_Web_Service_Additional_DataItem) : sprintf('%s(%s)', gettype($put_Purchase_Order_Line_Additional_Data_ResponseTypeNon_Effective_Dated_Web_Service_Additional_DataItem), var_export($put_Purchase_Order_Line_Additional_Data_ResponseTypeNon_Effective_Dated_Web_Service_Additional_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Non_Effective_Dated_Web_Service_Additional_Data property can only contain items of type \StructType\Non_Effective_Dated_Web_Service_Additional_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Non_Effective_Dated_Web_Service_Additional_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Non_Effective_Dated_Web_Service_Additional_DataType[] $non_Effective_Dated_Web_Service_Additional_Data
     * @return \StructType\Put_Purchase_Order_Line_Additional_Data_ResponseType
     */
    public function setNon_Effective_Dated_Web_Service_Additional_Data(array $non_Effective_Dated_Web_Service_Additional_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($non_Effective_Dated_Web_Service_Additional_DataArrayErrorMessage = self::validateNon_Effective_Dated_Web_Service_Additional_DataForArrayConstraintsFromSetNon_Effective_Dated_Web_Service_Additional_Data($non_Effective_Dated_Web_Service_Additional_Data))) {
            throw new \InvalidArgumentException($non_Effective_Dated_Web_Service_Additional_DataArrayErrorMessage, __LINE__);
        }
        $this->Non_Effective_Dated_Web_Service_Additional_Data = $non_Effective_Dated_Web_Service_Additional_Data;
        return $this;
    }
    /**
     * Add item to Non_Effective_Dated_Web_Service_Additional_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Non_Effective_Dated_Web_Service_Additional_DataType $item
     * @return \StructType\Put_Purchase_Order_Line_Additional_Data_ResponseType
     */
    public function addToNon_Effective_Dated_Web_Service_Additional_Data(\StructType\Non_Effective_Dated_Web_Service_Additional_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Non_Effective_Dated_Web_Service_Additional_DataType) {
            throw new \InvalidArgumentException(sprintf('The Non_Effective_Dated_Web_Service_Additional_Data property can only contain items of type \StructType\Non_Effective_Dated_Web_Service_Additional_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Non_Effective_Dated_Web_Service_Additional_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Purchase_Order_Line_Additional_Data_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
