<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Item_Request_Template_Item_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Purchase Item Request Template Item Data
 * @subpackage Structs
 */
class Purchase_Item_Request_Template_Item_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Request_Template_Item_ID
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Request Template ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Item_Request_Template_Item_ID;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: Text value for order of Condition Item. | Order
     * - base: xsd:string
     * - maxLength: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Order;
    /**
     * The Workbook_Template_Field_Reference
     * Meta information extracted from the WSDL
     * - documentation: Workbook Template Field
     * @var \StructType\Workbook_Template_FieldObjectType
     */
    public $Workbook_Template_Field_Reference;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - documentation: Label
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Label;
    /**
     * The Valid_Value_Instance_Reference
     * Meta information extracted from the WSDL
     * - documentation: Valid values
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InstanceObjectType[]
     */
    public $Valid_Value_Instance_Reference;
    /**
     * The Template_Field_Valid_Values_Boolean_Reference
     * Meta information extracted from the WSDL
     * - documentation: Valid value flag
     * - minOccurs: 0
     * @var \StructType\Template_Field_Valid_Values_BooleanObjectType
     */
    public $Template_Field_Valid_Values_Boolean_Reference;
    /**
     * The Display_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Display options
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Template_Item_Display_OptionObjectType[]
     */
    public $Display_Option_Reference;
    /**
     * Constructor method for Purchase_Item_Request_Template_Item_DataType
     * @uses Purchase_Item_Request_Template_Item_DataType::setPurchase_Item_Request_Template_Item_ID()
     * @uses Purchase_Item_Request_Template_Item_DataType::setOrder()
     * @uses Purchase_Item_Request_Template_Item_DataType::setWorkbook_Template_Field_Reference()
     * @uses Purchase_Item_Request_Template_Item_DataType::setLabel()
     * @uses Purchase_Item_Request_Template_Item_DataType::setValid_Value_Instance_Reference()
     * @uses Purchase_Item_Request_Template_Item_DataType::setTemplate_Field_Valid_Values_Boolean_Reference()
     * @uses Purchase_Item_Request_Template_Item_DataType::setDisplay_Option_Reference()
     * @param string $purchase_Item_Request_Template_Item_ID
     * @param string $order
     * @param \StructType\Workbook_Template_FieldObjectType $workbook_Template_Field_Reference
     * @param string $label
     * @param \StructType\InstanceObjectType[] $valid_Value_Instance_Reference
     * @param \StructType\Template_Field_Valid_Values_BooleanObjectType $template_Field_Valid_Values_Boolean_Reference
     * @param \StructType\Template_Item_Display_OptionObjectType[] $display_Option_Reference
     */
    public function __construct($purchase_Item_Request_Template_Item_ID = null, $order = null, \StructType\Workbook_Template_FieldObjectType $workbook_Template_Field_Reference = null, $label = null, array $valid_Value_Instance_Reference = array(), \StructType\Template_Field_Valid_Values_BooleanObjectType $template_Field_Valid_Values_Boolean_Reference = null, array $display_Option_Reference = array())
    {
        $this
            ->setPurchase_Item_Request_Template_Item_ID($purchase_Item_Request_Template_Item_ID)
            ->setOrder($order)
            ->setWorkbook_Template_Field_Reference($workbook_Template_Field_Reference)
            ->setLabel($label)
            ->setValid_Value_Instance_Reference($valid_Value_Instance_Reference)
            ->setTemplate_Field_Valid_Values_Boolean_Reference($template_Field_Valid_Values_Boolean_Reference)
            ->setDisplay_Option_Reference($display_Option_Reference);
    }
    /**
     * Get Purchase_Item_Request_Template_Item_ID value
     * @return string|null
     */
    public function getPurchase_Item_Request_Template_Item_ID()
    {
        return $this->Purchase_Item_Request_Template_Item_ID;
    }
    /**
     * Set Purchase_Item_Request_Template_Item_ID value
     * @param string $purchase_Item_Request_Template_Item_ID
     * @return \StructType\Purchase_Item_Request_Template_Item_DataType
     */
    public function setPurchase_Item_Request_Template_Item_ID($purchase_Item_Request_Template_Item_ID = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Item_Request_Template_Item_ID) && !is_string($purchase_Item_Request_Template_Item_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Item_Request_Template_Item_ID, true), gettype($purchase_Item_Request_Template_Item_ID)), __LINE__);
        }
        $this->Purchase_Item_Request_Template_Item_ID = $purchase_Item_Request_Template_Item_ID;
        return $this;
    }
    /**
     * Get Order value
     * @return string|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param string $order
     * @return \StructType\Purchase_Item_Request_Template_Item_DataType
     */
    public function setOrder($order = null)
    {
        // validation for constraint: string
        if (!is_null($order) && !is_string($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($order) && mb_strlen($order) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Workbook_Template_Field_Reference value
     * @return \StructType\Workbook_Template_FieldObjectType|null
     */
    public function getWorkbook_Template_Field_Reference()
    {
        return $this->Workbook_Template_Field_Reference;
    }
    /**
     * Set Workbook_Template_Field_Reference value
     * @param \StructType\Workbook_Template_FieldObjectType $workbook_Template_Field_Reference
     * @return \StructType\Purchase_Item_Request_Template_Item_DataType
     */
    public function setWorkbook_Template_Field_Reference(\StructType\Workbook_Template_FieldObjectType $workbook_Template_Field_Reference = null)
    {
        $this->Workbook_Template_Field_Reference = $workbook_Template_Field_Reference;
        return $this;
    }
    /**
     * Get Label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param string $label
     * @return \StructType\Purchase_Item_Request_Template_Item_DataType
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->Label = $label;
        return $this;
    }
    /**
     * Get Valid_Value_Instance_Reference value
     * @return \StructType\InstanceObjectType[]|null
     */
    public function getValid_Value_Instance_Reference()
    {
        return $this->Valid_Value_Instance_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setValid_Value_Instance_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValid_Value_Instance_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValid_Value_Instance_ReferenceForArrayConstraintsFromSetValid_Value_Instance_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_Template_Item_DataTypeValid_Value_Instance_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_Template_Item_DataTypeValid_Value_Instance_ReferenceItem instanceof \StructType\InstanceObjectType) {
                $invalidValues[] = is_object($purchase_Item_Request_Template_Item_DataTypeValid_Value_Instance_ReferenceItem) ? get_class($purchase_Item_Request_Template_Item_DataTypeValid_Value_Instance_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_Template_Item_DataTypeValid_Value_Instance_ReferenceItem), var_export($purchase_Item_Request_Template_Item_DataTypeValid_Value_Instance_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Valid_Value_Instance_Reference property can only contain items of type \StructType\InstanceObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Valid_Value_Instance_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\InstanceObjectType[] $valid_Value_Instance_Reference
     * @return \StructType\Purchase_Item_Request_Template_Item_DataType
     */
    public function setValid_Value_Instance_Reference(array $valid_Value_Instance_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($valid_Value_Instance_ReferenceArrayErrorMessage = self::validateValid_Value_Instance_ReferenceForArrayConstraintsFromSetValid_Value_Instance_Reference($valid_Value_Instance_Reference))) {
            throw new \InvalidArgumentException($valid_Value_Instance_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Valid_Value_Instance_Reference = $valid_Value_Instance_Reference;
        return $this;
    }
    /**
     * Add item to Valid_Value_Instance_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\InstanceObjectType $item
     * @return \StructType\Purchase_Item_Request_Template_Item_DataType
     */
    public function addToValid_Value_Instance_Reference(\StructType\InstanceObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InstanceObjectType) {
            throw new \InvalidArgumentException(sprintf('The Valid_Value_Instance_Reference property can only contain items of type \StructType\InstanceObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Valid_Value_Instance_Reference[] = $item;
        return $this;
    }
    /**
     * Get Template_Field_Valid_Values_Boolean_Reference value
     * @return \StructType\Template_Field_Valid_Values_BooleanObjectType|null
     */
    public function getTemplate_Field_Valid_Values_Boolean_Reference()
    {
        return $this->Template_Field_Valid_Values_Boolean_Reference;
    }
    /**
     * Set Template_Field_Valid_Values_Boolean_Reference value
     * @param \StructType\Template_Field_Valid_Values_BooleanObjectType $template_Field_Valid_Values_Boolean_Reference
     * @return \StructType\Purchase_Item_Request_Template_Item_DataType
     */
    public function setTemplate_Field_Valid_Values_Boolean_Reference(\StructType\Template_Field_Valid_Values_BooleanObjectType $template_Field_Valid_Values_Boolean_Reference = null)
    {
        $this->Template_Field_Valid_Values_Boolean_Reference = $template_Field_Valid_Values_Boolean_Reference;
        return $this;
    }
    /**
     * Get Display_Option_Reference value
     * @return \StructType\Template_Item_Display_OptionObjectType[]|null
     */
    public function getDisplay_Option_Reference()
    {
        return $this->Display_Option_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setDisplay_Option_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisplay_Option_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisplay_Option_ReferenceForArrayConstraintsFromSetDisplay_Option_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Item_Request_Template_Item_DataTypeDisplay_Option_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Item_Request_Template_Item_DataTypeDisplay_Option_ReferenceItem instanceof \StructType\Template_Item_Display_OptionObjectType) {
                $invalidValues[] = is_object($purchase_Item_Request_Template_Item_DataTypeDisplay_Option_ReferenceItem) ? get_class($purchase_Item_Request_Template_Item_DataTypeDisplay_Option_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Item_Request_Template_Item_DataTypeDisplay_Option_ReferenceItem), var_export($purchase_Item_Request_Template_Item_DataTypeDisplay_Option_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Display_Option_Reference property can only contain items of type \StructType\Template_Item_Display_OptionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Display_Option_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Template_Item_Display_OptionObjectType[] $display_Option_Reference
     * @return \StructType\Purchase_Item_Request_Template_Item_DataType
     */
    public function setDisplay_Option_Reference(array $display_Option_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($display_Option_ReferenceArrayErrorMessage = self::validateDisplay_Option_ReferenceForArrayConstraintsFromSetDisplay_Option_Reference($display_Option_Reference))) {
            throw new \InvalidArgumentException($display_Option_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Display_Option_Reference = $display_Option_Reference;
        return $this;
    }
    /**
     * Add item to Display_Option_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Template_Item_Display_OptionObjectType $item
     * @return \StructType\Purchase_Item_Request_Template_Item_DataType
     */
    public function addToDisplay_Option_Reference(\StructType\Template_Item_Display_OptionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Template_Item_Display_OptionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Display_Option_Reference property can only contain items of type \StructType\Template_Item_Display_OptionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Display_Option_Reference[] = $item;
        return $this;
    }
}
