<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procedure_Information_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Procedure Information related to the Purchase Order.
 * @subpackage Structs
 */
class Procedure_Information_DataType extends AbstractStructBase
{
    /**
     * The Procedure_Date
     * Meta information extracted from the WSDL
     * - documentation: Procedure Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Procedure_Date;
    /**
     * The Procedure
     * Meta information extracted from the WSDL
     * - documentation: Procedure
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Procedure;
    /**
     * The Procedure_Number
     * Meta information extracted from the WSDL
     * - documentation: Procedure Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Procedure_Number;
    /**
     * The Patient_ID
     * Meta information extracted from the WSDL
     * - documentation: Patient Id
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Patient_ID;
    /**
     * The Medical_Record_Number
     * Meta information extracted from the WSDL
     * - documentation: Medical Record Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Medical_Record_Number;
    /**
     * The Physician_ID
     * Meta information extracted from the WSDL
     * - documentation: Physician Id
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Physician_ID;
    /**
     * The Verified_By
     * Meta information extracted from the WSDL
     * - documentation: Procedure Verified By
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Verified_By;
    /**
     * The Supplier_Representative
     * Meta information extracted from the WSDL
     * - documentation: Supplier Representative
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Representative;
    /**
     * The Additional_Procedure_Details
     * Meta information extracted from the WSDL
     * - documentation: Additional Procedure Details
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Additional_Procedure_Details;
    /**
     * Constructor method for Procedure_Information_DataType
     * @uses Procedure_Information_DataType::setProcedure_Date()
     * @uses Procedure_Information_DataType::setProcedure()
     * @uses Procedure_Information_DataType::setProcedure_Number()
     * @uses Procedure_Information_DataType::setPatient_ID()
     * @uses Procedure_Information_DataType::setMedical_Record_Number()
     * @uses Procedure_Information_DataType::setPhysician_ID()
     * @uses Procedure_Information_DataType::setVerified_By()
     * @uses Procedure_Information_DataType::setSupplier_Representative()
     * @uses Procedure_Information_DataType::setAdditional_Procedure_Details()
     * @param string $procedure_Date
     * @param string $procedure
     * @param string $procedure_Number
     * @param string $patient_ID
     * @param string $medical_Record_Number
     * @param string $physician_ID
     * @param string $verified_By
     * @param string $supplier_Representative
     * @param string $additional_Procedure_Details
     */
    public function __construct($procedure_Date = null, $procedure = null, $procedure_Number = null, $patient_ID = null, $medical_Record_Number = null, $physician_ID = null, $verified_By = null, $supplier_Representative = null, $additional_Procedure_Details = null)
    {
        $this
            ->setProcedure_Date($procedure_Date)
            ->setProcedure($procedure)
            ->setProcedure_Number($procedure_Number)
            ->setPatient_ID($patient_ID)
            ->setMedical_Record_Number($medical_Record_Number)
            ->setPhysician_ID($physician_ID)
            ->setVerified_By($verified_By)
            ->setSupplier_Representative($supplier_Representative)
            ->setAdditional_Procedure_Details($additional_Procedure_Details);
    }
    /**
     * Get Procedure_Date value
     * @return string|null
     */
    public function getProcedure_Date()
    {
        return $this->Procedure_Date;
    }
    /**
     * Set Procedure_Date value
     * @param string $procedure_Date
     * @return \StructType\Procedure_Information_DataType
     */
    public function setProcedure_Date($procedure_Date = null)
    {
        // validation for constraint: string
        if (!is_null($procedure_Date) && !is_string($procedure_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procedure_Date, true), gettype($procedure_Date)), __LINE__);
        }
        $this->Procedure_Date = $procedure_Date;
        return $this;
    }
    /**
     * Get Procedure value
     * @return string|null
     */
    public function getProcedure()
    {
        return $this->Procedure;
    }
    /**
     * Set Procedure value
     * @param string $procedure
     * @return \StructType\Procedure_Information_DataType
     */
    public function setProcedure($procedure = null)
    {
        // validation for constraint: string
        if (!is_null($procedure) && !is_string($procedure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procedure, true), gettype($procedure)), __LINE__);
        }
        $this->Procedure = $procedure;
        return $this;
    }
    /**
     * Get Procedure_Number value
     * @return string|null
     */
    public function getProcedure_Number()
    {
        return $this->Procedure_Number;
    }
    /**
     * Set Procedure_Number value
     * @param string $procedure_Number
     * @return \StructType\Procedure_Information_DataType
     */
    public function setProcedure_Number($procedure_Number = null)
    {
        // validation for constraint: string
        if (!is_null($procedure_Number) && !is_string($procedure_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procedure_Number, true), gettype($procedure_Number)), __LINE__);
        }
        $this->Procedure_Number = $procedure_Number;
        return $this;
    }
    /**
     * Get Patient_ID value
     * @return string|null
     */
    public function getPatient_ID()
    {
        return $this->Patient_ID;
    }
    /**
     * Set Patient_ID value
     * @param string $patient_ID
     * @return \StructType\Procedure_Information_DataType
     */
    public function setPatient_ID($patient_ID = null)
    {
        // validation for constraint: string
        if (!is_null($patient_ID) && !is_string($patient_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patient_ID, true), gettype($patient_ID)), __LINE__);
        }
        $this->Patient_ID = $patient_ID;
        return $this;
    }
    /**
     * Get Medical_Record_Number value
     * @return string|null
     */
    public function getMedical_Record_Number()
    {
        return $this->Medical_Record_Number;
    }
    /**
     * Set Medical_Record_Number value
     * @param string $medical_Record_Number
     * @return \StructType\Procedure_Information_DataType
     */
    public function setMedical_Record_Number($medical_Record_Number = null)
    {
        // validation for constraint: string
        if (!is_null($medical_Record_Number) && !is_string($medical_Record_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medical_Record_Number, true), gettype($medical_Record_Number)), __LINE__);
        }
        $this->Medical_Record_Number = $medical_Record_Number;
        return $this;
    }
    /**
     * Get Physician_ID value
     * @return string|null
     */
    public function getPhysician_ID()
    {
        return $this->Physician_ID;
    }
    /**
     * Set Physician_ID value
     * @param string $physician_ID
     * @return \StructType\Procedure_Information_DataType
     */
    public function setPhysician_ID($physician_ID = null)
    {
        // validation for constraint: string
        if (!is_null($physician_ID) && !is_string($physician_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physician_ID, true), gettype($physician_ID)), __LINE__);
        }
        $this->Physician_ID = $physician_ID;
        return $this;
    }
    /**
     * Get Verified_By value
     * @return string|null
     */
    public function getVerified_By()
    {
        return $this->Verified_By;
    }
    /**
     * Set Verified_By value
     * @param string $verified_By
     * @return \StructType\Procedure_Information_DataType
     */
    public function setVerified_By($verified_By = null)
    {
        // validation for constraint: string
        if (!is_null($verified_By) && !is_string($verified_By)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verified_By, true), gettype($verified_By)), __LINE__);
        }
        $this->Verified_By = $verified_By;
        return $this;
    }
    /**
     * Get Supplier_Representative value
     * @return string|null
     */
    public function getSupplier_Representative()
    {
        return $this->Supplier_Representative;
    }
    /**
     * Set Supplier_Representative value
     * @param string $supplier_Representative
     * @return \StructType\Procedure_Information_DataType
     */
    public function setSupplier_Representative($supplier_Representative = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Representative) && !is_string($supplier_Representative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Representative, true), gettype($supplier_Representative)), __LINE__);
        }
        $this->Supplier_Representative = $supplier_Representative;
        return $this;
    }
    /**
     * Get Additional_Procedure_Details value
     * @return string|null
     */
    public function getAdditional_Procedure_Details()
    {
        return $this->Additional_Procedure_Details;
    }
    /**
     * Set Additional_Procedure_Details value
     * @param string $additional_Procedure_Details
     * @return \StructType\Procedure_Information_DataType
     */
    public function setAdditional_Procedure_Details($additional_Procedure_Details = null)
    {
        // validation for constraint: string
        if (!is_null($additional_Procedure_Details) && !is_string($additional_Procedure_Details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additional_Procedure_Details, true), gettype($additional_Procedure_Details)), __LINE__);
        }
        $this->Additional_Procedure_Details = $additional_Procedure_Details;
        return $this;
    }
}
