<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Time_In_Time_Out_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is the Time Card Daily Lines
 * @subpackage Structs
 */
class Time_In_Time_Out_WWS_DataType extends AbstractStructBase
{
    /**
     * The Time_In
     * Meta information extracted from the WSDL
     * - documentation: Time In
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Time_In;
    /**
     * The Time_Out
     * Meta information extracted from the WSDL
     * - documentation: Time Out
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Time_Out;
    /**
     * The Time_Card_Factor_Reference
     * Meta information extracted from the WSDL
     * - documentation: Time Code
     * - minOccurs: 0
     * @var \StructType\Time_Entry_CodeObjectType
     */
    public $Time_Card_Factor_Reference;
    /**
     * The Time_In_Time_Out_Memo
     * Meta information extracted from the WSDL
     * - documentation: Time In Time Out Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Time_In_Time_Out_Memo;
    /**
     * Constructor method for Time_In_Time_Out_WWS_DataType
     * @uses Time_In_Time_Out_WWS_DataType::setTime_In()
     * @uses Time_In_Time_Out_WWS_DataType::setTime_Out()
     * @uses Time_In_Time_Out_WWS_DataType::setTime_Card_Factor_Reference()
     * @uses Time_In_Time_Out_WWS_DataType::setTime_In_Time_Out_Memo()
     * @param string $time_In
     * @param string $time_Out
     * @param \StructType\Time_Entry_CodeObjectType $time_Card_Factor_Reference
     * @param string $time_In_Time_Out_Memo
     */
    public function __construct($time_In = null, $time_Out = null, \StructType\Time_Entry_CodeObjectType $time_Card_Factor_Reference = null, $time_In_Time_Out_Memo = null)
    {
        $this
            ->setTime_In($time_In)
            ->setTime_Out($time_Out)
            ->setTime_Card_Factor_Reference($time_Card_Factor_Reference)
            ->setTime_In_Time_Out_Memo($time_In_Time_Out_Memo);
    }
    /**
     * Get Time_In value
     * @return string|null
     */
    public function getTime_In()
    {
        return $this->Time_In;
    }
    /**
     * Set Time_In value
     * @param string $time_In
     * @return \StructType\Time_In_Time_Out_WWS_DataType
     */
    public function setTime_In($time_In = null)
    {
        // validation for constraint: string
        if (!is_null($time_In) && !is_string($time_In)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time_In, true), gettype($time_In)), __LINE__);
        }
        $this->Time_In = $time_In;
        return $this;
    }
    /**
     * Get Time_Out value
     * @return string|null
     */
    public function getTime_Out()
    {
        return $this->Time_Out;
    }
    /**
     * Set Time_Out value
     * @param string $time_Out
     * @return \StructType\Time_In_Time_Out_WWS_DataType
     */
    public function setTime_Out($time_Out = null)
    {
        // validation for constraint: string
        if (!is_null($time_Out) && !is_string($time_Out)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time_Out, true), gettype($time_Out)), __LINE__);
        }
        $this->Time_Out = $time_Out;
        return $this;
    }
    /**
     * Get Time_Card_Factor_Reference value
     * @return \StructType\Time_Entry_CodeObjectType|null
     */
    public function getTime_Card_Factor_Reference()
    {
        return $this->Time_Card_Factor_Reference;
    }
    /**
     * Set Time_Card_Factor_Reference value
     * @param \StructType\Time_Entry_CodeObjectType $time_Card_Factor_Reference
     * @return \StructType\Time_In_Time_Out_WWS_DataType
     */
    public function setTime_Card_Factor_Reference(\StructType\Time_Entry_CodeObjectType $time_Card_Factor_Reference = null)
    {
        $this->Time_Card_Factor_Reference = $time_Card_Factor_Reference;
        return $this;
    }
    /**
     * Get Time_In_Time_Out_Memo value
     * @return string|null
     */
    public function getTime_In_Time_Out_Memo()
    {
        return $this->Time_In_Time_Out_Memo;
    }
    /**
     * Set Time_In_Time_Out_Memo value
     * @param string $time_In_Time_Out_Memo
     * @return \StructType\Time_In_Time_Out_WWS_DataType
     */
    public function setTime_In_Time_Out_Memo($time_In_Time_Out_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($time_In_Time_Out_Memo) && !is_string($time_In_Time_Out_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time_In_Time_Out_Memo, true), gettype($time_In_Time_Out_Memo)), __LINE__);
        }
        $this->Time_In_Time_Out_Memo = $time_In_Time_Out_Memo;
        return $this;
    }
}
